/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.RunOnFailureKeywordsAdapter;
import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.Element;
import com.github.markusbernhardt.selenium2library.keywords.Logging;
import com.github.markusbernhardt.selenium2library.utils.Python;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.Autowired;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class SelectElement
extends RunOnFailureKeywordsAdapter {
    @Autowired
    protected Element element;
    @Autowired
    protected Logging logging;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public List<String> getListItems(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            List<WebElement> options = this.getSelectListOptions(locator);
            return this.getLabelsForOptions(options);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public String getSelectedListLabel(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        try {
            Select select = this.getSelectList(locator);
            return select.getFirstSelectedOption().getText();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public List<String> getSelectedListLabels(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        try {
            List<WebElement> options = this.getSelectListOptionsSelected(locator);
            if (options.size() == 0) {
                throw new Selenium2LibraryNonFatalException(String.format("Select list with locator '%s' does not have any selected values.", locator));
            }
            return this.getLabelsForOptions(options);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public String getSelectedListValue(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        try {
            Select select = this.getSelectList(locator);
            return select.getFirstSelectedOption().getAttribute("value");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public List<String> getSelectedListValues(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        try {
            List<WebElement> options = this.getSelectListOptionsSelected(locator);
            if (options.size() == 0) {
                throw new Selenium2LibraryNonFatalException(String.format("Select list with locator '%s' does not have any selected values.", locator));
            }
            return this.getValuesForOptions(options);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "*items"})
    public void listSelectionShouldBe(String locator, String ... items) {
        String string = locator;
        String[] stringArray = items;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        try {
            String itemList = items.length != 0 ? String.format("option(s) [ %s ]", Python.join(" | ", items)) : "no options";
            this.logging.info(String.format("Verifying list '%s' has %s selected.", locator, itemList));
            this.pageShouldContainList(locator);
            List<WebElement> options = this.getSelectListOptionsSelected(locator);
            List<String> selectedLabels = this.getLabelsForOptions(options);
            String message = String.format("List '%s' should have had selection [ %s ] but it was [ %s ].", locator, Python.join(" | ", items), Python.join(" | ", selectedLabels));
            if (items.length != options.size()) {
                throw new Selenium2LibraryNonFatalException(message);
            }
            List<String> selectedValues = this.getValuesForOptions(options);
            String[] stringArray2 = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray2[n2];
                if (!selectedValues.contains(item) && !selectedLabels.contains(item)) {
                    throw new Selenium2LibraryNonFatalException(message);
                }
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void listShouldHaveNoSelections(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Verifying list '%s' has no selection.", locator));
            List<WebElement> options = this.getSelectListOptionsSelected(locator);
            if (!options.equals(null)) {
                List<String> selectedLabels = this.getLabelsForOptions(options);
                String items = Python.join(" | ", selectedLabels);
                throw new Selenium2LibraryNonFatalException(String.format("List '%s' should have had no selection (selection was [ %s ]).", locator, items.toString()));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainList(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldContainList(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainList(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldContainList(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldContainList(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.element.pageShouldContainElement(locator, "list", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainList(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldNotContainList(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainList(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldNotContainList(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldNotContainList(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.element.pageShouldNotContainElement(locator, "list", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void selectAllFromList(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Selecting all options from list '%s'.", locator));
            Select select = this.getSelectList(locator);
            if (!this.isMultiselectList(select)) {
                throw new Selenium2LibraryNonFatalException("Keyword 'Select all from list' works only for multiselect lists.");
            }
            int i = 0;
            while (i < select.getOptions().size()) {
                select.selectByIndex(i);
                ++i;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "*items"})
    public void selectFromList(String locator, String ... items) {
        String string = locator;
        String[] stringArray = items;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        try {
            String itemList = items.length != 0 ? String.format("option(s) [ %s ]", Python.join(" | ", items)) : "all options";
            this.logging.info(String.format("Selecting %s from list '%s'.", itemList, locator));
            Select select = this.getSelectList(locator);
            if (items.length == 0) {
                int i = 0;
                while (i < select.getOptions().size()) {
                    select.selectByIndex(i);
                    ++i;
                }
                return;
            }
            boolean lastItemFound = false;
            ArrayList<String> nonExistingItems = new ArrayList<String>();
            String[] stringArray2 = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray2[n2];
                lastItemFound = true;
                try {
                    select.selectByValue(item);
                }
                catch (NoSuchElementException noSuchElementException) {
                    try {
                        select.selectByVisibleText(item);
                    }
                    catch (NoSuchElementException noSuchElementException2) {
                        nonExistingItems.add(item);
                        lastItemFound = false;
                    }
                }
                ++n2;
            }
            if (nonExistingItems.size() != 0) {
                if (select.isMultiple()) {
                    throw new Selenium2LibraryNonFatalException(String.format("Options '%s' not in list '%s'.", Python.join(", ", nonExistingItems), locator));
                }
                this.logging.warn(String.format("Option%s '%s' not found within list '%s'.", nonExistingItems.size() == 0 ? "" : "s", Python.join(", ", nonExistingItems), locator));
                if (!lastItemFound) {
                    throw new Selenium2LibraryNonFatalException(String.format("Option '%s' not in list '%s'.", nonExistingItems.get(nonExistingItems.size() - 1), locator));
                }
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "*indexes"})
    public void selectFromListByIndex(String locator, String ... indexes) {
        String string = locator;
        String[] stringArray = indexes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        try {
            if (indexes.length == 0) {
                throw new Selenium2LibraryNonFatalException("No index given.");
            }
            ArrayList<String> tmp = new ArrayList<String>();
            String[] stringArray2 = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                String index = stringArray2[n2];
                tmp.add(index);
                ++n2;
            }
            String items = String.format("index(es) '%s'", Python.join(", ", tmp));
            this.logging.info(String.format("Selecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList(locator);
            String[] stringArray3 = indexes;
            int n3 = indexes.length;
            int n4 = 0;
            while (n4 < n3) {
                String index = stringArray3[n4];
                select.selectByIndex(Integer.parseInt(index));
                ++n4;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "*values"})
    public void selectFromListByValue(String locator, String ... values) {
        String string = locator;
        String[] stringArray = values;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        try {
            if (values.length == 0) {
                throw new Selenium2LibraryNonFatalException("No value given.");
            }
            String items = String.format("value(s) '%s'", Python.join(", ", values));
            this.logging.info(String.format("Selecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList(locator);
            String[] stringArray2 = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray2[n2];
                select.selectByValue(value);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "*labels"})
    public void selectFromListByLabel(String locator, String ... labels) {
        String string = locator;
        String[] stringArray = labels;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        try {
            if (labels.length == 0) {
                throw new Selenium2LibraryNonFatalException("No value given.");
            }
            String items = String.format("label(s) '%s'", Python.join(", ", labels));
            this.logging.info(String.format("Selecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList(locator);
            String[] stringArray2 = labels;
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                String label = stringArray2[n2];
                select.selectByVisibleText(label);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "*items"})
    public void unselectFromList(String locator, String ... items) {
        String string = locator;
        String[] stringArray = items;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        try {
            String itemList = items.length != 0 ? String.format("option(s) [ %s ]", Python.join(" | ", items)) : "all options";
            this.logging.info(String.format("Unselecting %s from list '%s'.", itemList, locator));
            Select select = this.getSelectList(locator);
            if (!this.isMultiselectList(select)) {
                throw new Selenium2LibraryNonFatalException("Keyword 'Unselect from list' works only for multiselect lists.");
            }
            if (items.length == 0) {
                select.deselectAll();
                return;
            }
            String[] stringArray2 = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray2[n2];
                select.deselectByValue(item);
                select.deselectByVisibleText(item);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "*indexes"})
    public void unselectFromListByIndex(String locator, Integer ... indexes) {
        String string = locator;
        Integer[] integerArray = indexes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string, (Object)integerArray);
        try {
            if (indexes.equals(null)) {
                throw new Selenium2LibraryNonFatalException("No index given.");
            }
            ArrayList<String> tmp = new ArrayList<String>();
            Integer[] integerArray2 = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                Integer index = integerArray2[n2];
                tmp.add(index.toString());
                ++n2;
            }
            String items = String.format("index(es) '%s'", Python.join(", ", tmp));
            this.logging.info(String.format("Unselecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList(locator);
            if (!this.isMultiselectList(select)) {
                throw new Selenium2LibraryNonFatalException("Keyword 'Unselect from list' works only for multiselect lists.");
            }
            Integer[] integerArray3 = indexes;
            int n3 = indexes.length;
            int n4 = 0;
            while (n4 < n3) {
                int index = integerArray3[n4];
                select.deselectByIndex(index);
                ++n4;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "*values"})
    public void unselectFromListByValue(String locator, String ... values) {
        String string = locator;
        String[] stringArray = values;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        try {
            if (values.equals(null)) {
                throw new Selenium2LibraryNonFatalException("No value given.");
            }
            String items = String.format("value(s) '%s'", Python.join(", ", values));
            this.logging.info(String.format("Unselecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList(locator);
            if (!this.isMultiselectList(select)) {
                throw new Selenium2LibraryNonFatalException("Keyword 'Unselect from list' works only for multiselect lists.");
            }
            String[] stringArray2 = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray2[n2];
                select.deselectByValue(value);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "*labels"})
    public void unselectFromListByLabel(String locator, String ... labels) {
        String string = locator;
        String[] stringArray = labels;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string, (Object)stringArray);
        try {
            if (labels.equals(null)) {
                throw new Selenium2LibraryNonFatalException("No value given.");
            }
            String items = String.format("label(s) '%s'", Python.join(", ", labels));
            this.logging.info(String.format("Unselecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList(locator);
            if (!this.isMultiselectList(select)) {
                throw new Selenium2LibraryNonFatalException("Keyword 'Unselect from list' works only for multiselect lists.");
            }
            String[] stringArray2 = labels;
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                String label = stringArray2[n2];
                select.deselectByVisibleText(label);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    protected List<String> getLabelsForOptions(List<WebElement> options) {
        ArrayList<String> labels = new ArrayList<String>();
        for (WebElement option : options) {
            labels.add(option.getText());
        }
        return labels;
    }

    protected Select getSelectList(String locator) {
        List<WebElement> webElements = this.element.elementFind(locator, true, true, "select");
        return new Select(webElements.get(0));
    }

    protected List<WebElement> getSelectListOptions(Select select) {
        return new ArrayList<WebElement>(select.getOptions());
    }

    protected List<WebElement> getSelectListOptions(String locator) {
        Select select = this.getSelectList(locator);
        return this.getSelectListOptions(select);
    }

    protected List<WebElement> getSelectListOptionsSelected(String locator) {
        Select select = this.getSelectList(locator);
        return new ArrayList<WebElement>(select.getAllSelectedOptions());
    }

    protected List<String> getValuesForOptions(List<WebElement> options) {
        ArrayList<String> labels = new ArrayList<String>();
        for (WebElement option : options) {
            labels.add(option.getAttribute("value"));
        }
        return labels;
    }

    protected boolean isMultiselectList(Select select) {
        return select.isMultiple();
    }

    static {
        SelectElement.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SelectElement.java", SelectElement.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getListItems", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "java.util.List"), 51);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSelectedListLabel", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "java.lang.String"), 71);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "void"), 252);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 257);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 278);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectAllFromList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "void"), 294);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "selectFromList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:items", "", "void"), 328);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "selectFromListByIndex", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:indexes", "", "void"), 398);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "selectFromListByValue", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:values", "", "void"), 431);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "selectFromListByLabel", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:labels", "", "void"), 460);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "unselectFromList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:items", "", "void"), 495);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "unselectFromListByIndex", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.Integer;", "locator:indexes", "", "void"), 534);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSelectedListLabels", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "java.util.List"), 93);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "unselectFromListByValue", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:values", "", "void"), 573);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "unselectFromListByLabel", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:labels", "", "void"), 608);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSelectedListValue", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "java.lang.String"), 121);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSelectedListValues", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "java.util.List"), 144);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "listSelectionShouldBe", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:items", "", "void"), 172);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listShouldHaveNoSelections", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "void"), 208);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "void"), 221);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 226);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 247);
    }
}

