/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.RunOnFailureKeywordsAdapter;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.Logging;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.python.util.PythonInterpreter;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.Autowired;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class RunOnFailure
extends RunOnFailureKeywordsAdapter {
    protected String runOnFailureKeyword = "Capture Page Screenshot";
    protected boolean runningOnFailureRoutine;
    @Autowired
    protected Logging logging;
    protected static ThreadLocal<PythonInterpreter> runOnFailurePythonInterpreter;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        RunOnFailure.ajc$preClinit();
        runOnFailurePythonInterpreter = new ThreadLocal<PythonInterpreter>(){

            @Override
            protected PythonInterpreter initialValue() {
                PythonInterpreter pythonInterpreter = new PythonInterpreter();
                pythonInterpreter.exec("from robot.libraries import BuiltIn; BUILTIN = BuiltIn.BuiltIn();");
                return pythonInterpreter;
            }
        };
    }

    @RobotKeyword
    @ArgumentNames(value={"keyword"})
    public String registerKeywordToRunOnFailure(String keyword) {
        String string = keyword;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            String oldKeyword = this.runOnFailureKeyword;
            String oldKeywordText = oldKeyword != null ? oldKeyword : "No keyword";
            String newKeyword = !keyword.trim().toLowerCase().equals("nothing") ? keyword : null;
            String newKeywordText = newKeyword != null ? newKeyword : "No keyword";
            this.runOnFailureKeyword = newKeyword;
            this.logging.info(String.format("%s will be run on failure.", newKeywordText));
            return oldKeywordText;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public void runOnFailure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            if (this.runOnFailureKeyword == null) {
                return;
            }
            if (this.runningOnFailureRoutine) {
                return;
            }
            this.runningOnFailureRoutine = true;
            try {
                try {
                    runOnFailurePythonInterpreter.get().exec(String.format("BUILTIN.run_keyword('%s')", this.runOnFailureKeyword.replace("'", "\\'").replace("\n", "\\n")));
                }
                catch (RuntimeException r) {
                    this.logging.warn(String.format("Keyword '%s' could not be run on failure%s", this.runOnFailureKeyword, r.getMessage() != null ? " '" + r.getMessage() + "'" : ""));
                    this.runningOnFailureRoutine = false;
                }
            }
            finally {
                this.runningOnFailureRoutine = false;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RunOnFailure.java", RunOnFailure.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerKeywordToRunOnFailure", "com.github.markusbernhardt.selenium2library.keywords.RunOnFailure", "java.lang.String", "keyword", "", "java.lang.String"), 80);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "runOnFailure", "com.github.markusbernhardt.selenium2library.keywords.RunOnFailure", "", "", "", "void"), 107);
    }
}

