/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.RunOnFailureKeywordsAdapter;
import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.Element;
import com.github.markusbernhardt.selenium2library.keywords.Logging;
import java.io.File;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.WebElement;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.Autowired;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class FormElement
extends RunOnFailureKeywordsAdapter {
    @Autowired
    protected Element element;
    @Autowired
    protected Logging logging;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;

    @RobotKeywordOverload
    public void submitForm() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            this.submitForm(null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator=NONE"})
    public void submitForm(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Submitting form '%s'.", locator));
            if (locator == null) {
                locator = "xpath=//form";
            }
            List<WebElement> webElements = this.element.elementFind(locator, true, true, "form");
            webElements.get(0).submit();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void checkboxShouldBeSelected(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Verifying checkbox '%s' is selected.", locator));
            WebElement element = this.getCheckbox(locator);
            if (!element.isSelected()) {
                throw new Selenium2LibraryNonFatalException(String.format("Checkbox '%s' should have been selected.", locator));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void checkboxShouldNotBeSelected(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Verifying checkbox '%s' is selected.", locator));
            WebElement element = this.getCheckbox(locator);
            if (element.isSelected()) {
                throw new Selenium2LibraryNonFatalException(String.format("Checkbox '%s' should not have been selected.", locator));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainCheckbox(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldContainCheckbox(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainCheckbox(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldContainCheckbox(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldContainCheckbox(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.element.pageShouldContainElement(locator, "checkbox", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainCheckbox(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldNotContainCheckbox(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainCheckbox(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldNotContainCheckbox(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldNotContainCheckbox(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.element.pageShouldNotContainElement(locator, "checkbox", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void selectCheckbox(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Selecting checkbox '%s'.", locator));
            WebElement element = this.getCheckbox(locator);
            if (!element.isSelected()) {
                element.click();
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void unselectCheckbox(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Selecting checkbox '%s'.", locator));
            WebElement element = this.getCheckbox(locator);
            if (element.isSelected()) {
                element.click();
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainRadioButton(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldContainRadioButton(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainRadioButton(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldContainRadioButton(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldContainRadioButton(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.element.pageShouldContainElement(locator, "radio button", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainRadioButton(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldNotContainRadioButton(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainRadioButton(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldNotContainRadioButton(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldNotContainRadioButton(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.element.pageShouldNotContainElement(locator, "radio button", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"groupName", "value"})
    public void radioButtonShouldBeSetTo(String groupName, String value) {
        String string = groupName;
        String string2 = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.logging.info(String.format("Verifying radio button '%s' has selection '%s'.", groupName, value));
            List<WebElement> elements = this.getRadioButtons(groupName);
            String actualValue = this.getValueFromRadioButtons(elements);
            if (actualValue == null || !actualValue.equals(value)) {
                throw new Selenium2LibraryNonFatalException(String.format("Selection of radio button '%s' should have been '%s' but was '%s'", groupName, value, actualValue));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"groupName"})
    public void radioButtonShouldNotBeSelected(String groupName) {
        String string = groupName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Verifying radio button '%s' has no selection.", groupName));
            List<WebElement> elements = this.getRadioButtons(groupName);
            String actualValue = this.getValueFromRadioButtons(elements);
            if (actualValue != null) {
                throw new Selenium2LibraryNonFatalException(String.format("Radio button group '%s' should not have had selection, but '%s' was selected", groupName, actualValue));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"groupName", "value"})
    public void selectRadioButton(String groupName, String value) {
        String string = groupName;
        String string2 = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.logging.info(String.format("Selecting '%s' from radio button '%s'.", value, groupName));
            WebElement element = this.getRadioButtonWithValue(groupName, value);
            if (!element.isSelected()) {
                element.click();
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "filePath"})
    public void chooseFile(String locator, String filePath) {
        String string = locator;
        String string2 = filePath;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            if (!new File(filePath).isFile()) {
                this.logging.info(String.format("File '%s' does not exist on the local file system", filePath));
            }
            this.element.elementFind(locator, true, true).get(0).sendKeys(new CharSequence[]{filePath});
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text"})
    public void inputPassword(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.logging.info(String.format("Typing password into text field '%s'", locator));
            this.inputTextIntoTextField(locator, text);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text"})
    public void inputText(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.logging.info(String.format("Typing text '%s' into text field '%s'", text, locator));
            this.inputTextIntoTextField(locator, text);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainTextfield(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldContainTextfield(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainTextfield(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldContainTextfield(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldContainTextfield(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.element.pageShouldContainElement(locator, "text field", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainTextfield(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldNotContainTextfield(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainTextfield(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldNotContainTextfield(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldNotContainTextfield(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.element.pageShouldNotContainElement(locator, "text field", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void textfieldValueShouldBe(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.textfieldValueShouldBe(locator, text, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void textfieldValueShouldBe(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String actual = this.element.getValue(locator, "text field");
            if (!actual.contains(text)) {
                if (message == null) {
                    message = String.format("Value of text field '%s' should have been '%s' but was '%s'", locator, text, actual);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            this.logging.info(String.format("Content of text field '%s' is '%s'.", locator, text));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void textfieldValueShouldNotBe(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.textfieldValueShouldNotBe(locator, text, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void textfieldValueShouldNotBe(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String actual = this.element.getValue(locator, "text field");
            if (actual.contains(text)) {
                if (message == null) {
                    message = String.format("Value of text field '%s' should not have been '%s' but was '%s'", locator, text, actual);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            this.logging.info(String.format("Content of text field '%s' is '%s'.", locator, text));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void textfieldShouldContain(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.textfieldShouldContain(locator, text, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void textfieldShouldContain(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String actual = this.element.getValue(locator, "text field");
            if (!actual.contains(text)) {
                if (message == null) {
                    message = String.format("Text field '%s' should have contained text '%s', but was '%s'", locator, text, actual);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            this.logging.info(String.format("Text field '%s' contains text '%s'.", locator, text));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void textfieldShouldNotContain(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.textfieldShouldNotContain(locator, text, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void textfieldShouldNotContain(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String actual = this.element.getValue(locator, "text field");
            if (actual.contains(text)) {
                if (message == null) {
                    message = String.format("Text field '%s' should not have contained text '%s', but was '%s'", locator, text, actual);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            this.logging.info(String.format("Text field '%s' contains text '%s'.", locator, text));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void textareaShouldContain(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.textareaShouldContain(locator, text, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void textareaShouldContain(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String actual = this.element.getValue(locator, "text area");
            if (!actual.contains(text)) {
                if (message == null) {
                    message = String.format("Text area '%s' should have contained text '%s', but was '%s'", locator, text, actual);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            this.logging.info(String.format("Text field '%s' contains text '%s'.", locator, text));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void textareaShouldNotContain(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.textareaShouldNotContain(locator, text, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void textareaShouldNotContain(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String actual = this.element.getValue(locator, "text area");
            if (!actual.contains(text)) {
                if (message == null) {
                    message = String.format("Text area '%s' should not have contained text '%s', but was '%s'", locator, text, actual);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            this.logging.info(String.format("Text field '%s' contains text '%s'.", locator, text));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void textareaValueShouldBe(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.textareaValueShouldBe(locator, text, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void textareaValueShouldBe(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String actual = this.element.getValue(locator, "text area");
            if (!actual.contains(text)) {
                if (message == null) {
                    message = String.format("Value of text area '%s' should have been '%s' but was '%s'", locator, text, actual);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            this.logging.info(String.format("Content of text area '%s' is '%s'.", locator, text));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void textareaValueShouldNotBe(String locator, String text) {
        String string = locator;
        String string2 = text;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.textareaValueShouldNotBe(locator, text, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "text", "message=NONE"})
    public void textareaValueShouldNotBe(String locator, String text, String message) {
        String string = locator;
        String string2 = text;
        String string3 = message;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String actual = this.element.getValue(locator, "text area");
            if (actual.contains(text)) {
                if (message == null) {
                    message = String.format("Value of text area '%s' should not have been '%s' but was '%s'", locator, text, actual);
                }
                throw new Selenium2LibraryNonFatalException(message);
            }
            this.logging.info(String.format("Content of text area '%s' is '%s'.", locator, text));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void clickButton(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Clicking button '%s'.", locator));
            List<WebElement> elements = this.element.elementFind(locator, true, false, "input");
            if (elements.size() == 0) {
                elements = this.element.elementFind(locator, true, true, "button");
            }
            elements.get(0).click();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainButton(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldContainButton(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldContainButton(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldContainButton(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldContainButton(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object[])objectArray);
        try {
            try {
                this.element.pageShouldContainElement(locator, "input", message, logLevel);
            }
            catch (Selenium2LibraryNonFatalException selenium2LibraryNonFatalException) {
                this.element.pageShouldContainElement(locator, "button", message, logLevel);
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainButton(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)string);
        try {
            this.pageShouldNotContainButton(locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void pageShouldNotContainButton(String locator, String message) {
        String string = locator;
        String string2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.pageShouldNotContainButton(locator, message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator", "message=NONE", "logLevel=INFO"})
    public void pageShouldNotContainButton(String locator, String message, String logLevel) {
        String string = locator;
        String string2 = message;
        String string3 = logLevel;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.element.pageShouldNotContainElement(locator, "input", message, logLevel);
            this.element.pageShouldNotContainElement(locator, "button", message, logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    protected WebElement getCheckbox(String locator) {
        return this.element.elementFind(locator, true, true, "input").get(0);
    }

    protected List<WebElement> getRadioButtons(String groupName) {
        String xpath = String.format("xpath=//input[@type='radio' and @name='%s']", groupName);
        this.logging.debug("Radio group locator: " + xpath);
        return this.element.elementFind(xpath, false, true);
    }

    protected WebElement getRadioButtonWithValue(String groupName, String value) {
        String xpath = String.format("xpath=//input[@type='radio' and @name='%s' and (@value='%s' or @id='%s')]", groupName, value, value);
        this.logging.debug("Radio group locator: " + xpath);
        return this.element.elementFind(xpath, true, true).get(0);
    }

    protected String getValueFromRadioButtons(List<WebElement> elements) {
        for (WebElement element : elements) {
            if (!element.isSelected()) continue;
            return element.getAttribute("value");
        }
        return null;
    }

    protected void inputTextIntoTextField(String locator, String text) {
        WebElement webElement = this.element.elementFind(locator, true, true).get(0);
        webElement.clear();
        webElement.sendKeys(new CharSequence[]{text});
    }

    protected boolean isFormElement(WebElement element) {
        if (element == null) {
            return false;
        }
        String tag = element.getTagName().toLowerCase();
        return tag == "input" || tag == "select" || tag == "textarea" || tag == "button" || tag == "option";
    }

    static {
        FormElement.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FormElement.java", FormElement.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "submitForm", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "", "", "", "void"), 36);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "submitForm", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 53);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectCheckbox", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 175);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unselectCheckbox", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 196);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainRadioButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 205);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainRadioButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 210);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainRadioButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 230);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainRadioButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 235);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainRadioButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 240);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainRadioButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 260);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "radioButtonShouldBeSetTo", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "groupName:value", "", "void"), 277);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "radioButtonShouldNotBeSelected", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "groupName", "", "void"), 298);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkboxShouldBeSelected", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 73);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectRadioButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "groupName:value", "", "void"), 338);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "chooseFile", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:filePath", "", "void"), 372);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "inputPassword", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:text", "", "void"), 393);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "inputText", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:text", "", "void"), 412);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainTextfield", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 418);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainTextfield", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 423);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainTextfield", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 443);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainTextfield", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 448);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainTextfield", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 453);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainTextfield", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 473);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkboxShouldNotBeSelected", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 93);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textfieldValueShouldBe", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:text", "", "void"), 478);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textfieldValueShouldBe", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 502);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textfieldValueShouldNotBe", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:text", "", "void"), 515);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textfieldValueShouldNotBe", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 539);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textfieldShouldContain", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:text", "", "void"), 552);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textfieldShouldContain", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 575);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textfieldShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:text", "", "void"), 588);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textfieldShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 612);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textareaShouldContain", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:text", "", "void"), 625);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textareaShouldContain", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 648);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainCheckbox", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 103);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textareaShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:text", "", "void"), 661);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textareaShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 684);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textareaValueShouldBe", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:text", "", "void"), 697);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textareaValueShouldBe", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 721);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textareaValueShouldNotBe", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:text", "", "void"), 734);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textareaValueShouldNotBe", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:text:message", "", "void"), 758);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clickButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 781);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 791);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 796);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 816);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainCheckbox", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 108);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 825);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 830);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainButton", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 850);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainCheckbox", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 128);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainCheckbox", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String", "locator", "", "void"), 133);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainCheckbox", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 138);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainCheckbox", "com.github.markusbernhardt.selenium2library.keywords.FormElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 158);
    }
}

