/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.RunOnFailureKeywordsAdapter;
import com.github.markusbernhardt.selenium2library.Selenium2LibraryFatalException;
import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.Element;
import com.github.markusbernhardt.selenium2library.keywords.Logging;
import com.github.markusbernhardt.selenium2library.locators.ElementFinder;
import com.github.markusbernhardt.selenium2library.locators.WindowManager;
import com.github.markusbernhardt.selenium2library.utils.Robotframework;
import com.github.markusbernhardt.selenium2library.utils.WebDriverCache;
import com.opera.core.systems.OperaDriver;
import java.io.File;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.DefaultHttpRoutePlanner;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.android.AndroidDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.iphone.IPhoneDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.Autowired;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class BrowserManagement
extends RunOnFailureKeywordsAdapter {
    public String remoteWebDriverProxyHost = "";
    public String remoteWebDriverProxyPort = "";
    public String remoteWebDriverProxyUser = "";
    public String remoteWebDriverProxyPassword = "";
    public String remoteWebDriverProxyDomain = "";
    public String remoteWebDriverProxyWorkstation = "";
    protected WebDriverCache webDriverCache = new WebDriverCache();
    protected double timeout = 5.0;
    protected double implicitWait = 0.0;
    @Autowired
    protected Logging logging;
    @Autowired
    protected Element element;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;

    public WebDriverCache getWebDriverCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            return this.webDriverCache;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public WebDriver getCurrentWebDriver() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            return this.webDriverCache.getCurrent();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public double getTimeout() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            return this.timeout;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void addLocationStrategy(String strategyName, String functionDefinition) {
        String string = strategyName;
        String string2 = functionDefinition;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.addLocationStrategy(strategyName, functionDefinition, null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"strategyName", "functionDefinition", "delimiter=NONE"})
    public void addLocationStrategy(String strategyName, String functionDefinition, String delimiter) {
        String string = strategyName;
        String string2 = functionDefinition;
        String string3 = delimiter;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        try {
            ElementFinder.addLocationStrategy(strategyName, functionDefinition, delimiter);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public void closeBrowser() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            if (this.webDriverCache.getCurrentSessionId() != null) {
                this.logging.debug(String.format("Closing browser with session id %s", this.webDriverCache.getCurrentSessionId()));
                this.webDriverCache.close();
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public String openBrowser(String url) throws Throwable {
        String string = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        try {
            return this.openBrowser(url, "firefox");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public String openBrowser(String url, String browserName) throws Throwable {
        String string = url;
        String string2 = browserName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            return this.openBrowser(url, browserName, null);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public String openBrowser(String url, String browserName, String alias) throws Throwable {
        String string = url;
        String string2 = browserName;
        String string3 = alias;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        try {
            return this.openBrowser(url, browserName, alias, null);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public String openBrowser(String url, String browserName, String alias, String remoteUrl) throws Throwable {
        String string = url;
        String string2 = browserName;
        String string3 = alias;
        String string4 = remoteUrl;
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        try {
            return this.openBrowser(url, browserName, alias, remoteUrl, null);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public String openBrowser(String url, String browserName, String alias, String remoteUrl, String desiredCapabilities) throws Throwable {
        String string = url;
        String string2 = browserName;
        String string3 = alias;
        String string4 = remoteUrl;
        String string5 = desiredCapabilities;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        try {
            return this.openBrowser(url, browserName, alias, remoteUrl, desiredCapabilities, null);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"url", "browserName=firefox", "alias=NONE", "remoteUrl=NONE", "desiredCapabilities=NONE", "ffProfileDir=NONE"})
    public String openBrowser(String url, String browserName, String alias, String remoteUrl, String desiredCapabilities, String ffProfileDir) throws Throwable {
        String string = url;
        String string2 = browserName;
        String string3 = alias;
        String string4 = remoteUrl;
        String string5 = desiredCapabilities;
        String string6 = ffProfileDir;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
        try {
            try {
                this.logging.info("browserName: " + browserName);
                if (remoteUrl != null) {
                    this.logging.info(String.format("Opening browser '%s' to base url '%s' through remote server at '%s'", browserName, url, remoteUrl));
                } else {
                    this.logging.info(String.format("Opening browser '%s' to base url '%s'", browserName, url));
                }
                WebDriver webDriver = this.createWebDriver(browserName, desiredCapabilities, ffProfileDir, remoteUrl);
                webDriver.get(url);
                String sessionId = this.webDriverCache.register(webDriver, alias);
                this.logging.debug(String.format("Opened browser with session id %s", sessionId));
                return sessionId;
            }
            catch (Throwable t) {
                if (remoteUrl != null) {
                    this.logging.warn(String.format("Opening browser '%s' to base url '%s' through remote server at '%s' failed", browserName, url, remoteUrl));
                } else {
                    this.logging.warn(String.format("Opening browser '%s' to base url '%s' failed", browserName, url));
                }
                throw new Selenium2LibraryFatalException(t);
            }
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"indexOrAlias"})
    public void switchBrowser(String indexOrAlias) {
        String string = indexOrAlias;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string);
        try {
            try {
                this.webDriverCache.switchBrowser(indexOrAlias);
                this.logging.debug(String.format("Switched to browser with Selenium session id %s", this.webDriverCache.getCurrentSessionId()));
            }
            catch (Throwable throwable) {
                throw new Selenium2LibraryFatalException(String.format("No browser with index or alias '%s' found.", indexOrAlias));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public void closeAllBrowsers() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        try {
            this.logging.debug("Closing all browsers");
            this.webDriverCache.closeAll();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public void closeWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        try {
            this.webDriverCache.getCurrent().close();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public List<String> getWindowIdentifiers() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        try {
            return this.toList(WindowManager.getWindowIds(this.webDriverCache.getCurrent()), "Window Id");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public List<String> getWindowNames() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        try {
            List<String> windowNames = WindowManager.getWindowNames(this.webDriverCache.getCurrent());
            if (windowNames.size() != 0 && windowNames.get(0).equals("undefined")) {
                windowNames.set(0, "selenium_main_app_window");
            }
            return this.toList(windowNames, "Window Name");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public List<String> getWindowTitles() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        try {
            return this.toList(WindowManager.getWindowTitles(this.webDriverCache.getCurrent()), "Window Title");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public void maximizeBrowserWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        try {
            this.webDriverCache.getCurrent().manage().window().maximize();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public Object[] getWindowSize() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        try {
            Dimension size = this.getCurrentWebDriver().manage().window().getSize();
            return new Object[]{Integer.toString(size.width), Integer.toString(size.height)};
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"width", "height"})
    public void setWindowSize(String width, String height) {
        String string = width;
        String string2 = height;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.getCurrentWebDriver().manage().window().setSize(new Dimension(Integer.parseInt(width), Integer.parseInt(height)));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator"})
    public void selectFrame(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Selecting frame '%s'.", locator));
            List<WebElement> elements = this.element.elementFind(locator, true, true);
            this.webDriverCache.getCurrent().switchTo().frame(elements.get(0));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void selectWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        try {
            this.selectWindow(null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"locator=NONE"})
    public void selectWindow(String locator) {
        String string = locator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)string);
        try {
            WindowManager.select(this.webDriverCache.getCurrent(), locator);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public void unselectFrame() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        try {
            this.webDriverCache.getCurrent().switchTo().defaultContent();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public String getLocation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        try {
            return this.webDriverCache.getCurrent().getCurrentUrl();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public String getSource() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        try {
            return this.webDriverCache.getCurrent().getPageSource();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public String getTitle() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        try {
            return this.webDriverCache.getCurrent().getTitle();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public String getRemoteCapabilities() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        try {
            if (this.getCurrentWebDriver() instanceof RemoteWebDriver) {
                return ((RemoteWebDriver)this.getCurrentWebDriver()).getCapabilities().toString();
            }
            return "No remote session id";
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public String getRemoteSessionId() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        try {
            if (this.getCurrentWebDriver() instanceof RemoteWebDriver) {
                return ((RemoteWebDriver)this.getCurrentWebDriver()).getSessionId().toString();
            }
            return "No remote session id";
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public String getSystemInfo() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        try {
            return String.format("      os.name: '%s'\n      os.arch: '%s'\n   os.version: '%s'\n java.version: '%s'", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.version"));
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"url"})
    public void locationShouldBe(String url) {
        String string = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.getLocation();
            if (!actual.equals(url)) {
                throw new Selenium2LibraryNonFatalException(String.format("Location should have been '%s', but was '%s'", url, actual));
            }
            this.logging.info(String.format("Current location is '%s'.", url));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"url"})
    public void locationShouldContain(String url) {
        String string = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.getLocation();
            if (!actual.contains(url)) {
                throw new Selenium2LibraryNonFatalException(String.format("Location should have contained '%s', but was '%s'", url, actual));
            }
            this.logging.info(String.format("Current location is '%s'.", url));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"title"})
    public void titleShouldBe(String title) {
        String string = title;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.getTitle();
            if (!actual.equals(title)) {
                throw new Selenium2LibraryNonFatalException(String.format("Title should have been '%s', but was '%s'", title, actual));
            }
            this.logging.info(String.format("Page title is '%s'.", title));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"title"})
    public void titleShouldNotBe(String title) {
        String string = title;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.getTitle();
            if (actual.equals(title)) {
                throw new Selenium2LibraryNonFatalException(String.format("Title should not have been '%s', but was '%s'", title, actual));
            }
            this.logging.info(String.format("Page title is '%s'.", title));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"title"})
    public void titleShouldContain(String title) {
        String string = title;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.getTitle();
            if (!actual.contains(title)) {
                throw new Selenium2LibraryNonFatalException(String.format("Title should have contained '%s', but was '%s'", title, actual));
            }
            this.logging.info(String.format("Page title is '%s'.", title));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"title"})
    public void titleShouldNotContain(String title) {
        String string = title;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)string);
        try {
            String actual = this.getTitle();
            if (actual.contains(title)) {
                throw new Selenium2LibraryNonFatalException(String.format("Title should not have contained '%s', but was '%s'", title, actual));
            }
            this.logging.info(String.format("Page title is '%s'.", title));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public void goBack() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        try {
            this.webDriverCache.getCurrent().navigate().back();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"url"})
    public void goTo(String url) {
        String string = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)string);
        try {
            this.logging.info(String.format("Opening url '%s'", url));
            this.webDriverCache.getCurrent().get(url);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public void reloadPage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        try {
            this.webDriverCache.getCurrent().navigate().refresh();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public String getSeleniumSpeed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this);
        try {
            return Robotframework.secsToTimestr(0.0);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword(value="(NOT IMPLEMENTED)\n\nSets the delay in seconds that is waited after each Selenium command.\n")
    @ArgumentNames(value={"timestr"})
    public String setSeleniumSpeed(String timestr) {
        String string = timestr;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)string);
        try {
            return "0s";
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public String getSeleniumTimeout() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this);
        try {
            return Robotframework.secsToTimestr(this.timeout);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"timestr"})
    public String setSeleniumTimeout(String timestr) {
        String string = timestr;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)string);
        try {
            String oldWait = this.getSeleniumTimeout();
            this.timeout = Robotframework.timestrToSecs(timestr);
            for (WebDriverCache.SessionIdAliasWebDriverTuple sessionIdAliasWebDriverTuple : this.webDriverCache.getWebDrivers()) {
                sessionIdAliasWebDriverTuple.webDriver.manage().timeouts().setScriptTimeout((long)((int)(this.timeout * 1000.0)), TimeUnit.MILLISECONDS);
            }
            return oldWait;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    public String getSeleniumImplicitWait() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this);
        try {
            return Robotframework.secsToTimestr(this.implicitWait);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"timestr"})
    public String setSeleniumImplicitWait(String timestr) {
        String string = timestr;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)string);
        try {
            String oldWait = this.getSeleniumTimeout();
            this.implicitWait = Robotframework.timestrToSecs(timestr);
            for (WebDriverCache.SessionIdAliasWebDriverTuple sessionIdAliasWebDriverTuple : this.webDriverCache.getWebDrivers()) {
                sessionIdAliasWebDriverTuple.webDriver.manage().timeouts().implicitlyWait((long)((int)(this.implicitWait * 1000.0)), TimeUnit.MILLISECONDS);
            }
            return oldWait;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"timestr"})
    public String setBrowserImplicitWait(String timestr) {
        String string = timestr;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)string);
        try {
            String oldWait = this.getSeleniumTimeout();
            this.implicitWait = Robotframework.timestrToSecs(timestr);
            this.webDriverCache.getCurrent().manage().timeouts().implicitlyWait((long)((int)(this.implicitWait * 1000.0)), TimeUnit.MILLISECONDS);
            return oldWait;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void setRemoteWebDriverProxy(String host, String port) {
        String string = host;
        String string2 = port;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            this.setRemoteWebDriverProxy(host, port, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void setRemoteWebDriverProxy(String host, String port, String user) {
        String string = host;
        String string2 = port;
        String string3 = user;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.setRemoteWebDriverProxy(host, port, user, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void setRemoteWebDriverProxy(String host, String port, String user, String password) {
        String string = host;
        String string2 = port;
        String string3 = user;
        String string4 = password;
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.setRemoteWebDriverProxy(host, port, user, password, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeywordOverload
    public void setRemoteWebDriverProxy(String host, String port, String user, String password, String domain) {
        String string = host;
        String string2 = port;
        String string3 = user;
        String string4 = password;
        String string5 = domain;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object[])objectArray);
        try {
            this.setRemoteWebDriverProxy(host, port, user, password, domain, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    @RobotKeyword
    @ArgumentNames(value={"host", "port", "username=NONE", "password=NONE", "domain=NONE", "workstation=NONE"})
    public void setRemoteWebDriverProxy(String host, String port, String username, String password, String domain, String workstation) {
        String string = host;
        String string2 = port;
        String string3 = username;
        String string4 = password;
        String string5 = domain;
        String string6 = workstation;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object[])objectArray);
        try {
            if (host.length() == 0 || port.length() == 0) {
                this.remoteWebDriverProxyHost = "";
                this.remoteWebDriverProxyPort = "";
                this.remoteWebDriverProxyUser = "";
                this.remoteWebDriverProxyPassword = "";
                this.remoteWebDriverProxyDomain = "";
                this.remoteWebDriverProxyWorkstation = "";
                return;
            }
            URL proxyUrl = null;
            try {
                String httpProxy = System.getenv().get("http_proxy");
                if (httpProxy != null) {
                    proxyUrl = new URL(httpProxy);
                } else {
                    httpProxy = System.getenv().get("HTTP_PROXY");
                    if (httpProxy != null) {
                        proxyUrl = new URL(httpProxy);
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new Selenium2LibraryNonFatalException(e.getMessage());
            }
            if (username.length() == 0) {
                if (System.getProperty("http.proxyHost", "").equals(host) && System.getProperty("http.proxyPort", "").equals(port)) {
                    username = System.getProperty("http.proxyUser", "");
                }
                if (username.length() == 0 && proxyUrl != null && proxyUrl.getHost().equals(host) && Integer.toString(proxyUrl.getPort()).equals(port)) {
                    username = this.getUserFromURL(proxyUrl);
                }
            }
            if (password.length() == 0) {
                if (System.getProperty("http.proxyHost", "").equals(host) && System.getProperty("http.proxyPort", "").equals(port) && System.getProperty("http.proxyUser", "").equals(username)) {
                    password = System.getProperty("http.proxyPassword", "");
                }
                if (password.length() == 0 && proxyUrl != null && proxyUrl.getHost().equals(host) && Integer.toString(proxyUrl.getPort()).equals(port) && this.getUserFromURL(proxyUrl).equals(username)) {
                    password = this.getPasswordFromURL(proxyUrl);
                }
            }
            if (domain.length() != 0 && workstation.length() == 0) {
                try {
                    workstation = InetAddress.getLocalHost().getHostName().split("\\.")[0];
                }
                catch (UnknownHostException unknownHostException) {
                    this.logging.warn("No workstation name found");
                }
            }
            this.remoteWebDriverProxyHost = host;
            this.remoteWebDriverProxyPort = port;
            this.remoteWebDriverProxyUser = username;
            this.remoteWebDriverProxyPassword = password;
            this.remoteWebDriverProxyDomain = domain;
            this.remoteWebDriverProxyWorkstation = workstation;
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String getUserFromURL(URL url) {
        String auth = url.getUserInfo();
        int index = auth.indexOf(58);
        if (index == -1) {
            return auth;
        }
        return auth.substring(0, index);
    }

    protected String getPasswordFromURL(URL url) {
        String auth = url.getUserInfo();
        int index = auth.indexOf(58);
        if (index == -1) {
            return "";
        }
        return auth.substring(index + 1);
    }

    protected WebDriver createWebDriver(String browserName, String desiredCapabilitiesString, String profileDirectory, String remoteUrlString) throws MalformedURLException {
        browserName = browserName.toLowerCase().replace(" ", "");
        DesiredCapabilities desiredCapabilities = this.createDesiredCapabilities(browserName, desiredCapabilitiesString, profileDirectory);
        WebDriver webDriver = remoteUrlString != null && !"False".equals(remoteUrlString) ? this.createRemoteWebDriver(desiredCapabilities, new URL(remoteUrlString)) : this.createLocalWebDriver(browserName, desiredCapabilities);
        webDriver.manage().timeouts().setScriptTimeout((long)((int)(this.timeout * 1000.0)), TimeUnit.MILLISECONDS);
        webDriver.manage().timeouts().implicitlyWait((long)((int)(this.implicitWait * 1000.0)), TimeUnit.MILLISECONDS);
        return webDriver;
    }

    protected WebDriver createLocalWebDriver(String browserName, DesiredCapabilities desiredCapabilities) {
        if ("ff".equals(browserName) || "firefox".equals(browserName)) {
            return new FirefoxDriver((Capabilities)desiredCapabilities);
        }
        if ("ie".equals(browserName) || "internetexplorer".equals(browserName)) {
            return new InternetExplorerDriver((Capabilities)desiredCapabilities);
        }
        if ("gc".equals(browserName) || "chrome".equals(browserName) || "googlechrome".equals(browserName)) {
            return new ChromeDriver((Capabilities)desiredCapabilities);
        }
        if ("opera".equals(browserName)) {
            return new OperaDriver((Capabilities)desiredCapabilities);
        }
        if ("phantomjs".equals(browserName)) {
            return new PhantomJSDriver((Capabilities)desiredCapabilities);
        }
        if ("safari".equals(browserName)) {
            return new SafariDriver((Capabilities)desiredCapabilities);
        }
        if ("htmlunit".equals(browserName)) {
            return new HtmlUnitDriver((Capabilities)desiredCapabilities);
        }
        if ("htmlunitwithjs".equals(browserName)) {
            HtmlUnitDriver driver = new HtmlUnitDriver((Capabilities)desiredCapabilities);
            driver.setJavascriptEnabled(true);
            return driver;
        }
        if ("iphone".equals(browserName) || "ipad".equals(browserName)) {
            try {
                return new IPhoneDriver((Capabilities)desiredCapabilities);
            }
            catch (Exception e) {
                throw new Selenium2LibraryFatalException("Creating " + browserName + " instance failed.", e);
            }
        }
        if ("android".equals(browserName)) {
            return new AndroidDriver(desiredCapabilities);
        }
        throw new Selenium2LibraryFatalException(String.valueOf(browserName) + " is not a supported browser.");
    }

    protected WebDriver createRemoteWebDriver(DesiredCapabilities desiredCapabilities, URL remoteUrl) {
        HttpCommandExecutor httpCommandExecutor = new HttpCommandExecutor(remoteUrl);
        this.setRemoteWebDriverProxy(httpCommandExecutor);
        return new Augmenter().augment((WebDriver)new RemoteWebDriver((CommandExecutor)httpCommandExecutor, (Capabilities)desiredCapabilities));
    }

    protected DesiredCapabilities createDesiredCapabilities(String browserName, String desiredCapabilitiesString, String profileDirectory) {
        DesiredCapabilities desiredCapabilities;
        if ("ff".equals(browserName) || "firefox".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.firefox();
            if (profileDirectory != null) {
                FirefoxProfile profile = new FirefoxProfile(new File(profileDirectory));
                desiredCapabilities.setCapability("firefox_profile", (Object)profile);
            }
        } else if ("ie".equals(browserName) || "internetexplorer".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.internetExplorer();
        } else if ("gc".equals(browserName) || "chrome".equals(browserName) || "googlechrome".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.chrome();
        } else if ("opera".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.opera();
        } else if ("phantomjs".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.phantomjs();
        } else if ("safari".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.safari();
        } else if ("ipad".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.ipad();
        } else if ("iphone".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.iphone();
        } else if ("android".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.android();
        } else if ("htmlunit".equals(browserName) || "htmlunitwithjs".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.htmlUnit();
        } else {
            throw new Selenium2LibraryFatalException(String.valueOf(browserName) + " is not a supported browser.");
        }
        if (desiredCapabilitiesString != null && !"None".equals(desiredCapabilitiesString)) {
            String[] stringArray = desiredCapabilitiesString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String capability = stringArray[n2];
                String[] keyValue = capability.split(":");
                desiredCapabilities.setCapability(keyValue[0], keyValue[1]);
                ++n2;
            }
        }
        return desiredCapabilities;
    }

    protected void setRemoteWebDriverProxy(HttpCommandExecutor httpCommandExecutor) {
        if (this.remoteWebDriverProxyHost.length() == 0) {
            return;
        }
        String fieldName = "<unknown>";
        String className = "<unknown>";
        try {
            fieldName = "client";
            className = "DefaultHttpClient";
            Field field = HttpCommandExecutor.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            DefaultHttpClient client = (DefaultHttpClient)field.get(httpCommandExecutor);
            AuthScope authScope = new AuthScope(this.remoteWebDriverProxyHost, Integer.parseInt(this.remoteWebDriverProxyPort));
            if (this.remoteWebDriverProxyDomain.length() == 0) {
                client.getCredentialsProvider().setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(this.remoteWebDriverProxyUser, this.remoteWebDriverProxyPassword));
            } else {
                client.getCredentialsProvider().setCredentials(authScope, (Credentials)new NTCredentials(this.remoteWebDriverProxyUser, this.remoteWebDriverProxyPassword, this.remoteWebDriverProxyWorkstation, this.remoteWebDriverProxyDomain));
            }
            client.setRoutePlanner((HttpRoutePlanner)new DefaultHttpRoutePlanner(client.getConnectionManager().getSchemeRegistry()));
            HttpHost proxy = new HttpHost(this.remoteWebDriverProxyHost, Integer.parseInt(this.remoteWebDriverProxyPort));
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        catch (SecurityException securityException) {
            throw new Selenium2LibraryFatalException(String.format("The SecurityManager does not allow us to lookup to the %s field.", fieldName));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new Selenium2LibraryFatalException(String.format("The RemoteWebDriver dose not declare the %s field any more.", fieldName));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Selenium2LibraryFatalException(String.format("The field %s does not belong to the given object.", fieldName));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Selenium2LibraryFatalException(String.format("The SecurityManager does not allow us to access to the %s field.", fieldName));
        }
        catch (ClassCastException classCastException) {
            throw new Selenium2LibraryFatalException(String.format("The %s field does not contain a %s.", fieldName, className));
        }
    }

    protected List<String> toList(List<String> items) {
        return this.toList(items, "item");
    }

    protected List<String> toList(List<String> items, String what) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add(String.format("Altogether %d %s%s.\n", items.size(), what, items.size() == 1 ? "" : "s"));
        int index = 0;
        while (index < items.size()) {
            msg.add(String.format("%d: %s", index + 1, items.get(index)));
            ++index;
        }
        return items;
    }

    static {
        BrowserManagement.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BrowserManagement.java", BrowserManagement.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWebDriverCache", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "com.github.markusbernhardt.selenium2library.utils.WebDriverCache"), 94);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCurrentWebDriver", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "org.openqa.selenium.WebDriver"), 98);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "url:browserName:alias:remoteUrl:desiredCapabilities", "java.lang.Throwable", "java.lang.String"), 203);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "url:browserName:alias:remoteUrl:desiredCapabilities:ffProfileDir", "java.lang.Throwable", "java.lang.String"), 317);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "switchBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "indexOrAlias", "", "void"), 441);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeAllBrowsers", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 464);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeWindow", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 473);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWindowIdentifiers", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.util.List"), 486);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWindowNames", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.util.List"), 498);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWindowTitles", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.util.List"), 514);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "maximizeBrowserWindow", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 522);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWindowSize", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "[Ljava.lang.Object;"), 540);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimeout", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "double"), 102);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWindowSize", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String", "width:height", "", "void"), 580);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectFrame", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "locator", "", "void"), 596);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectWindow", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 603);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectWindow", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "locator", "", "void"), 676);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unselectFrame", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 684);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLocation", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 696);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSource", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 708);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTitle", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 720);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRemoteCapabilities", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 743);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRemoteSessionId", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 759);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addLocationStrategy", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String", "strategyName:functionDefinition", "", "void"), 111);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSystemInfo", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 775);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "locationShouldBe", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "url", "", "void"), 791);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "locationShouldContain", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "url", "", "void"), 810);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "titleShouldBe", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "title", "", "void"), 831);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "titleShouldNotBe", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "title", "", "void"), 852);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "titleShouldContain", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "title", "", "void"), 873);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "titleShouldNotContain", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "title", "", "void"), 894);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "goBack", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 907);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "goTo", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "url", "", "void"), 919);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reloadPage", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 928);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addLocationStrategy", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String", "strategyName:functionDefinition:delimiter", "", "void"), 163);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSeleniumSpeed", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 941);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSeleniumSpeed", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "timestr", "", "java.lang.String"), 957);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSeleniumTimeout", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 969);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSeleniumTimeout", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "timestr", "", "java.lang.String"), 1012);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSeleniumImplicitWait", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 1031);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSeleniumImplicitWait", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "timestr", "", "java.lang.String"), 1072);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBrowserImplicitWait", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "timestr", "", "java.lang.String"), 1118);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoteWebDriverProxy", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String", "host:port", "", "void"), 1127);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoteWebDriverProxy", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String", "host:port:user", "", "void"), 1132);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoteWebDriverProxy", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "host:port:user:password", "", "void"), 1137);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 175);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoteWebDriverProxy", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "host:port:user:password:domain", "", "void"), 1142);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoteWebDriverProxy", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "host:port:username:password:domain:workstation", "", "void"), 1187);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "url", "java.lang.Throwable", "java.lang.String"), 183);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String", "url:browserName", "java.lang.Throwable", "java.lang.String"), 188);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String", "url:browserName:alias", "java.lang.Throwable", "java.lang.String"), 193);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "url:browserName:alias:remoteUrl", "java.lang.Throwable", "java.lang.String"), 198);
    }
}

