/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.utils;

import com.github.markusbernhardt.selenium2library.Selenium2LibraryFatalException;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.openqa.selenium.WebDriver;

public class WebDriverCache {
    SessionIdAliasWebDriverTuple currentSessionIdAliasWebDriverTuple;
    int maxAssignedSessionId = 0;
    Stack<String> openSessionIds = new Stack();
    Stack<String> closedSessionIds = new Stack();
    Map<String, SessionIdAliasWebDriverTuple> tupleBySessionId = new TreeMap<String, SessionIdAliasWebDriverTuple>();
    Map<String, SessionIdAliasWebDriverTuple> tupleByAlias = new TreeMap<String, SessionIdAliasWebDriverTuple>();

    public String register(WebDriver webDriver, String alias) {
        this.currentSessionIdAliasWebDriverTuple = new SessionIdAliasWebDriverTuple();
        this.currentSessionIdAliasWebDriverTuple.alias = alias;
        this.currentSessionIdAliasWebDriverTuple.webDriver = webDriver;
        if (this.closedSessionIds.size() == 0) {
            ++this.maxAssignedSessionId;
            this.currentSessionIdAliasWebDriverTuple.id = Integer.toString(this.maxAssignedSessionId);
        } else {
            this.currentSessionIdAliasWebDriverTuple.id = this.closedSessionIds.pop();
        }
        this.openSessionIds.push(this.currentSessionIdAliasWebDriverTuple.id);
        this.tupleBySessionId.put(this.currentSessionIdAliasWebDriverTuple.id, this.currentSessionIdAliasWebDriverTuple);
        if (alias != null) {
            this.tupleByAlias.put(this.currentSessionIdAliasWebDriverTuple.alias, this.currentSessionIdAliasWebDriverTuple);
        }
        return this.currentSessionIdAliasWebDriverTuple.id;
    }

    public WebDriver getCurrent() {
        if (this.currentSessionIdAliasWebDriverTuple != null) {
            return this.currentSessionIdAliasWebDriverTuple.webDriver;
        }
        return null;
    }

    public String getCurrentSessionId() {
        if (this.currentSessionIdAliasWebDriverTuple != null) {
            return this.currentSessionIdAliasWebDriverTuple.id;
        }
        return null;
    }

    public void close() {
        if (this.currentSessionIdAliasWebDriverTuple != null) {
            this.currentSessionIdAliasWebDriverTuple.webDriver.quit();
            this.tupleBySessionId.remove(this.currentSessionIdAliasWebDriverTuple.id);
            this.tupleByAlias.remove(this.currentSessionIdAliasWebDriverTuple.alias);
            this.openSessionIds.remove(this.currentSessionIdAliasWebDriverTuple.id);
            this.closedSessionIds.push(this.currentSessionIdAliasWebDriverTuple.id);
            this.currentSessionIdAliasWebDriverTuple = this.openSessionIds.size() != 0 ? this.tupleBySessionId.get(this.openSessionIds.pop()) : null;
        }
    }

    public void closeAll() {
        for (SessionIdAliasWebDriverTuple sessionIdAliasWebDriverTuple : this.tupleBySessionId.values()) {
            sessionIdAliasWebDriverTuple.webDriver.quit();
        }
        this.maxAssignedSessionId = 0;
        this.currentSessionIdAliasWebDriverTuple = null;
        this.openSessionIds = new Stack();
        this.closedSessionIds = new Stack();
        this.tupleBySessionId = new TreeMap<String, SessionIdAliasWebDriverTuple>();
        this.tupleByAlias = new TreeMap<String, SessionIdAliasWebDriverTuple>();
    }

    public void switchBrowser(String sessionIdOrAlias) {
        SessionIdAliasWebDriverTuple sessionIdAliasWebDriverTuple = this.tupleByAlias.get(sessionIdOrAlias);
        if (sessionIdAliasWebDriverTuple != null) {
            this.currentSessionIdAliasWebDriverTuple = sessionIdAliasWebDriverTuple;
            this.openSessionIds.remove(this.currentSessionIdAliasWebDriverTuple.id);
            this.openSessionIds.push(this.currentSessionIdAliasWebDriverTuple.id);
            return;
        }
        sessionIdAliasWebDriverTuple = this.tupleBySessionId.get(sessionIdOrAlias);
        if (sessionIdAliasWebDriverTuple != null) {
            this.currentSessionIdAliasWebDriverTuple = sessionIdAliasWebDriverTuple;
            this.openSessionIds.remove(this.currentSessionIdAliasWebDriverTuple.id);
            this.openSessionIds.push(this.currentSessionIdAliasWebDriverTuple.id);
            return;
        }
        throw new Selenium2LibraryFatalException(String.format("Non-existing index or alias '%s'", sessionIdOrAlias));
    }

    public Collection<SessionIdAliasWebDriverTuple> getWebDrivers() {
        return this.tupleBySessionId.values();
    }

    public static class SessionIdAliasWebDriverTuple {
        public String id;
        public String alias;
        public WebDriver webDriver;
    }
}

