/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.keywords.JavaScript;
import com.github.markusbernhardt.selenium2library.utils.Python;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;

public abstract class Logging
extends JavaScript {
    protected static final Map<String, String[]> VALID_LOG_LEVELS = new HashMap<String, String[]>();
    protected static ThreadLocal<PythonInterpreter> loggingPythonInterpreter;

    static {
        VALID_LOG_LEVELS.put("debug", new String[]{"debug", ""});
        VALID_LOG_LEVELS.put("html", new String[]{"info", ", True, False"});
        VALID_LOG_LEVELS.put("info", new String[]{"info", ""});
        VALID_LOG_LEVELS.put("trace", new String[]{"trace", ""});
        VALID_LOG_LEVELS.put("warn", new String[]{"warn", ""});
        loggingPythonInterpreter = new ThreadLocal<PythonInterpreter>(){

            @Override
            protected PythonInterpreter initialValue() {
                PythonInterpreter pythonInterpreter = new PythonInterpreter();
                pythonInterpreter.exec("from robot.variables import GLOBAL_VARIABLES; from robot.api import logger;");
                return pythonInterpreter;
            }
        };
    }

    @Override
    protected void trace(String msg) {
        this.log(msg, "trace");
    }

    @Override
    protected void debug(String msg) {
        this.log(msg, "debug");
    }

    @Override
    protected void info(String msg) {
        this.log(msg, "info");
    }

    @Override
    protected void html(String msg) {
        this.log(msg, "html");
    }

    @Override
    protected void warn(String msg) {
        this.log(msg, "warn");
    }

    @Override
    protected void log(String msg, String logLevel) {
        String[] methodParameters = VALID_LOG_LEVELS.get(logLevel.toLowerCase());
        if (methodParameters == null) {
            throw new Selenium2LibraryNonFatalException(String.format("Given log level %s is invalid.", logLevel));
        }
        this.log0(msg, methodParameters[0], methodParameters[1]);
    }

    protected void log0(String msg, String methodName, String methodArguments) {
        if (msg.length() > 1024) {
            try {
                File tempFile = File.createTempFile("Selenium2Library-", ".log");
                tempFile.deleteOnExit();
                FileWriter writer = new FileWriter(tempFile);
                writer.write(msg);
                writer.close();
                loggingPythonInterpreter.get().exec(String.format("from __future__ import with_statement\n\nwith open('%s', 'r') as msg_file:\n    msg = msg_file.read()\n    logger.%s(msg%s)", tempFile.getAbsolutePath().replace("\\", "\\\\"), methodName, methodArguments));
            }
            catch (IOException e) {
                throw new Selenium2LibraryNonFatalException("Error in handling temp file for long log message.", e);
            }
        } else {
            loggingPythonInterpreter.get().exec(String.format("logger.%s('%s'%s)", methodName, msg.replace("'", "\\'").replace("\n", "\\n"), methodArguments));
        }
    }

    @Override
    protected List<String> logList(List<String> items) {
        return this.logList(items, "item");
    }

    @Override
    protected List<String> logList(List<String> items, String what) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add(String.format("Altogether %d %s%s.\n", items.size(), what, items.size() == 1 ? "" : "s"));
        int index = 0;
        while (index < items.size()) {
            msg.add(String.format("%d: %s", index + 1, items.get(index)));
            ++index;
        }
        this.info(Python.join("\n", msg));
        return items;
    }

    @Override
    protected File getLogDir() {
        PyString logDirName = (PyString)loggingPythonInterpreter.get().eval("GLOBAL_VARIABLES['${LOG FILE}']");
        if (logDirName != null) {
            return new File(logDirName.asString()).getParentFile();
        }
        logDirName = (PyString)loggingPythonInterpreter.get().eval("GLOBAL_VARIABLES['${OUTPUTDIR}']");
        return new File(logDirName.asString()).getParentFile();
    }
}

