/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.Selenium2LibraryFatalException;
import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.locators.WindowManager;
import com.github.markusbernhardt.selenium2library.utils.Robotframework;
import com.github.markusbernhardt.selenium2library.utils.WebDriverCache;
import com.opera.core.systems.OperaDriver;
import java.io.File;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.DefaultHttpRoutePlanner;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.android.AndroidDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.iphone.IPhoneDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;

public abstract class BrowserManagement {
    public String remoteWebDriverProxyHost = "";
    public String remoteWebDriverProxyPort = "";
    public String remoteWebDriverProxyUser = "";
    public String remoteWebDriverProxyPassword = "";
    public String remoteWebDriverProxyDomain = "";
    public String remoteWebDriverProxyWorkstation = "";
    protected WebDriverCache webDriverCache = new WebDriverCache();
    protected double timeout = 5.0;
    protected double implicitWait = 0.0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;

    public void closeBrowser() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            if (this.webDriverCache.getCurrentSessionId() != null) {
                this.debug(String.format("Closing browser with session id %s", this.webDriverCache.getCurrentSessionId()));
                this.webDriverCache.close();
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String openBrowser(String string) throws Throwable {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string2);
        try {
            void url;
            return this.openBrowser((String)url, "firefox");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String openBrowser(String string, String string2) throws Throwable {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string3, (Object)string4);
        try {
            void browserName;
            void url;
            return this.openBrowser((String)url, (String)browserName, null);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String openBrowser(String string, String string2, String string3) throws Throwable {
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void alias;
            void browserName;
            void url;
            return this.openBrowser((String)url, (String)browserName, (String)alias, null);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String openBrowser(String string, String string2, String string3, String string4) throws Throwable {
        String string5 = string;
        String string6 = string2;
        String string7 = string3;
        String string8 = string4;
        Object[] objectArray = new Object[]{string5, string6, string7, string8};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void remoteUrl;
            void alias;
            void browserName;
            void url;
            return this.openBrowser((String)url, (String)browserName, (String)alias, (String)remoteUrl, null);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String openBrowser(String string, String string2, String string3, String string4, String string5) throws Throwable {
        String string6 = string;
        String string7 = string2;
        String string8 = string3;
        String string9 = string4;
        String string10 = string5;
        Object[] objectArray = new Object[]{string6, string7, string8, string9, string10};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void desiredCapabilities;
            void remoteUrl;
            void alias;
            void browserName;
            void url;
            return this.openBrowser((String)url, (String)browserName, (String)alias, (String)remoteUrl, (String)desiredCapabilities, null);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String openBrowser(String string, String string2, String string3, String string4, String string5, String string6) throws Throwable {
        String string7 = string;
        String string8 = string2;
        String string9 = string3;
        String string10 = string4;
        String string11 = string5;
        String string12 = string6;
        Object[] objectArray = new Object[]{string7, string8, string9, string10, string11, string12};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void url;
            void remoteUrl;
            void browserName;
            try {
                void alias;
                void ffProfileDir;
                void desiredCapabilities;
                this.info("browserName: " + (String)browserName);
                if (remoteUrl != null) {
                    this.info(String.format("Opening browser '%s' to base url '%s' through remote server at '%s'", browserName, url, remoteUrl));
                } else {
                    this.info(String.format("Opening browser '%s' to base url '%s'", browserName, url));
                }
                WebDriver webDriver = this.createWebDriver((String)browserName, (String)desiredCapabilities, (String)ffProfileDir, (String)remoteUrl);
                webDriver.get((String)url);
                String sessionId = this.webDriverCache.register(webDriver, (String)alias);
                this.debug(String.format("Opened browser with session id %s", sessionId));
                return sessionId;
            }
            catch (Throwable t) {
                if (remoteUrl != null) {
                    this.warn(String.format("Opening browser '%s' to base url '%s' through remote server at '%s' failed", browserName, url, remoteUrl));
                } else {
                    this.warn(String.format("Opening browser '%s' to base url '%s' failed", browserName, url));
                }
                throw new Selenium2LibraryFatalException(t);
            }
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void switchBrowser(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string2);
        try {
            void indexOrAlias;
            try {
                this.webDriverCache.switchBrowser((String)indexOrAlias);
                this.debug(String.format("Switched to browser with Selenium session id %s", this.webDriverCache.getCurrentSessionId()));
            }
            catch (Throwable throwable) {
                throw new Selenium2LibraryFatalException(String.format("No browser with index or alias '%s' found.", indexOrAlias));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public void closeAllBrowsers() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            this.debug("Closing all browsers");
            this.webDriverCache.closeAll();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public void closeWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        try {
            this.webDriverCache.getCurrent().close();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public List<String> getWindowIdentifiers() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        try {
            return this.logList(WindowManager.getWindowIds(this.webDriverCache.getCurrent()), "Window Id");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public List<String> getWindowNames() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        try {
            List<String> windowNames = WindowManager.getWindowNames(this.webDriverCache.getCurrent());
            if (windowNames.size() != 0 && windowNames.get(0).equals("undefined")) {
                windowNames.set(0, "selenium_main_app_window");
            }
            return this.logList(windowNames, "Window Name");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public List<String> getWindowTitles() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        try {
            return this.logList(WindowManager.getWindowTitles(this.webDriverCache.getCurrent()), "Window Title");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public void maximizeBrowserWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        try {
            this.webDriverCache.getCurrent().manage().window().maximize();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void selectFrame(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string2);
        try {
            void locator;
            this.info(String.format("Selecting frame '%s'.", locator));
            List<WebElement> elements = this.elementFind((String)locator, true, true);
            this.webDriverCache.getCurrent().switchTo().frame(elements.get(0));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public void selectWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        try {
            this.selectWindow(null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void selectWindow(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string2);
        try {
            void locator;
            WindowManager.select(this.webDriverCache.getCurrent(), (String)locator);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public void unselectFrame() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        try {
            this.webDriverCache.getCurrent().switchTo().defaultContent();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getLocation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        try {
            return this.webDriverCache.getCurrent().getCurrentUrl();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getSource() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        try {
            return this.webDriverCache.getCurrent().getPageSource();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getTitle() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        try {
            return this.webDriverCache.getCurrent().getTitle();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void locationShouldBe(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string2);
        try {
            void url;
            String actual = this.getLocation();
            if (!actual.equals(url)) {
                throw new Selenium2LibraryNonFatalException(String.format("Location should have been '%s' but was '%s'", url, actual));
            }
            this.info(String.format("Current location is '%s'.", url));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void locationShouldContain(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)string2);
        try {
            void url;
            String actual = this.getLocation();
            if (!actual.contains((CharSequence)url)) {
                throw new Selenium2LibraryNonFatalException(String.format("Location should have been '%s' but was '%s'", url, actual));
            }
            this.info(String.format("Current location is '%s'.", url));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String logLocation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        try {
            String actual = this.getLocation();
            this.info(actual);
            return actual;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String logSource() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        try {
            return this.logSource("INFO");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String logSource(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string2);
        try {
            void logLevel;
            String actual = this.getSource();
            this.log(actual, (String)logLevel);
            return actual;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String logTitle() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        try {
            String actual = this.getTitle();
            this.info(actual);
            return actual;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void titleShouldBe(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)string2);
        try {
            void title;
            String actual = this.getTitle();
            if (!actual.equals(title)) {
                throw new Selenium2LibraryNonFatalException(String.format("Title should have been '%s' but was '%s'", title, actual));
            }
            this.info(String.format("Page title is '%s'.", title));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public void goBack() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        try {
            this.webDriverCache.getCurrent().navigate().back();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void goTo(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)string2);
        try {
            void url;
            this.info(String.format("Opening url '%s'", url));
            this.webDriverCache.getCurrent().get((String)url);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public void reloadPage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        try {
            this.webDriverCache.getCurrent().navigate().refresh();
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getSeleniumSpeed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        try {
            return Robotframework.secsToTimestr(0.0);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getSeleniumTimeout() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        try {
            return Robotframework.secsToTimestr(this.timeout);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getSeleniumImplicitWait() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        try {
            return Robotframework.secsToTimestr(this.implicitWait);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String setSeleniumSpeed(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)string2);
        try {
            return "0s";
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String setSeleniumTimeout(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)string2);
        try {
            void timestr;
            String oldWait = this.getSeleniumTimeout();
            this.timeout = Robotframework.timestrToSecs((String)timestr);
            for (WebDriverCache.SessionIdAliasWebDriverTuple sessionIdAliasWebDriverTuple : this.webDriverCache.getWebDrivers()) {
                sessionIdAliasWebDriverTuple.webDriver.manage().timeouts().setScriptTimeout((long)((int)(this.timeout * 1000.0)), TimeUnit.MILLISECONDS);
            }
            return oldWait;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String setSeleniumImplicitWait(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)string2);
        try {
            void timestr;
            String oldWait = this.getSeleniumTimeout();
            this.implicitWait = Robotframework.timestrToSecs((String)timestr);
            for (WebDriverCache.SessionIdAliasWebDriverTuple sessionIdAliasWebDriverTuple : this.webDriverCache.getWebDrivers()) {
                sessionIdAliasWebDriverTuple.webDriver.manage().timeouts().implicitlyWait((long)((int)(this.implicitWait * 1000.0)), TimeUnit.MILLISECONDS);
            }
            return oldWait;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String setBrowserImplicitWait(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)string2);
        try {
            void timestr;
            String oldWait = this.getSeleniumTimeout();
            this.implicitWait = Robotframework.timestrToSecs((String)timestr);
            this.webDriverCache.getCurrent().manage().timeouts().implicitlyWait((long)((int)(this.implicitWait * 1000.0)), TimeUnit.MILLISECONDS);
            return oldWait;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRemoteWebDriverProxy(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)string3, (Object)string4);
        try {
            void port;
            void host;
            this.setRemoteWebDriverProxy((String)host, (String)port, "", "", "", "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRemoteWebDriverProxy(String string, String string2, String string3, String string4) {
        String string5 = string;
        String string6 = string2;
        String string7 = string3;
        String string8 = string4;
        Object[] objectArray = new Object[]{string5, string6, string7, string8};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void password;
            void user;
            void port;
            void host;
            this.setRemoteWebDriverProxy((String)host, (String)port, (String)user, (String)password, "", "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRemoteWebDriverProxy(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = string;
        String string8 = string2;
        String string9 = string3;
        String string10 = string4;
        String string11 = string5;
        String string12 = string6;
        Object[] objectArray = new Object[]{string7, string8, string9, string10, string11, string12};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String workstation;
            void domain;
            String password;
            String user;
            void port;
            void host;
            if (host.length() == 0 || port.length() == 0) {
                this.remoteWebDriverProxyHost = "";
                this.remoteWebDriverProxyPort = "";
                this.remoteWebDriverProxyUser = "";
                this.remoteWebDriverProxyPassword = "";
                this.remoteWebDriverProxyDomain = "";
                this.remoteWebDriverProxyWorkstation = "";
                return;
            }
            URL proxyUrl = null;
            try {
                String httpProxy = System.getenv().get("http_proxy");
                if (httpProxy != null) {
                    proxyUrl = new URL(httpProxy);
                } else {
                    httpProxy = System.getenv().get("HTTP_PROXY");
                    if (httpProxy != null) {
                        proxyUrl = new URL(httpProxy);
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new Selenium2LibraryNonFatalException(e.getMessage());
            }
            if (user.length() == 0) {
                if (System.getProperty("http.proxyHost", "").equals(host) && System.getProperty("http.proxyPort", "").equals(port)) {
                    user = System.getProperty("http.proxyUser", "");
                }
                if (user.length() == 0 && proxyUrl != null && proxyUrl.getHost().equals(host) && Integer.toString(proxyUrl.getPort()).equals(port)) {
                    user = this.getUserFromURL(proxyUrl);
                }
            }
            if (password.length() == 0) {
                if (System.getProperty("http.proxyHost", "").equals(host) && System.getProperty("http.proxyPort", "").equals(port) && System.getProperty("http.proxyUser", "").equals(user)) {
                    password = System.getProperty("http.proxyPassword", "");
                }
                if (password.length() == 0 && proxyUrl != null && proxyUrl.getHost().equals(host) && Integer.toString(proxyUrl.getPort()).equals(port) && this.getUserFromURL(proxyUrl).equals(user)) {
                    password = this.getPasswordFromURL(proxyUrl);
                }
            }
            if (domain.length() != 0 && workstation.length() == 0) {
                try {
                    workstation = InetAddress.getLocalHost().getHostName().split("\\.")[0];
                }
                catch (UnknownHostException unknownHostException) {
                    this.warn("No workstation name found");
                }
            }
            this.remoteWebDriverProxyHost = host;
            this.remoteWebDriverProxyPort = port;
            this.remoteWebDriverProxyUser = user;
            this.remoteWebDriverProxyPassword = password;
            this.remoteWebDriverProxyDomain = domain;
            this.remoteWebDriverProxyWorkstation = workstation;
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String getUserFromURL(URL url) {
        String auth = url.getUserInfo();
        int index = auth.indexOf(58);
        if (index == -1) {
            return auth;
        }
        return auth.substring(0, index);
    }

    protected String getPasswordFromURL(URL url) {
        String auth = url.getUserInfo();
        int index = auth.indexOf(58);
        if (index == -1) {
            return "";
        }
        return auth.substring(index + 1);
    }

    protected WebDriver createWebDriver(String browserName, String desiredCapabilitiesString, String profileDirectory, String remoteUrlString) throws MalformedURLException {
        browserName = browserName.toLowerCase().replace(" ", "");
        DesiredCapabilities desiredCapabilities = this.createDesiredCapabilities(browserName, desiredCapabilitiesString, profileDirectory);
        WebDriver webDriver = remoteUrlString != null && !"False".equals(remoteUrlString) ? this.createRemoteWebDriver(desiredCapabilities, new URL(remoteUrlString)) : this.createLocalWebDriver(browserName, desiredCapabilities);
        webDriver.manage().timeouts().setScriptTimeout((long)((int)(this.timeout * 1000.0)), TimeUnit.MILLISECONDS);
        webDriver.manage().timeouts().implicitlyWait((long)((int)(this.implicitWait * 1000.0)), TimeUnit.MILLISECONDS);
        return webDriver;
    }

    protected WebDriver createLocalWebDriver(String browserName, DesiredCapabilities desiredCapabilities) {
        if ("ff".equals(browserName) || "firefox".equals(browserName)) {
            return new FirefoxDriver((Capabilities)desiredCapabilities);
        }
        if ("ie".equals(browserName) || "internetexplorer".equals(browserName)) {
            return new InternetExplorerDriver((Capabilities)desiredCapabilities);
        }
        if ("gc".equals(browserName) || "chrome".equals(browserName) || "googlechrome".equals(browserName)) {
            return new ChromeDriver((Capabilities)desiredCapabilities);
        }
        if ("opera".equals(browserName)) {
            return new OperaDriver((Capabilities)desiredCapabilities);
        }
        if ("phantomjs".equals(browserName)) {
            return new PhantomJSDriver((Capabilities)desiredCapabilities);
        }
        if ("safari".equals(browserName)) {
            return new SafariDriver((Capabilities)desiredCapabilities);
        }
        if ("htmlunit".equals(browserName)) {
            return new HtmlUnitDriver((Capabilities)desiredCapabilities);
        }
        if ("htmlunitwithjs".equals(browserName)) {
            HtmlUnitDriver driver = new HtmlUnitDriver((Capabilities)desiredCapabilities);
            driver.setJavascriptEnabled(true);
            return driver;
        }
        if ("iphone".equals(browserName) || "ipad".equals(browserName)) {
            try {
                return new IPhoneDriver((Capabilities)desiredCapabilities);
            }
            catch (Exception e) {
                throw new Selenium2LibraryFatalException("Creating " + browserName + " instance failed.", e);
            }
        }
        if ("android".equals(browserName)) {
            return new AndroidDriver(desiredCapabilities);
        }
        throw new Selenium2LibraryFatalException(String.valueOf(browserName) + " is not a supported browser.");
    }

    protected WebDriver createRemoteWebDriver(DesiredCapabilities desiredCapabilities, URL remoteUrl) {
        HttpCommandExecutor httpCommandExecutor = new HttpCommandExecutor(remoteUrl);
        this.setRemoteWebDriverProxy(httpCommandExecutor);
        return new Augmenter().augment((WebDriver)new RemoteWebDriver((CommandExecutor)httpCommandExecutor, (Capabilities)desiredCapabilities));
    }

    protected DesiredCapabilities createDesiredCapabilities(String browserName, String desiredCapabilitiesString, String profileDirectory) {
        DesiredCapabilities desiredCapabilities;
        if ("ff".equals(browserName) || "firefox".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.firefox();
            if (profileDirectory != null) {
                FirefoxProfile profile = new FirefoxProfile(new File(profileDirectory));
                desiredCapabilities.setCapability("firefox_profile", (Object)profile);
            }
        } else if ("ie".equals(browserName) || "internetexplorer".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.internetExplorer();
        } else if ("gc".equals(browserName) || "chrome".equals(browserName) || "googlechrome".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.chrome();
        } else if ("opera".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.opera();
        } else if ("phantomjs".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.phantomjs();
        } else if ("safari".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.safari();
        } else if ("ipad".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.ipad();
        } else if ("iphone".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.iphone();
        } else if ("android".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.android();
        } else if ("htmlunit".equals(browserName) || "htmlunitwithjs".equals(browserName)) {
            desiredCapabilities = DesiredCapabilities.htmlUnit();
        } else {
            throw new Selenium2LibraryFatalException(String.valueOf(browserName) + " is not a supported browser.");
        }
        if (desiredCapabilitiesString != null && !"None".equals(desiredCapabilitiesString)) {
            String[] stringArray = desiredCapabilitiesString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String capability = stringArray[n2];
                String[] keyValue = capability.split(":");
                desiredCapabilities.setCapability(keyValue[0], keyValue[1]);
                ++n2;
            }
        }
        return desiredCapabilities;
    }

    protected void setRemoteWebDriverProxy(HttpCommandExecutor httpCommandExecutor) {
        if (this.remoteWebDriverProxyHost.length() == 0) {
            return;
        }
        String fieldName = "<unknown>";
        String className = "<unknown>";
        try {
            fieldName = "client";
            className = "DefaultHttpClient";
            Field field = HttpCommandExecutor.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            DefaultHttpClient client = (DefaultHttpClient)field.get(httpCommandExecutor);
            AuthScope authScope = new AuthScope(this.remoteWebDriverProxyHost, Integer.parseInt(this.remoteWebDriverProxyPort));
            if (this.remoteWebDriverProxyDomain.length() == 0) {
                client.getCredentialsProvider().setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(this.remoteWebDriverProxyUser, this.remoteWebDriverProxyPassword));
            } else {
                client.getCredentialsProvider().setCredentials(authScope, (Credentials)new NTCredentials(this.remoteWebDriverProxyUser, this.remoteWebDriverProxyPassword, this.remoteWebDriverProxyWorkstation, this.remoteWebDriverProxyDomain));
            }
            client.setRoutePlanner((HttpRoutePlanner)new DefaultHttpRoutePlanner(client.getConnectionManager().getSchemeRegistry()));
            HttpHost proxy = new HttpHost(this.remoteWebDriverProxyHost, Integer.parseInt(this.remoteWebDriverProxyPort));
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        catch (SecurityException securityException) {
            throw new Selenium2LibraryFatalException(String.format("The SecurityManager does not allow us to lookup to the %s field.", fieldName));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new Selenium2LibraryFatalException(String.format("The RemoteWebDriver dose not declare the %s field any more.", fieldName));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Selenium2LibraryFatalException(String.format("The field %s does not belong to the given object.", fieldName));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Selenium2LibraryFatalException(String.format("The SecurityManager does not allow us to access to the %s field.", fieldName));
        }
        catch (ClassCastException classCastException) {
            throw new Selenium2LibraryFatalException(String.format("The %s field does not contain a %s.", fieldName, className));
        }
    }

    protected abstract List<WebElement> elementFind(String var1, boolean var2, boolean var3);

    protected abstract void log(String var1, String var2);

    protected abstract void trace(String var1);

    protected abstract void debug(String var1);

    protected abstract void info(String var1);

    protected abstract void html(String var1);

    protected abstract void warn(String var1);

    protected abstract List<String> logList(List<String> var1);

    protected abstract List<String> logList(List<String> var1, String var2);

    protected abstract File getLogDir();

    static {
        BrowserManagement.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BrowserManagement.java", BrowserManagement.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "url", "java.lang.Throwable", "java.lang.String"), 79);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWindowIdentifiers", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.util.List"), 158);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWindowNames", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.util.List"), 163);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWindowTitles", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.util.List"), 172);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "maximizeBrowserWindow", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 178);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectFrame", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "locator", "", "void"), 182);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectWindow", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 188);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectWindow", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "locator", "", "void"), 192);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unselectFrame", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 196);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLocation", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 200);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSource", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 204);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String", "url:browserName", "java.lang.Throwable", "java.lang.String"), 83);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTitle", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 208);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "locationShouldBe", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "url", "", "void"), 212);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "locationShouldContain", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "url", "", "void"), 221);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logLocation", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 230);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logSource", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 236);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logSource", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "logLevel", "", "java.lang.String"), 240);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logTitle", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 246);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "titleShouldBe", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "title", "", "void"), 252);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "goBack", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 261);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "goTo", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "url", "", "void"), 265);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String", "url:browserName:alias", "java.lang.Throwable", "java.lang.String"), 87);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reloadPage", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 270);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSeleniumSpeed", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 274);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSeleniumTimeout", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 278);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSeleniumImplicitWait", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "java.lang.String"), 282);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSeleniumSpeed", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "timestr", "", "java.lang.String"), 286);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSeleniumTimeout", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "timestr", "", "java.lang.String"), 290);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSeleniumImplicitWait", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "timestr", "", "java.lang.String"), 305);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBrowserImplicitWait", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "timestr", "", "java.lang.String"), 320);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoteWebDriverProxy", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String", "host:port", "", "void"), 332);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoteWebDriverProxy", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "host:port:user:password", "", "void"), 336);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "url:browserName:alias:remoteUrl", "java.lang.Throwable", "java.lang.String"), 92);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoteWebDriverProxy", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "host:port:user:password:domain:workstation", "", "void"), 341);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "url:browserName:alias:remoteUrl:desiredCapabilities", "java.lang.Throwable", "java.lang.String"), 97);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "url:browserName:alias:remoteUrl:desiredCapabilities:ffProfileDir", "java.lang.Throwable", "java.lang.String"), 103);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "switchBrowser", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "java.lang.String", "indexOrAlias", "", "void"), 137);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeAllBrowsers", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 149);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeWindow", "com.github.markusbernhardt.selenium2library.keywords.BrowserManagement", "", "", "", "void"), 154);
    }
}

