/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.locators;

import com.github.markusbernhardt.selenium2library.Selenium2Library;
import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.utils.Python;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.python.util.PythonInterpreter;

public class ElementFinder {
    private static final Hashtable<String, CustomStrategy> registeredLocationStrategies = new Hashtable();
    protected static ThreadLocal<PythonInterpreter> loggingPythonInterpreter = new ThreadLocal<PythonInterpreter>(){

        @Override
        protected PythonInterpreter initialValue() {
            PythonInterpreter pythonInterpreter = new PythonInterpreter();
            pythonInterpreter.exec("from robot.variables import GLOBAL_VARIABLES; from robot.api import logger;");
            return pythonInterpreter;
        }
    };

    private static List<WebElement> findByJQuerySizzle(WebDriver webDriver, FindByCoordinates findByCoordinates) {
        String js = String.format("return jQuery('%s').get();", findByCoordinates.criteria.replace("'", "\\'"));
        Object o = ((JavascriptExecutor)webDriver).executeScript(js, new Object[0]);
        List<WebElement> list = ElementFinder.toList(o);
        return ElementFinder.filterElements(list, findByCoordinates);
    }

    private static List<WebElement> filterElements(List<WebElement> elements, FindByCoordinates findByCoordinates) {
        if (findByCoordinates.tag == null) {
            return elements;
        }
        ArrayList<WebElement> result = new ArrayList<WebElement>();
        for (WebElement element : elements) {
            if (!ElementFinder.elementMatches(element, findByCoordinates)) continue;
            result.add(element);
        }
        return result;
    }

    private static boolean elementMatches(WebElement element, FindByCoordinates findByCoordinates) {
        if (!element.getTagName().toLowerCase().equals(findByCoordinates.tag)) {
            return false;
        }
        if (findByCoordinates.constraints != null) {
            for (String name : findByCoordinates.constraints.keySet()) {
                if (element.getAttribute(name).equals(findByCoordinates.constraints.get(name))) continue;
                return false;
            }
        }
        return true;
    }

    private static List<WebElement> findByKeyAttrs(WebDriver webDriver, FindByCoordinates findByCoordinates) {
        KeyAttrs keyAttrs = KeyAttrs.DEFAULT;
        if (findByCoordinates.tag != null) {
            try {
                keyAttrs = KeyAttrs.valueOf(findByCoordinates.tag.trim().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        String xpathCriteria = Selenium2Library.escapeXpathValue(findByCoordinates.criteria);
        String xpathTag = findByCoordinates.tag;
        if (findByCoordinates.tag == null) {
            xpathTag = "*";
        }
        ArrayList<String> xpathConstraints = new ArrayList<String>();
        if (findByCoordinates.constraints != null) {
            for (Map.Entry<String, String> entry : findByCoordinates.constraints.entrySet()) {
                xpathConstraints.add(String.format("@%s='%s'", entry.getKey(), entry.getValue()));
            }
        }
        ArrayList<String> xpathSearchers = new ArrayList<String>();
        String[] stringArray = keyAttrs.getKeyAttrs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            xpathSearchers.add(String.format("%s=%s", attr, xpathCriteria));
            ++n2;
        }
        xpathSearchers.addAll(ElementFinder.getAttrsWithUrl(webDriver, keyAttrs, findByCoordinates.criteria));
        String xpath = String.format("//%s[%s(%s)]", xpathTag, String.valueOf(Python.join(" and ", xpathConstraints)) + (xpathConstraints.size() > 0 ? " and " : ""), Python.join(" or ", xpathSearchers));
        return webDriver.findElements(By.xpath((String)xpath));
    }

    private static List<String> getAttrsWithUrl(WebDriver webDriver, KeyAttrs keyAttrs, String criteria) {
        String[] srcHref;
        ArrayList<String> attrs = new ArrayList<String>();
        String url = null;
        String xpathUrl = null;
        String[] stringArray = srcHref = new String[]{"@src", "@href"};
        int n = srcHref.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            String[] stringArray2 = keyAttrs.getKeyAttrs();
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String keyAttr = stringArray2[n4];
                if (attr.equals(keyAttr)) {
                    if (url == null || xpathUrl == null) {
                        url = String.valueOf(ElementFinder.getBaseUrl(webDriver)) + "/" + criteria;
                        xpathUrl = Selenium2Library.escapeXpathValue(url);
                    }
                    attrs.add(String.format("%s=%s", attr, xpathUrl));
                }
                ++n4;
            }
            ++n2;
        }
        return attrs;
    }

    private static String getBaseUrl(WebDriver webDriver) {
        String url = webDriver.getCurrentUrl();
        int lastIndex = url.lastIndexOf(47);
        if (lastIndex != -1) {
            url = url.substring(0, lastIndex);
        }
        return url;
    }

    public static void addLocationStrategy(String strategyName, String functionDefinition, String delimiter) {
        registeredLocationStrategies.put(strategyName.toUpperCase(), new CustomStrategy(functionDefinition, delimiter));
    }

    public static List<WebElement> find(WebDriver webDriver, String locator) {
        return ElementFinder.find(webDriver, locator, null);
    }

    public static List<WebElement> find(WebDriver webDriver, String locator, String tag) {
        if (webDriver == null) {
            throw new Selenium2LibraryNonFatalException("ElementFinder.find: webDriver is null.");
        }
        if (locator == null) {
            throw new Selenium2LibraryNonFatalException("ElementFinder.find: locator is null.");
        }
        FindByCoordinates findByCoordinates = new FindByCoordinates();
        Strategy strategy = ElementFinder.parseLocator(findByCoordinates, locator);
        ElementFinder.parseTag(findByCoordinates, strategy, tag);
        return strategy.findBy(webDriver, findByCoordinates);
    }

    protected static void warn(String msg) {
        loggingPythonInterpreter.get().exec(String.format("logger.warn('%s');", msg.replace("'", "\\'").replace("\n", "\\n")));
    }

    private static Strategy parseLocator(FindByCoordinates findByCoordinates, String locator) {
        Strategy strategy;
        String criteria;
        block4: {
            String[] locatorParts;
            String prefix = null;
            criteria = locator;
            if (!locator.startsWith("//") && (locatorParts = locator.split("=", 2)).length == 2) {
                prefix = locatorParts[0].trim().toUpperCase();
                criteria = locatorParts[1].trim();
            }
            strategy = StrategyEnum.DEFAULT;
            if (prefix != null) {
                try {
                    strategy = StrategyEnum.valueOf(prefix);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    CustomStrategy customStrategy = registeredLocationStrategies.get(prefix);
                    if (customStrategy == null) break block4;
                    strategy = customStrategy;
                }
            }
        }
        findByCoordinates.criteria = criteria;
        return strategy;
    }

    private static void parseTag(FindByCoordinates findByCoordinates, Strategy strategy, String tag) {
        if (tag == null) {
            return;
        }
        tag = tag.toLowerCase();
        TreeMap<String, String> constraints = new TreeMap<String, String>();
        if (tag.equals("link")) {
            tag = "a";
        } else if (tag.equals("image")) {
            tag = "img";
        } else if (tag.equals("list")) {
            tag = "select";
        } else if (tag.equals("radio button")) {
            tag = "input";
            constraints.put("type", "radio");
        } else if (tag.equals("checkbox")) {
            tag = "input";
            constraints.put("type", "checkbox");
        } else if (tag.equals("text field")) {
            tag = "input";
            constraints.put("type", "text");
        } else if (tag.equals("file upload")) {
            tag = "input";
            constraints.put("type", "file");
        }
        findByCoordinates.tag = tag;
        findByCoordinates.constraints = constraints;
    }

    private static List<WebElement> toList(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        ArrayList<WebElement> list = new ArrayList<WebElement>();
        if (o instanceof WebElement) {
            list.add((WebElement)o);
            return list;
        }
        return list;
    }

    private static class CustomStrategy
    implements Strategy {
        private String functionDefinition;
        private String delimiter;

        public CustomStrategy(String functionDefinition, String delimiter) {
            this.functionDefinition = functionDefinition;
            this.delimiter = delimiter;
        }

        @Override
        public List<WebElement> findBy(final WebDriver webDriver, final FindByCoordinates findByCoordinates) {
            return ElementFinder.filterElements(webDriver.findElements(new By(){

                public List<WebElement> findElements(SearchContext context) {
                    Object[] arguments = null;
                    if (CustomStrategy.this.delimiter == null) {
                        arguments = new Object[]{findByCoordinates.criteria};
                    } else {
                        String[] splittedCriteria = findByCoordinates.criteria.split(CustomStrategy.this.delimiter);
                        arguments = new Object[splittedCriteria.length];
                        int i = 0;
                        while (i < splittedCriteria.length) {
                            arguments[i] = splittedCriteria[i];
                            ++i;
                        }
                    }
                    Object o = ((JavascriptExecutor)webDriver).executeScript(CustomStrategy.this.functionDefinition, arguments);
                    return ElementFinder.toList(o);
                }
            }), findByCoordinates);
        }
    }

    private static class FindByCoordinates {
        String criteria;
        String tag;
        Map<String, String> constraints;

        private FindByCoordinates() {
        }
    }

    private static enum KeyAttrs {
        DEFAULT("@id,@name"),
        A("@id,@name,@href,normalize-space(descendant-or-self::text())"),
        IMG("@id,@name,@src,@alt"),
        INPUT("@id,@name,@value,@src"),
        BUTTON("@id,@name,@value,normalize-space(descendant-or-self::text())");

        private String[] keyAttrs;

        private KeyAttrs(String keyAttrs) {
            this.keyAttrs = keyAttrs.split(",");
        }

        public String[] getKeyAttrs() {
            return this.keyAttrs;
        }
    }

    private static interface Strategy {
        public List<WebElement> findBy(WebDriver var1, FindByCoordinates var2);
    }

    private static enum StrategyEnum implements Strategy
    {
        DEFAULT{

            @Override
            public List<WebElement> findBy(WebDriver webDriver, FindByCoordinates findByCoordinates) {
                if (findByCoordinates.criteria.startsWith("//")) {
                    return XPATH.findBy(webDriver, findByCoordinates);
                }
                return ElementFinder.findByKeyAttrs(webDriver, findByCoordinates);
            }
        }
        ,
        IDENTIFIER{

            @Override
            public List<WebElement> findBy(WebDriver webDriver, FindByCoordinates findByCoordinates) {
                List elements = webDriver.findElements(By.id((String)findByCoordinates.criteria));
                elements.addAll(webDriver.findElements(By.name((String)findByCoordinates.criteria)));
                return ElementFinder.filterElements(elements, findByCoordinates);
            }
        }
        ,
        ID{

            @Override
            public List<WebElement> findBy(WebDriver webDriver, FindByCoordinates findByCoordinates) {
                return ElementFinder.filterElements(webDriver.findElements(By.id((String)findByCoordinates.criteria)), findByCoordinates);
            }
        }
        ,
        NAME{

            @Override
            public List<WebElement> findBy(WebDriver webDriver, FindByCoordinates findByCoordinates) {
                return ElementFinder.filterElements(webDriver.findElements(By.name((String)findByCoordinates.criteria)), findByCoordinates);
            }
        }
        ,
        XPATH{

            @Override
            public List<WebElement> findBy(WebDriver webDriver, FindByCoordinates findByCoordinates) {
                return ElementFinder.filterElements(webDriver.findElements(By.xpath((String)findByCoordinates.criteria)), findByCoordinates);
            }
        }
        ,
        DOM{

            @Override
            public List<WebElement> findBy(WebDriver webDriver, FindByCoordinates findByCoordinates) {
                Object result = ((JavascriptExecutor)webDriver).executeScript(String.format("return %s;", findByCoordinates.criteria), new Object[0]);
                return ElementFinder.filterElements(ElementFinder.toList(result), findByCoordinates);
            }
        }
        ,
        LINK{

            @Override
            public List<WebElement> findBy(WebDriver webDriver, FindByCoordinates findByCoordinates) {
                return ElementFinder.filterElements(webDriver.findElements(By.linkText((String)findByCoordinates.criteria)), findByCoordinates);
            }
        }
        ,
        CSS{

            @Override
            public List<WebElement> findBy(WebDriver webDriver, FindByCoordinates findByCoordinates) {
                return ElementFinder.filterElements(webDriver.findElements(By.cssSelector((String)findByCoordinates.criteria)), findByCoordinates);
            }
        }
        ,
        TAG{

            @Override
            public List<WebElement> findBy(WebDriver webDriver, FindByCoordinates findByCoordinates) {
                return ElementFinder.filterElements(webDriver.findElements(By.tagName((String)findByCoordinates.criteria)), findByCoordinates);
            }
        }
        ,
        JQUERY{

            @Override
            public List<WebElement> findBy(WebDriver webDriver, FindByCoordinates findByCoordinates) {
                return ElementFinder.findByJQuerySizzle(webDriver, findByCoordinates);
            }
        }
        ,
        SIZZLE{

            @Override
            public List<WebElement> findBy(WebDriver webDriver, FindByCoordinates findByCoordinates) {
                return ElementFinder.findByJQuerySizzle(webDriver, findByCoordinates);
            }
        };

    }
}

