/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.RunOnFailure;
import com.github.markusbernhardt.selenium2library.utils.Robotframework;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public abstract class Screenshot
extends RunOnFailure {
    private int screenshotIndex = 0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public void capturePageScreenshot() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            this.capturePageScreenshot(null);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void capturePageScreenshot(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string2);
        try {
            void filename;
            File logdir = this.getLogDir();
            File path = new File(logdir, this.normalizeFilename((String)filename));
            String link = Robotframework.getLinkPath(path, logdir);
            TakesScreenshot takesScreenshot = (TakesScreenshot)this.webDriverCache.getCurrent();
            if (takesScreenshot == null) {
                this.warn("Can't take screenshot. No open browser found");
                return;
            }
            byte[] png = (byte[])takesScreenshot.getScreenshotAs(OutputType.BYTES);
            this.writeScreenshot(path, png);
            this.html(String.format("</td></tr><tr><td colspan=\"3\"><a href=\"%s\"><img src=\"%s\" width=\"800px\"></a>", link, link));
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    private void writeScreenshot(File path, byte[] png) {
        block14: {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(path);
                    fos.write(png);
                    fos.flush();
                }
                catch (IOException iOException) {
                    this.warn(String.format("Can't write screenshot '%s'", path.getAbsolutePath()));
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException2) {
                            this.warn("Can't even close stream");
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                        this.warn("Can't even close stream");
                    }
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {
                    this.warn("Can't even close stream");
                }
            }
        }
    }

    private String normalizeFilename(String filename) {
        if (filename == null) {
            ++this.screenshotIndex;
            filename = String.format("selenium-screenshot-%d.png", this.screenshotIndex);
        } else {
            filename = filename.replace('/', File.separatorChar);
        }
        return filename;
    }

    static {
        Screenshot.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Screenshot.java", Screenshot.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "capturePageScreenshot", "com.github.markusbernhardt.selenium2library.keywords.Screenshot", "", "", "", "void"), 18);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "capturePageScreenshot", "com.github.markusbernhardt.selenium2library.keywords.Screenshot", "java.lang.String", "filename", "", "void"), 22);
    }
}

