/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.FormElement;
import com.github.markusbernhardt.selenium2library.utils.Python;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.Alert;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriverException;

public abstract class JavaScript
extends FormElement {
    protected boolean cancelOnNextConfirmation = false;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public void alertShouldBePresent() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            this.alertShouldBePresent("");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alertShouldBePresent(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string2);
        try {
            void text;
            String alertText = this.getAlertMessage();
            if (text != null && !alertText.equals(text)) {
                throw new Selenium2LibraryNonFatalException(String.format("Alert text should have been '%s' but was '%s'", text, alertText));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public void chooseCancelOnNextConfirmation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            this.cancelOnNextConfirmation = true;
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public void chooseOkOnNextConfirmation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            this.cancelOnNextConfirmation = false;
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String confirmAction() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            String text = this.closeAlert(!this.cancelOnNextConfirmation);
            this.cancelOnNextConfirmation = false;
            return text;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object executeJavascript(String ... stringArray) {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)stringArray2);
        try {
            void code;
            String js = this.getJavascriptToExecute(Python.join("", Arrays.asList(code)));
            String.format("Executing JavaScript:\n%s", js);
            return ((JavascriptExecutor)this.webDriverCache.getCurrent()).executeScript(js, new Object[0]);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object executeAsyncJavascript(String ... stringArray) {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)stringArray2);
        try {
            void code;
            String js = this.getJavascriptToExecute(Python.join("", Arrays.asList(code)));
            String.format("Executing JavaScript:\n%s", js);
            return ((JavascriptExecutor)this.webDriverCache.getCurrent()).executeAsyncScript(js, new Object[0]);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getAlertMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            return this.closeAlert();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String closeAlert() {
        return this.closeAlert(false);
    }

    protected String closeAlert(boolean confirm) {
        Alert alert = null;
        try {
            alert = this.webDriverCache.getCurrent().switchTo().alert();
            String text = alert.getText().replace("\n", "");
            if (!confirm) {
                alert.dismiss();
            } else {
                alert.accept();
            }
            return text;
        }
        catch (WebDriverException webDriverException) {
            throw new Selenium2LibraryNonFatalException("There were no alerts");
        }
    }

    protected static String readFile(String path) throws IOException {
        FileInputStream stream = new FileInputStream(new File(path));
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    protected String getJavascriptToExecute(String code) {
        String codepath = code.replace('/', File.separatorChar);
        if (!new File(codepath).isFile()) {
            return code;
        }
        this.html(String.format("Reading JavaScript from file <a href=\"file://%s\">%s</a>.", codepath.replace(File.separatorChar, '/'), codepath));
        try {
            return JavaScript.readFile(codepath);
        }
        catch (IOException iOException) {
            throw new Selenium2LibraryNonFatalException("Cannot read JavaScript file: " + codepath);
        }
    }

    static {
        JavaScript.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JavaScript.java", JavaScript.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "alertShouldBePresent", "com.github.markusbernhardt.selenium2library.keywords.JavaScript", "", "", "", "void"), 24);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "alertShouldBePresent", "com.github.markusbernhardt.selenium2library.keywords.JavaScript", "java.lang.String", "text", "", "void"), 28);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "chooseCancelOnNextConfirmation", "com.github.markusbernhardt.selenium2library.keywords.JavaScript", "", "", "", "void"), 37);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "chooseOkOnNextConfirmation", "com.github.markusbernhardt.selenium2library.keywords.JavaScript", "", "", "", "void"), 41);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "confirmAction", "com.github.markusbernhardt.selenium2library.keywords.JavaScript", "", "", "", "java.lang.String"), 45);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "executeJavascript", "com.github.markusbernhardt.selenium2library.keywords.JavaScript", "[Ljava.lang.String;", "code", "", "java.lang.Object"), 51);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "executeAsyncJavascript", "com.github.markusbernhardt.selenium2library.keywords.JavaScript", "[Ljava.lang.String;", "code", "", "java.lang.Object"), 58);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAlertMessage", "com.github.markusbernhardt.selenium2library.keywords.JavaScript", "", "", "", "java.lang.String"), 65);
    }
}

