/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.utils;

import com.github.markusbernhardt.selenium2library.Selenium2LibraryFatalException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.WebDriver;

public class WebDriverCache {
    int currentSessionId = 0;
    WebDriver currentWebDriver;
    Map<Integer, WebDriver> webDriverBySessionId = new TreeMap<Integer, WebDriver>();
    Map<String, Integer> sessionIdByAlias = new TreeMap<String, Integer>();

    public String register(WebDriver webDriver, String alias) {
        ++this.currentSessionId;
        this.currentWebDriver = webDriver;
        this.webDriverBySessionId.put(this.currentSessionId, webDriver);
        if (alias != null) {
            this.sessionIdByAlias.put(alias, this.currentSessionId);
        }
        return Integer.toString(this.currentSessionId);
    }

    public WebDriver getCurrent() {
        return this.currentWebDriver;
    }

    public String getCurrentSessionId() {
        return Integer.toString(this.currentSessionId);
    }

    public void close() {
        this.currentSessionId = 0;
        this.close(this.currentWebDriver);
    }

    public void close(WebDriver webDriver) {
        if (webDriver != null) {
            webDriver.quit();
            this.webDriverBySessionId.values().remove(webDriver);
            this.sessionIdByAlias.values().remove(webDriver);
        }
    }

    public void closeAll() {
        for (WebDriver webDriver : this.webDriverBySessionId.values()) {
            this.close(webDriver);
        }
    }

    public void switchBrowser(String sessionIdOrAlias) {
        WebDriver webDriver;
        Integer sessionId = this.sessionIdByAlias.get(sessionIdOrAlias);
        if (sessionId == null) {
            try {
                sessionId = Integer.parseInt(sessionIdOrAlias);
            }
            catch (NullPointerException nullPointerException) {
                throw new Selenium2LibraryFatalException(String.format("Non-existing index or alias '%s'", sessionIdOrAlias));
            }
        }
        if ((webDriver = this.webDriverBySessionId.get(sessionId)) == null) {
            throw new Selenium2LibraryFatalException(String.format("Non-existing index or alias '%s'", sessionIdOrAlias));
        }
        this.currentWebDriver = webDriver;
        this.currentSessionId = sessionId;
    }

    public Collection<WebDriver> getWebDrivers() {
        return this.webDriverBySessionId.values();
    }
}

