/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.utils;

import com.github.markusbernhardt.selenium2library.utils.Python;
import java.util.ArrayList;
import java.util.List;

public class TimestrHelper {
    private boolean compact;
    private List<String> ret = new ArrayList<String>();
    private String sign;
    private int millis;
    private int secs;
    private int mins;
    private int hours;
    private int days;

    public TimestrHelper(double double_secs) {
        this(double_secs, false);
    }

    public TimestrHelper(double double_secs, boolean compact) {
        this.compact = compact;
        this.secsToComponents(double_secs);
        this.addItem(this.days, "d", "day");
        this.addItem(this.hours, "h", "hour");
        this.addItem(this.mins, "min", "minute");
        this.addItem(this.secs, "s", "second");
        this.addItem(this.millis, "ms", "millisecond");
    }

    public String getValue() {
        if (this.ret.size() > 0) {
            return String.valueOf(this.sign) + Python.join(" ", this.ret);
        }
        return this.compact ? "0s" : "0 seconds";
    }

    protected int doubleSecsToSecs(double double_secs) {
        return (int)double_secs;
    }

    protected int doubleSecsToMillis(double double_secs) {
        int int_secs = this.doubleSecsToSecs(double_secs);
        return (int)Math.round((double_secs - (double)int_secs) * 1000.0);
    }

    protected void addItem(int value, String compactSuffix, String longSuffix) {
        if (value == 0) {
            return;
        }
        String suffix = compactSuffix;
        if (!this.compact) {
            suffix = String.format(" %s%s", longSuffix, this.pluralOrNot(value));
        }
        this.ret.add(String.format("%d%s", value, suffix));
    }

    protected void secsToComponents(double double_secs) {
        if (double_secs < 0.0) {
            this.sign = "- ";
            double_secs = Math.abs(double_secs);
        } else {
            this.sign = "";
        }
        int int_secs = this.doubleSecsToSecs(double_secs);
        this.millis = this.doubleSecsToMillis(double_secs);
        this.secs = int_secs % 60;
        this.mins = int_secs / 60 % 60;
        this.hours = int_secs / 3600 % 24;
        this.days = int_secs / 86400;
    }

    protected String pluralOrNot(int value) {
        return value == 1 ? "" : "s";
    }
}

