/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.utils;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Python {
    public static String join(String glue, String[] strings) {
        return Python.join(glue, (Iterable<String>)Arrays.asList(strings));
    }

    public static String join(String glue, Iterable<String> strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String verkett = "";
        for (String string : strings) {
            stringBuilder.append(verkett);
            stringBuilder.append(string);
            verkett = glue;
        }
        return stringBuilder.toString();
    }

    public static <A, B> Map<A, B> zip(List<A> keys, List<B> values) {
        if (keys.size() != values.size()) {
            return null;
        }
        HashMap map = new HashMap();
        Iterator valueIterator = values.listIterator();
        for (A key : keys) {
            map.put(key, valueIterator.next());
        }
        return map;
    }

    public static String osPathBasename(String path) {
        int index = path.lastIndexOf(File.separatorChar) + 1;
        return path.substring(index);
    }

    public static String osPathDirname(String path) {
        int index = path.lastIndexOf(File.separatorChar) + 1;
        String head = path.substring(0, index);
        if (head.length() != 0) {
            String regex = "";
            regex = File.separatorChar == '/' ? String.format("/{%d}", head.length()) : String.format("\\\\{%d}", head.length());
            if (!head.matches(regex)) {
                head = Python.rstrip(head, File.separatorChar);
            }
        }
        return head;
    }

    public static String[] osPathSplitDrive(String path) {
        String[] array = new String[2];
        if (File.separatorChar == '/') {
            array[0] = "";
            array[1] = path;
        } else {
            int index = path.indexOf(58) + 1;
            array[0] = path.substring(0, index);
            array[1] = path.substring(index);
        }
        return array;
    }

    public static String lstrip(String string) {
        return Python.lstrip(string, ' ');
    }

    public static String lstrip(String string, char trimChar) {
        int stringLength = string.length();
        int i = 0;
        while (i < stringLength && string.charAt(i) == trimChar) {
            ++i;
        }
        if (i == 0) {
            return string;
        }
        return string.substring(i);
    }

    public static String rstrip(String string) {
        return Python.rstrip(string, ' ');
    }

    public static String rstrip(String string, char trimChar) {
        int lastChar;
        int i = lastChar = string.length() - 1;
        while (i >= 0 && string.charAt(i) == trimChar) {
            --i;
        }
        if (i < lastChar) {
            return string.substring(0, i + 1);
        }
        return string;
    }
}

