/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.locators;

import com.github.markusbernhardt.selenium2library.locators.ElementFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class TableElementFinder {
    private static final TreeMap<String, List<String>> locatorSuffixesMap = new TreeMap();

    static {
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "css.default", "");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "css.content", "");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "css.header", " th");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "css.footer", " tfoot td");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "css.row", " tr:nth-child(%s)");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "css.col", " tr td:nth-child(%s)", " tr th:nth-child(%s)");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "sizzle.default", "");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "sizzle.content", "");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "sizzle.header", " th");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "sizzle.footer", " tfoot td");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "sizzle.row", " tr:nth-child(%s)");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "sizzle.col", " tr td:nth-child(%s)", " tr th:nth-child(%s)");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "xpath.default", "");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "xpath.content", "//*");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "xpath.header", "//th");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "xpath.footer", "//tfoot//td");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "xpath.row", "//tr[%s]//*");
        TableElementFinder.addLocatorSuffix(locatorSuffixesMap, "xpath.col", "//tr//*[self::td or self::th][%s]");
    }

    public static WebElement find(WebDriver webDriver, String tableLocator) {
        List<String> locators = TableElementFinder.parseTableLocator(tableLocator, "default");
        return TableElementFinder.searchInLocators(webDriver, locators, null);
    }

    public static WebElement findByContent(WebDriver webDriver, String tableLocator, String content) {
        List<String> locators = TableElementFinder.parseTableLocator(tableLocator, "content");
        return TableElementFinder.searchInLocators(webDriver, locators, content);
    }

    public static WebElement findByHeader(WebDriver webDriver, String tableLocator, String content) {
        List<String> locators = TableElementFinder.parseTableLocator(tableLocator, "header");
        return TableElementFinder.searchInLocators(webDriver, locators, content);
    }

    public static WebElement findByFooter(WebDriver webDriver, String tableLocator, String content) {
        List<String> locators = TableElementFinder.parseTableLocator(tableLocator, "footer");
        return TableElementFinder.searchInLocators(webDriver, locators, content);
    }

    public static WebElement findByRow(WebDriver webDriver, String tableLocator, int row, String content) {
        List<String> locators = TableElementFinder.parseTableLocator(tableLocator, "row");
        ArrayList<String> formattedLocators = new ArrayList<String>();
        for (String locator : locators) {
            formattedLocators.add(String.format(locator, Integer.toString(row)));
        }
        return TableElementFinder.searchInLocators(webDriver, formattedLocators, content);
    }

    public static WebElement findByCol(WebDriver webDriver, String tableLocator, int col, String content) {
        List<String> locators = TableElementFinder.parseTableLocator(tableLocator, "col");
        ArrayList<String> formattedLocators = new ArrayList<String>();
        for (String locator : locators) {
            formattedLocators.add(String.format(locator, Integer.toString(col)));
        }
        return TableElementFinder.searchInLocators(webDriver, formattedLocators, content);
    }

    private static void addLocatorSuffix(Map<String, List<String>> locatorSuffixesMap, String key, String ... values) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            list.add(value);
            ++n2;
        }
        locatorSuffixesMap.put(key, list);
    }

    private static List<String> parseTableLocator(String tableLocator, String locationMethod) {
        String tableLocatorType = null;
        if (tableLocator.startsWith("xpath=")) {
            tableLocatorType = "xpath.";
        } else if (tableLocator.startsWith("jquery=") || tableLocator.startsWith("sizzle=")) {
            tableLocatorType = "sizzle.";
        } else {
            if (!tableLocator.startsWith("css=")) {
                tableLocator = String.format("css=table#%s", tableLocator);
            }
            tableLocatorType = "css.";
        }
        List<String> locatorSuffixes = locatorSuffixesMap.get(String.valueOf(tableLocatorType) + locationMethod);
        ArrayList<String> parsedTabeLocators = new ArrayList<String>();
        for (String locatorSuffix : locatorSuffixes) {
            parsedTabeLocators.add(String.valueOf(tableLocator) + locatorSuffix);
        }
        return parsedTabeLocators;
    }

    private static WebElement searchInLocators(WebDriver webDriver, List<String> locators, String content) {
        for (String locator : locators) {
            List<WebElement> elements = ElementFinder.find(webDriver, locator);
            for (WebElement element : elements) {
                if (content == null) {
                    return element;
                }
                String elementText = element.getText();
                if (elementText == null || !elementText.contains(content)) continue;
                return element;
            }
        }
        return null;
    }
}

