/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.aspects.RunOnFailureAspect;
import com.github.markusbernhardt.selenium2library.keywords.Screenshot;
import com.github.markusbernhardt.selenium2library.utils.Python;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public abstract class SelectElement
extends Screenshot {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;

    /*
     * WARNING - void declaration
     */
    public List<String> getListItems(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
        try {
            void locator;
            List<WebElement> options = this.getSelectListOptions((String)locator);
            return this.getLabelsForOptions(options);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getSelectedListLabel(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string2);
        try {
            void locator;
            Select select = this.getSelectList((String)locator);
            return select.getFirstSelectedOption().getText();
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getSelectedListLabels(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
        try {
            void locator;
            List<WebElement> options = this.getSelectListOptionsSelected((String)locator);
            if (options.size() == 0) {
                throw new Selenium2LibraryNonFatalException(String.format("Select list with locator '%s' does not have any selected values.", locator));
            }
            return this.getLabelsForOptions(options);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getSelectedListValue(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string2);
        try {
            void locator;
            Select select = this.getSelectList((String)locator);
            return select.getFirstSelectedOption().getAttribute("value");
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getSelectedListValues(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2);
        try {
            void locator;
            List<WebElement> options = this.getSelectListOptionsSelected((String)locator);
            if (options.size() == 0) {
                throw new Selenium2LibraryNonFatalException(String.format("Select list with locator '%s' does not have any selected values.", locator));
            }
            return this.getValuesForOptions(options);
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void listSelectionShouldBe(String string, List<String> list) {
        String string2 = string;
        List<String> list2 = list;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2, list2);
        try {
            void locator;
            void items;
            String itemList = items.size() != 0 ? String.format("option(s) [ %s ]", Python.join(" | ", (Iterable<String>)items)) : "no options";
            this.info(String.format("Verifying list '%s' has %s selected.", locator, itemList));
            this.pageShouldContainList((String)locator);
            List<WebElement> options = this.getSelectListOptionsSelected((String)locator);
            if (items.size() > 0 || options.size() > 0) {
                List<String> selectedValues = this.getValuesForOptions(options);
                List<String> selectedLabels = this.getLabelsForOptions(options);
                String message = String.format("List '%s' should have had selection [ %s ] but it was [ %s ].", locator, Python.join(" | ", (Iterable<String>)items), Python.join(" | ", selectedLabels));
                for (String item : items) {
                    if (selectedValues.contains(item) && selectedLabels.contains(item)) continue;
                    throw new Selenium2LibraryNonFatalException(message);
                }
                Map<String, String> map = Python.zip(selectedValues, selectedLabels);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (items.contains(entry.getKey()) && items.contains(entry.getValue())) continue;
                    throw new Selenium2LibraryNonFatalException(message);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void listShouldHaveNoSelections(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string2);
        try {
            void locator;
            this.info(String.format("Verifying list '%s' has no selection.", locator));
            List<WebElement> options = this.getSelectListOptionsSelected((String)locator);
            if (!options.equals(null)) {
                List<String> selectedLabels = this.getLabelsForOptions(options);
                String items = Python.join(" | ", selectedLabels);
                throw new Selenium2LibraryNonFatalException(String.format("List '%s' should have had no selection (selection was [ %s ]).", locator, items.toString()));
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void pageShouldContainList(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string2);
        try {
            void locator;
            this.pageShouldContainList((String)locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void pageShouldContainList(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string3, (Object)string4);
        try {
            void message;
            void locator;
            this.pageShouldContainList((String)locator, (String)message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void pageShouldContainList(String string, String string2, String string3) {
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void logLevel;
            void message;
            void locator;
            this.pageShouldContainElement((String)locator, "list", (String)message, (String)logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void pageShouldNotContainList(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2);
        try {
            void locator;
            this.pageShouldNotContainList((String)locator, "");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void pageShouldNotContainList(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string3, (Object)string4);
        try {
            void message;
            void locator;
            this.pageShouldNotContainList((String)locator, (String)message, "INFO");
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void pageShouldNotContainList(String string, String string2, String string3) {
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void logLevel;
            void message;
            void locator;
            this.pageShouldNotContainElement((String)locator, "list", (String)message, (String)logLevel);
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void selectAllFromList(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string2);
        try {
            void locator;
            this.info(String.format("Selecting all options from list '%s'.", locator));
            Select select = this.getSelectList((String)locator);
            if (!this.isMultiselectList(select)) {
                throw new Selenium2LibraryNonFatalException("Keyword 'Select all from list' works only for multiselect lists.");
            }
            int i = 0;
            while (i < select.getOptions().size()) {
                select.selectByIndex(i);
                ++i;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void selectFromList(String string, String ... stringArray) {
        String string2 = string;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string2, (Object)stringArray2);
        try {
            void locator;
            void items;
            String itemList = ((void)items).length != 0 ? String.format("option(s) [ %s ]", Python.join(" | ", (String[])items)) : "all options";
            this.info(String.format("Selecting %s from list '%s'.", itemList, locator));
            Select select = this.getSelectList((String)locator);
            if (((void)items).length != 0) {
                int i = 0;
                while (i < select.getOptions().size()) {
                    select.selectByIndex(i);
                    ++i;
                }
            }
            void var8_10 = items;
            int n = ((void)var8_10).length;
            int n2 = 0;
            while (n2 < n) {
                void item = var8_10[n2];
                try {
                    select.selectByValue((String)item);
                }
                catch (NoSuchElementException noSuchElementException) {
                    try {
                        select.selectByVisibleText((String)item);
                    }
                    catch (NoSuchElementException noSuchElementException2) {}
                }
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void selectFromListByIndex(String string, String ... stringArray) {
        String string2 = string;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string2, (Object)stringArray2);
        try {
            void locator;
            void indexes;
            if (((void)indexes).length == 0) {
                throw new Selenium2LibraryNonFatalException("No index given.");
            }
            ArrayList<String> tmp = new ArrayList<String>();
            void var7_7 = indexes;
            int n = ((void)var7_7).length;
            int n2 = 0;
            while (n2 < n) {
                void index = var7_7[n2];
                tmp.add((String)index);
                ++n2;
            }
            String items = String.format("index(es) '%s'", Python.join(", ", tmp));
            this.info(String.format("Selecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList((String)locator);
            void var9_14 = indexes;
            int n3 = ((void)var9_14).length;
            int n4 = 0;
            while (n4 < n3) {
                void index = var9_14[n4];
                select.selectByIndex(Integer.parseInt((String)index));
                ++n4;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void selectFromListByValue(String string, String ... stringArray) {
        String string2 = string;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string2, (Object)stringArray2);
        try {
            void locator;
            void values;
            if (((void)values).length == 0) {
                throw new Selenium2LibraryNonFatalException("No value given.");
            }
            String items = String.format("value(s) '%s'", Python.join(", ", (String[])values));
            this.info(String.format("Selecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList((String)locator);
            void var8_8 = values;
            int n = ((void)var8_8).length;
            int n2 = 0;
            while (n2 < n) {
                void value = var8_8[n2];
                select.selectByValue((String)value);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void selectFromListByLabel(String string, String ... stringArray) {
        String string2 = string;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string2, (Object)stringArray2);
        try {
            void locator;
            void labels;
            if (((void)labels).length == 0) {
                throw new Selenium2LibraryNonFatalException("No value given.");
            }
            String items = String.format("label(s) '%s'", Python.join(", ", (String[])labels));
            this.info(String.format("Selecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList((String)locator);
            void var8_8 = labels;
            int n = ((void)var8_8).length;
            int n2 = 0;
            while (n2 < n) {
                void label = var8_8[n2];
                select.selectByVisibleText((String)label);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unselectFromList(String string, String ... stringArray) {
        String string2 = string;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string2, (Object)stringArray2);
        try {
            void locator;
            void items;
            String itemList = ((void)items).length != 0 ? String.format("option(s) [ %s ]", Python.join(" | ", (String[])items)) : "all options";
            this.info(String.format("Unselecting %s from list '%s'.", itemList, locator));
            Select select = this.getSelectList((String)locator);
            if (!this.isMultiselectList(select)) {
                throw new Selenium2LibraryNonFatalException("Keyword 'Unselect from list' works only for multiselect lists.");
            }
            if (((void)items).length == 0) {
                select.deselectAll();
                return;
            }
            void var8_8 = items;
            int n = ((void)var8_8).length;
            int n2 = 0;
            while (n2 < n) {
                void item = var8_8[n2];
                select.deselectByValue((String)item);
                select.deselectByVisibleText((String)item);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unselectFromListByIndex(String string, Integer ... integerArray) {
        String string2 = string;
        Integer[] integerArray2 = integerArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string2, (Object)integerArray2);
        try {
            void locator;
            void indexes;
            if (indexes.equals(null)) {
                throw new Selenium2LibraryNonFatalException("No index given.");
            }
            ArrayList<String> tmp = new ArrayList<String>();
            void var7_7 = indexes;
            int n = ((void)var7_7).length;
            int n2 = 0;
            while (n2 < n) {
                void index = var7_7[n2];
                tmp.add(index.toString());
                ++n2;
            }
            String items = String.format("index(es) '%s'", Python.join(", ", tmp));
            this.info(String.format("Unselecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList((String)locator);
            if (!this.isMultiselectList(select)) {
                throw new Selenium2LibraryNonFatalException("Keyword 'Unselect from list' works only for multiselect lists.");
            }
            void var9_13 = indexes;
            int n3 = ((void)var9_13).length;
            int n4 = 0;
            while (n4 < n3) {
                int index = var9_13[n4].intValue();
                select.deselectByIndex(index);
                ++n4;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unselectFromListByValue(String string, String ... stringArray) {
        String string2 = string;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string2, (Object)stringArray2);
        try {
            void locator;
            void values;
            if (values.equals(null)) {
                throw new Selenium2LibraryNonFatalException("No value given.");
            }
            String items = String.format("value(s) '%s'", Python.join(", ", (String[])values));
            this.info(String.format("Unselecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList((String)locator);
            if (!this.isMultiselectList(select)) {
                throw new Selenium2LibraryNonFatalException("Keyword 'Unselect from list' works only for multiselect lists.");
            }
            void var8_8 = values;
            int n = ((void)var8_8).length;
            int n2 = 0;
            while (n2 < n) {
                void value = var8_8[n2];
                select.deselectByValue((String)value);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unselectFromListByLabel(String string, String ... stringArray) {
        String string2 = string;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string2, (Object)stringArray2);
        try {
            void locator;
            void labels;
            if (labels.equals(null)) {
                throw new Selenium2LibraryNonFatalException("No value given.");
            }
            String items = String.format("label(s) '%s'", Python.join(", ", (String[])labels));
            this.info(String.format("Unselecting %s from list '%s'.", items, locator));
            Select select = this.getSelectList((String)locator);
            if (!this.isMultiselectList(select)) {
                throw new Selenium2LibraryNonFatalException("Keyword 'Unselect from list' works only for multiselect lists.");
            }
            void var8_8 = labels;
            int n = ((void)var8_8).length;
            int n2 = 0;
            while (n2 < n) {
                void label = var8_8[n2];
                select.deselectByVisibleText((String)label);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable) {
            RunOnFailureAspect.aspectOf().ajc$afterThrowing$com_github_markusbernhardt_selenium2library_aspects_RunOnFailureAspect$1$28ae5ef9(throwable, joinPoint);
            throw throwable;
        }
    }

    private List<String> getLabelsForOptions(List<WebElement> options) {
        ArrayList<String> labels = new ArrayList<String>();
        for (WebElement option : options) {
            labels.add(option.getText());
        }
        return labels;
    }

    private Select getSelectList(String locator) {
        List<WebElement> elements = this.elementFind(locator, true, true, "select");
        return new Select(elements.get(0));
    }

    private List<WebElement> getSelectListOptions(Select select) {
        return new ArrayList<WebElement>(select.getOptions());
    }

    private List<WebElement> getSelectListOptions(String locator) {
        Select select = this.getSelectList(locator);
        return this.getSelectListOptions(select);
    }

    private List<WebElement> getSelectListOptionsSelected(String locator) {
        Select select = this.getSelectList(locator);
        return new ArrayList<WebElement>(select.getAllSelectedOptions());
    }

    private List<String> getValuesForOptions(List<WebElement> options) {
        ArrayList<String> labels = new ArrayList<String>();
        for (WebElement option : options) {
            labels.add(option.getAttribute("value"));
        }
        return labels;
    }

    private boolean isMultiselectList(Select select) {
        return select.isMultiple();
    }

    static {
        SelectElement.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SelectElement.java", SelectElement.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getListItems", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "java.util.List"), 20);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSelectedListLabel", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "java.lang.String"), 26);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "void"), 127);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 131);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldNotContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 135);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectAllFromList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "void"), 140);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "selectFromList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:items", "", "void"), 154);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "selectFromListByIndex", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:indexes", "", "void"), 180);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "selectFromListByValue", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:values", "", "void"), 198);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "selectFromListByLabel", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:labels", "", "void"), 213);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "unselectFromList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:items", "", "void"), 228);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "unselectFromListByIndex", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.Integer;", "locator:indexes", "", "void"), 252);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSelectedListLabels", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "java.util.List"), 32);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "unselectFromListByValue", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:values", "", "void"), 276);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "unselectFromListByLabel", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:[Ljava.lang.String;", "locator:labels", "", "void"), 297);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSelectedListValue", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "java.lang.String"), 45);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSelectedListValues", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "java.util.List"), 51);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listSelectionShouldBe", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:java.util.List", "locator:items", "", "void"), 64);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listShouldHaveNoSelections", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "void"), 100);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String", "locator", "", "void"), 114);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:java.lang.String", "locator:message", "", "void"), 118);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pageShouldContainList", "com.github.markusbernhardt.selenium2library.keywords.SelectElement", "java.lang.String:java.lang.String:java.lang.String", "locator:message:logLevel", "", "void"), 122);
    }
}

