/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.selenium2library.keywords;

import com.github.markusbernhardt.selenium2library.Selenium2LibraryNonFatalException;
import com.github.markusbernhardt.selenium2library.keywords.JavaScript;
import com.github.markusbernhardt.selenium2library.utils.Python;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;

public abstract class Logging
extends JavaScript {
    protected static ThreadLocal<PythonInterpreter> loggingPythonInterpreter = new ThreadLocal<PythonInterpreter>(){

        @Override
        protected PythonInterpreter initialValue() {
            PythonInterpreter pythonInterpreter = new PythonInterpreter();
            pythonInterpreter.exec("from robot.variables import GLOBAL_VARIABLES; from robot.api import logger;");
            return pythonInterpreter;
        }
    };

    @Override
    protected void trace(String msg) {
        loggingPythonInterpreter.get().exec(String.format("logger.trace('%s');", msg.replace("'", "\\'").replace("\n", "\\n")));
    }

    @Override
    protected void debug(String msg) {
        loggingPythonInterpreter.get().exec(String.format("logger.debug('%s');", msg.replace("'", "\\'").replace("\n", "\\n")));
    }

    @Override
    protected void info(String msg) {
        loggingPythonInterpreter.get().exec(String.format("logger.info('%s');", msg.replace("'", "\\'").replace("\n", "\\n")));
    }

    @Override
    protected void html(String msg) {
        loggingPythonInterpreter.get().exec(String.format("logger.info('%s', True, False);", msg.replace("'", "\\'").replace("\n", "\\n")));
    }

    @Override
    protected void warn(String msg) {
        loggingPythonInterpreter.get().exec(String.format("logger.warn('%s');", msg.replace("'", "\\'").replace("\n", "\\n")));
    }

    @Override
    protected void log(String msg, String logLevel) {
        if ((logLevel = logLevel.toLowerCase()).equals("trace")) {
            this.trace(msg);
        } else if (logLevel.equals("debug")) {
            this.debug(msg);
        } else if (logLevel.equals("info")) {
            this.info(msg);
        } else if (logLevel.equals("html")) {
            this.html(msg);
        } else if (logLevel.equals("warn")) {
            this.warn(msg);
        } else {
            throw new Selenium2LibraryNonFatalException(String.format("Given log level %s is invalid.", logLevel));
        }
    }

    @Override
    protected List<String> logList(List<String> items) {
        return this.logList(items, "item");
    }

    @Override
    protected List<String> logList(List<String> items, String what) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add(String.format("Altogether %d %s%s.\n", items.size(), what, items.size() == 1 ? "" : "s"));
        int index = 0;
        while (index < items.size()) {
            msg.add(String.format("%d: %s", index + 1, items.get(index)));
            ++index;
        }
        this.info(Python.join("\n", msg));
        return items;
    }

    @Override
    protected File getLogDir() {
        PyString logDirName = (PyString)loggingPythonInterpreter.get().eval("GLOBAL_VARIABLES['${LOG FILE}']");
        if (logDirName != null) {
            return new File(logDirName.asString()).getParentFile();
        }
        logDirName = (PyString)loggingPythonInterpreter.get().eval("GLOBAL_VARIABLES['${OUTPUTDIR}']");
        return new File(logDirName.asString()).getParentFile();
    }
}

