/*
 * generated by Xtext 2.10.0
 */
package org.structs4java.validation

import org.eclipse.xtext.validation.Check
import org.structs4java.structs4JavaDsl.IntegerMember
import org.structs4java.structs4JavaDsl.FloatMember
import org.structs4java.structs4JavaDsl.Member
import org.structs4java.structs4JavaDsl.StructDeclaration
import org.structs4java.structs4JavaDsl.Structs4JavaDslPackage
import org.structs4java.structs4JavaDsl.StringMember

/**
 * This class contains custom validation rules. 
 *
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
class Structs4JavaDslValidator extends AbstractStructs4JavaDslValidator {
	
	@Check
	def checkArrayDimension(Member m) {
		if(m.array === null) {
			return;
		}
		
		if(m.array.dimension == 0) {
			if(m instanceof StringMember) {
				return;
			}
			
			if(getSizeOfFor(m) !== null) {
				return;
			}
			
			val struct = m.eContainer as StructDeclaration;
			val idx = struct.members.indexOf(m)
			
			if(idx+1 < struct.members.size()) {
				error('Only the last member is allowed to be greedy!', m, Structs4JavaDslPackage.Literals.MEMBER__ARRAY)
			}
			
		} else {
			if(getCountOfFor(m) !== null) {
				error('Either array dimension or countof must be specified but not both!', m, Structs4JavaDslPackage.Literals.MEMBER__ARRAY)
			}
			
			if(getSizeOfFor(m) !== null) {
				error('Either array dimension or sizeof must be specified but not both!', m, Structs4JavaDslPackage.Literals.MEMBER__ARRAY)
			}
		}
	}
	
	@Check
	def checkArrayDimensionIsBeforeDynamicElement(Member m) {
		if(m.array === null) {
			return;
		}
		
		if(m.array.dimension == 0) {
			val struct = m.eContainer as StructDeclaration;
			val countOf = getCountOfFor(m)
			
			val countOfIdx = struct.members.indexOf(countOf)
			val memberIdx = struct.members.indexOf(m)
			if(countOfIdx > memberIdx) {			
				error('Size of a dynamic element must be specified before the actual field!', m, Structs4JavaDslPackage.Literals.MEMBER__ARRAY)
				error('Size of a dynamic element must be specified before the actual field!', countOf, Structs4JavaDslPackage.Literals.INTEGER_MEMBER__COUNTOF)
			}
		}
	}
	
	@Check
	def checkSizeIsBeforeDynamicElement(Member m) {
		if(m.array.dimension == 0) {
			val struct = m.eContainer as StructDeclaration;
			val sizeOf = getSizeOfFor(m)
			
			val sizeOfIdx = struct.members.indexOf(sizeOf)
			val memberIdx = struct.members.indexOf(m)
			if(sizeOfIdx > memberIdx) {			
				error('Size of a dynamic element must be specified before the actual field!', m, Structs4JavaDslPackage.Literals.MEMBER__ARRAY)
				error('Size of a dynamic element must be specified before the actual field!', sizeOf, Structs4JavaDslPackage.Literals.INTEGER_MEMBER__SIZEOF)
			}
		}
	}
	
	@Check
	def disable64BitSizeOfAndCountOf(Member m) {
		if(m instanceof IntegerMember) {
			if(m.sizeof !== null || m.countof !== null || m.sizeofThis) {
				if(m.typename.equals("uint64_t") || m.typename.equals("int64_t")) {
					warning('64 bit types for sizeof/countof members are not fully supported!\nThey throw a RuntimeException in case the value is larger than 2^63!', m, Structs4JavaDslPackage.Literals.INTEGER_MEMBER__TYPENAME)
				}
			}
		}
	}

	@Check
	def defaultValueInitializerListOfIntMemberDoesNotExceedArrayDimension(IntegerMember m) {
	    if(m.array === null) {
	        return
	    }

	    if(m.array.dimension == 0) {
	        return
	    }

	    if(m.defaultValues === null) {
	        return
	    }

	    if(m.array.dimension < m.defaultValues.items.size) {
	        error("Can't fit default values (size=" + m.defaultValues.items.size + ") into fixed-sized array(size=" + m.array.dimension + ").", m, Structs4JavaDslPackage.Literals.INTEGER_MEMBER__DEFAULT_VALUES)
	    }
	}

	@Check
    def defaultValueInitializerListOfIntMemberDoesNotExceedArrayDimension(FloatMember m) {
        if(m.array === null) {
            return
        }

        if(m.array.dimension == 0) {
            return
        }

        if(m.defaultValues === null) {
            return
        }

        if(m.array.dimension < m.defaultValues.items.size) {
            error("Can't fit default values (size=" + m.defaultValues.items.size + ") into fixed-sized array(size=" + m.array.dimension + ").", m, Structs4JavaDslPackage.Literals.FLOAT_MEMBER__DEFAULT_VALUES)
        }
    }

    @Check
    def defaultValueInitializerListOfIntMemberDoesNotExceedArrayDimension(StringMember m) {
        if(m.array === null) {
            return
        }

        if(m.array.dimension == 0) {
            return
        }

        if(m.defaultValue === null) {
            return
        }

        val encoding = if(m.encoding !== null) m.encoding else "UTF-8"
        var lenBytes = m.defaultValue.getBytes(encoding).length

        if(m.nullTerminated !== null) {
            lenBytes += "\u0000".getBytes(encoding).length
        }

        if(m.array.dimension < lenBytes) {
            error("Can't fit default value (size=" + lenBytes + ") into fixed-sized array(size=" + m.array.dimension + ").", m, Structs4JavaDslPackage.Literals.STRING_MEMBER__DEFAULT_VALUE)
        }
    }
	
	def getSizeOfFor(Member m) {
		val struct = m.eContainer as StructDeclaration;
		for(Member field : struct.members) {
			if(field instanceof IntegerMember) {
				if(field.sizeof.equals(m)) {
					return field
				}
			}
		}
		return null
	}
	
	def getCountOfFor(Member m) {
		val struct = m.eContainer as StructDeclaration;
		for(Member field : struct.members) {
			if(field instanceof IntegerMember) {
				if(field.countof.equals(m)) {
					return field
				}
			}
		}
		return null
	}
}
