/*
 * generated by Xtext 2.10.0
 */
package org.structs4java.generator

import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import org.structs4java.structs4JavaDsl.ComplexTypeDeclaration
import org.structs4java.structs4JavaDsl.StructsFile

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
class Structs4JavaDslGenerator extends AbstractGenerator {

	override void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
		val enumGen = new EnumGenerator
		val structGen = new StructGenerator
		
		for (pkg : resource.allContents.toIterable.filter(StructsFile)) {
			for (struct : pkg.structs) {
				fsa.generateFile(javaType(struct).replace('.', '/') + ".java", structGen.compile(pkg, struct))
			}

			for (enumDecl : pkg.enums) {
				fsa.generateFile(javaType(enumDecl).replace('.', '/') + ".java", enumGen.compile(pkg, enumDecl))
			}
		}
	}

	def javaType(ComplexTypeDeclaration type) {
		val pkg = type.eContainer as StructsFile
		if (pkg !== null && !pkg.name.empty) {
			return pkg.name + "." + type.name
		}
		return type.name
	}
}
