/*
 * generated by Xtext 2.10.0
 */
package org.structs4java.generator

import org.structs4java.structs4JavaDsl.ComplexTypeDeclaration
import org.structs4java.structs4JavaDsl.ComplexTypeMember
import org.structs4java.structs4JavaDsl.FloatMember
import org.structs4java.structs4JavaDsl.IntegerMember
import org.structs4java.structs4JavaDsl.Member
import org.structs4java.structs4JavaDsl.StructsFile
import org.structs4java.structs4JavaDsl.StringMember
import org.structs4java.structs4JavaDsl.StructDeclaration
import org.structs4java.structs4JavaDsl.EnumDeclaration
import org.structs4java.structs4JavaDsl.BitfieldMember
import org.structs4java.structs4JavaDsl.BitfieldEntry

import java.util.stream.Collectors

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
class StructGenerator {

	def compile(StructsFile structsFile, StructDeclaration struct) '''
		«packageDeclaration(structsFile)»
		
		«printComments(struct)»
		public class «struct.name» «implementedInterfaces(struct)» {
			public «struct.name»() {
			}
			
			«copyConstructor(struct)»
			«cloneMethod(struct)»
			
			«readerMethodForStruct(struct)»
			«writerMethodForStruct(struct)»
			
			«getters(struct)»
			«setters(struct)»
			
			«sizeOfStructMethod(struct)»
			
			«toStringMethod(struct)»
			«hashCodeMethod(struct)»
			«equalsMethod(struct)»
			
			«readerMethods(struct)»
			«writerMethods(struct)»
			
			«fields(struct)»
		}
	'''
	
	def isMemberOfTypeStruct(Member m) {
		return m instanceof ComplexTypeMember && (m as ComplexTypeMember).type instanceof StructDeclaration;
	}
	
	def isMemberOfTypeString(Member m) {
		return m instanceof StringMember;
	}
	
	def isBitfield(Member m) {
		return m instanceof BitfieldMember;
	}
	
	def isMemberOfTypeByteBuffer(Member m) {
		if(m.isArray()) {
			switch (m) {
				IntegerMember case m.typename == "uint8_t": return true
				IntegerMember case m.typename == "int8_t": return true
				default: return false
			}
		} 
		return false
	}
	
	def copyConstructor(StructDeclaration struct) '''
	public «struct.name»(«struct.name» source) {
		if(source == null) {
			throw new NullPointerException("source must be non null");
		}
		«FOR m : struct.members»
		«IF m.isBitfield()»
			«FOR entry : (m as BitfieldMember).entries»
			this.«attributeName(entry)» = source.«attributeName(entry)»;
			«ENDFOR»
		«ELSEIF m.isArray() && !m.isMemberOfTypeString() && !m.isMemberOfTypeByteBuffer()»
			«IF m.isMemberOfTypeStruct()»
			if(source.«attributeName(m)» != null) {
				this.«attributeName(m)» = new java.util.ArrayList<«m.nativeTypeName().native2JavaType().box()»>();
				for(«m.nativeTypeName().native2JavaType().box()» element : source.«attributeName(m)») {
					this.«attributeName(m)».add(new «m.nativeTypeName().native2JavaType().box()»(element));
				}
			}
			«ELSE»
			if(source.«attributeName(m)» != null) {
				this.«attributeName(m)» = new java.util.ArrayList<«m.nativeTypeName().native2JavaType().box()»>(source.«attributeName(m)»);
			}
			«ENDIF»
		«ELSE»
			«IF m.isMemberOfTypeStruct()»
			if(source.«attributeName(m)» != null) {
				this.«attributeName(m)» = new «attributeJavaType(m)»(source.«attributeName(m)»);
			}
			«ELSE»
				this.«attributeName(m)» = source.«attributeName(m)»;
			«ENDIF»
		«ENDIF»
		«ENDFOR»	
	}
	'''
	
	def cloneMethod(StructDeclaration struct) '''
	public «struct.name» clone() {
		return new «struct.name»(this);
	}
	'''
	
	def implementedInterfaces(StructDeclaration struct) '''
	«IF struct.implements.size > 0»
	implements «FOR jvmType : struct.implements SEPARATOR ", "»«jvmType.qualifiedName»«ENDFOR»
	«ENDIF»
	'''
	
	def printComments(StructDeclaration struct) '''
	/**
	«FOR comment : struct.comments»
	* «comment.substring(2).trim()»
	«ENDFOR»
	*/
	'''
	
	def printComments(Member member) '''
	/**
	«FOR comment : member.comments»
	* «comment.substring(2).trim()»
	«ENDFOR»
	*/
	'''
	
	def printComments(BitfieldEntry member) '''
	/**
	«FOR comment : member.comments»
	* «comment.substring(2).trim()»
	«ENDFOR»
	*/
	'''
	
	def sizeOfStructMethod(StructDeclaration struct) '''
	«IF struct.isFixedSize()»
	public static long getSizeOf() {
		return «computeFixedSizeOf(struct)»;
	}
	«ENDIF»
	'''
	
	def hashCodeMethod(StructDeclaration struct) '''
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		«FOR m : struct.members»
			«IF !m.hasSizeOfOrCountOfAttribute()»
				«IF m.isBitfield()»
					«FOR entry : (m as BitfieldMember).entries»
						«IF entry.isEnumType()»
						result = prime * result + ((this.«attributeName(entry)» == null) ? 0 : this.«attributeName(entry)».hashCode());
						«ELSEIF entry.is64BitType()»
						result = prime * result + (int) (this.«attributeName(entry)» ^ (this.«attributeName(entry)» >>> 32));
						«ELSEIF entry.isBooleanType()»
						result = prime * result + (this.«attributeName(entry)» ? 1231 : 1237);
						«ELSE»
						result = prime * result + (int)this.«attributeName(entry)»;
						«ENDIF»
					«ENDFOR»
				«ELSEIF m instanceof StringMember || m instanceof ComplexTypeMember || m.isArray()»
				result = prime * result + ((this.«attributeName(m)» == null) ? 0 : this.«attributeName(m)».hashCode());
				«ELSEIF m instanceof IntegerMember»
					«IF m.is64BitType()»
					result = prime * result + (int) (this.«attributeName(m)» ^ (this.«attributeName(m)» >>> 32));
					«ELSE»
					result = prime * result + (int)this.«attributeName(m)»;
					«ENDIF»
				«ELSEIF m instanceof FloatMember»
				{
					long temp;
					temp = Double.doubleToLongBits(this.«attributeName(m)»);
					result = prime * result + (int) (temp ^ (temp >>> 32));
				}
				«ENDIF»	
			«ENDIF»
		«ENDFOR»	
		return result;
	}
	'''
	
	def equalsMethod(StructDeclaration struct) '''
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		«struct.name» other = («struct.name») obj;
		
		«FOR m : struct.members»
			«IF !m.hasSizeOfOrCountOfAttribute()»
				«IF m.isBitfield()»
					«FOR entry : (m as BitfieldMember).entries»
						«IF entry.isEnumType()»
						if (this.«attributeName(entry)» == null) {
							if (other.«attributeName(entry)» != null)
								return false;
						} else if (!this.«attributeName(entry)».equals(other.«attributeName(entry)»))
							return false;
						«ELSE»
						if (this.«attributeName(entry)» != other.«attributeName(entry)»)
							return false;
						«ENDIF»
					«ENDFOR»
				«ELSEIF m instanceof StringMember || m instanceof ComplexTypeMember || m.isArray()»
					if (this.«attributeName(m)» == null) {
						if (other.«attributeName(m)» != null)
							return false;
					} else if (!this.«attributeName(m)».equals(other.«attributeName(m)»))
						return false;
				«ELSEIF m instanceof IntegerMember»
					if (this.«attributeName(m)» != other.«attributeName(m)»)
						return false;
				«ELSEIF m instanceof FloatMember»
					if (Double.doubleToLongBits(this.«attributeName(m)») != Double.doubleToLongBits(other.«attributeName(m)»))
						return false;
				«ENDIF»	
			«ENDIF»
		«ENDFOR»
		return true;
	}
	'''
	
	def toStringMethod(StructDeclaration struct) '''
	public String toString() {
		StringBuilder buf = new StringBuilder("«javaType(struct)»[");
		«FOR m : struct.nonTransientMembers() SEPARATOR "buf.append(\", \");"»
			«IF m.isBitfield()»
				«FOR entry : (m as BitfieldMember).entries SEPARATOR "buf.append(\", \");"»
				buf.append("«attributeName(entry)»=" + «getterName(entry)»());
				«ENDFOR»
			«ELSE»
			buf.append("«attributeName(m)»=" + «getterName(m)»());
			«ENDIF»
		«ENDFOR»
		buf.append("]");
		return buf.toString();
	}
	'''
	
	def nonTransientMembers(StructDeclaration struct) {
		return struct.members.filter[!isTransient];
	}
	
	def isTransient(Member m) {
		return m.hasSizeOfOrCountOfAttribute()
	}
	
	def readerMethods(StructDeclaration struct) '''
		«FOR m : struct.members»
			«readerMethodForMember(m)»
		«ENDFOR»
	'''
	
	def isPadded(Member m) {
		return m.padding > 0
	}
	
	def is64BitType(Member m) {
		if(!(m instanceof IntegerMember)) {
			return false;
		}
		
		if((m as IntegerMember).typename == "uint64_t") {
			return true;
		}
		
		if((m as IntegerMember).typename == "int64_t") {
			return true;
		}
		
		return false;
	}
	
	def is64BitType(BitfieldEntry m) {
		if(m.typename == "uint64_t") {
			return true;
		}
		
		if(m.typename == "int64_t") {
			return true;
		}
		
		return false;
	}
	
	def isBooleanType(Member m) {
        if(nativeTypeName(m) == "boolean") {
            return true;
        }

        return false;
    }

    def isBooleanType(BitfieldEntry m) {
        if(m.typename == "boolean") {
            return true;
        }

        return false;
    }
	
	def isEnumType(BitfieldEntry m) {
		if(m.type !== null) {
			return true;
		}
		
		return false;
	}

	def readerMethodForStruct(StructDeclaration struct) '''
		public static «struct.name» read(java.nio.ByteBuffer buf) throws java.io.IOException {
			return read(buf, false);
		}
		
		public static «struct.name» read(java.nio.ByteBuffer buf, boolean partialRead) throws java.io.IOException {
			if(buf.remaining() == 0) {
				// avoid empty object construction for partial reads
				throw new java.nio.BufferUnderflowException();
			}
			«IF struct.isSelfSized()»
			long structBeginPosition = buf.position();
			long structEndPosition = -1;
			«ENDIF»
			
			«struct.name» obj = new «struct.name»();
			
			try {
			«FOR m : struct.members»
				«IF m.hasSizeOfOrCountOfAttribute()»
					«IF (m as IntegerMember).sizeofThis»
						structEndPosition = structBeginPosition + «readerMethodName(m)»(buf, partialRead);
					«ELSE»
						«IF struct.isSelfSized()»
							if(buf.position() == structEndPosition) {
								return obj;
							}
							if(buf.position() > structEndPosition) {
								throw new java.io.IOException(String.format("Read beyond the memory region of the struct [%d,%d) definition by %d bytes", structBeginPosition, structEndPosition, buf.position() - structEndPosition));
							}
						«ENDIF»
						«attributeJavaType(m)» «tempVarForMember(m)» = «readerMethodName(m)»(buf, partialRead);
						«IF m.is64BitType()»
						if(«tempVarForMember(m)» > «Math.pow(2, 31) - 1» || «tempVarForMember(m)» < 0) {
							throw new java.io.IOException("64 bit field '«attributeName(m)»' in struct '«(m.eContainer as StructDeclaration).name»' overflew the maximum supported value of 2^31-1!");
						}
						«ENDIF»
						obj.«attributeName(m)» = «tempVarForMember(m)»;
					«ENDIF»
				«ELSE»
					«IF struct.isSelfSized()»
						if(buf.position() == structEndPosition) {
							return obj;
						}
						if(structEndPosition != -1 && buf.position() > structEndPosition) {
							throw new java.io.IOException(String.format("Read beyond the memory region of the struct [%d,%d) definition by %d bytes", structBeginPosition, structEndPosition, buf.position() - structEndPosition));
						}
					«ENDIF»
					
					«IF findMemberDefiningSizeOf(m) !== null»
						«IF m instanceof ComplexTypeMember»
						{
							java.nio.ByteBuffer slice = buf.slice();
							slice.order(buf.order());
							slice.limit((int)«tempVarForMember(findMemberDefiningSizeOf(m))»);
							«IF isConst(m)»
							«readerMethodName(m)»(slice, true);
							«ELSE»
							obj.«setterName(m)»(«readerMethodName(m)»(slice, true));
							«ENDIF»

							buf.position(buf.position() + (int)«tempVarForMember(findMemberDefiningSizeOf(m))»);
						}
						«ELSE»
						«IF isConst(m)»
						«readerMethodName(m)»(buf, partialRead, (int)«tempVarForMember(findMemberDefiningSizeOf(m))»);
                        «ELSE»
                        obj.«setterName(m)»(«readerMethodName(m)»(buf, partialRead, (int)«tempVarForMember(findMemberDefiningSizeOf(m))»));
                        «ENDIF»
						«ENDIF»
					«ELSEIF findMemberDefiningCountOf(m) !== null»
					    «IF isConst(m)»
					    «readerMethodName(m)»(buf, partialRead, (int)«tempVarForMember(findMemberDefiningCountOf(m))»);
                        «ELSE»
                        obj.«setterName(m)»(«readerMethodName(m)»(buf, partialRead, (int)«tempVarForMember(findMemberDefiningCountOf(m))»));
                        «ENDIF»
					«ELSE»
						«IF m.isBitfield()»
							«IF m.isArray()»
								// TODO: array
								throw new UnsupportedOperationException("Bitfields on top of arrays are not yet supported.");
							«ELSE»
							{
								long value = «readerMethodName(m)»(buf, partialRead);
								«FOR entry : (m as BitfieldMember).entries»
									«IF entry.type !== null»
                                    obj.«setterName(entry)»(«javaType(entry.type)».fromValue((value & «computeBitmaskFor(entry)») >>> «computeBitsToShift(entry)»));
									«ELSEIF entry.typename == "boolean"»
                                    obj.«setterName(entry)»(((value & «computeBitmaskFor(entry)») >>> «computeBitsToShift(entry)») != 0);
									«ELSE»
									obj.«setterName(entry)»((value & «computeBitmaskFor(entry)») >>> «computeBitsToShift(entry)»);
									«ENDIF»
								«ENDFOR»
							}
							«ENDIF»	
						«ELSEIF m.isArray() && !m.isString() && m.isGreedy()»
							«IF struct.isSelfSized()»
							«IF isConst(m)»
							«readerMethodName(m)»(buf, partialRead, (int)(structEndPosition - buf.position()));
                            «ELSE»
                            obj.«setterName(m)»(«readerMethodName(m)»(buf, partialRead, (int)(structEndPosition - buf.position())));
                            «ENDIF»
							«ELSE»
							// greedy member
							«IF isConst(m)»
							«readerMethodName(m)»(buf, partialRead, (int)(buf.limit() - buf.position()));
                            «ELSE»
                            obj.«setterName(m)»(«readerMethodName(m)»(buf, partialRead, (int)(buf.limit() - buf.position())));
                            «ENDIF»
							«ENDIF»
						«ELSE»
						    «IF isConst(m)»
						    «readerMethodName(m)»(buf, partialRead);
                            «ELSE»
                            obj.«setterName(m)»(«readerMethodName(m)»(buf, partialRead));
                            «ENDIF»
						«ENDIF»
					«ENDIF»
				«ENDIF»
			«ENDFOR»
			} catch(java.nio.BufferUnderflowException e) {
				if(!partialRead) {
					throw e;
				}
			}
			
			return obj;
		}
	'''
	
	def computeBitmaskFor(BitfieldEntry e) {
		var bitmask = 0;
		for(i : 0..< e.bits as int) {
			bitmask = bitmask.bitwiseOr(1 << i);
		}
		bitmask = bitmask << computeBitsToShift(e);
		return bitmask;
	}
	
	def computeBitsToShift(BitfieldEntry e) {
		var offsetInBits = computeBitOffsetFor(e)
		return (computeBitLengthFor(e.eContainer as BitfieldMember) - offsetInBits) as int
	}
	
	def computeBitLengthFor(BitfieldMember m) {
		return computeFixedSizeOf(m) * 8
	}
	
	def computeBitOffsetFor(BitfieldEntry e) {
		val m = e.eContainer as BitfieldMember;
		var offsetInBits = 0L;
		for(e2 : m.entries) {
			offsetInBits = offsetInBits + e2.bits;
			if(e2 === e) {
				return offsetInBits
			}
		}
	}
	
	def isSelfSized(StructDeclaration struct) {
		for(Member m : struct.members) {
			if(m instanceof IntegerMember) {
				if(m.sizeofThis) {
					return true;
				}
			}
		}
		return false;
	}
	
	def tempVarForMember(Member m) {
		if(m.hasSizeOfAttribute()) {
			return "sizeof__" + attributeName((m as IntegerMember).sizeof)				
		} else {
			return "countof__" + attributeName((m as IntegerMember).countof)
		}
	}
	
	def readerMethodName(Member m) {
		return "read" + attributeName(m).toFirstUpper;
	}

	def isArray(Member m) {
		return m.array !== null
	}
	
	def isGreedy(Member m) {
		if(m.array === null) {
			return false;
		}
		
		if(m.array.dimension > 0) {
			return false;
		}
		
		return true;
	}
	
	def isString(Member m) {
		return m instanceof StringMember;
	}
	
	def findMemberDefiningSizeOrCountOf(Member m) {
		var m2 = findMemberDefiningSizeOf(m)
		if(m2 !== null) {
			return m2
		}
		return findMemberDefiningCountOf(m)
	}

	def findMemberDefiningSizeOf(Member m) {
		val struct = m.eContainer as StructDeclaration;
		for (member : struct.members) {
			if (member instanceof IntegerMember) {
				if (m.equals(member.sizeof)) {
					return member
				}
			}
		}
		return null
	}
	
	def findMemberDefiningCountOf(Member m) {
		val struct = m.eContainer as StructDeclaration;
		for (member : struct.members) {
			if (member instanceof IntegerMember) {
				if (m.equals(member.countof)) {
					return member
				}
			}
		}
		return null
	}

	def setterName(Member m) {
		return "set" + attributeName(m).toFirstUpper();
	}
	
	def setterName(BitfieldEntry m) {
		return "set" + attributeName(m).toFirstUpper();
	}

	def getterName(Member m) {
		return "get" + attributeName(m).toFirstUpper();
	}
	
	def getterName(BitfieldEntry m) {
		return "get" + attributeName(m).toFirstUpper();
	}

	def attributeName(Member m) {
		switch(m) {
			IntegerMember: m.name
			FloatMember: m.name
			StringMember: m.name
			ComplexTypeMember: m.name
			BitfieldMember: attributeName(m)
			default: "<anonymous>"		
		}
	}
	
	def attributeName(BitfieldMember m) {
		val struct = m.eContainer as StructDeclaration
		var i = 0
		for(member : struct.members) {
			if(member.isBitfield()) {
				if(member == m) {
					return "bitfield_" + i
				}
				i = i + 1
			}
		}
	}
	
	def attributeName(BitfieldEntry m) {
		return m.name;
	}

	def readerMethodForMember(Member m) {
		if(m.isArray()) {
			switch (m) {
				IntegerMember case m.typename == "uint8_t": readerMethodForByteBuffer(m)
				IntegerMember case m.typename == "int8_t": readerMethodForByteBuffer(m)
				StringMember: readerMethodForStringMember(m)
				default: readerMethodForArrayMember(m)
			}
		} else  {
			readerMethodForPrimitive(m)		
		}
	}
	
	def readerMethodForPrimitive(Member m) {
		switch (m) {
			ComplexTypeMember: readerMethodForComplexTypeMember(m)
			IntegerMember: readerMethodForIntegerMember(m)
			FloatMember: readerMethodForFloatMember(m)
			StringMember: readerMethodForStringMember(m)
			BitfieldMember: readerMethodForBitfieldMember(m)
		}
	}
	
	def getDefiningStruct(Member m) {
		return m.eContainer as StructDeclaration;
	}

	def getDefaultValues(Member m) {
        if(m instanceof IntegerMember) return m.defaultValues.items
        if(m instanceof FloatMember) return m.defaultValues.items
        return null
    }
	
	def readerMethodForArrayMember(Member m) '''
	private static java.util.ArrayList<«m.nativeTypeName().native2JavaType().box()»> «m.readerMethodName()»(java.nio.ByteBuffer buf, boolean partialRead«IF findMemberDefiningCountOf(m) !== null», long countof«ENDIF») throws java.io.IOException {
		java.util.ArrayList<«m.nativeTypeName().native2JavaType().box()»> lst = new java.util.ArrayList<«m.nativeTypeName().native2JavaType().box()»>();

		try {
		«IF dimensionOf(m) == 0»
		«IF findMemberDefiningCountOf(m) !== null»
        for(long i = 0; i < countof; ++i) {
            lst.add(«readerMethodName(m)»«arrayPostfix(m)»(buf, partialRead));
        }
		«ELSE»
        while(buf.hasRemaining()) {
            lst.add(«readerMethodName(m)»«arrayPostfix(m)»(buf, partialRead));
        }
		«ENDIF»
		«ELSE»
		«FOR i : 0 ..< dimensionOf(m)»
        lst.add(«readerMethodName(m)»«arrayPostfix(m)»(buf, partialRead));
		«ENDFOR»
		«ENDIF»
		} catch(java.nio.BufferUnderflowException e) {
			if(!partialRead) {
				throw e;
			}
		}

		«IF isConst(m)»
		«FOR i : 0 ..< getDefaultValues(m).size»
		if(lst.get(«i») != «getDefaultValues(m).get(i)») throw new java.io.IOException("Expected constant '«getDefaultValues(m).get(i)»' but got '" + lst.get(«i») + "'.");
		«ENDFOR»
		«ENDIF»

		return lst;
	}

	«readerMethodForPrimitive(m)»
	'''
	
	def dimensionOf(Member m) {
		if(m.array === null) {
			return 0;
		}
		return m.array.dimension as int;
	}
	
	def readerMethodForByteBuffer(IntegerMember m) '''
		private static java.nio.ByteBuffer «readerMethodName(m)»(java.nio.ByteBuffer buf, boolean partialRead«IF dimensionOf(m) == 0», long sizeof«ENDIF») throws java.io.IOException {
			java.nio.ByteBuffer buffer = buf.slice();
			buffer.order(buf.order());
			buffer.limit(«IF dimensionOf(m) == 0»(int)sizeof«ELSE»«dimensionOf(m)»«ENDIF»);
			buf.position(buf.position() + «IF dimensionOf(m) == 0»((int)sizeof)«ELSE»«dimensionOf(m)»«ENDIF»);
			«IF m.isPadded()»
			int bytesOverlap = (buffer.limit() % «m.padding»);
			if(bytesOverlap > 0) {
				buf.position(buf.position() + «m.padding» - bytesOverlap);				
			}
			«ENDIF»

			«IF isConst(m)»
			«FOR i : 0 ..< getDefaultValues(m).size»
			{
			    int actual = buffer.get(«i») & 0xFF;
                if(actual != «getDefaultValues(m).get(i)») throw new java.io.IOException("Expected constant '«getDefaultValues(m).get(i)»' but got '" + actual + "' at offset «i».");
            }
            «ENDFOR»
            buffer.position(0);
			«ENDIF»

			return buffer; 
		}
	'''

	def readerMethodForComplexTypeMember(ComplexTypeMember m) '''
		private static «m.nativeTypeName().native2JavaType()» «m.readerMethodName()»«arrayPostfix(m)»(java.nio.ByteBuffer buf, boolean partialRead) throws java.io.IOException {
			«IF m.isPadded()»
			long beginMember = buf.position();
			«ENDIF»
			«m.nativeTypeName().native2JavaType()» value = «m.nativeTypeName().native2JavaType()».read(buf, partialRead);
			«IF m.isPadded()»
			long bytesOverlap = ((buf.position() - beginMember) % «m.padding»);
			if(bytesOverlap > 0) {
				buf.position((int)(buf.position() + «m.padding» - bytesOverlap));				
			}
			«ENDIF»
			return value;
		}
	'''
	
	def readerMethodForIntegerMember(IntegerMember m) '''
		private static «m.nativeTypeName().native2JavaType()» «m.readerMethodName()»«arrayPostfix(m)»(java.nio.ByteBuffer buf, boolean partialRead) throws java.io.IOException {
			«IF m.typename.equals("int8_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.get();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 1);
			«ENDIF»
			«ELSEIF m.typename.equals("uint8_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.get() & 0xFFL;
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 1);
			«ENDIF»
			«ELSEIF m.typename.equals("int16_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getShort();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 2);
			«ENDIF»
			«ELSEIF m.typename.equals("uint16_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getShort() & 0xFFFFL;
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 2);
			«ENDIF»
			«ELSEIF m.typename.equals("int32_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getInt();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 4);
			«ENDIF»
			«ELSEIF m.typename.equals("uint32_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getInt() & 0xFFFFFFFFL;
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 4);
			«ENDIF»
			«ELSEIF m.typename.equals("int64_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getLong();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 8);
			«ENDIF»
			«ELSEIF m.typename.equals("uint64_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getLong();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 8);
			«ENDIF»
			«ENDIF»

			«IF isConst(m) && !m.isArray()»
            if(value != «m.defaultValue») throw new java.io.IOException("Expected constant '«m.defaultValue»' but got '" + value + "'.");
            «ENDIF»

			return value;
		}
	'''
	
	def readerMethodForBitfieldMember(BitfieldMember m) '''
		private static «m.nativeTypeName().native2JavaType()» «m.readerMethodName()»«arrayPostfix(m)»(java.nio.ByteBuffer buf, boolean partialRead) throws java.io.IOException {
			«IF m.typename.equals("int8_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.get();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 1);
			«ENDIF»
			«ELSEIF m.typename.equals("uint8_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.get() & 0xFFL;
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 1);
			«ENDIF»
			«ELSEIF m.typename.equals("int16_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getShort();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 2);
			«ENDIF»
			«ELSEIF m.typename.equals("uint16_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getShort() & 0xFFFFL;
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 2);
			«ENDIF»
			«ELSEIF m.typename.equals("int32_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getInt();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 4);
			«ENDIF»
			«ELSEIF m.typename.equals("uint32_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getInt() & 0xFFFFFFFFL;
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 4);
			«ENDIF»
			«ELSEIF m.typename.equals("int64_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getLong();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 8);
			«ENDIF»
			«ELSEIF m.typename.equals("uint64_t")»
			«m.nativeTypeName().native2JavaType()» value = buf.getLong();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 8);
			«ENDIF»
			«ENDIF»
			return value;
		}
	'''

	def readerMethodForFloatMember(FloatMember m) '''
		private static «m.nativeTypeName().native2JavaType()» «m.readerMethodName()»«arrayPostfix(m)»(java.nio.ByteBuffer buf, boolean partialRead) throws java.io.IOException {
			«IF m.typename.equals("float")»
			float value = buf.getFloat();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 4);
			«ENDIF»
			«ELSEIF m.typename.equals("double")»
			double value = buf.getDouble();
			«IF m.isPadded()»
			buf.position(buf.position() + «m.padding» - 8);
			«ENDIF»
			«ENDIF»

			«IF isConst(m) && !m.isArray()»
            if(value != «m.defaultValue») throw new java.io.IOException("Expected constant '«m.defaultValue»' but got '" + value + "'.");
            «ENDIF»

			return value;
		}
	'''

	def readerMethodForStringMember(StringMember m) '''
		private static String «m.readerMethodName()»(java.nio.ByteBuffer buf, boolean partialRead«IF dimensionOf(m) == 0 && findMemberDefiningSizeOf(m) !== null», «attributeJavaType(findMemberDefiningSizeOrCountOf(m))» sizeof«ENDIF») throws java.io.IOException {
			String value = null;
			«IF dimensionOf(m) == 0 && findMemberDefiningSizeOf(m) === null»
			java.io.ByteArrayOutputStream tmp = new java.io.ByteArrayOutputStream();
			int zerosRead = 0;
			«ENDIF»
			try {
			«IF dimensionOf(m) == 0»
				«IF findMemberDefiningSizeOf(m) === null»
				int terminatingZeros = "\0".getBytes("«encodingOf(m)»").length;
				while(zerosRead < terminatingZeros) {
					int b = buf.get();
					tmp.write(b);
					if(b == 0) {
						zerosRead++;
					} else {
						zerosRead = 0;
					}
				}
				«IF m.isPadded()»
				int bytesOverlap = (tmp.size() % «m.padding»);
				if(bytesOverlap > 0) {
					buf.position(buf.position() + «m.padding» - bytesOverlap);				
				}
				«ENDIF»
				value = new String(tmp.toByteArray(), 0, tmp.size() - zerosRead, "«encodingOf(m)»");
				«ELSE»

				byte[] tmp = new byte[(int)sizeof];
				buf.get(tmp);

				«IF m.isPadded()»
				int bytesOverlap = ((int)(sizeof) % «m.padding»);
				if(bytesOverlap > 0) {
					buf.position(buf.position() + «m.padding» - bytesOverlap);				
				}
				«ENDIF»

				«IF m.getNullTerminated() === null»
				value = new String(tmp, 0, (int)sizeof, "«encodingOf(m)»");
				«ELSE»
				int terminatingZeros = "\0".getBytes("«encodingOf(m)»").length;
				value = new String(tmp, 0, (int)(sizeof - terminatingZeros), "«encodingOf(m)»");
				«ENDIF»

				«ENDIF»
			«ELSE»
				byte[] tmp = new byte[«dimensionOf(m)»];
				buf.get(tmp);
				int terminatingZeros = "\0".getBytes("«encodingOf(m)»").length;
				int zerosRead = 0;
				int i = 0;
				int len = 0;
				while(zerosRead < terminatingZeros) {
					if(i >= «dimensionOf(m)») {
						len = i;
						break;
					}
					if(tmp[i++] == 0) {
						zerosRead++;
					} else {
						zerosRead = 0;
						len = i;
					}
				}
				«IF m.isPadded() && (dimensionOf(m) % m.padding) > 0»
				buf.position(buf.position() + «m.padding - (dimensionOf(m) % m.padding)»);
				«ENDIF»
				value = new String(tmp, 0, len, "«encodingOf(m)»");
			«ENDIF»
			} catch(java.io.UnsupportedEncodingException e) {
				throw new java.io.IOException(e);
			}
			«IF dimensionOf(m) == 0 && findMemberDefiningSizeOf(m) === null»
			catch(java.nio.BufferUnderflowException e) {
				if(!partialRead) {
					throw e;
				}
				value = new String(tmp.toByteArray(), 0, tmp.size() - zerosRead, "«encodingOf(m)»");
			}
			«ENDIF»

			«IF isConst(m)»
            if(!"«m.defaultValue»".equals(value)) throw new java.io.IOException("Expected constant '«m.defaultValue»' but got '" + value + "'.");
            «ENDIF»

			return value;
		}
	'''
	
	def arrayPostfix(Member m) {
		if(m.isArray()) {
			return "_ArrayItem"
		}
		return ""
	}
	
	def writerMethodName(Member m) {
		return "write" + attributeName(m).toFirstUpper;
	}

	def writerMethodForStruct(StructDeclaration struct) '''
		public void write(java.nio.ByteBuffer buf) throws java.io.IOException {
			«IF struct.isSelfSized()»
			int beginOfStruct = buf.position();
			«ENDIF»
			«FOR m : struct.members»
				«IF m.isTransient()»
				int positionof__«attributeName(m)» = buf.position();
				buf.position(buf.position() + «computeFixedSizeOf(m)»);
				«ELSE»
					«IF m.findMemberDefiningSizeOrCountOf() !== null»
						int positionof__«attributeName(m)» = buf.position();
						«writerMethodName(m)»(buf);
						
						«IF m.isArray() && m instanceof IntegerMember && (m as IntegerMember).typename == "uint8_t"»
						«attributeJavaType(m.findMemberDefiningSizeOrCountOf())» «attributeName(m.findMemberDefiningSizeOrCountOf())» = «attributeName(m)».limit();
						«ELSE»
						«attributeJavaType(m.findMemberDefiningSizeOrCountOf())» «attributeName(m.findMemberDefiningSizeOrCountOf())» = («attributeJavaType(m.findMemberDefiningSizeOrCountOf())»)(buf.position() - positionof__«attributeName(m)»);
						«ENDIF»
						
						
						positionof__«attributeName(m)» = buf.position();
						buf.position(positionof__«attributeName(m.findMemberDefiningSizeOrCountOf())»);
						«writerMethodName(m.findMemberDefiningSizeOrCountOf())»(buf, «attributeName(m.findMemberDefiningSizeOrCountOf())»);
						buf.position(positionof__«attributeName(m)»);
					«ELSE»
						«writerMethodName(m)»(buf);
					«ENDIF»
				«ENDIF»
			«ENDFOR»
			
			«IF struct.isSelfSized()»
			int endOfStruct = buf.position();
			buf.position(positionof__«attributeName(selfSizeMember(struct))»);
			«writerMethodName(selfSizeMember(struct))»(buf, endOfStruct - beginOfStruct);
			buf.position(endOfStruct);
			«ENDIF»
		}
	'''
	
	def selfSizeMember(StructDeclaration struct) {
		for(Member m : struct.members) {
			if(m instanceof IntegerMember) {
				if(m.sizeofThis) {
					return m
				}
			}
		}
		return null
	}
	
	def writerMethods(StructDeclaration struct) '''
		«FOR m : struct.members»
			«writerMethodForMember(m)»
		«ENDFOR»
	'''
	
    def hasSizeOfOrCountOfAttribute(Member m) {
		return m.hasSizeOfAttribute() || m.hasCountOfAttribute()
	}
	
	def hasSizeOfAttribute(Member m) {
		if(m instanceof IntegerMember) {
			return m.sizeof !== null || m.sizeofThis;
		}
		return false;
	}
	
	def hasCountOfAttribute(Member m) {
		if(m instanceof IntegerMember) {
			return m.countof !== null;
		}
		return false;
	}
	
	def writerMethodForMember(Member m) {
		if(m.isTransient()) {
			return writerMethodForIntegerMemberReceivingValue(m as IntegerMember)
		}
		
		if(isArray(m)) {
			switch (m) {
				IntegerMember case m.typename == "uint8_t": return writerMethodForByteBuffer(m)
				IntegerMember case m.typename == "int8_t": return writerMethodForByteBuffer(m)
				StringMember: return writerMethodForString(m)
				default: return writerMethodForArrayMember(m)
			}
		} else  {
			return writerMethodForPrimitive(m)		
		}
	}
	
	def writerMethodForPrimitive(Member m) {
		switch (m) {
			ComplexTypeMember: writerMethodForComplexTypeMember(m)
			IntegerMember: writerMethodForIntegerMember(m)
			FloatMember: writerMethodForFloatMember(m)
			StringMember: writerMethodForString(m)
			BitfieldMember: writerMethodForBitfieldMember(m)
		}
	}
	
	def writerMethodForArrayMember(Member m) '''
	private void «m.writerMethodName()»(java.nio.ByteBuffer buf) throws java.io.IOException {
		java.util.ArrayList<«m.nativeTypeName().native2JavaType().box()»> lst = «getterName(m)»();
		«IF dimensionOf(m) == 0»
		if(lst == null) {
            return;
        }
		for(«m.nativeTypeName().native2JavaType().box()» item : lst) {
			«writerMethodName(m)»«arrayPostfix(m)»(buf, item);
		}
		«ELSE»
		if(lst.size() > «dimensionOf(m)») {
		    throw new java.io.IOException("Field '«attributeName(m)»' contains " + lst.size() + " element which can't be serialized into structure with limit of «dimensionOf(m)» elements!");
		}

		for(int i = 0; i < lst.size(); ++i) {
		    «writerMethodName(m)»«arrayPostfix(m)»(buf, lst.get(i));
		}

		// if there are less elements than expected, we fill with default constructed
		for(int i = lst.size(); i < «dimensionOf(m)»; ++i) {
		    «writerMethodName(m)»«arrayPostfix(m)»(buf, «defaultConstructArrayItem(m)»);
		}
		«ENDIF»
	}
	
	«writerMethodForPrimitive(m)»
	'''
	
	def writerMethodForByteBuffer(IntegerMember m) '''
		private void «m.writerMethodName()»(java.nio.ByteBuffer buf) throws java.io.IOException {
		    java.nio.ByteBuffer buffer = «getterName(m)»();

		    // null buffers serialize like empty buffers
		    if(buffer == null) {
		        buffer = java.nio.ByteBuffer.wrap(new byte[]{});
		    }

			// reset position in case someone read this buffer before
			buffer.position(0);

			«IF dimensionOf(m) > 0»
			// we need to slice the buffer in order to limit its written size
			java.nio.ByteBuffer slicedBuffer = buffer.slice();
			if(slicedBuffer.limit() > «dimensionOf(m)») {
				slicedBuffer.limit(«dimensionOf(m)»);
			}
			buf.put(slicedBuffer);
			int bytesToFill = («dimensionOf(m)» - slicedBuffer.limit());
			if(bytesToFill > 0) {
				for(int i = 0; i < bytesToFill; ++i) {
					buf.put((byte)0);	
				}		
			}
			«ELSE»
			// buffer has unbound / dynamic size
			buf.put(buffer);
			«ENDIF»
			
			«IF m.isPadded()»
			int bytesOverlap = (buffer.limit() % «m.padding»);
			if(bytesOverlap > 0) {
				for(int i = 0; i < «m.padding» - bytesOverlap; ++i) {
					buf.put((byte)«m.getUsing()»);	
				}		
			}
			«ENDIF»
		}
	'''

	def writerMethodForComplexTypeMember(ComplexTypeMember m) '''
		private void «m.writerMethodName()»«arrayPostfix(m)»(java.nio.ByteBuffer buf«IF m.isArray()», «m.nativeTypeName().native2JavaType()» value«ENDIF») throws java.io.IOException {
			if(«IF m.isArray()»value«ELSE»«getterName(m)»()«ENDIF» != null) {
				«IF m.isPadded()»
				int beginMember = buf.position();
				«ENDIF»
				
				«IF m.isArray()»value«ELSE»«getterName(m)»()«ENDIF».write(buf);
				
				«IF m.isPadded()»
				int bytesOverlap = ((buf.position() - beginMember) % «m.padding»);
				if(bytesOverlap > 0) {
					for(int i = 0; i < «m.padding» - bytesOverlap; ++i) {
						buf.put((byte)«m.getUsing()»);	
					}
				}
				«ENDIF»
			}
		}
	'''

	def writerMethodForIntegerMember(IntegerMember m) '''
	«IF m.isArray()»
		«writerMethodForIntegerMemberReceivingValue(m)»
	«ELSE»
		private void «m.writerMethodName()»«arrayPostfix(m)»(java.nio.ByteBuffer buf) throws java.io.IOException {
			«IF m.typename.equals("int8_t")»
			buf.put((byte)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 1; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint8_t")»
			buf.put((byte)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 1; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int16_t")»
			buf.putShort((short)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 2; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint16_t")»
			buf.putShort((short)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 2; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int32_t")»
			buf.putInt((int)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 4; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint32_t")»
			buf.putInt((int)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 4; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int64_t")»
			buf.putLong(«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 8; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint64_t")»
			buf.putLong(«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 8; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ENDIF»
		}
	«ENDIF»
	'''
	
	def writerMethodForBitfieldMember(BitfieldMember m) '''
	«IF m.isArray()»
		«writerMethodForBitfieldMemberReceivingValue(m)»
	«ELSE»
		private void «m.writerMethodName()»«arrayPostfix(m)»(java.nio.ByteBuffer buf) throws java.io.IOException {
			«IF m.typename.equals("int8_t")»
			buf.put((byte)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 1; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint8_t")»
			buf.put((byte)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 1; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int16_t")»
			buf.putShort((short)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 2; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint16_t")»
			buf.putShort((short)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 2; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int32_t")»
			buf.putInt((int)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 4; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint32_t")»
			buf.putInt((int)«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 4; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int64_t")»
			buf.putLong(«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 8; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint64_t")»
			buf.putLong(«getterName(m)»());
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 8; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ENDIF»
		}
	«ENDIF»
	'''
	
	def writerMethodForIntegerMemberReceivingValue(IntegerMember m) '''
		private void «m.writerMethodName()»«arrayPostfix(m)»(java.nio.ByteBuffer buf, «m.nativeTypeName().native2JavaType()» value) throws java.io.IOException {
			«IF m.typename.equals("int8_t")»
			buf.put((byte)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 1; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint8_t")»
			buf.put((byte)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 1; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int16_t")»
			buf.putShort((short)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 2; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint16_t")»
			buf.putShort((short)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 2; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int32_t")»
			buf.putInt((int)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 4; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint32_t")»
			buf.putInt((int)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 4; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int64_t")»
			buf.putLong(value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 8; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint64_t")»
			buf.putLong(value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 8; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ENDIF»
		}
	'''
	
	def writerMethodForBitfieldMemberReceivingValue(BitfieldMember m) '''
		private void «m.writerMethodName()»«arrayPostfix(m)»(java.nio.ByteBuffer buf, «m.nativeTypeName().native2JavaType()» value) throws java.io.IOException {
			«IF m.typename.equals("int8_t")»
			buf.put((byte)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 1; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint8_t")»
			buf.put((byte)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 1; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int16_t")»
			buf.putShort((short)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 2; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint16_t")»
			buf.putShort((short)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 2; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int32_t")»
			buf.putInt((int)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 4; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint32_t")»
			buf.putInt((int)value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 4; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("int64_t")»
			buf.putLong(value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 8; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("uint64_t")»
			buf.putLong(value);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 8; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ENDIF»
		}
	'''

	def writerMethodForFloatMember(FloatMember m) '''
		private void «m.writerMethodName()»«arrayPostfix(m)»(java.nio.ByteBuffer buf«IF m.isArray()», «m.nativeTypeName().native2JavaType()» value«ENDIF») throws java.io.IOException {
			«IF m.typename.equals("float")»
			buf.putFloat((float)«IF m.isArray()»value«ELSE»«getterName(m)»()«ENDIF»);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 4; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ELSEIF m.typename.equals("double")»
			buf.putDouble(«IF m.isArray()»value«ELSE»«getterName(m)»()«ENDIF»);
			«IF m.isPadded()»
			for(int i = 0; i < «m.padding» - 8; ++i) {
				buf.put((byte)«m.getUsing()»);	
			}
			«ENDIF»
			«ENDIF»
		}
	'''

	def writerMethodForString(StringMember m) '''
	private void «writerMethodName(m)»(java.nio.ByteBuffer buf) throws java.io.IOException {
		try {
			«IF m.isPadded()»
			int memberBegin = buf.position();
			«ENDIF»
			byte[] encoded = («getterName(m)»() != null) ? «getterName(m)»().getBytes("«encodingOf(m)»") : new byte[]{};
			«IF dimensionOf(m) == 0»
			buf.put(encoded);
			«IF findMemberDefiningSizeOf(m) === null»
			buf.put("\0".getBytes("«encodingOf(m)»"));
			«ELSE»
			«IF m.getNullTerminated() !== null»
			buf.put("\0".getBytes("«encodingOf(m)»"));
			«ENDIF»
			«ENDIF»

			«ELSE»
			int len = Math.min(encoded.length, «dimensionOf(m)»);
			int bytesToFill = «dimensionOf(m)» - len;
			buf.put(encoded, 0, len);
			if(bytesToFill > 0) {
				for(int i = 0; i < bytesToFill; ++i) {
					buf.put((byte)«m.getFiller()»);
				}
			}
			«ENDIF»
			«IF m.isPadded()»
			int bytesOverlap = ((buf.position() - memberBegin) % «m.padding»);
			if(bytesOverlap > 0) {
				for(int i = 0; i < «m.padding» - bytesOverlap; ++i) {
					buf.put((byte)«m.getUsing()»);
				}
			}
			«ENDIF»
		} catch(java.io.UnsupportedEncodingException e) {
			throw new java.io.IOException(e);
		}
	}
	'''
	
	def encodingOf(StringMember m) {
		if(m.encoding !== null) {
			return m.encoding;
		}
		
		return "UTF-8";
	}

	def packageDeclaration(StructsFile structsFile) '''
		«IF !structsFile.name.empty»
			package «structsFile.name»;
		«ENDIF»
	'''

	def fields(StructDeclaration struct) '''
		«FOR m : struct.members»
		«IF m instanceof BitfieldMember»
			«field(m)»
		«ELSE»
			«field(m)»
		«ENDIF»
		«ENDFOR»
	'''

	def getters(StructDeclaration struct) '''
		«FOR m : struct.members»
		«IF m instanceof BitfieldMember»
			«getter(m)»
		«ELSE»
			«getter(m)»
		«ENDIF»
		«ENDFOR»
	'''

	def setters(StructDeclaration struct) '''
		«FOR m : struct.nonTransientMembers()»
		«IF !isConst(m)»
		«IF m instanceof BitfieldMember»
			«setter(m)»
		«ELSE»
			«setter(m)»
		«ENDIF»
		«ENDIF»
		«ENDFOR»
	'''

	def isConst(Member m) {
	    if(m instanceof ComplexTypeMember) {
	        return false
	    }

	    if(m instanceof IntegerMember) {
	        return m.constant !== null
	    }

	    if(m instanceof FloatMember) {
            return m.constant !== null
        }

        if(m instanceof StringMember) {
            return m.constant !== null
        }

        return false
	}

	def field(Member m) '''
		«printComments(m)»
		private «attributeJavaType(m)» «attributeName(m)» = «defaultConstruct(m)»;
	'''
	
	def field(BitfieldMember m) '''
		«FOR entry : m.entries»
		«printComments(entry)»
		private «attributeJavaType(entry)» «attributeName(entry)»;
		«ENDFOR»
	'''

	def getter(Member m) '''
		«printComments(m)»
		public «attributeJavaType(m)» «getterName(m)»() {
			return this.«attributeName(m)»;
		}
	'''
	
	def getter(BitfieldMember m) '''
		«FOR entry : m.entries»
		«printComments(entry)»
		public «attributeJavaType(entry)» «getterName(entry)»() {
			return this.«attributeName(entry)»;
		}
		«ENDFOR»
		
		private «attributeJavaType(m)» «getterName(m)»() {
			«IF m.isArray()»
				// TODO: array
				throw new UnsupportedOperationException("Bitfields on top of arrays are not yet supported.");
			«ELSE»
				long value = 0;
				«FOR entry : m.entries»
					«IF entry.isEnumType()»
					value |= this.«attributeName(entry)».getValue() << «computeBitsToShift(entry)»;
					«ELSEIF entry.isBooleanType()»
					value |= (this.«attributeName(entry)» ? 1 : 0) << «computeBitsToShift(entry)»;
					«ELSE»					
					value |= this.«attributeName(entry)» << «computeBitsToShift(entry)»;
					«ENDIF»
				«ENDFOR»
				return («attributeJavaType(m)») value;
			«ENDIF»
		}
	'''

	def setter(Member m) '''
		«printComments(m)»
		public void «setterName(m)»(«attributeJavaType(m)» «attributeName(m)») {
			this.«attributeName(m)» = «attributeName(m)»;
		}
	'''
	
	def setter(BitfieldMember m) '''
		«FOR entry : m.entries»
		«printComments(entry)»
		public void «setterName(entry)»(«attributeJavaType(entry)» «attributeName(entry)») {
			this.«attributeName(entry)» = «attributeName(entry)»;
		}
		«ENDFOR»
	'''

	def defaultConstructArrayItem(Member m) {
	    if(!m.isArray()) {
	        throw new RuntimeException("compiler-error: non-array member passed to defaultConstructArrayItem()")
	    }

	    switch (m) {
            ComplexTypeMember: {
                if(m.type instanceof EnumDeclaration) {
                    if(m.defaultValue === null) {
                        return "null"
                    }
                    return attributeJavaType(m) + "." + m.defaultValue.name
                }
                "new " + javaType(m.type) + "()"
            }
            IntegerMember: "" + m.defaultValue
            FloatMember: m.defaultValue + "f"
            default: throw new RuntimeException("Unsupported member type: " + m)
        }
	}

	def defaultConstruct(Member m) {
	    if(m.isArray()) {

	        if(m instanceof IntegerMember) {
	            if(doesAttributeJavaTypeMapToByteBuffer(m)) {

                    if(m.defaultValues === null) {
                        return "java.nio.ByteBuffer.wrap(new byte[]{})"
                    }

                    val initList = m.defaultValues.items.join(", ")

                    return "java.nio.ByteBuffer.wrap(new byte[]{" + initList + "})"
	            }
	        }

	        if(m instanceof StringMember) {
                return "\"" + m.defaultValue + "\""
            }

            val nativeType = nativeTypeName(m)
            val javaType = native2JavaType(nativeType)

            if(m instanceof IntegerMember) {
                if(m.defaultValues !== null) {
                    return "new java.util.ArrayList<" + box(javaType) + ">(java.util.Arrays.<Long>asList(" + m.defaultValues.items.stream().map(v | v + "L").collect(Collectors.joining(", ")) + "))"
                }
            } else if(m instanceof FloatMember) {
                if(m.defaultValues !== null) {
                    return "new java.util.ArrayList<" + box(javaType) + ">(java.util.Arrays.<Double>asList(" + m.defaultValues.items.join(', ') + "))"
                }
            }

	        return "new java.util.ArrayList<" + box(javaType) + ">()"
	    }

	    if(m instanceof IntegerMember) {
	        return "" + m.defaultValue
	    }

	    if(m instanceof FloatMember) {
	        return m.defaultValue + "f"
	    }

	    if(isBooleanType(m)) {
	        return "false"
	    }

        if(m instanceof ComplexTypeMember) {
	        if(m.type instanceof EnumDeclaration) {
	            if(m.defaultValue === null) {
	                return "null"
	            }
                return attributeJavaType(m) + "." + m.defaultValue.name
            }
	    }

	    return "new " + attributeJavaType(m) + "()"
	}

	def attributeJavaType(Member m) {
		val nativeType = nativeTypeName(m)
		val javaType = native2JavaType(nativeType)

		if (isArray(m)) {
			if(m instanceof IntegerMember) {
				if(m.typename.equals("uint8_t") || m.typename.equals("int8_t")) {
					return "java.nio.ByteBuffer";
				}
			}
			if(m instanceof StringMember) {
				return javaType
			}
			return "java.util.ArrayList<" + box(javaType) + ">";
		} else {
			return javaType
		}
	}

	def doesAttributeJavaTypeMapToByteBuffer(Member m) {
        if (!isArray(m)) {
            return false
        }

        if(m instanceof IntegerMember) {
            if(m.typename.equals("uint8_t") || m.typename.equals("int8_t")) {
                return true
            }
        }

        return false
	}
	
	def attributeJavaType(BitfieldEntry m) {
		return native2JavaType(nativeTypeName(m))
	}

	def box(String type) {
		switch (type) {
			case "byte": "Byte"
			case "short": "Short"
			case "int": "Integer"
			case "long": "Long"
			case "float": "Float"
			case "double": "Double"
			case "boolean": "Boolean"
			default: type
		}
	}

	def unbox(String type) {
		switch (type) {
			case "Short": "short"
			case "Int": "int"
			case "Long": "long"
			case "Float": "float"
			case "Double": "double"
			default: type
		}
	}

	def nativeTypeName(Member m) {
		switch (m) {
			ComplexTypeMember: javaType(m.type)
			IntegerMember: m.typename
			FloatMember: m.typename
			StringMember: m.typename
			BitfieldMember: m.typename
			default: throw new RuntimeException("Unsupported member type: " + m)
		}
	}
	
	def nativeTypeName(BitfieldEntry m) {
		if(m.type !== null) {
			return javaType(m.type);
		} else {
			return m.typename;
		}
	}

	def native2JavaType(String type) {
		switch (type) {
			case "uint8_t": "long"
			case "int8_t": "long"
			case "uint16_t": "long"
			case "int16_t": "long"
			case "int32_t": "long"
			case "uint32_t": "long"
			case "int64_t": "long"
			case "uint64_t": "long"
			case "char": "String"
			case "bool": "boolean"
			case "float": "double"
			case "double": "double"
			default: type
		}
	}

	def javaType(ComplexTypeDeclaration type) {
		val pkg = type.eContainer as StructsFile
		if (pkg !== null && !pkg.name.empty) {
			return pkg.name + "." + type.name
		}
		return type.name
	}
	
	def boolean isFixedSize(StructDeclaration struct) {
		for(Member m : struct.members) {
			if(!m.isFixedSize()) {
				return false;
			}
			if(m instanceof IntegerMember) {
				if(m.sizeofThis) {
					return false;
				}
			}
		}
		return true;
	}
	
	def boolean isFixedSize(ComplexTypeDeclaration typeDecl) {
		if(typeDecl instanceof StructDeclaration) {
			return isFixedSize(typeDecl)
		}
		// for enums always true
		return true;
	}
	
	def boolean isFixedSize(Member m) {
		if(m.isArray()) {
			if(m.array.dimension == 0) {
				return false;
			}
		}
		
		if(m instanceof ComplexTypeMember) {
			return isFixedSize(m.type);
		}
		return true;
	}
	
	def computeFixedSizeOf(StructDeclaration struct) {
		var size = 0 as long;
		for(Member m : struct.members) {
			if(m.isArray()) {
				size += computeFixedSizeOf(m) * dimensionOf(m);
			} else {
				size += computeFixedSizeOf(m);				
			}
		}
		return size;
	}
	
	def long computeFixedSizeOf(Member m)  {
		switch(m) {
			IntegerMember case m.typename == 'uint8_t': return 1
			IntegerMember case m.typename == 'int8_t': return 1
			IntegerMember case m.typename == 'uint16_t': return 2
			IntegerMember case m.typename == 'int16_t': return 2
			IntegerMember case m.typename == 'uint32_t': return 4
			IntegerMember case m.typename == 'int32_t': return 4
			IntegerMember case m.typename == 'uint64_t': return 8
			IntegerMember case m.typename == 'int64_t': return 8
			
			BitfieldMember case m.typename == 'uint8_t': return 1
			BitfieldMember case m.typename == 'int8_t': return 1
			BitfieldMember case m.typename == 'uint16_t': return 2
			BitfieldMember case m.typename == 'int16_t': return 2
			BitfieldMember case m.typename == 'uint32_t': return 4
			BitfieldMember case m.typename == 'int32_t': return 4
			BitfieldMember case m.typename == 'uint64_t': return 8
			BitfieldMember case m.typename == 'int64_t': return 8
			
			FloatMember case m.typename == 'float': return 4
			FloatMember case m.typename == 'double': return 8
			StringMember: return 1 // a char
			ComplexTypeMember: return computeFixedSizeOf(m.type)
			default: throw new RuntimeException("Unexpected member type: " + m)
		}
	}
	
	def long computeFixedSizeOf(ComplexTypeDeclaration typeDecl) {
		if(typeDecl instanceof StructDeclaration) {
			return computeFixedSizeOf(typeDecl)
		} else {
			return computeFixedSizeOf(typeDecl as EnumDeclaration)
		}
	}
	
	def long computeFixedSizeOf(EnumDeclaration enumDecl) {
		switch(enumDecl.typename) {
			case 'int8_t': return 1
			case 'uint8_t': return 1
			case 'int16_t': return 2
			case 'uint16_t': return 2
			case 'int32_t': return 4
			case 'uint32_t': return 4
			default: return 0
		}
	}
}
