/*
 * Decompiled with CFR 0.152.
 */
package org.structs4java.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.structs4java.structs4JavaDsl.ArrayDimension;
import org.structs4java.structs4JavaDsl.FloatInitializerList;
import org.structs4java.structs4JavaDsl.FloatMember;
import org.structs4java.structs4JavaDsl.IntInitializerList;
import org.structs4java.structs4JavaDsl.IntegerMember;
import org.structs4java.structs4JavaDsl.Member;
import org.structs4java.structs4JavaDsl.StringMember;
import org.structs4java.structs4JavaDsl.StructDeclaration;
import org.structs4java.structs4JavaDsl.Structs4JavaDslPackage;
import org.structs4java.validation.AbstractStructs4JavaDslValidator;

public class Structs4JavaDslValidator
extends AbstractStructs4JavaDslValidator {
    @Check
    public void checkArrayDimension(Member m) {
        boolean _equals;
        boolean _tripleEquals;
        ArrayDimension _array = m.getArray();
        boolean bl = _tripleEquals = _array == null;
        if (_tripleEquals) {
            return;
        }
        long _dimension = m.getArray().getDimension();
        boolean bl2 = _equals = _dimension == 0L;
        if (_equals) {
            int _size;
            boolean _lessThan;
            boolean _tripleNotEquals;
            if (m instanceof StringMember) {
                return;
            }
            IntegerMember _sizeOfFor = this.getSizeOfFor(m);
            boolean bl3 = _tripleNotEquals = _sizeOfFor != null;
            if (_tripleNotEquals) {
                return;
            }
            EObject _eContainer = m.eContainer();
            StructDeclaration struct = (StructDeclaration)_eContainer;
            int idx = struct.getMembers().indexOf((Object)m);
            boolean bl4 = _lessThan = idx + 1 < (_size = struct.getMembers().size());
            if (_lessThan) {
                this.error("Only the last member is allowed to be greedy!", m, (EStructuralFeature)Structs4JavaDslPackage.Literals.MEMBER__ARRAY);
            }
        } else {
            IntegerMember _sizeOfFor_1;
            boolean _tripleNotEquals_2;
            boolean _tripleNotEquals_1;
            IntegerMember _countOfFor = this.getCountOfFor(m);
            boolean bl5 = _tripleNotEquals_1 = _countOfFor != null;
            if (_tripleNotEquals_1) {
                this.error("Either array dimension or countof must be specified but not both!", m, (EStructuralFeature)Structs4JavaDslPackage.Literals.MEMBER__ARRAY);
            }
            boolean bl6 = _tripleNotEquals_2 = (_sizeOfFor_1 = this.getSizeOfFor(m)) != null;
            if (_tripleNotEquals_2) {
                this.error("Either array dimension or sizeof must be specified but not both!", m, (EStructuralFeature)Structs4JavaDslPackage.Literals.MEMBER__ARRAY);
            }
        }
    }

    @Check
    public void checkArrayDimensionIsBeforeDynamicElement(Member m) {
        boolean _equals;
        boolean _tripleEquals;
        ArrayDimension _array = m.getArray();
        boolean bl = _tripleEquals = _array == null;
        if (_tripleEquals) {
            return;
        }
        long _dimension = m.getArray().getDimension();
        boolean bl2 = _equals = _dimension == 0L;
        if (_equals) {
            int memberIdx;
            EObject _eContainer = m.eContainer();
            StructDeclaration struct = (StructDeclaration)_eContainer;
            IntegerMember countOf = this.getCountOfFor(m);
            int countOfIdx = struct.getMembers().indexOf((Object)countOf);
            if (countOfIdx > (memberIdx = struct.getMembers().indexOf((Object)m))) {
                this.error("Size of a dynamic element must be specified before the actual field!", m, (EStructuralFeature)Structs4JavaDslPackage.Literals.MEMBER__ARRAY);
                this.error("Size of a dynamic element must be specified before the actual field!", countOf, (EStructuralFeature)Structs4JavaDslPackage.Literals.INTEGER_MEMBER__COUNTOF);
            }
        }
    }

    @Check
    public void checkSizeIsBeforeDynamicElement(Member m) {
        boolean _equals;
        long _dimension = m.getArray().getDimension();
        boolean bl = _equals = _dimension == 0L;
        if (_equals) {
            int memberIdx;
            EObject _eContainer = m.eContainer();
            StructDeclaration struct = (StructDeclaration)_eContainer;
            IntegerMember sizeOf = this.getSizeOfFor(m);
            int sizeOfIdx = struct.getMembers().indexOf((Object)sizeOf);
            if (sizeOfIdx > (memberIdx = struct.getMembers().indexOf((Object)m))) {
                this.error("Size of a dynamic element must be specified before the actual field!", m, (EStructuralFeature)Structs4JavaDslPackage.Literals.MEMBER__ARRAY);
                this.error("Size of a dynamic element must be specified before the actual field!", sizeOf, (EStructuralFeature)Structs4JavaDslPackage.Literals.INTEGER_MEMBER__SIZEOF);
            }
        }
    }

    @Check
    public void disable64BitSizeOfAndCountOf(Member m) {
        if (m instanceof IntegerMember && (((IntegerMember)m).getSizeof() != null || ((IntegerMember)m).getCountof() != null || ((IntegerMember)m).isSizeofThis()) && (((IntegerMember)m).getTypename().equals("uint64_t") || ((IntegerMember)m).getTypename().equals("int64_t"))) {
            this.warning("64 bit types for sizeof/countof members are not fully supported!\nThey throw a RuntimeException in case the value is larger than 2^63!", m, (EStructuralFeature)Structs4JavaDslPackage.Literals.INTEGER_MEMBER__TYPENAME);
        }
    }

    @Check
    public void defaultValueInitializerListOfIntMemberDoesNotExceedArrayDimension(IntegerMember m) {
        int _size;
        boolean _lessThan;
        boolean _tripleEquals_1;
        boolean _equals;
        boolean _tripleEquals;
        ArrayDimension _array = m.getArray();
        boolean bl = _tripleEquals = _array == null;
        if (_tripleEquals) {
            return;
        }
        long _dimension = m.getArray().getDimension();
        boolean bl2 = _equals = _dimension == 0L;
        if (_equals) {
            return;
        }
        IntInitializerList _defaultValues = m.getDefaultValues();
        boolean bl3 = _tripleEquals_1 = _defaultValues == null;
        if (_tripleEquals_1) {
            return;
        }
        long _dimension_1 = m.getArray().getDimension();
        boolean bl4 = _lessThan = _dimension_1 < (long)(_size = m.getDefaultValues().getItems().size());
        if (_lessThan) {
            int _size_1 = m.getDefaultValues().getItems().size();
            String _plus = "Can't fit default values (size=" + String.valueOf((Object)_size_1);
            String _plus_1 = _plus + ") into fixed-sized array(size=";
            long _dimension_2 = m.getArray().getDimension();
            String _plus_2 = _plus_1 + String.valueOf((Object)_dimension_2);
            String _plus_3 = _plus_2 + ").";
            this.error(_plus_3, m, (EStructuralFeature)Structs4JavaDslPackage.Literals.INTEGER_MEMBER__DEFAULT_VALUES);
        }
    }

    @Check
    public void defaultValueInitializerListOfIntMemberDoesNotExceedArrayDimension(FloatMember m) {
        int _size;
        boolean _lessThan;
        boolean _tripleEquals_1;
        boolean _equals;
        boolean _tripleEquals;
        ArrayDimension _array = m.getArray();
        boolean bl = _tripleEquals = _array == null;
        if (_tripleEquals) {
            return;
        }
        long _dimension = m.getArray().getDimension();
        boolean bl2 = _equals = _dimension == 0L;
        if (_equals) {
            return;
        }
        FloatInitializerList _defaultValues = m.getDefaultValues();
        boolean bl3 = _tripleEquals_1 = _defaultValues == null;
        if (_tripleEquals_1) {
            return;
        }
        long _dimension_1 = m.getArray().getDimension();
        boolean bl4 = _lessThan = _dimension_1 < (long)(_size = m.getDefaultValues().getItems().size());
        if (_lessThan) {
            int _size_1 = m.getDefaultValues().getItems().size();
            String _plus = "Can't fit default values (size=" + String.valueOf((Object)_size_1);
            String _plus_1 = _plus + ") into fixed-sized array(size=";
            long _dimension_2 = m.getArray().getDimension();
            String _plus_2 = _plus_1 + String.valueOf((Object)_dimension_2);
            String _plus_3 = _plus_2 + ").";
            this.error(_plus_3, m, (EStructuralFeature)Structs4JavaDslPackage.Literals.FLOAT_MEMBER__DEFAULT_VALUES);
        }
    }

    @Check
    public void defaultValueInitializerListOfIntMemberDoesNotExceedArrayDimension(StringMember m) {
        try {
            long _dimension_1;
            boolean _lessThan;
            boolean _tripleNotEquals_1;
            boolean _tripleEquals_1;
            boolean _equals;
            boolean _tripleEquals;
            ArrayDimension _array = m.getArray();
            boolean bl = _tripleEquals = _array == null;
            if (_tripleEquals) {
                return;
            }
            long _dimension = m.getArray().getDimension();
            boolean bl2 = _equals = _dimension == 0L;
            if (_equals) {
                return;
            }
            String _defaultValue = m.getDefaultValue();
            boolean bl3 = _tripleEquals_1 = _defaultValue == null;
            if (_tripleEquals_1) {
                return;
            }
            String _xifexpression = null;
            String _encoding = m.getEncoding();
            boolean _tripleNotEquals = _encoding != null;
            _xifexpression = _tripleNotEquals ? m.getEncoding() : "UTF-8";
            String encoding = _xifexpression;
            int lenBytes = m.getDefaultValue().getBytes(encoding).length;
            String _nullTerminated = m.getNullTerminated();
            boolean bl4 = _tripleNotEquals_1 = _nullTerminated != null;
            if (_tripleNotEquals_1) {
                int _lenBytes = lenBytes;
                int _length = "\u0000".getBytes(encoding).length;
                lenBytes = _lenBytes + _length;
            }
            boolean bl5 = _lessThan = (_dimension_1 = m.getArray().getDimension()) < (long)lenBytes;
            if (_lessThan) {
                long _dimension_2 = m.getArray().getDimension();
                String _plus = "Can't fit default value (size=" + String.valueOf((Object)lenBytes) + ") into fixed-sized array(size=" + String.valueOf((Object)_dimension_2);
                String _plus_1 = _plus + ").";
                this.error(_plus_1, m, (EStructuralFeature)Structs4JavaDslPackage.Literals.STRING_MEMBER__DEFAULT_VALUE);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IntegerMember getSizeOfFor(Member m) {
        EObject _eContainer = m.eContainer();
        StructDeclaration struct = (StructDeclaration)_eContainer;
        EList<Member> _members = struct.getMembers();
        for (Member field : _members) {
            boolean _equals;
            if (!(field instanceof IntegerMember) || !(_equals = ((IntegerMember)field).getSizeof().equals(m))) continue;
            return (IntegerMember)field;
        }
        return null;
    }

    public IntegerMember getCountOfFor(Member m) {
        EObject _eContainer = m.eContainer();
        StructDeclaration struct = (StructDeclaration)_eContainer;
        EList<Member> _members = struct.getMembers();
        for (Member field : _members) {
            boolean _equals;
            if (!(field instanceof IntegerMember) || !(_equals = ((IntegerMember)field).getCountof().equals(m))) continue;
            return (IntegerMember)field;
        }
        return null;
    }
}

