/*
 * Decompiled with CFR 0.152.
 */
package org.structs4java.generator;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.structs4java.structs4JavaDsl.ArrayDimension;
import org.structs4java.structs4JavaDsl.BitfieldEntry;
import org.structs4java.structs4JavaDsl.BitfieldMember;
import org.structs4java.structs4JavaDsl.ComplexTypeDeclaration;
import org.structs4java.structs4JavaDsl.ComplexTypeMember;
import org.structs4java.structs4JavaDsl.EnumDeclaration;
import org.structs4java.structs4JavaDsl.FloatInitializerList;
import org.structs4java.structs4JavaDsl.FloatMember;
import org.structs4java.structs4JavaDsl.IntInitializerList;
import org.structs4java.structs4JavaDsl.IntegerMember;
import org.structs4java.structs4JavaDsl.Item;
import org.structs4java.structs4JavaDsl.Member;
import org.structs4java.structs4JavaDsl.StringMember;
import org.structs4java.structs4JavaDsl.StructDeclaration;
import org.structs4java.structs4JavaDsl.StructsFile;

public class StructGenerator {
    public CharSequence compile(StructsFile structsFile, StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageDeclaration = this.packageDeclaration(structsFile);
        _builder.append((Object)_packageDeclaration);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _printComments = this.printComments(struct);
        _builder.append((Object)_printComments);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        String _name = struct.getName();
        _builder.append(_name);
        _builder.append(" ");
        CharSequence _implementedInterfaces = this.implementedInterfaces(struct);
        _builder.append((Object)_implementedInterfaces);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public ");
        String _name_1 = struct.getName();
        _builder.append(_name_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _copyConstructor = this.copyConstructor(struct);
        _builder.append((Object)_copyConstructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _cloneMethod = this.cloneMethod(struct);
        _builder.append((Object)_cloneMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _readerMethodForStruct = this.readerMethodForStruct(struct);
        _builder.append((Object)_readerMethodForStruct, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _writerMethodForStruct = this.writerMethodForStruct(struct);
        _builder.append((Object)_writerMethodForStruct, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _ters = this.getters(struct);
        _builder.append((Object)_ters, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _setters = this.setters(struct);
        _builder.append((Object)_setters, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _sizeOfStructMethod = this.sizeOfStructMethod(struct);
        _builder.append((Object)_sizeOfStructMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _stringMethod = this.toStringMethod(struct);
        _builder.append((Object)_stringMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _hashCodeMethod = this.hashCodeMethod(struct);
        _builder.append((Object)_hashCodeMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _equalsMethod = this.equalsMethod(struct);
        _builder.append((Object)_equalsMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _readerMethods = this.readerMethods(struct);
        _builder.append((Object)_readerMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _writerMethods = this.writerMethods(struct);
        _builder.append((Object)_writerMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _fields = this.fields(struct);
        _builder.append((Object)_fields, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public boolean isMemberOfTypeStruct(Member m) {
        return m instanceof ComplexTypeMember && ((ComplexTypeMember)m).getType() instanceof StructDeclaration;
    }

    public boolean isMemberOfTypeString(Member m) {
        return m instanceof StringMember;
    }

    public boolean isBitfield(Member m) {
        return m instanceof BitfieldMember;
    }

    public boolean isMemberOfTypeByteBuffer(Member m) {
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            String _typename;
            boolean _equals;
            boolean _matched = false;
            if (m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "uint8_t"))) {
                _matched = true;
                return true;
            }
            if (!_matched && m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "int8_t"))) {
                _matched = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public CharSequence copyConstructor(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public ");
        String _name = struct.getName();
        _builder.append(_name);
        _builder.append("(");
        String _name_1 = struct.getName();
        _builder.append(_name_1);
        _builder.append(" source) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(source == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("throw new NullPointerException(\"source must be non null\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            boolean _isBitfield = this.isBitfield(m);
            if (_isBitfield) {
                EList<BitfieldEntry> _entries = ((BitfieldMember)m).getEntries();
                for (BitfieldEntry entry : _entries) {
                    _builder.append("\t");
                    _builder.append("this.");
                    String _attributeName = this.attributeName(entry);
                    _builder.append(_attributeName, "\t");
                    _builder.append(" = source.");
                    String _attributeName_1 = this.attributeName(entry);
                    _builder.append(_attributeName_1, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                continue;
            }
            if (this.isArray(m) && !this.isMemberOfTypeString(m) && !this.isMemberOfTypeByteBuffer(m)) {
                boolean _isMemberOfTypeStruct = this.isMemberOfTypeStruct(m);
                if (_isMemberOfTypeStruct) {
                    _builder.append("\t");
                    _builder.append("if(source.");
                    String _attributeName_2 = this.attributeName(m);
                    _builder.append(_attributeName_2, "\t");
                    _builder.append(" != null) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("this.");
                    String _attributeName_3 = this.attributeName(m);
                    _builder.append(_attributeName_3, "\t\t");
                    _builder.append(" = new java.util.ArrayList<");
                    String _box = this.box(this.native2JavaType(this.nativeTypeName(m)));
                    _builder.append(_box, "\t\t");
                    _builder.append(">();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("for(");
                    String _box_1 = this.box(this.native2JavaType(this.nativeTypeName(m)));
                    _builder.append(_box_1, "\t\t");
                    _builder.append(" element : source.");
                    String _attributeName_4 = this.attributeName(m);
                    _builder.append(_attributeName_4, "\t\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("this.");
                    String _attributeName_5 = this.attributeName(m);
                    _builder.append(_attributeName_5, "\t\t\t");
                    _builder.append(".add(new ");
                    String _box_2 = this.box(this.native2JavaType(this.nativeTypeName(m)));
                    _builder.append(_box_2, "\t\t\t");
                    _builder.append("(element));");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    continue;
                }
                _builder.append("\t");
                _builder.append("if(source.");
                String _attributeName_6 = this.attributeName(m);
                _builder.append(_attributeName_6, "\t");
                _builder.append(" != null) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("this.");
                String _attributeName_7 = this.attributeName(m);
                _builder.append(_attributeName_7, "\t\t");
                _builder.append(" = new java.util.ArrayList<");
                String _box_3 = this.box(this.native2JavaType(this.nativeTypeName(m)));
                _builder.append(_box_3, "\t\t");
                _builder.append(">(source.");
                String _attributeName_8 = this.attributeName(m);
                _builder.append(_attributeName_8, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                continue;
            }
            boolean _isMemberOfTypeStruct_1 = this.isMemberOfTypeStruct(m);
            if (_isMemberOfTypeStruct_1) {
                _builder.append("\t");
                _builder.append("if(source.");
                String _attributeName_9 = this.attributeName(m);
                _builder.append(_attributeName_9, "\t");
                _builder.append(" != null) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("this.");
                String _attributeName_10 = this.attributeName(m);
                _builder.append(_attributeName_10, "\t\t");
                _builder.append(" = new ");
                String _attributeJavaType = this.attributeJavaType(m);
                _builder.append(_attributeJavaType, "\t\t");
                _builder.append("(source.");
                String _attributeName_11 = this.attributeName(m);
                _builder.append(_attributeName_11, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                continue;
            }
            _builder.append("\t");
            _builder.append("this.");
            String _attributeName_12 = this.attributeName(m);
            _builder.append(_attributeName_12, "\t");
            _builder.append(" = source.");
            String _attributeName_13 = this.attributeName(m);
            _builder.append(_attributeName_13, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence cloneMethod(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public ");
        String _name = struct.getName();
        _builder.append(_name);
        _builder.append(" clone() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return new ");
        String _name_1 = struct.getName();
        _builder.append(_name_1, "\t");
        _builder.append("(this);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence implementedInterfaces(StructDeclaration struct) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = struct.getImplements().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("implements ");
            EList<JvmType> _implements = struct.getImplements();
            boolean _hasElements = false;
            for (JvmType jvmType : _implements) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _qualifiedName = jvmType.getQualifiedName();
                _builder.append(_qualifiedName);
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence printComments(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        EList<String> _comments = struct.getComments();
        for (String comment : _comments) {
            _builder.append("* ");
            String _trim = comment.substring(2).trim();
            _builder.append(_trim);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("*/");
        _builder.newLine();
        return _builder;
    }

    public CharSequence printComments(Member member) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        EList<String> _comments = member.getComments();
        for (String comment : _comments) {
            _builder.append("* ");
            String _trim = comment.substring(2).trim();
            _builder.append(_trim);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("*/");
        _builder.newLine();
        return _builder;
    }

    public CharSequence printComments(BitfieldEntry member) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        EList<String> _comments = member.getComments();
        for (String comment : _comments) {
            _builder.append("* ");
            String _trim = comment.substring(2).trim();
            _builder.append(_trim);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("*/");
        _builder.newLine();
        return _builder;
    }

    public CharSequence sizeOfStructMethod(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isFixedSize = this.isFixedSize(struct);
        if (_isFixedSize) {
            _builder.append("public static long getSizeOf() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return ");
            long _computeFixedSizeOf = this.computeFixedSizeOf(struct);
            _builder.append((Object)_computeFixedSizeOf, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence hashCodeMethod(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public int hashCode() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("final int prime = 31;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int result = 1;");
        _builder.newLine();
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            boolean _not;
            boolean _hasSizeOfOrCountOfAttribute = this.hasSizeOfOrCountOfAttribute(m);
            boolean bl = _not = !_hasSizeOfOrCountOfAttribute;
            if (!_not) continue;
            boolean _isBitfield = this.isBitfield(m);
            if (_isBitfield) {
                EList<BitfieldEntry> _entries = ((BitfieldMember)m).getEntries();
                for (BitfieldEntry entry : _entries) {
                    boolean _isEnumType = this.isEnumType(entry);
                    if (_isEnumType) {
                        _builder.append("\t");
                        _builder.append("result = prime * result + ((this.");
                        String _attributeName = this.attributeName(entry);
                        _builder.append(_attributeName, "\t");
                        _builder.append(" == null) ? 0 : this.");
                        String _attributeName_1 = this.attributeName(entry);
                        _builder.append(_attributeName_1, "\t");
                        _builder.append(".hashCode());");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    boolean _is64BitType = this.is64BitType(entry);
                    if (_is64BitType) {
                        _builder.append("\t");
                        _builder.append("result = prime * result + (int) (this.");
                        String _attributeName_2 = this.attributeName(entry);
                        _builder.append(_attributeName_2, "\t");
                        _builder.append(" ^ (this.");
                        String _attributeName_3 = this.attributeName(entry);
                        _builder.append(_attributeName_3, "\t");
                        _builder.append(" >>> 32));");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    boolean _isBooleanType = this.isBooleanType(entry);
                    if (_isBooleanType) {
                        _builder.append("\t");
                        _builder.append("result = prime * result + (this.");
                        String _attributeName_4 = this.attributeName(entry);
                        _builder.append(_attributeName_4, "\t");
                        _builder.append(" ? 1231 : 1237);");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("\t");
                    _builder.append("result = prime * result + (int)this.");
                    String _attributeName_5 = this.attributeName(entry);
                    _builder.append(_attributeName_5, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                continue;
            }
            if (m instanceof StringMember || m instanceof ComplexTypeMember || this.isArray(m)) {
                _builder.append("\t");
                _builder.append("result = prime * result + ((this.");
                String _attributeName_6 = this.attributeName(m);
                _builder.append(_attributeName_6, "\t");
                _builder.append(" == null) ? 0 : this.");
                String _attributeName_7 = this.attributeName(m);
                _builder.append(_attributeName_7, "\t");
                _builder.append(".hashCode());");
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (m instanceof IntegerMember) {
                boolean _is64BitType_1 = this.is64BitType(m);
                if (_is64BitType_1) {
                    _builder.append("\t");
                    _builder.append("result = prime * result + (int) (this.");
                    String _attributeName_8 = this.attributeName(m);
                    _builder.append(_attributeName_8, "\t");
                    _builder.append(" ^ (this.");
                    String _attributeName_9 = this.attributeName(m);
                    _builder.append(_attributeName_9, "\t");
                    _builder.append(" >>> 32));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t");
                _builder.append("result = prime * result + (int)this.");
                String _attributeName_10 = this.attributeName(m);
                _builder.append(_attributeName_10, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (!(m instanceof FloatMember)) continue;
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("long temp;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("temp = Double.doubleToLongBits(this.");
            String _attributeName_11 = this.attributeName(m);
            _builder.append(_attributeName_11, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("result = prime * result + (int) (temp ^ (temp >>> 32));");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence equalsMethod(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public boolean equals(Object obj) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (this == obj)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (obj == null)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (getClass() != obj.getClass())");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        String _name = struct.getName();
        _builder.append(_name, "\t");
        _builder.append(" other = (");
        String _name_1 = struct.getName();
        _builder.append(_name_1, "\t");
        _builder.append(") obj;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            boolean _not;
            boolean _hasSizeOfOrCountOfAttribute = this.hasSizeOfOrCountOfAttribute(m);
            boolean bl = _not = !_hasSizeOfOrCountOfAttribute;
            if (!_not) continue;
            boolean _isBitfield = this.isBitfield(m);
            if (_isBitfield) {
                EList<BitfieldEntry> _entries = ((BitfieldMember)m).getEntries();
                for (BitfieldEntry entry : _entries) {
                    boolean _isEnumType = this.isEnumType(entry);
                    if (_isEnumType) {
                        _builder.append("\t");
                        _builder.append("if (this.");
                        String _attributeName = this.attributeName(entry);
                        _builder.append(_attributeName, "\t");
                        _builder.append(" == null) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("if (other.");
                        String _attributeName_1 = this.attributeName(entry);
                        _builder.append(_attributeName_1, "\t\t");
                        _builder.append(" != null)");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("return false;");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("} else if (!this.");
                        String _attributeName_2 = this.attributeName(entry);
                        _builder.append(_attributeName_2, "\t");
                        _builder.append(".equals(other.");
                        String _attributeName_3 = this.attributeName(entry);
                        _builder.append(_attributeName_3, "\t");
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("return false;");
                        _builder.newLine();
                        continue;
                    }
                    _builder.append("\t");
                    _builder.append("if (this.");
                    String _attributeName_4 = this.attributeName(entry);
                    _builder.append(_attributeName_4, "\t");
                    _builder.append(" != other.");
                    String _attributeName_5 = this.attributeName(entry);
                    _builder.append(_attributeName_5, "\t");
                    _builder.append(")");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("return false;");
                    _builder.newLine();
                }
                continue;
            }
            if (m instanceof StringMember || m instanceof ComplexTypeMember || this.isArray(m)) {
                _builder.append("\t");
                _builder.append("if (this.");
                String _attributeName_6 = this.attributeName(m);
                _builder.append(_attributeName_6, "\t");
                _builder.append(" == null) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("if (other.");
                String _attributeName_7 = this.attributeName(m);
                _builder.append(_attributeName_7, "\t\t");
                _builder.append(" != null)");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("return false;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("} else if (!this.");
                String _attributeName_8 = this.attributeName(m);
                _builder.append(_attributeName_8, "\t");
                _builder.append(".equals(other.");
                String _attributeName_9 = this.attributeName(m);
                _builder.append(_attributeName_9, "\t");
                _builder.append("))");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return false;");
                _builder.newLine();
                continue;
            }
            if (m instanceof IntegerMember) {
                _builder.append("\t");
                _builder.append("if (this.");
                String _attributeName_10 = this.attributeName(m);
                _builder.append(_attributeName_10, "\t");
                _builder.append(" != other.");
                String _attributeName_11 = this.attributeName(m);
                _builder.append(_attributeName_11, "\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return false;");
                _builder.newLine();
                continue;
            }
            if (!(m instanceof FloatMember)) continue;
            _builder.append("\t");
            _builder.append("if (Double.doubleToLongBits(this.");
            String _attributeName_12 = this.attributeName(m);
            _builder.append(_attributeName_12, "\t");
            _builder.append(") != Double.doubleToLongBits(other.");
            String _attributeName_13 = this.attributeName(m);
            _builder.append(_attributeName_13, "\t");
            _builder.append("))");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return false;");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence toStringMethod(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public String toString() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("StringBuilder buf = new StringBuilder(\"");
        String _javaType = this.javaType(struct);
        _builder.append(_javaType, "\t");
        _builder.append("[\");");
        _builder.newLineIfNotEmpty();
        Iterable<Member> _nonTransientMembers = this.nonTransientMembers(struct);
        boolean _hasElements = false;
        for (Member m : _nonTransientMembers) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"buf.append(\", \");", "\t");
            }
            boolean _isBitfield = this.isBitfield(m);
            if (_isBitfield) {
                EList<BitfieldEntry> _entries = ((BitfieldMember)m).getEntries();
                boolean _hasElements_1 = false;
                for (BitfieldEntry entry : _entries) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)"buf.append(\", \");", "\t");
                    }
                    _builder.append("\t");
                    _builder.append("buf.append(\"");
                    String _attributeName = this.attributeName(entry);
                    _builder.append(_attributeName, "\t");
                    _builder.append("=\" + ");
                    String _terName = this.getterName(entry);
                    _builder.append(_terName, "\t");
                    _builder.append("());");
                    _builder.newLineIfNotEmpty();
                }
                continue;
            }
            _builder.append("\t");
            _builder.append("buf.append(\"");
            String _attributeName_1 = this.attributeName(m);
            _builder.append(_attributeName_1, "\t");
            _builder.append("=\" + ");
            String _terName_1 = this.getterName(m);
            _builder.append(_terName_1, "\t");
            _builder.append("());");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("buf.append(\"]\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return buf.toString();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public Iterable<Member> nonTransientMembers(StructDeclaration struct) {
        Functions.Function1 _function = it -> {
            boolean _isTransient = this.isTransient((Member)it);
            return !_isTransient;
        };
        return IterableExtensions.filter(struct.getMembers(), (Functions.Function1)_function);
    }

    public boolean isTransient(Member m) {
        return this.hasSizeOfOrCountOfAttribute(m);
    }

    public CharSequence readerMethods(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            CharSequence _readerMethodForMember = this.readerMethodForMember(m);
            _builder.append((Object)_readerMethodForMember);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public boolean isPadded(Member m) {
        long _padding = m.getPadding();
        return _padding > 0L;
    }

    public boolean is64BitType(Member m) {
        if (!(m instanceof IntegerMember)) {
            return false;
        }
        String _typename = ((IntegerMember)m).getTypename();
        boolean _equals = Objects.equals(_typename, "uint64_t");
        if (_equals) {
            return true;
        }
        String _typename_1 = ((IntegerMember)m).getTypename();
        boolean _equals_1 = Objects.equals(_typename_1, "int64_t");
        return _equals_1;
    }

    public boolean is64BitType(BitfieldEntry m) {
        String _typename = m.getTypename();
        boolean _equals = Objects.equals(_typename, "uint64_t");
        if (_equals) {
            return true;
        }
        String _typename_1 = m.getTypename();
        boolean _equals_1 = Objects.equals(_typename_1, "int64_t");
        return _equals_1;
    }

    public boolean isBooleanType(Member m) {
        String _nativeTypeName = this.nativeTypeName(m);
        boolean _equals = Objects.equals(_nativeTypeName, "boolean");
        return _equals;
    }

    public boolean isBooleanType(BitfieldEntry m) {
        String _typename = m.getTypename();
        boolean _equals = Objects.equals(_typename, "boolean");
        return _equals;
    }

    public boolean isEnumType(BitfieldEntry m) {
        boolean _tripleNotEquals;
        EnumDeclaration _type = m.getType();
        boolean bl = _tripleNotEquals = _type != null;
        return _tripleNotEquals;
    }

    public CharSequence readerMethodForStruct(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public static ");
        String _name = struct.getName();
        _builder.append(_name);
        _builder.append(" read(java.nio.ByteBuffer buf) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return read(buf, false);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public static ");
        String _name_1 = struct.getName();
        _builder.append(_name_1);
        _builder.append(" read(java.nio.ByteBuffer buf, boolean partialRead) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(buf.remaining() == 0) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// avoid empty object construction for partial reads");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("throw new java.nio.BufferUnderflowException();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        boolean _isSelfSized = this.isSelfSized(struct);
        if (_isSelfSized) {
            _builder.append("\t");
            _builder.append("long structBeginPosition = buf.position();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("long structEndPosition = -1;");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        String _name_2 = struct.getName();
        _builder.append(_name_2, "\t");
        _builder.append(" obj = new ");
        String _name_3 = struct.getName();
        _builder.append(_name_3, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            boolean _hasSizeOfOrCountOfAttribute = this.hasSizeOfOrCountOfAttribute(m);
            if (_hasSizeOfOrCountOfAttribute) {
                boolean _isSizeofThis = ((IntegerMember)m).isSizeofThis();
                if (_isSizeofThis) {
                    _builder.append("\t");
                    _builder.append("structEndPosition = structBeginPosition + ");
                    String _readerMethodName = this.readerMethodName(m);
                    _builder.append(_readerMethodName, "\t");
                    _builder.append("(buf, partialRead);");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                boolean _isSelfSized_1 = this.isSelfSized(struct);
                if (_isSelfSized_1) {
                    _builder.append("\t");
                    _builder.append("if(buf.position() == structEndPosition) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("return obj;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("if(buf.position() > structEndPosition) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("throw new java.io.IOException(String.format(\"Read beyond the memory region of the struct [%d,%d) definition by %d bytes\", structBeginPosition, structEndPosition, buf.position() - structEndPosition));");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("\t");
                String _attributeJavaType = this.attributeJavaType(m);
                _builder.append(_attributeJavaType, "\t");
                _builder.append(" ");
                String _tempVarForMember = this.tempVarForMember(m);
                _builder.append(_tempVarForMember, "\t");
                _builder.append(" = ");
                String _readerMethodName_1 = this.readerMethodName(m);
                _builder.append(_readerMethodName_1, "\t");
                _builder.append("(buf, partialRead);");
                _builder.newLineIfNotEmpty();
                boolean _is64BitType = this.is64BitType(m);
                if (_is64BitType) {
                    _builder.append("\t");
                    _builder.append("if(");
                    String _tempVarForMember_1 = this.tempVarForMember(m);
                    _builder.append(_tempVarForMember_1, "\t");
                    _builder.append(" > ");
                    double _pow = Math.pow(2.0, 31.0);
                    double _minus = _pow - 1.0;
                    _builder.append((Object)_minus, "\t");
                    _builder.append(" || ");
                    String _tempVarForMember_2 = this.tempVarForMember(m);
                    _builder.append(_tempVarForMember_2, "\t");
                    _builder.append(" < 0) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("throw new java.io.IOException(\"64 bit field '");
                    String _attributeName = this.attributeName(m);
                    _builder.append(_attributeName, "\t\t");
                    _builder.append("' in struct '");
                    EObject _eContainer = m.eContainer();
                    String _name_4 = ((StructDeclaration)_eContainer).getName();
                    _builder.append(_name_4, "\t\t");
                    _builder.append("' overflew the maximum supported value of 2^31-1!\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("obj.");
                String _attributeName_1 = this.attributeName(m);
                _builder.append(_attributeName_1, "\t");
                _builder.append(" = ");
                String _tempVarForMember_3 = this.tempVarForMember(m);
                _builder.append(_tempVarForMember_3, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            boolean _isSelfSized_2 = this.isSelfSized(struct);
            if (_isSelfSized_2) {
                _builder.append("\t");
                _builder.append("if(buf.position() == structEndPosition) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return obj;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if(structEndPosition != -1 && buf.position() > structEndPosition) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("throw new java.io.IOException(String.format(\"Read beyond the memory region of the struct [%d,%d) definition by %d bytes\", structBeginPosition, structEndPosition, buf.position() - structEndPosition));");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.newLine();
            IntegerMember _findMemberDefiningSizeOf = this.findMemberDefiningSizeOf(m);
            boolean bl = _tripleNotEquals = _findMemberDefiningSizeOf != null;
            if (_tripleNotEquals) {
                if (m instanceof ComplexTypeMember) {
                    _builder.append("\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("java.nio.ByteBuffer slice = buf.slice();");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("slice.order(buf.order());");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("slice.limit((int)");
                    String _tempVarForMember_4 = this.tempVarForMember(this.findMemberDefiningSizeOf(m));
                    _builder.append(_tempVarForMember_4, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    boolean _isConst = this.isConst(m);
                    if (_isConst) {
                        _builder.append("\t");
                        _builder.append("\t");
                        String _readerMethodName_2 = this.readerMethodName(m);
                        _builder.append(_readerMethodName_2, "\t\t");
                        _builder.append("(slice, true);");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("obj.");
                        String _setterName = this.setterName(m);
                        _builder.append(_setterName, "\t\t");
                        _builder.append("(");
                        String _readerMethodName_3 = this.readerMethodName(m);
                        _builder.append(_readerMethodName_3, "\t\t");
                        _builder.append("(slice, true));");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("buf.position(buf.position() + (int)");
                    String _tempVarForMember_5 = this.tempVarForMember(this.findMemberDefiningSizeOf(m));
                    _builder.append(_tempVarForMember_5, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    continue;
                }
                boolean _isConst_1 = this.isConst(m);
                if (_isConst_1) {
                    _builder.append("\t");
                    String _readerMethodName_4 = this.readerMethodName(m);
                    _builder.append(_readerMethodName_4, "\t");
                    _builder.append("(buf, partialRead, (int)");
                    String _tempVarForMember_6 = this.tempVarForMember(this.findMemberDefiningSizeOf(m));
                    _builder.append(_tempVarForMember_6, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("obj.");
                String _setterName_1 = this.setterName(m);
                _builder.append(_setterName_1);
                _builder.append("(");
                String _readerMethodName_5 = this.readerMethodName(m);
                _builder.append(_readerMethodName_5);
                _builder.append("(buf, partialRead, (int)");
                String _tempVarForMember_7 = this.tempVarForMember(this.findMemberDefiningSizeOf(m));
                _builder.append(_tempVarForMember_7);
                _builder.append("));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            IntegerMember _findMemberDefiningCountOf = this.findMemberDefiningCountOf(m);
            boolean bl2 = _tripleNotEquals_1 = _findMemberDefiningCountOf != null;
            if (_tripleNotEquals_1) {
                boolean _isConst_2 = this.isConst(m);
                if (_isConst_2) {
                    _builder.append("\t");
                    String _readerMethodName_6 = this.readerMethodName(m);
                    _builder.append(_readerMethodName_6, "\t");
                    _builder.append("(buf, partialRead, (int)");
                    String _tempVarForMember_8 = this.tempVarForMember(this.findMemberDefiningCountOf(m));
                    _builder.append(_tempVarForMember_8, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("obj.");
                String _setterName_2 = this.setterName(m);
                _builder.append(_setterName_2);
                _builder.append("(");
                String _readerMethodName_7 = this.readerMethodName(m);
                _builder.append(_readerMethodName_7);
                _builder.append("(buf, partialRead, (int)");
                String _tempVarForMember_9 = this.tempVarForMember(this.findMemberDefiningCountOf(m));
                _builder.append(_tempVarForMember_9);
                _builder.append("));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            boolean _isBitfield = this.isBitfield(m);
            if (_isBitfield) {
                boolean _isArray = this.isArray(m);
                if (_isArray) {
                    _builder.append("\t");
                    _builder.append("// TODO: array");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("throw new UnsupportedOperationException(\"Bitfields on top of arrays are not yet supported.\");");
                    _builder.newLine();
                    continue;
                }
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("long value = ");
                String _readerMethodName_8 = this.readerMethodName(m);
                _builder.append(_readerMethodName_8, "\t\t");
                _builder.append("(buf, partialRead);");
                _builder.newLineIfNotEmpty();
                EList<BitfieldEntry> _entries = ((BitfieldMember)m).getEntries();
                for (BitfieldEntry entry : _entries) {
                    boolean _tripleNotEquals_2;
                    EnumDeclaration _type = entry.getType();
                    boolean bl3 = _tripleNotEquals_2 = _type != null;
                    if (_tripleNotEquals_2) {
                        _builder.append("obj.");
                        String _setterName_3 = this.setterName(entry);
                        _builder.append(_setterName_3);
                        _builder.append("(");
                        String _javaType = this.javaType(entry.getType());
                        _builder.append(_javaType);
                        _builder.append(".fromValue((value & ");
                        int _computeBitmaskFor = this.computeBitmaskFor(entry);
                        _builder.append((Object)_computeBitmaskFor);
                        _builder.append(") >>> ");
                        int _computeBitsToShift = this.computeBitsToShift(entry);
                        _builder.append((Object)_computeBitsToShift);
                        _builder.append("));");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    String _typename = entry.getTypename();
                    boolean _equals = Objects.equals(_typename, "boolean");
                    if (_equals) {
                        _builder.append("obj.");
                        String _setterName_4 = this.setterName(entry);
                        _builder.append(_setterName_4);
                        _builder.append("(((value & ");
                        int _computeBitmaskFor_1 = this.computeBitmaskFor(entry);
                        _builder.append((Object)_computeBitmaskFor_1);
                        _builder.append(") >>> ");
                        int _computeBitsToShift_1 = this.computeBitsToShift(entry);
                        _builder.append((Object)_computeBitsToShift_1);
                        _builder.append(") != 0);");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("obj.");
                    String _setterName_5 = this.setterName(entry);
                    _builder.append(_setterName_5, "\t\t");
                    _builder.append("((value & ");
                    int _computeBitmaskFor_2 = this.computeBitmaskFor(entry);
                    _builder.append((Object)_computeBitmaskFor_2, "\t\t");
                    _builder.append(") >>> ");
                    int _computeBitsToShift_2 = this.computeBitsToShift(entry);
                    _builder.append((Object)_computeBitsToShift_2, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                continue;
            }
            if (this.isArray(m) && !this.isString(m) && this.isGreedy(m)) {
                boolean _isSelfSized_3 = this.isSelfSized(struct);
                if (_isSelfSized_3) {
                    boolean _isConst_3 = this.isConst(m);
                    if (_isConst_3) {
                        _builder.append("\t");
                        String _readerMethodName_9 = this.readerMethodName(m);
                        _builder.append(_readerMethodName_9, "\t");
                        _builder.append("(buf, partialRead, (int)(structEndPosition - buf.position()));");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("obj.");
                    String _setterName_6 = this.setterName(m);
                    _builder.append(_setterName_6);
                    _builder.append("(");
                    String _readerMethodName_10 = this.readerMethodName(m);
                    _builder.append(_readerMethodName_10);
                    _builder.append("(buf, partialRead, (int)(structEndPosition - buf.position())));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t");
                _builder.append("// greedy member");
                _builder.newLine();
                boolean _isConst_4 = this.isConst(m);
                if (_isConst_4) {
                    _builder.append("\t");
                    String _readerMethodName_11 = this.readerMethodName(m);
                    _builder.append(_readerMethodName_11, "\t");
                    _builder.append("(buf, partialRead, (int)(buf.limit() - buf.position()));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("obj.");
                String _setterName_7 = this.setterName(m);
                _builder.append(_setterName_7);
                _builder.append("(");
                String _readerMethodName_12 = this.readerMethodName(m);
                _builder.append(_readerMethodName_12);
                _builder.append("(buf, partialRead, (int)(buf.limit() - buf.position())));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            boolean _isConst_5 = this.isConst(m);
            if (_isConst_5) {
                _builder.append("\t");
                String _readerMethodName_13 = this.readerMethodName(m);
                _builder.append(_readerMethodName_13, "\t");
                _builder.append("(buf, partialRead);");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("obj.");
            String _setterName_8 = this.setterName(m);
            _builder.append(_setterName_8);
            _builder.append("(");
            String _readerMethodName_14 = this.readerMethodName(m);
            _builder.append(_readerMethodName_14);
            _builder.append("(buf, partialRead));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("} catch(java.nio.BufferUnderflowException e) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(!partialRead) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("throw e;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return obj;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public int computeBitmaskFor(BitfieldEntry e) {
        int _doubleLessThan;
        int bitmask = 0;
        long _bits = e.getBits();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, (int)_bits, true);
        for (Integer i : _doubleDotLessThan) {
            bitmask |= 1 << i;
        }
        int _computeBitsToShift = this.computeBitsToShift(e);
        bitmask = _doubleLessThan = bitmask << _computeBitsToShift;
        return bitmask;
    }

    public int computeBitsToShift(BitfieldEntry e) {
        Long offsetInBits = this.computeBitOffsetFor(e);
        EObject _eContainer = e.eContainer();
        long _computeBitLengthFor = this.computeBitLengthFor((BitfieldMember)_eContainer);
        long _minus = _computeBitLengthFor - offsetInBits;
        return (int)_minus;
    }

    public long computeBitLengthFor(BitfieldMember m) {
        long _computeFixedSizeOf = this.computeFixedSizeOf(m);
        return _computeFixedSizeOf * 8L;
    }

    public Long computeBitOffsetFor(BitfieldEntry e) {
        EObject _eContainer = e.eContainer();
        BitfieldMember m = (BitfieldMember)_eContainer;
        long offsetInBits = 0L;
        EList<BitfieldEntry> _entries = m.getEntries();
        for (BitfieldEntry e2 : _entries) {
            long _plus;
            long _bits = e2.getBits();
            offsetInBits = _plus = offsetInBits + _bits;
            if (e2 != e) continue;
            return offsetInBits;
        }
        return null;
    }

    public boolean isSelfSized(StructDeclaration struct) {
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            boolean _isSizeofThis;
            if (!(m instanceof IntegerMember) || !(_isSizeofThis = ((IntegerMember)m).isSizeofThis())) continue;
            return true;
        }
        return false;
    }

    public String tempVarForMember(Member m) {
        boolean _hasSizeOfAttribute = this.hasSizeOfAttribute(m);
        if (_hasSizeOfAttribute) {
            String _attributeName = this.attributeName(((IntegerMember)m).getSizeof());
            return "sizeof__" + _attributeName;
        }
        String _attributeName_1 = this.attributeName(((IntegerMember)m).getCountof());
        return "countof__" + _attributeName_1;
    }

    public String readerMethodName(Member m) {
        String _firstUpper = StringExtensions.toFirstUpper((String)this.attributeName(m));
        return "read" + _firstUpper;
    }

    public boolean isArray(Member m) {
        ArrayDimension _array = m.getArray();
        return _array != null;
    }

    public boolean isGreedy(Member m) {
        boolean _greaterThan;
        boolean _tripleEquals;
        ArrayDimension _array = m.getArray();
        boolean bl = _tripleEquals = _array == null;
        if (_tripleEquals) {
            return false;
        }
        long _dimension = m.getArray().getDimension();
        boolean bl2 = _greaterThan = _dimension > 0L;
        return !_greaterThan;
    }

    public boolean isString(Member m) {
        return m instanceof StringMember;
    }

    public IntegerMember findMemberDefiningSizeOrCountOf(Member m) {
        IntegerMember m2 = this.findMemberDefiningSizeOf(m);
        if (m2 != null) {
            return m2;
        }
        return this.findMemberDefiningCountOf(m);
    }

    public IntegerMember findMemberDefiningSizeOf(Member m) {
        EObject _eContainer = m.eContainer();
        StructDeclaration struct = (StructDeclaration)_eContainer;
        EList<Member> _members = struct.getMembers();
        for (Member member : _members) {
            boolean _equals;
            if (!(member instanceof IntegerMember) || !(_equals = m.equals(((IntegerMember)member).getSizeof()))) continue;
            return (IntegerMember)member;
        }
        return null;
    }

    public IntegerMember findMemberDefiningCountOf(Member m) {
        EObject _eContainer = m.eContainer();
        StructDeclaration struct = (StructDeclaration)_eContainer;
        EList<Member> _members = struct.getMembers();
        for (Member member : _members) {
            boolean _equals;
            if (!(member instanceof IntegerMember) || !(_equals = m.equals(((IntegerMember)member).getCountof()))) continue;
            return (IntegerMember)member;
        }
        return null;
    }

    public String setterName(Member m) {
        String _firstUpper = StringExtensions.toFirstUpper((String)this.attributeName(m));
        return "set" + _firstUpper;
    }

    public String setterName(BitfieldEntry m) {
        String _firstUpper = StringExtensions.toFirstUpper((String)this.attributeName(m));
        return "set" + _firstUpper;
    }

    public String getterName(Member m) {
        String _firstUpper = StringExtensions.toFirstUpper((String)this.attributeName(m));
        return "get" + _firstUpper;
    }

    public String getterName(BitfieldEntry m) {
        String _firstUpper = StringExtensions.toFirstUpper((String)this.attributeName(m));
        return "get" + _firstUpper;
    }

    public String attributeName(Member m) {
        String _switchResult = null;
        boolean _matched = false;
        if (m instanceof IntegerMember) {
            _matched = true;
            _switchResult = ((IntegerMember)m).getName();
        }
        if (!_matched && m instanceof FloatMember) {
            _matched = true;
            _switchResult = ((FloatMember)m).getName();
        }
        if (!_matched && m instanceof StringMember) {
            _matched = true;
            _switchResult = ((StringMember)m).getName();
        }
        if (!_matched && m instanceof ComplexTypeMember) {
            _matched = true;
            _switchResult = ((ComplexTypeMember)m).getName();
        }
        if (!_matched && m instanceof BitfieldMember) {
            _matched = true;
            _switchResult = this.attributeName((BitfieldMember)m);
        }
        if (!_matched) {
            _switchResult = "<anonymous>";
        }
        return _switchResult;
    }

    public String attributeName(BitfieldMember m) {
        EObject _eContainer = m.eContainer();
        StructDeclaration struct = (StructDeclaration)_eContainer;
        int i = 0;
        EList<Member> _members = struct.getMembers();
        for (Member member : _members) {
            boolean _isBitfield = this.isBitfield(member);
            if (!_isBitfield) continue;
            boolean _equals = Objects.equals(member, m);
            if (_equals) {
                return "bitfield_" + String.valueOf((Object)i);
            }
            ++i;
        }
        return null;
    }

    public String attributeName(BitfieldEntry m) {
        return m.getName();
    }

    public CharSequence readerMethodForMember(Member m) {
        CharSequence _xifexpression = null;
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            String _typename;
            boolean _equals;
            CharSequence _switchResult = null;
            boolean _matched = false;
            if (m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "uint8_t"))) {
                _matched = true;
                _switchResult = this.readerMethodForByteBuffer((IntegerMember)m);
            }
            if (!_matched && m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "int8_t"))) {
                _matched = true;
                _switchResult = this.readerMethodForByteBuffer((IntegerMember)m);
            }
            if (!_matched && m instanceof StringMember) {
                _matched = true;
                _switchResult = this.readerMethodForStringMember((StringMember)m);
            }
            if (!_matched) {
                _switchResult = this.readerMethodForArrayMember(m);
            }
            _xifexpression = _switchResult;
        } else {
            _xifexpression = this.readerMethodForPrimitive(m);
        }
        return _xifexpression;
    }

    public CharSequence readerMethodForPrimitive(Member m) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (m instanceof ComplexTypeMember) {
            _matched = true;
            _switchResult = this.readerMethodForComplexTypeMember((ComplexTypeMember)m);
        }
        if (!_matched && m instanceof IntegerMember) {
            _matched = true;
            _switchResult = this.readerMethodForIntegerMember((IntegerMember)m);
        }
        if (!_matched && m instanceof FloatMember) {
            _matched = true;
            _switchResult = this.readerMethodForFloatMember((FloatMember)m);
        }
        if (!_matched && m instanceof StringMember) {
            _matched = true;
            _switchResult = this.readerMethodForStringMember((StringMember)m);
        }
        if (!_matched && m instanceof BitfieldMember) {
            _matched = true;
            _switchResult = this.readerMethodForBitfieldMember((BitfieldMember)m);
        }
        return _switchResult;
    }

    public StructDeclaration getDefiningStruct(Member m) {
        EObject _eContainer = m.eContainer();
        return (StructDeclaration)_eContainer;
    }

    public EList<? extends Number> getDefaultValues(Member m) {
        if (m instanceof IntegerMember) {
            return ((IntegerMember)m).getDefaultValues().getItems();
        }
        if (m instanceof FloatMember) {
            return ((FloatMember)m).getDefaultValues().getItems();
        }
        return null;
    }

    public CharSequence readerMethodForArrayMember(Member m) {
        boolean _equals;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private static java.util.ArrayList<");
        String _box = this.box(this.native2JavaType(this.nativeTypeName(m)));
        _builder.append(_box);
        _builder.append("> ");
        String _readerMethodName = this.readerMethodName(m);
        _builder.append(_readerMethodName);
        _builder.append("(java.nio.ByteBuffer buf, boolean partialRead");
        IntegerMember _findMemberDefiningCountOf = this.findMemberDefiningCountOf(m);
        boolean bl = _tripleNotEquals = _findMemberDefiningCountOf != null;
        if (_tripleNotEquals) {
            _builder.append(", long countof");
        }
        _builder.append(") throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("java.util.ArrayList<");
        String _box_1 = this.box(this.native2JavaType(this.nativeTypeName(m)));
        _builder.append(_box_1, "\t");
        _builder.append("> lst = new java.util.ArrayList<");
        String _box_2 = this.box(this.native2JavaType(this.nativeTypeName(m)));
        _builder.append(_box_2, "\t");
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        int _dimensionOf = this.dimensionOf(m);
        boolean bl2 = _equals = _dimensionOf == 0;
        if (_equals) {
            boolean _tripleNotEquals_1;
            IntegerMember _findMemberDefiningCountOf_1 = this.findMemberDefiningCountOf(m);
            boolean bl3 = _tripleNotEquals_1 = _findMemberDefiningCountOf_1 != null;
            if (_tripleNotEquals_1) {
                _builder.append("for(long i = 0; i < countof; ++i) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("lst.add(");
                String _readerMethodName_1 = this.readerMethodName(m);
                _builder.append(_readerMethodName_1, "    ");
                String _arrayPostfix = this.arrayPostfix(m);
                _builder.append(_arrayPostfix, "    ");
                _builder.append("(buf, partialRead));");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            } else {
                _builder.append("while(buf.hasRemaining()) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("lst.add(");
                String _readerMethodName_2 = this.readerMethodName(m);
                _builder.append(_readerMethodName_2, "    ");
                String _arrayPostfix_1 = this.arrayPostfix(m);
                _builder.append(_arrayPostfix_1, "    ");
                _builder.append("(buf, partialRead));");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            }
        } else {
            int _dimensionOf_1 = this.dimensionOf(m);
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _dimensionOf_1, true);
            for (Integer i : _doubleDotLessThan) {
                _builder.append("lst.add(");
                String _readerMethodName_3 = this.readerMethodName(m);
                _builder.append(_readerMethodName_3);
                String _arrayPostfix_2 = this.arrayPostfix(m);
                _builder.append(_arrayPostfix_2);
                _builder.append("(buf, partialRead));");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.append("} catch(java.nio.BufferUnderflowException e) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(!partialRead) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("throw e;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _isConst = this.isConst(m);
        if (_isConst) {
            int _size = this.getDefaultValues(m).size();
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _size, true);
            for (Integer i_1 : _doubleDotLessThan_1) {
                _builder.append("\t");
                _builder.append("if(lst.get(");
                _builder.append((Object)i_1, "\t");
                _builder.append(") != ");
                Number _get = (Number)this.getDefaultValues(m).get(i_1.intValue());
                _builder.append((Object)_get, "\t");
                _builder.append(") throw new java.io.IOException(\"Expected constant '");
                Number _get_1 = (Number)this.getDefaultValues(m).get(i_1.intValue());
                _builder.append((Object)_get_1, "\t");
                _builder.append("' but got '\" + lst.get(");
                _builder.append((Object)i_1, "\t");
                _builder.append(") + \"'.\");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return lst;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _readerMethodForPrimitive = this.readerMethodForPrimitive(m);
        _builder.append((Object)_readerMethodForPrimitive);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public int dimensionOf(Member m) {
        boolean _tripleEquals;
        ArrayDimension _array = m.getArray();
        boolean bl = _tripleEquals = _array == null;
        if (_tripleEquals) {
            return 0;
        }
        long _dimension = m.getArray().getDimension();
        return (int)_dimension;
    }

    public CharSequence readerMethodForByteBuffer(IntegerMember m) {
        boolean _equals_2;
        boolean _equals_1;
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private static java.nio.ByteBuffer ");
        String _readerMethodName = this.readerMethodName(m);
        _builder.append(_readerMethodName);
        _builder.append("(java.nio.ByteBuffer buf, boolean partialRead");
        int _dimensionOf = this.dimensionOf(m);
        boolean bl = _equals = _dimensionOf == 0;
        if (_equals) {
            _builder.append(", long sizeof");
        }
        _builder.append(") throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("java.nio.ByteBuffer buffer = buf.slice();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("buffer.order(buf.order());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("buffer.limit(");
        int _dimensionOf_1 = this.dimensionOf(m);
        boolean bl2 = _equals_1 = _dimensionOf_1 == 0;
        if (_equals_1) {
            _builder.append("(int)sizeof");
        } else {
            int _dimensionOf_2 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_2, "\t");
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("buf.position(buf.position() + ");
        int _dimensionOf_3 = this.dimensionOf(m);
        boolean bl3 = _equals_2 = _dimensionOf_3 == 0;
        if (_equals_2) {
            _builder.append("((int)sizeof)");
        } else {
            int _dimensionOf_4 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_4, "\t");
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        boolean _isPadded = this.isPadded(m);
        if (_isPadded) {
            _builder.append("\t");
            _builder.append("int bytesOverlap = (buffer.limit() % ");
            long _padding = m.getPadding();
            _builder.append((Object)_padding, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("if(bytesOverlap > 0) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("buf.position(buf.position() + ");
            long _padding_1 = m.getPadding();
            _builder.append((Object)_padding_1, "\t\t");
            _builder.append(" - bytesOverlap);\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isConst = this.isConst(m);
        if (_isConst) {
            int _size = this.getDefaultValues(m).size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
            for (Integer i : _doubleDotLessThan) {
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("    ");
                _builder.append("int actual = buffer.get(");
                _builder.append((Object)i, "\t    ");
                _builder.append(") & 0xFF;");
                _builder.newLineIfNotEmpty();
                _builder.append("                ");
                _builder.append("if(actual != ");
                Number _get = (Number)this.getDefaultValues(m).get(i.intValue());
                _builder.append((Object)_get, "                ");
                _builder.append(") throw new java.io.IOException(\"Expected constant '");
                Number _get_1 = (Number)this.getDefaultValues(m).get(i.intValue());
                _builder.append((Object)_get_1, "                ");
                _builder.append("' but got '\" + actual + \"' at offset ");
                _builder.append((Object)i, "                ");
                _builder.append(".\");");
                _builder.newLineIfNotEmpty();
                _builder.append("            ");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("            ");
            _builder.append("buffer.position(0);");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return buffer; ");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence readerMethodForComplexTypeMember(ComplexTypeMember m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private static ");
        String _native2JavaType = this.native2JavaType(this.nativeTypeName(m));
        _builder.append(_native2JavaType);
        _builder.append(" ");
        String _readerMethodName = this.readerMethodName(m);
        _builder.append(_readerMethodName);
        String _arrayPostfix = this.arrayPostfix(m);
        _builder.append(_arrayPostfix);
        _builder.append("(java.nio.ByteBuffer buf, boolean partialRead) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        boolean _isPadded = this.isPadded(m);
        if (_isPadded) {
            _builder.append("\t");
            _builder.append("long beginMember = buf.position();");
            _builder.newLine();
        }
        _builder.append("\t");
        String _native2JavaType_1 = this.native2JavaType(this.nativeTypeName(m));
        _builder.append(_native2JavaType_1, "\t");
        _builder.append(" value = ");
        String _native2JavaType_2 = this.native2JavaType(this.nativeTypeName(m));
        _builder.append(_native2JavaType_2, "\t");
        _builder.append(".read(buf, partialRead);");
        _builder.newLineIfNotEmpty();
        boolean _isPadded_1 = this.isPadded(m);
        if (_isPadded_1) {
            _builder.append("\t");
            _builder.append("long bytesOverlap = ((buf.position() - beginMember) % ");
            long _padding = m.getPadding();
            _builder.append((Object)_padding, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("if(bytesOverlap > 0) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("buf.position((int)(buf.position() + ");
            long _padding_1 = m.getPadding();
            _builder.append((Object)_padding_1, "\t\t");
            _builder.append(" - bytesOverlap));\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return value;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence readerMethodForIntegerMember(IntegerMember m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private static ");
        String _native2JavaType = this.native2JavaType(this.nativeTypeName(m));
        _builder.append(_native2JavaType);
        _builder.append(" ");
        String _readerMethodName = this.readerMethodName(m);
        _builder.append(_readerMethodName);
        String _arrayPostfix = this.arrayPostfix(m);
        _builder.append(_arrayPostfix);
        _builder.append("(java.nio.ByteBuffer buf, boolean partialRead) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        boolean _equals = m.getTypename().equals("int8_t");
        if (_equals) {
            _builder.append("\t");
            String _native2JavaType_1 = this.native2JavaType(this.nativeTypeName(m));
            _builder.append(_native2JavaType_1, "\t");
            _builder.append(" value = buf.get();");
            _builder.newLineIfNotEmpty();
            boolean _isPadded = this.isPadded(m);
            if (_isPadded) {
                _builder.append("\t");
                _builder.append("buf.position(buf.position() + ");
                long _padding = m.getPadding();
                _builder.append((Object)_padding, "\t");
                _builder.append(" - 1);");
                _builder.newLineIfNotEmpty();
            }
        } else {
            boolean _equals_1 = m.getTypename().equals("uint8_t");
            if (_equals_1) {
                _builder.append("\t");
                String _native2JavaType_2 = this.native2JavaType(this.nativeTypeName(m));
                _builder.append(_native2JavaType_2, "\t");
                _builder.append(" value = buf.get() & 0xFFL;");
                _builder.newLineIfNotEmpty();
                boolean _isPadded_1 = this.isPadded(m);
                if (_isPadded_1) {
                    _builder.append("\t");
                    _builder.append("buf.position(buf.position() + ");
                    long _padding_1 = m.getPadding();
                    _builder.append((Object)_padding_1, "\t");
                    _builder.append(" - 1);");
                    _builder.newLineIfNotEmpty();
                }
            } else {
                boolean _equals_2 = m.getTypename().equals("int16_t");
                if (_equals_2) {
                    _builder.append("\t");
                    String _native2JavaType_3 = this.native2JavaType(this.nativeTypeName(m));
                    _builder.append(_native2JavaType_3, "\t");
                    _builder.append(" value = buf.getShort();");
                    _builder.newLineIfNotEmpty();
                    boolean _isPadded_2 = this.isPadded(m);
                    if (_isPadded_2) {
                        _builder.append("\t");
                        _builder.append("buf.position(buf.position() + ");
                        long _padding_2 = m.getPadding();
                        _builder.append((Object)_padding_2, "\t");
                        _builder.append(" - 2);");
                        _builder.newLineIfNotEmpty();
                    }
                } else {
                    boolean _equals_3 = m.getTypename().equals("uint16_t");
                    if (_equals_3) {
                        _builder.append("\t");
                        String _native2JavaType_4 = this.native2JavaType(this.nativeTypeName(m));
                        _builder.append(_native2JavaType_4, "\t");
                        _builder.append(" value = buf.getShort() & 0xFFFFL;");
                        _builder.newLineIfNotEmpty();
                        boolean _isPadded_3 = this.isPadded(m);
                        if (_isPadded_3) {
                            _builder.append("\t");
                            _builder.append("buf.position(buf.position() + ");
                            long _padding_3 = m.getPadding();
                            _builder.append((Object)_padding_3, "\t");
                            _builder.append(" - 2);");
                            _builder.newLineIfNotEmpty();
                        }
                    } else {
                        boolean _equals_4 = m.getTypename().equals("int32_t");
                        if (_equals_4) {
                            _builder.append("\t");
                            String _native2JavaType_5 = this.native2JavaType(this.nativeTypeName(m));
                            _builder.append(_native2JavaType_5, "\t");
                            _builder.append(" value = buf.getInt();");
                            _builder.newLineIfNotEmpty();
                            boolean _isPadded_4 = this.isPadded(m);
                            if (_isPadded_4) {
                                _builder.append("\t");
                                _builder.append("buf.position(buf.position() + ");
                                long _padding_4 = m.getPadding();
                                _builder.append((Object)_padding_4, "\t");
                                _builder.append(" - 4);");
                                _builder.newLineIfNotEmpty();
                            }
                        } else {
                            boolean _equals_5 = m.getTypename().equals("uint32_t");
                            if (_equals_5) {
                                _builder.append("\t");
                                String _native2JavaType_6 = this.native2JavaType(this.nativeTypeName(m));
                                _builder.append(_native2JavaType_6, "\t");
                                _builder.append(" value = buf.getInt() & 0xFFFFFFFFL;");
                                _builder.newLineIfNotEmpty();
                                boolean _isPadded_5 = this.isPadded(m);
                                if (_isPadded_5) {
                                    _builder.append("\t");
                                    _builder.append("buf.position(buf.position() + ");
                                    long _padding_5 = m.getPadding();
                                    _builder.append((Object)_padding_5, "\t");
                                    _builder.append(" - 4);");
                                    _builder.newLineIfNotEmpty();
                                }
                            } else {
                                boolean _equals_6 = m.getTypename().equals("int64_t");
                                if (_equals_6) {
                                    _builder.append("\t");
                                    String _native2JavaType_7 = this.native2JavaType(this.nativeTypeName(m));
                                    _builder.append(_native2JavaType_7, "\t");
                                    _builder.append(" value = buf.getLong();");
                                    _builder.newLineIfNotEmpty();
                                    boolean _isPadded_6 = this.isPadded(m);
                                    if (_isPadded_6) {
                                        _builder.append("\t");
                                        _builder.append("buf.position(buf.position() + ");
                                        long _padding_6 = m.getPadding();
                                        _builder.append((Object)_padding_6, "\t");
                                        _builder.append(" - 8);");
                                        _builder.newLineIfNotEmpty();
                                    }
                                } else {
                                    boolean _equals_7 = m.getTypename().equals("uint64_t");
                                    if (_equals_7) {
                                        _builder.append("\t");
                                        String _native2JavaType_8 = this.native2JavaType(this.nativeTypeName(m));
                                        _builder.append(_native2JavaType_8, "\t");
                                        _builder.append(" value = buf.getLong();");
                                        _builder.newLineIfNotEmpty();
                                        boolean _isPadded_7 = this.isPadded(m);
                                        if (_isPadded_7) {
                                            _builder.append("\t");
                                            _builder.append("buf.position(buf.position() + ");
                                            long _padding_7 = m.getPadding();
                                            _builder.append((Object)_padding_7, "\t");
                                            _builder.append(" - 8);");
                                            _builder.newLineIfNotEmpty();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        _builder.newLine();
        if (this.isConst(m) && !this.isArray(m)) {
            _builder.append("if(value != ");
            long _defaultValue = m.getDefaultValue();
            _builder.append((Object)_defaultValue);
            _builder.append(") throw new java.io.IOException(\"Expected constant '");
            long _defaultValue_1 = m.getDefaultValue();
            _builder.append((Object)_defaultValue_1);
            _builder.append("' but got '\" + value + \"'.\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return value;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence readerMethodForBitfieldMember(BitfieldMember m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private static ");
        String _native2JavaType = this.native2JavaType(this.nativeTypeName(m));
        _builder.append(_native2JavaType);
        _builder.append(" ");
        String _readerMethodName = this.readerMethodName(m);
        _builder.append(_readerMethodName);
        String _arrayPostfix = this.arrayPostfix(m);
        _builder.append(_arrayPostfix);
        _builder.append("(java.nio.ByteBuffer buf, boolean partialRead) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        boolean _equals = m.getTypename().equals("int8_t");
        if (_equals) {
            _builder.append("\t");
            String _native2JavaType_1 = this.native2JavaType(this.nativeTypeName(m));
            _builder.append(_native2JavaType_1, "\t");
            _builder.append(" value = buf.get();");
            _builder.newLineIfNotEmpty();
            boolean _isPadded = this.isPadded(m);
            if (_isPadded) {
                _builder.append("\t");
                _builder.append("buf.position(buf.position() + ");
                long _padding = m.getPadding();
                _builder.append((Object)_padding, "\t");
                _builder.append(" - 1);");
                _builder.newLineIfNotEmpty();
            }
        } else {
            boolean _equals_1 = m.getTypename().equals("uint8_t");
            if (_equals_1) {
                _builder.append("\t");
                String _native2JavaType_2 = this.native2JavaType(this.nativeTypeName(m));
                _builder.append(_native2JavaType_2, "\t");
                _builder.append(" value = buf.get() & 0xFFL;");
                _builder.newLineIfNotEmpty();
                boolean _isPadded_1 = this.isPadded(m);
                if (_isPadded_1) {
                    _builder.append("\t");
                    _builder.append("buf.position(buf.position() + ");
                    long _padding_1 = m.getPadding();
                    _builder.append((Object)_padding_1, "\t");
                    _builder.append(" - 1);");
                    _builder.newLineIfNotEmpty();
                }
            } else {
                boolean _equals_2 = m.getTypename().equals("int16_t");
                if (_equals_2) {
                    _builder.append("\t");
                    String _native2JavaType_3 = this.native2JavaType(this.nativeTypeName(m));
                    _builder.append(_native2JavaType_3, "\t");
                    _builder.append(" value = buf.getShort();");
                    _builder.newLineIfNotEmpty();
                    boolean _isPadded_2 = this.isPadded(m);
                    if (_isPadded_2) {
                        _builder.append("\t");
                        _builder.append("buf.position(buf.position() + ");
                        long _padding_2 = m.getPadding();
                        _builder.append((Object)_padding_2, "\t");
                        _builder.append(" - 2);");
                        _builder.newLineIfNotEmpty();
                    }
                } else {
                    boolean _equals_3 = m.getTypename().equals("uint16_t");
                    if (_equals_3) {
                        _builder.append("\t");
                        String _native2JavaType_4 = this.native2JavaType(this.nativeTypeName(m));
                        _builder.append(_native2JavaType_4, "\t");
                        _builder.append(" value = buf.getShort() & 0xFFFFL;");
                        _builder.newLineIfNotEmpty();
                        boolean _isPadded_3 = this.isPadded(m);
                        if (_isPadded_3) {
                            _builder.append("\t");
                            _builder.append("buf.position(buf.position() + ");
                            long _padding_3 = m.getPadding();
                            _builder.append((Object)_padding_3, "\t");
                            _builder.append(" - 2);");
                            _builder.newLineIfNotEmpty();
                        }
                    } else {
                        boolean _equals_4 = m.getTypename().equals("int32_t");
                        if (_equals_4) {
                            _builder.append("\t");
                            String _native2JavaType_5 = this.native2JavaType(this.nativeTypeName(m));
                            _builder.append(_native2JavaType_5, "\t");
                            _builder.append(" value = buf.getInt();");
                            _builder.newLineIfNotEmpty();
                            boolean _isPadded_4 = this.isPadded(m);
                            if (_isPadded_4) {
                                _builder.append("\t");
                                _builder.append("buf.position(buf.position() + ");
                                long _padding_4 = m.getPadding();
                                _builder.append((Object)_padding_4, "\t");
                                _builder.append(" - 4);");
                                _builder.newLineIfNotEmpty();
                            }
                        } else {
                            boolean _equals_5 = m.getTypename().equals("uint32_t");
                            if (_equals_5) {
                                _builder.append("\t");
                                String _native2JavaType_6 = this.native2JavaType(this.nativeTypeName(m));
                                _builder.append(_native2JavaType_6, "\t");
                                _builder.append(" value = buf.getInt() & 0xFFFFFFFFL;");
                                _builder.newLineIfNotEmpty();
                                boolean _isPadded_5 = this.isPadded(m);
                                if (_isPadded_5) {
                                    _builder.append("\t");
                                    _builder.append("buf.position(buf.position() + ");
                                    long _padding_5 = m.getPadding();
                                    _builder.append((Object)_padding_5, "\t");
                                    _builder.append(" - 4);");
                                    _builder.newLineIfNotEmpty();
                                }
                            } else {
                                boolean _equals_6 = m.getTypename().equals("int64_t");
                                if (_equals_6) {
                                    _builder.append("\t");
                                    String _native2JavaType_7 = this.native2JavaType(this.nativeTypeName(m));
                                    _builder.append(_native2JavaType_7, "\t");
                                    _builder.append(" value = buf.getLong();");
                                    _builder.newLineIfNotEmpty();
                                    boolean _isPadded_6 = this.isPadded(m);
                                    if (_isPadded_6) {
                                        _builder.append("\t");
                                        _builder.append("buf.position(buf.position() + ");
                                        long _padding_6 = m.getPadding();
                                        _builder.append((Object)_padding_6, "\t");
                                        _builder.append(" - 8);");
                                        _builder.newLineIfNotEmpty();
                                    }
                                } else {
                                    boolean _equals_7 = m.getTypename().equals("uint64_t");
                                    if (_equals_7) {
                                        _builder.append("\t");
                                        String _native2JavaType_8 = this.native2JavaType(this.nativeTypeName(m));
                                        _builder.append(_native2JavaType_8, "\t");
                                        _builder.append(" value = buf.getLong();");
                                        _builder.newLineIfNotEmpty();
                                        boolean _isPadded_7 = this.isPadded(m);
                                        if (_isPadded_7) {
                                            _builder.append("\t");
                                            _builder.append("buf.position(buf.position() + ");
                                            long _padding_7 = m.getPadding();
                                            _builder.append((Object)_padding_7, "\t");
                                            _builder.append(" - 8);");
                                            _builder.newLineIfNotEmpty();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        _builder.append("\t");
        _builder.append("return value;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence readerMethodForFloatMember(FloatMember m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private static ");
        String _native2JavaType = this.native2JavaType(this.nativeTypeName(m));
        _builder.append(_native2JavaType);
        _builder.append(" ");
        String _readerMethodName = this.readerMethodName(m);
        _builder.append(_readerMethodName);
        String _arrayPostfix = this.arrayPostfix(m);
        _builder.append(_arrayPostfix);
        _builder.append("(java.nio.ByteBuffer buf, boolean partialRead) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        boolean _equals = m.getTypename().equals("float");
        if (_equals) {
            _builder.append("\t");
            _builder.append("float value = buf.getFloat();");
            _builder.newLine();
            boolean _isPadded = this.isPadded(m);
            if (_isPadded) {
                _builder.append("\t");
                _builder.append("buf.position(buf.position() + ");
                long _padding = m.getPadding();
                _builder.append((Object)_padding, "\t");
                _builder.append(" - 4);");
                _builder.newLineIfNotEmpty();
            }
        } else {
            boolean _equals_1 = m.getTypename().equals("double");
            if (_equals_1) {
                _builder.append("\t");
                _builder.append("double value = buf.getDouble();");
                _builder.newLine();
                boolean _isPadded_1 = this.isPadded(m);
                if (_isPadded_1) {
                    _builder.append("\t");
                    _builder.append("buf.position(buf.position() + ");
                    long _padding_1 = m.getPadding();
                    _builder.append((Object)_padding_1, "\t");
                    _builder.append(" - 8);");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.newLine();
        if (this.isConst(m) && !this.isArray(m)) {
            _builder.append("if(value != ");
            float _defaultValue = m.getDefaultValue();
            _builder.append((Object)Float.valueOf(_defaultValue));
            _builder.append(") throw new java.io.IOException(\"Expected constant '");
            float _defaultValue_1 = m.getDefaultValue();
            _builder.append((Object)Float.valueOf(_defaultValue_1));
            _builder.append("' but got '\" + value + \"'.\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return value;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence readerMethodForStringMember(StringMember m) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private static String ");
        String _readerMethodName = this.readerMethodName(m);
        _builder.append(_readerMethodName);
        _builder.append("(java.nio.ByteBuffer buf, boolean partialRead");
        if (this.dimensionOf(m) == 0 && this.findMemberDefiningSizeOf(m) != null) {
            _builder.append(", ");
            String _attributeJavaType = this.attributeJavaType(this.findMemberDefiningSizeOrCountOf(m));
            _builder.append(_attributeJavaType);
            _builder.append(" sizeof");
        }
        _builder.append(") throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("String value = null;");
        _builder.newLine();
        if (this.dimensionOf(m) == 0 && this.findMemberDefiningSizeOf(m) == null) {
            _builder.append("\t");
            _builder.append("java.io.ByteArrayOutputStream tmp = new java.io.ByteArrayOutputStream();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("int zerosRead = 0;");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        int _dimensionOf = this.dimensionOf(m);
        boolean bl = _equals = _dimensionOf == 0;
        if (_equals) {
            boolean _tripleEquals;
            IntegerMember _findMemberDefiningSizeOf = this.findMemberDefiningSizeOf(m);
            boolean bl2 = _tripleEquals = _findMemberDefiningSizeOf == null;
            if (_tripleEquals) {
                _builder.append("\t");
                _builder.append("int terminatingZeros = \"\\0\".getBytes(\"");
                String _encodingOf = this.encodingOf(m);
                _builder.append(_encodingOf, "\t");
                _builder.append("\").length;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("while(zerosRead < terminatingZeros) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("int b = buf.get();");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("tmp.write(b);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("if(b == 0) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("zerosRead++;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("} else {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("zerosRead = 0;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                boolean _isPadded = this.isPadded(m);
                if (_isPadded) {
                    _builder.append("\t");
                    _builder.append("int bytesOverlap = (tmp.size() % ");
                    long _padding = m.getPadding();
                    _builder.append((Object)_padding, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("if(bytesOverlap > 0) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("buf.position(buf.position() + ");
                    long _padding_1 = m.getPadding();
                    _builder.append((Object)_padding_1, "\t\t");
                    _builder.append(" - bytesOverlap);\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("value = new String(tmp.toByteArray(), 0, tmp.size() - zerosRead, \"");
                String _encodingOf_1 = this.encodingOf(m);
                _builder.append(_encodingOf_1, "\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
            } else {
                boolean _tripleEquals_1;
                _builder.newLine();
                _builder.append("\t");
                _builder.append("byte[] tmp = new byte[(int)sizeof];");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("buf.get(tmp);");
                _builder.newLine();
                _builder.newLine();
                boolean _isPadded_1 = this.isPadded(m);
                if (_isPadded_1) {
                    _builder.append("\t");
                    _builder.append("int bytesOverlap = ((int)(sizeof) % ");
                    long _padding_2 = m.getPadding();
                    _builder.append((Object)_padding_2, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("if(bytesOverlap > 0) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("buf.position(buf.position() + ");
                    long _padding_3 = m.getPadding();
                    _builder.append((Object)_padding_3, "\t\t");
                    _builder.append(" - bytesOverlap);\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.newLine();
                String _nullTerminated = m.getNullTerminated();
                boolean bl3 = _tripleEquals_1 = _nullTerminated == null;
                if (_tripleEquals_1) {
                    _builder.append("\t");
                    _builder.append("value = new String(tmp, 0, (int)sizeof, \"");
                    String _encodingOf_2 = this.encodingOf(m);
                    _builder.append(_encodingOf_2, "\t");
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("int terminatingZeros = \"\\0\".getBytes(\"");
                    String _encodingOf_3 = this.encodingOf(m);
                    _builder.append(_encodingOf_3, "\t");
                    _builder.append("\").length;");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("value = new String(tmp, 0, (int)(sizeof - terminatingZeros), \"");
                    String _encodingOf_4 = this.encodingOf(m);
                    _builder.append(_encodingOf_4, "\t");
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
            }
        } else {
            _builder.append("\t");
            _builder.append("byte[] tmp = new byte[");
            int _dimensionOf_1 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_1, "\t");
            _builder.append("];");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("buf.get(tmp);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("int terminatingZeros = \"\\0\".getBytes(\"");
            String _encodingOf_5 = this.encodingOf(m);
            _builder.append(_encodingOf_5, "\t");
            _builder.append("\").length;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("int zerosRead = 0;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("int i = 0;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("int len = 0;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("while(zerosRead < terminatingZeros) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if(i >= ");
            int _dimensionOf_2 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_2, "\t\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("len = i;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if(tmp[i++] == 0) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("zerosRead++;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("zerosRead = 0;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("len = i;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            if (this.isPadded(m) && (long)this.dimensionOf(m) % m.getPadding() > 0L) {
                _builder.append("\t");
                _builder.append("buf.position(buf.position() + ");
                long _padding_4 = m.getPadding();
                int _dimensionOf_3 = this.dimensionOf(m);
                long _padding_5 = m.getPadding();
                long _modulo = (long)_dimensionOf_3 % _padding_5;
                long _minus = _padding_4 - _modulo;
                _builder.append((Object)_minus, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("value = new String(tmp, 0, len, \"");
            String _encodingOf_6 = this.encodingOf(m);
            _builder.append(_encodingOf_6, "\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("} catch(java.io.UnsupportedEncodingException e) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("throw new java.io.IOException(e);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        if (this.dimensionOf(m) == 0 && this.findMemberDefiningSizeOf(m) == null) {
            _builder.append("\t");
            _builder.append("catch(java.nio.BufferUnderflowException e) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if(!partialRead) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("throw e;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("value = new String(tmp.toByteArray(), 0, tmp.size() - zerosRead, \"");
            String _encodingOf_7 = this.encodingOf(m);
            _builder.append(_encodingOf_7, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isConst = this.isConst(m);
        if (_isConst) {
            _builder.append("if(!\"");
            String _defaultValue = m.getDefaultValue();
            _builder.append(_defaultValue);
            _builder.append("\".equals(value)) throw new java.io.IOException(\"Expected constant '");
            String _defaultValue_1 = m.getDefaultValue();
            _builder.append(_defaultValue_1);
            _builder.append("' but got '\" + value + \"'.\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return value;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public String arrayPostfix(Member m) {
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            return "_ArrayItem";
        }
        return "";
    }

    public String writerMethodName(Member m) {
        String _firstUpper = StringExtensions.toFirstUpper((String)this.attributeName(m));
        return "write" + _firstUpper;
    }

    public CharSequence writerMethodForStruct(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public void write(java.nio.ByteBuffer buf) throws java.io.IOException {");
        _builder.newLine();
        boolean _isSelfSized = this.isSelfSized(struct);
        if (_isSelfSized) {
            _builder.append("\t");
            _builder.append("int beginOfStruct = buf.position();");
            _builder.newLine();
        }
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            boolean _tripleNotEquals;
            boolean _isTransient = this.isTransient(m);
            if (_isTransient) {
                _builder.append("\t");
                _builder.append("int positionof__");
                String _attributeName = this.attributeName(m);
                _builder.append(_attributeName, "\t");
                _builder.append(" = buf.position();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("buf.position(buf.position() + ");
                long _computeFixedSizeOf = this.computeFixedSizeOf(m);
                _builder.append((Object)_computeFixedSizeOf, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            IntegerMember _findMemberDefiningSizeOrCountOf = this.findMemberDefiningSizeOrCountOf(m);
            boolean bl = _tripleNotEquals = _findMemberDefiningSizeOrCountOf != null;
            if (_tripleNotEquals) {
                _builder.append("\t");
                _builder.append("int positionof__");
                String _attributeName_1 = this.attributeName(m);
                _builder.append(_attributeName_1, "\t");
                _builder.append(" = buf.position();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _writerMethodName = this.writerMethodName(m);
                _builder.append(_writerMethodName, "\t");
                _builder.append("(buf);");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.newLine();
                if (this.isArray(m) && m instanceof IntegerMember && Objects.equals(((IntegerMember)m).getTypename(), "uint8_t")) {
                    _builder.append("\t");
                    String _attributeJavaType = this.attributeJavaType(this.findMemberDefiningSizeOrCountOf(m));
                    _builder.append(_attributeJavaType, "\t");
                    _builder.append(" ");
                    String _attributeName_2 = this.attributeName(this.findMemberDefiningSizeOrCountOf(m));
                    _builder.append(_attributeName_2, "\t");
                    _builder.append(" = ");
                    String _attributeName_3 = this.attributeName(m);
                    _builder.append(_attributeName_3, "\t");
                    _builder.append(".limit();");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    String _attributeJavaType_1 = this.attributeJavaType(this.findMemberDefiningSizeOrCountOf(m));
                    _builder.append(_attributeJavaType_1, "\t");
                    _builder.append(" ");
                    String _attributeName_4 = this.attributeName(this.findMemberDefiningSizeOrCountOf(m));
                    _builder.append(_attributeName_4, "\t");
                    _builder.append(" = (");
                    String _attributeJavaType_2 = this.attributeJavaType(this.findMemberDefiningSizeOrCountOf(m));
                    _builder.append(_attributeJavaType_2, "\t");
                    _builder.append(")(buf.position() - positionof__");
                    String _attributeName_5 = this.attributeName(m);
                    _builder.append(_attributeName_5, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("positionof__");
                String _attributeName_6 = this.attributeName(m);
                _builder.append(_attributeName_6, "\t");
                _builder.append(" = buf.position();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("buf.position(positionof__");
                String _attributeName_7 = this.attributeName(this.findMemberDefiningSizeOrCountOf(m));
                _builder.append(_attributeName_7, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _writerMethodName_1 = this.writerMethodName(this.findMemberDefiningSizeOrCountOf(m));
                _builder.append(_writerMethodName_1, "\t");
                _builder.append("(buf, ");
                String _attributeName_8 = this.attributeName(this.findMemberDefiningSizeOrCountOf(m));
                _builder.append(_attributeName_8, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("buf.position(positionof__");
                String _attributeName_9 = this.attributeName(m);
                _builder.append(_attributeName_9, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("\t");
            String _writerMethodName_2 = this.writerMethodName(m);
            _builder.append(_writerMethodName_2, "\t");
            _builder.append("(buf);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        boolean _isSelfSized_1 = this.isSelfSized(struct);
        if (_isSelfSized_1) {
            _builder.append("\t");
            _builder.append("int endOfStruct = buf.position();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("buf.position(positionof__");
            String _attributeName_10 = this.attributeName(this.selfSizeMember(struct));
            _builder.append(_attributeName_10, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _writerMethodName_3 = this.writerMethodName(this.selfSizeMember(struct));
            _builder.append(_writerMethodName_3, "\t");
            _builder.append("(buf, endOfStruct - beginOfStruct);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("buf.position(endOfStruct);");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public IntegerMember selfSizeMember(StructDeclaration struct) {
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            boolean _isSizeofThis;
            if (!(m instanceof IntegerMember) || !(_isSizeofThis = ((IntegerMember)m).isSizeofThis())) continue;
            return (IntegerMember)m;
        }
        return null;
    }

    public CharSequence writerMethods(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            CharSequence _writerMethodForMember = this.writerMethodForMember(m);
            _builder.append((Object)_writerMethodForMember);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public boolean hasSizeOfOrCountOfAttribute(Member m) {
        return this.hasSizeOfAttribute(m) || this.hasCountOfAttribute(m);
    }

    public boolean hasSizeOfAttribute(Member m) {
        if (m instanceof IntegerMember) {
            return ((IntegerMember)m).getSizeof() != null || ((IntegerMember)m).isSizeofThis();
        }
        return false;
    }

    public boolean hasCountOfAttribute(Member m) {
        if (m instanceof IntegerMember) {
            Member _countof = ((IntegerMember)m).getCountof();
            return _countof != null;
        }
        return false;
    }

    public CharSequence writerMethodForMember(Member m) {
        boolean _isTransient = this.isTransient(m);
        if (_isTransient) {
            return this.writerMethodForIntegerMemberReceivingValue((IntegerMember)m);
        }
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            String _typename;
            boolean _equals;
            boolean _matched = false;
            if (m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "uint8_t"))) {
                _matched = true;
                return this.writerMethodForByteBuffer((IntegerMember)m);
            }
            if (!_matched && m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "int8_t"))) {
                _matched = true;
                return this.writerMethodForByteBuffer((IntegerMember)m);
            }
            if (!_matched && m instanceof StringMember) {
                _matched = true;
                return this.writerMethodForString((StringMember)m);
            }
            return this.writerMethodForArrayMember(m);
        }
        return this.writerMethodForPrimitive(m);
    }

    public CharSequence writerMethodForPrimitive(Member m) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (m instanceof ComplexTypeMember) {
            _matched = true;
            _switchResult = this.writerMethodForComplexTypeMember((ComplexTypeMember)m);
        }
        if (!_matched && m instanceof IntegerMember) {
            _matched = true;
            _switchResult = this.writerMethodForIntegerMember((IntegerMember)m);
        }
        if (!_matched && m instanceof FloatMember) {
            _matched = true;
            _switchResult = this.writerMethodForFloatMember((FloatMember)m);
        }
        if (!_matched && m instanceof StringMember) {
            _matched = true;
            _switchResult = this.writerMethodForString((StringMember)m);
        }
        if (!_matched && m instanceof BitfieldMember) {
            _matched = true;
            _switchResult = this.writerMethodForBitfieldMember((BitfieldMember)m);
        }
        return _switchResult;
    }

    public CharSequence writerMethodForArrayMember(Member m) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private void ");
        String _writerMethodName = this.writerMethodName(m);
        _builder.append(_writerMethodName);
        _builder.append("(java.nio.ByteBuffer buf) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("java.util.ArrayList<");
        String _box = this.box(this.native2JavaType(this.nativeTypeName(m)));
        _builder.append(_box, "\t");
        _builder.append("> lst = ");
        String _terName = this.getterName(m);
        _builder.append(_terName, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        int _dimensionOf = this.dimensionOf(m);
        boolean bl = _equals = _dimensionOf == 0;
        if (_equals) {
            _builder.append("\t");
            _builder.append("if(lst == null) {");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("return;");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("for(");
            String _box_1 = this.box(this.native2JavaType(this.nativeTypeName(m)));
            _builder.append(_box_1, "\t");
            _builder.append(" item : lst) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            String _writerMethodName_1 = this.writerMethodName(m);
            _builder.append(_writerMethodName_1, "\t\t");
            String _arrayPostfix = this.arrayPostfix(m);
            _builder.append(_arrayPostfix, "\t\t");
            _builder.append("(buf, item);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("if(lst.size() > ");
            int _dimensionOf_1 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_1, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("    ");
            _builder.append("throw new java.io.IOException(\"Field '");
            String _attributeName = this.attributeName(m);
            _builder.append(_attributeName, "\t    ");
            _builder.append("' contains \" + lst.size() + \" element which can't be serialized into structure with limit of ");
            int _dimensionOf_2 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_2, "\t    ");
            _builder.append(" elements!\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("for(int i = 0; i < lst.size(); ++i) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("    ");
            String _writerMethodName_2 = this.writerMethodName(m);
            _builder.append(_writerMethodName_2, "\t    ");
            String _arrayPostfix_1 = this.arrayPostfix(m);
            _builder.append(_arrayPostfix_1, "\t    ");
            _builder.append("(buf, lst.get(i));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// if there are less elements than expected, we fill with default constructed");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("for(int i = lst.size(); i < ");
            int _dimensionOf_3 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_3, "\t");
            _builder.append("; ++i) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("    ");
            String _writerMethodName_3 = this.writerMethodName(m);
            _builder.append(_writerMethodName_3, "\t    ");
            String _arrayPostfix_2 = this.arrayPostfix(m);
            _builder.append(_arrayPostfix_2, "\t    ");
            _builder.append("(buf, ");
            String _defaultConstructArrayItem = this.defaultConstructArrayItem(m);
            _builder.append(_defaultConstructArrayItem, "\t    ");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _writerMethodForPrimitive = this.writerMethodForPrimitive(m);
        _builder.append((Object)_writerMethodForPrimitive);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence writerMethodForByteBuffer(IntegerMember m) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private void ");
        String _writerMethodName = this.writerMethodName(m);
        _builder.append(_writerMethodName);
        _builder.append("(java.nio.ByteBuffer buf) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("java.nio.ByteBuffer buffer = ");
        String _terName = this.getterName(m);
        _builder.append(_terName, "    ");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("// null buffers serialize like empty buffers");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if(buffer == null) {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("buffer = java.nio.ByteBuffer.wrap(new byte[]{});");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// reset position in case someone read this buffer before");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("buffer.position(0);");
        _builder.newLine();
        _builder.newLine();
        int _dimensionOf = this.dimensionOf(m);
        boolean bl = _greaterThan = _dimensionOf > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("// we need to slice the buffer in order to limit its written size");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("java.nio.ByteBuffer slicedBuffer = buffer.slice();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if(slicedBuffer.limit() > ");
            int _dimensionOf_1 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_1, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("slicedBuffer.limit(");
            int _dimensionOf_2 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_2, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("buf.put(slicedBuffer);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("int bytesToFill = (");
            int _dimensionOf_3 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_3, "\t");
            _builder.append(" - slicedBuffer.limit());");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("if(bytesToFill > 0) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("for(int i = 0; i < bytesToFill; ++i) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("buf.put((byte)0);\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("// buffer has unbound / dynamic size");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("buf.put(buffer);");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        boolean _isPadded = this.isPadded(m);
        if (_isPadded) {
            _builder.append("\t");
            _builder.append("int bytesOverlap = (buffer.limit() % ");
            long _padding = m.getPadding();
            _builder.append((Object)_padding, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("if(bytesOverlap > 0) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("for(int i = 0; i < ");
            long _padding_1 = m.getPadding();
            _builder.append((Object)_padding_1, "\t\t");
            _builder.append(" - bytesOverlap; ++i) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("buf.put((byte)");
            long _using = m.getUsing();
            _builder.append((Object)_using, "\t\t\t");
            _builder.append(");\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}\t\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence writerMethodForComplexTypeMember(ComplexTypeMember m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private void ");
        String _writerMethodName = this.writerMethodName(m);
        _builder.append(_writerMethodName);
        String _arrayPostfix = this.arrayPostfix(m);
        _builder.append(_arrayPostfix);
        _builder.append("(java.nio.ByteBuffer buf");
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            _builder.append(", ");
            String _native2JavaType = this.native2JavaType(this.nativeTypeName(m));
            _builder.append(_native2JavaType);
            _builder.append(" value");
        }
        _builder.append(") throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(");
        boolean _isArray_1 = this.isArray(m);
        if (_isArray_1) {
            _builder.append("value");
        } else {
            String _terName = this.getterName(m);
            _builder.append(_terName, "\t");
            _builder.append("()");
        }
        _builder.append(" != null) {");
        _builder.newLineIfNotEmpty();
        boolean _isPadded = this.isPadded(m);
        if (_isPadded) {
            _builder.append("\t\t");
            _builder.append("int beginMember = buf.position();");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        boolean _isArray_2 = this.isArray(m);
        if (_isArray_2) {
            _builder.append("value");
        } else {
            String _terName_1 = this.getterName(m);
            _builder.append(_terName_1, "\t\t");
            _builder.append("()");
        }
        _builder.append(".write(buf);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        boolean _isPadded_1 = this.isPadded(m);
        if (_isPadded_1) {
            _builder.append("\t\t");
            _builder.append("int bytesOverlap = ((buf.position() - beginMember) % ");
            long _padding = m.getPadding();
            _builder.append((Object)_padding, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("if(bytesOverlap > 0) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("for(int i = 0; i < ");
            long _padding_1 = m.getPadding();
            _builder.append((Object)_padding_1, "\t\t\t");
            _builder.append(" - bytesOverlap; ++i) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("buf.put((byte)");
            long _using = m.getUsing();
            _builder.append((Object)_using, "\t\t\t\t");
            _builder.append(");\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence writerMethodForIntegerMember(IntegerMember m) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            CharSequence _writerMethodForIntegerMemberReceivingValue = this.writerMethodForIntegerMemberReceivingValue(m);
            _builder.append((Object)_writerMethodForIntegerMemberReceivingValue);
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("private void ");
            String _writerMethodName = this.writerMethodName(m);
            _builder.append(_writerMethodName);
            String _arrayPostfix = this.arrayPostfix(m);
            _builder.append(_arrayPostfix);
            _builder.append("(java.nio.ByteBuffer buf) throws java.io.IOException {");
            _builder.newLineIfNotEmpty();
            boolean _equals = m.getTypename().equals("int8_t");
            if (_equals) {
                _builder.append("\t");
                _builder.append("buf.put((byte)");
                String _terName = this.getterName(m);
                _builder.append(_terName, "\t");
                _builder.append("());");
                _builder.newLineIfNotEmpty();
                boolean _isPadded = this.isPadded(m);
                if (_isPadded) {
                    _builder.append("\t");
                    _builder.append("for(int i = 0; i < ");
                    long _padding = m.getPadding();
                    _builder.append((Object)_padding, "\t");
                    _builder.append(" - 1; ++i) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("buf.put((byte)");
                    long _using = m.getUsing();
                    _builder.append((Object)_using, "\t\t");
                    _builder.append(");\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
            } else {
                boolean _equals_1 = m.getTypename().equals("uint8_t");
                if (_equals_1) {
                    _builder.append("\t");
                    _builder.append("buf.put((byte)");
                    String _terName_1 = this.getterName(m);
                    _builder.append(_terName_1, "\t");
                    _builder.append("());");
                    _builder.newLineIfNotEmpty();
                    boolean _isPadded_1 = this.isPadded(m);
                    if (_isPadded_1) {
                        _builder.append("\t");
                        _builder.append("for(int i = 0; i < ");
                        long _padding_1 = m.getPadding();
                        _builder.append((Object)_padding_1, "\t");
                        _builder.append(" - 1; ++i) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("buf.put((byte)");
                        long _using_1 = m.getUsing();
                        _builder.append((Object)_using_1, "\t\t");
                        _builder.append(");\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                    }
                } else {
                    boolean _equals_2 = m.getTypename().equals("int16_t");
                    if (_equals_2) {
                        _builder.append("\t");
                        _builder.append("buf.putShort((short)");
                        String _terName_2 = this.getterName(m);
                        _builder.append(_terName_2, "\t");
                        _builder.append("());");
                        _builder.newLineIfNotEmpty();
                        boolean _isPadded_2 = this.isPadded(m);
                        if (_isPadded_2) {
                            _builder.append("\t");
                            _builder.append("for(int i = 0; i < ");
                            long _padding_2 = m.getPadding();
                            _builder.append((Object)_padding_2, "\t");
                            _builder.append(" - 2; ++i) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("buf.put((byte)");
                            long _using_2 = m.getUsing();
                            _builder.append((Object)_using_2, "\t\t");
                            _builder.append(");\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("}");
                            _builder.newLine();
                        }
                    } else {
                        boolean _equals_3 = m.getTypename().equals("uint16_t");
                        if (_equals_3) {
                            _builder.append("\t");
                            _builder.append("buf.putShort((short)");
                            String _terName_3 = this.getterName(m);
                            _builder.append(_terName_3, "\t");
                            _builder.append("());");
                            _builder.newLineIfNotEmpty();
                            boolean _isPadded_3 = this.isPadded(m);
                            if (_isPadded_3) {
                                _builder.append("\t");
                                _builder.append("for(int i = 0; i < ");
                                long _padding_3 = m.getPadding();
                                _builder.append((Object)_padding_3, "\t");
                                _builder.append(" - 2; ++i) {");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("buf.put((byte)");
                                long _using_3 = m.getUsing();
                                _builder.append((Object)_using_3, "\t\t");
                                _builder.append(");\t");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t");
                                _builder.append("}");
                                _builder.newLine();
                            }
                        } else {
                            boolean _equals_4 = m.getTypename().equals("int32_t");
                            if (_equals_4) {
                                _builder.append("\t");
                                _builder.append("buf.putInt((int)");
                                String _terName_4 = this.getterName(m);
                                _builder.append(_terName_4, "\t");
                                _builder.append("());");
                                _builder.newLineIfNotEmpty();
                                boolean _isPadded_4 = this.isPadded(m);
                                if (_isPadded_4) {
                                    _builder.append("\t");
                                    _builder.append("for(int i = 0; i < ");
                                    long _padding_4 = m.getPadding();
                                    _builder.append((Object)_padding_4, "\t");
                                    _builder.append(" - 4; ++i) {");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    _builder.append("buf.put((byte)");
                                    long _using_4 = m.getUsing();
                                    _builder.append((Object)_using_4, "\t\t");
                                    _builder.append(");\t");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t");
                                    _builder.append("}");
                                    _builder.newLine();
                                }
                            } else {
                                boolean _equals_5 = m.getTypename().equals("uint32_t");
                                if (_equals_5) {
                                    _builder.append("\t");
                                    _builder.append("buf.putInt((int)");
                                    String _terName_5 = this.getterName(m);
                                    _builder.append(_terName_5, "\t");
                                    _builder.append("());");
                                    _builder.newLineIfNotEmpty();
                                    boolean _isPadded_5 = this.isPadded(m);
                                    if (_isPadded_5) {
                                        _builder.append("\t");
                                        _builder.append("for(int i = 0; i < ");
                                        long _padding_5 = m.getPadding();
                                        _builder.append((Object)_padding_5, "\t");
                                        _builder.append(" - 4; ++i) {");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("\t");
                                        _builder.append("\t");
                                        _builder.append("buf.put((byte)");
                                        long _using_5 = m.getUsing();
                                        _builder.append((Object)_using_5, "\t\t");
                                        _builder.append(");\t");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("\t");
                                        _builder.append("}");
                                        _builder.newLine();
                                    }
                                } else {
                                    boolean _equals_6 = m.getTypename().equals("int64_t");
                                    if (_equals_6) {
                                        _builder.append("\t");
                                        _builder.append("buf.putLong(");
                                        String _terName_6 = this.getterName(m);
                                        _builder.append(_terName_6, "\t");
                                        _builder.append("());");
                                        _builder.newLineIfNotEmpty();
                                        boolean _isPadded_6 = this.isPadded(m);
                                        if (_isPadded_6) {
                                            _builder.append("\t");
                                            _builder.append("for(int i = 0; i < ");
                                            long _padding_6 = m.getPadding();
                                            _builder.append((Object)_padding_6, "\t");
                                            _builder.append(" - 8; ++i) {");
                                            _builder.newLineIfNotEmpty();
                                            _builder.append("\t");
                                            _builder.append("\t");
                                            _builder.append("buf.put((byte)");
                                            long _using_6 = m.getUsing();
                                            _builder.append((Object)_using_6, "\t\t");
                                            _builder.append(");\t");
                                            _builder.newLineIfNotEmpty();
                                            _builder.append("\t");
                                            _builder.append("}");
                                            _builder.newLine();
                                        }
                                    } else {
                                        boolean _equals_7 = m.getTypename().equals("uint64_t");
                                        if (_equals_7) {
                                            _builder.append("\t");
                                            _builder.append("buf.putLong(");
                                            String _terName_7 = this.getterName(m);
                                            _builder.append(_terName_7, "\t");
                                            _builder.append("());");
                                            _builder.newLineIfNotEmpty();
                                            boolean _isPadded_7 = this.isPadded(m);
                                            if (_isPadded_7) {
                                                _builder.append("\t");
                                                _builder.append("for(int i = 0; i < ");
                                                long _padding_7 = m.getPadding();
                                                _builder.append((Object)_padding_7, "\t");
                                                _builder.append(" - 8; ++i) {");
                                                _builder.newLineIfNotEmpty();
                                                _builder.append("\t");
                                                _builder.append("\t");
                                                _builder.append("buf.put((byte)");
                                                long _using_7 = m.getUsing();
                                                _builder.append((Object)_using_7, "\t\t");
                                                _builder.append(");\t");
                                                _builder.newLineIfNotEmpty();
                                                _builder.append("\t");
                                                _builder.append("}");
                                                _builder.newLine();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence writerMethodForBitfieldMember(BitfieldMember m) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            CharSequence _writerMethodForBitfieldMemberReceivingValue = this.writerMethodForBitfieldMemberReceivingValue(m);
            _builder.append((Object)_writerMethodForBitfieldMemberReceivingValue);
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("private void ");
            String _writerMethodName = this.writerMethodName(m);
            _builder.append(_writerMethodName);
            String _arrayPostfix = this.arrayPostfix(m);
            _builder.append(_arrayPostfix);
            _builder.append("(java.nio.ByteBuffer buf) throws java.io.IOException {");
            _builder.newLineIfNotEmpty();
            boolean _equals = m.getTypename().equals("int8_t");
            if (_equals) {
                _builder.append("\t");
                _builder.append("buf.put((byte)");
                String _terName = this.getterName(m);
                _builder.append(_terName, "\t");
                _builder.append("());");
                _builder.newLineIfNotEmpty();
                boolean _isPadded = this.isPadded(m);
                if (_isPadded) {
                    _builder.append("\t");
                    _builder.append("for(int i = 0; i < ");
                    long _padding = m.getPadding();
                    _builder.append((Object)_padding, "\t");
                    _builder.append(" - 1; ++i) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("buf.put((byte)");
                    long _using = m.getUsing();
                    _builder.append((Object)_using, "\t\t");
                    _builder.append(");\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
            } else {
                boolean _equals_1 = m.getTypename().equals("uint8_t");
                if (_equals_1) {
                    _builder.append("\t");
                    _builder.append("buf.put((byte)");
                    String _terName_1 = this.getterName(m);
                    _builder.append(_terName_1, "\t");
                    _builder.append("());");
                    _builder.newLineIfNotEmpty();
                    boolean _isPadded_1 = this.isPadded(m);
                    if (_isPadded_1) {
                        _builder.append("\t");
                        _builder.append("for(int i = 0; i < ");
                        long _padding_1 = m.getPadding();
                        _builder.append((Object)_padding_1, "\t");
                        _builder.append(" - 1; ++i) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("buf.put((byte)");
                        long _using_1 = m.getUsing();
                        _builder.append((Object)_using_1, "\t\t");
                        _builder.append(");\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                    }
                } else {
                    boolean _equals_2 = m.getTypename().equals("int16_t");
                    if (_equals_2) {
                        _builder.append("\t");
                        _builder.append("buf.putShort((short)");
                        String _terName_2 = this.getterName(m);
                        _builder.append(_terName_2, "\t");
                        _builder.append("());");
                        _builder.newLineIfNotEmpty();
                        boolean _isPadded_2 = this.isPadded(m);
                        if (_isPadded_2) {
                            _builder.append("\t");
                            _builder.append("for(int i = 0; i < ");
                            long _padding_2 = m.getPadding();
                            _builder.append((Object)_padding_2, "\t");
                            _builder.append(" - 2; ++i) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("buf.put((byte)");
                            long _using_2 = m.getUsing();
                            _builder.append((Object)_using_2, "\t\t");
                            _builder.append(");\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("}");
                            _builder.newLine();
                        }
                    } else {
                        boolean _equals_3 = m.getTypename().equals("uint16_t");
                        if (_equals_3) {
                            _builder.append("\t");
                            _builder.append("buf.putShort((short)");
                            String _terName_3 = this.getterName(m);
                            _builder.append(_terName_3, "\t");
                            _builder.append("());");
                            _builder.newLineIfNotEmpty();
                            boolean _isPadded_3 = this.isPadded(m);
                            if (_isPadded_3) {
                                _builder.append("\t");
                                _builder.append("for(int i = 0; i < ");
                                long _padding_3 = m.getPadding();
                                _builder.append((Object)_padding_3, "\t");
                                _builder.append(" - 2; ++i) {");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("buf.put((byte)");
                                long _using_3 = m.getUsing();
                                _builder.append((Object)_using_3, "\t\t");
                                _builder.append(");\t");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t");
                                _builder.append("}");
                                _builder.newLine();
                            }
                        } else {
                            boolean _equals_4 = m.getTypename().equals("int32_t");
                            if (_equals_4) {
                                _builder.append("\t");
                                _builder.append("buf.putInt((int)");
                                String _terName_4 = this.getterName(m);
                                _builder.append(_terName_4, "\t");
                                _builder.append("());");
                                _builder.newLineIfNotEmpty();
                                boolean _isPadded_4 = this.isPadded(m);
                                if (_isPadded_4) {
                                    _builder.append("\t");
                                    _builder.append("for(int i = 0; i < ");
                                    long _padding_4 = m.getPadding();
                                    _builder.append((Object)_padding_4, "\t");
                                    _builder.append(" - 4; ++i) {");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    _builder.append("buf.put((byte)");
                                    long _using_4 = m.getUsing();
                                    _builder.append((Object)_using_4, "\t\t");
                                    _builder.append(");\t");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t");
                                    _builder.append("}");
                                    _builder.newLine();
                                }
                            } else {
                                boolean _equals_5 = m.getTypename().equals("uint32_t");
                                if (_equals_5) {
                                    _builder.append("\t");
                                    _builder.append("buf.putInt((int)");
                                    String _terName_5 = this.getterName(m);
                                    _builder.append(_terName_5, "\t");
                                    _builder.append("());");
                                    _builder.newLineIfNotEmpty();
                                    boolean _isPadded_5 = this.isPadded(m);
                                    if (_isPadded_5) {
                                        _builder.append("\t");
                                        _builder.append("for(int i = 0; i < ");
                                        long _padding_5 = m.getPadding();
                                        _builder.append((Object)_padding_5, "\t");
                                        _builder.append(" - 4; ++i) {");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("\t");
                                        _builder.append("\t");
                                        _builder.append("buf.put((byte)");
                                        long _using_5 = m.getUsing();
                                        _builder.append((Object)_using_5, "\t\t");
                                        _builder.append(");\t");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("\t");
                                        _builder.append("}");
                                        _builder.newLine();
                                    }
                                } else {
                                    boolean _equals_6 = m.getTypename().equals("int64_t");
                                    if (_equals_6) {
                                        _builder.append("\t");
                                        _builder.append("buf.putLong(");
                                        String _terName_6 = this.getterName(m);
                                        _builder.append(_terName_6, "\t");
                                        _builder.append("());");
                                        _builder.newLineIfNotEmpty();
                                        boolean _isPadded_6 = this.isPadded(m);
                                        if (_isPadded_6) {
                                            _builder.append("\t");
                                            _builder.append("for(int i = 0; i < ");
                                            long _padding_6 = m.getPadding();
                                            _builder.append((Object)_padding_6, "\t");
                                            _builder.append(" - 8; ++i) {");
                                            _builder.newLineIfNotEmpty();
                                            _builder.append("\t");
                                            _builder.append("\t");
                                            _builder.append("buf.put((byte)");
                                            long _using_6 = m.getUsing();
                                            _builder.append((Object)_using_6, "\t\t");
                                            _builder.append(");\t");
                                            _builder.newLineIfNotEmpty();
                                            _builder.append("\t");
                                            _builder.append("}");
                                            _builder.newLine();
                                        }
                                    } else {
                                        boolean _equals_7 = m.getTypename().equals("uint64_t");
                                        if (_equals_7) {
                                            _builder.append("\t");
                                            _builder.append("buf.putLong(");
                                            String _terName_7 = this.getterName(m);
                                            _builder.append(_terName_7, "\t");
                                            _builder.append("());");
                                            _builder.newLineIfNotEmpty();
                                            boolean _isPadded_7 = this.isPadded(m);
                                            if (_isPadded_7) {
                                                _builder.append("\t");
                                                _builder.append("for(int i = 0; i < ");
                                                long _padding_7 = m.getPadding();
                                                _builder.append((Object)_padding_7, "\t");
                                                _builder.append(" - 8; ++i) {");
                                                _builder.newLineIfNotEmpty();
                                                _builder.append("\t");
                                                _builder.append("\t");
                                                _builder.append("buf.put((byte)");
                                                long _using_7 = m.getUsing();
                                                _builder.append((Object)_using_7, "\t\t");
                                                _builder.append(");\t");
                                                _builder.newLineIfNotEmpty();
                                                _builder.append("\t");
                                                _builder.append("}");
                                                _builder.newLine();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence writerMethodForIntegerMemberReceivingValue(IntegerMember m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private void ");
        String _writerMethodName = this.writerMethodName(m);
        _builder.append(_writerMethodName);
        String _arrayPostfix = this.arrayPostfix(m);
        _builder.append(_arrayPostfix);
        _builder.append("(java.nio.ByteBuffer buf, ");
        String _native2JavaType = this.native2JavaType(this.nativeTypeName(m));
        _builder.append(_native2JavaType);
        _builder.append(" value) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        boolean _equals = m.getTypename().equals("int8_t");
        if (_equals) {
            _builder.append("\t");
            _builder.append("buf.put((byte)value);");
            _builder.newLine();
            boolean _isPadded = this.isPadded(m);
            if (_isPadded) {
                _builder.append("\t");
                _builder.append("for(int i = 0; i < ");
                long _padding = m.getPadding();
                _builder.append((Object)_padding, "\t");
                _builder.append(" - 1; ++i) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("buf.put((byte)");
                long _using = m.getUsing();
                _builder.append((Object)_using, "\t\t");
                _builder.append(");\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
        } else {
            boolean _equals_1 = m.getTypename().equals("uint8_t");
            if (_equals_1) {
                _builder.append("\t");
                _builder.append("buf.put((byte)value);");
                _builder.newLine();
                boolean _isPadded_1 = this.isPadded(m);
                if (_isPadded_1) {
                    _builder.append("\t");
                    _builder.append("for(int i = 0; i < ");
                    long _padding_1 = m.getPadding();
                    _builder.append((Object)_padding_1, "\t");
                    _builder.append(" - 1; ++i) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("buf.put((byte)");
                    long _using_1 = m.getUsing();
                    _builder.append((Object)_using_1, "\t\t");
                    _builder.append(");\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
            } else {
                boolean _equals_2 = m.getTypename().equals("int16_t");
                if (_equals_2) {
                    _builder.append("\t");
                    _builder.append("buf.putShort((short)value);");
                    _builder.newLine();
                    boolean _isPadded_2 = this.isPadded(m);
                    if (_isPadded_2) {
                        _builder.append("\t");
                        _builder.append("for(int i = 0; i < ");
                        long _padding_2 = m.getPadding();
                        _builder.append((Object)_padding_2, "\t");
                        _builder.append(" - 2; ++i) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("buf.put((byte)");
                        long _using_2 = m.getUsing();
                        _builder.append((Object)_using_2, "\t\t");
                        _builder.append(");\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                    }
                } else {
                    boolean _equals_3 = m.getTypename().equals("uint16_t");
                    if (_equals_3) {
                        _builder.append("\t");
                        _builder.append("buf.putShort((short)value);");
                        _builder.newLine();
                        boolean _isPadded_3 = this.isPadded(m);
                        if (_isPadded_3) {
                            _builder.append("\t");
                            _builder.append("for(int i = 0; i < ");
                            long _padding_3 = m.getPadding();
                            _builder.append((Object)_padding_3, "\t");
                            _builder.append(" - 2; ++i) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("buf.put((byte)");
                            long _using_3 = m.getUsing();
                            _builder.append((Object)_using_3, "\t\t");
                            _builder.append(");\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("}");
                            _builder.newLine();
                        }
                    } else {
                        boolean _equals_4 = m.getTypename().equals("int32_t");
                        if (_equals_4) {
                            _builder.append("\t");
                            _builder.append("buf.putInt((int)value);");
                            _builder.newLine();
                            boolean _isPadded_4 = this.isPadded(m);
                            if (_isPadded_4) {
                                _builder.append("\t");
                                _builder.append("for(int i = 0; i < ");
                                long _padding_4 = m.getPadding();
                                _builder.append((Object)_padding_4, "\t");
                                _builder.append(" - 4; ++i) {");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("buf.put((byte)");
                                long _using_4 = m.getUsing();
                                _builder.append((Object)_using_4, "\t\t");
                                _builder.append(");\t");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t");
                                _builder.append("}");
                                _builder.newLine();
                            }
                        } else {
                            boolean _equals_5 = m.getTypename().equals("uint32_t");
                            if (_equals_5) {
                                _builder.append("\t");
                                _builder.append("buf.putInt((int)value);");
                                _builder.newLine();
                                boolean _isPadded_5 = this.isPadded(m);
                                if (_isPadded_5) {
                                    _builder.append("\t");
                                    _builder.append("for(int i = 0; i < ");
                                    long _padding_5 = m.getPadding();
                                    _builder.append((Object)_padding_5, "\t");
                                    _builder.append(" - 4; ++i) {");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    _builder.append("buf.put((byte)");
                                    long _using_5 = m.getUsing();
                                    _builder.append((Object)_using_5, "\t\t");
                                    _builder.append(");\t");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t");
                                    _builder.append("}");
                                    _builder.newLine();
                                }
                            } else {
                                boolean _equals_6 = m.getTypename().equals("int64_t");
                                if (_equals_6) {
                                    _builder.append("\t");
                                    _builder.append("buf.putLong(value);");
                                    _builder.newLine();
                                    boolean _isPadded_6 = this.isPadded(m);
                                    if (_isPadded_6) {
                                        _builder.append("\t");
                                        _builder.append("for(int i = 0; i < ");
                                        long _padding_6 = m.getPadding();
                                        _builder.append((Object)_padding_6, "\t");
                                        _builder.append(" - 8; ++i) {");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("\t");
                                        _builder.append("\t");
                                        _builder.append("buf.put((byte)");
                                        long _using_6 = m.getUsing();
                                        _builder.append((Object)_using_6, "\t\t");
                                        _builder.append(");\t");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("\t");
                                        _builder.append("}");
                                        _builder.newLine();
                                    }
                                } else {
                                    boolean _equals_7 = m.getTypename().equals("uint64_t");
                                    if (_equals_7) {
                                        _builder.append("\t");
                                        _builder.append("buf.putLong(value);");
                                        _builder.newLine();
                                        boolean _isPadded_7 = this.isPadded(m);
                                        if (_isPadded_7) {
                                            _builder.append("\t");
                                            _builder.append("for(int i = 0; i < ");
                                            long _padding_7 = m.getPadding();
                                            _builder.append((Object)_padding_7, "\t");
                                            _builder.append(" - 8; ++i) {");
                                            _builder.newLineIfNotEmpty();
                                            _builder.append("\t");
                                            _builder.append("\t");
                                            _builder.append("buf.put((byte)");
                                            long _using_7 = m.getUsing();
                                            _builder.append((Object)_using_7, "\t\t");
                                            _builder.append(");\t");
                                            _builder.newLineIfNotEmpty();
                                            _builder.append("\t");
                                            _builder.append("}");
                                            _builder.newLine();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence writerMethodForBitfieldMemberReceivingValue(BitfieldMember m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private void ");
        String _writerMethodName = this.writerMethodName(m);
        _builder.append(_writerMethodName);
        String _arrayPostfix = this.arrayPostfix(m);
        _builder.append(_arrayPostfix);
        _builder.append("(java.nio.ByteBuffer buf, ");
        String _native2JavaType = this.native2JavaType(this.nativeTypeName(m));
        _builder.append(_native2JavaType);
        _builder.append(" value) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        boolean _equals = m.getTypename().equals("int8_t");
        if (_equals) {
            _builder.append("\t");
            _builder.append("buf.put((byte)value);");
            _builder.newLine();
            boolean _isPadded = this.isPadded(m);
            if (_isPadded) {
                _builder.append("\t");
                _builder.append("for(int i = 0; i < ");
                long _padding = m.getPadding();
                _builder.append((Object)_padding, "\t");
                _builder.append(" - 1; ++i) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("buf.put((byte)");
                long _using = m.getUsing();
                _builder.append((Object)_using, "\t\t");
                _builder.append(");\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
        } else {
            boolean _equals_1 = m.getTypename().equals("uint8_t");
            if (_equals_1) {
                _builder.append("\t");
                _builder.append("buf.put((byte)value);");
                _builder.newLine();
                boolean _isPadded_1 = this.isPadded(m);
                if (_isPadded_1) {
                    _builder.append("\t");
                    _builder.append("for(int i = 0; i < ");
                    long _padding_1 = m.getPadding();
                    _builder.append((Object)_padding_1, "\t");
                    _builder.append(" - 1; ++i) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("buf.put((byte)");
                    long _using_1 = m.getUsing();
                    _builder.append((Object)_using_1, "\t\t");
                    _builder.append(");\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
            } else {
                boolean _equals_2 = m.getTypename().equals("int16_t");
                if (_equals_2) {
                    _builder.append("\t");
                    _builder.append("buf.putShort((short)value);");
                    _builder.newLine();
                    boolean _isPadded_2 = this.isPadded(m);
                    if (_isPadded_2) {
                        _builder.append("\t");
                        _builder.append("for(int i = 0; i < ");
                        long _padding_2 = m.getPadding();
                        _builder.append((Object)_padding_2, "\t");
                        _builder.append(" - 2; ++i) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("buf.put((byte)");
                        long _using_2 = m.getUsing();
                        _builder.append((Object)_using_2, "\t\t");
                        _builder.append(");\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                    }
                } else {
                    boolean _equals_3 = m.getTypename().equals("uint16_t");
                    if (_equals_3) {
                        _builder.append("\t");
                        _builder.append("buf.putShort((short)value);");
                        _builder.newLine();
                        boolean _isPadded_3 = this.isPadded(m);
                        if (_isPadded_3) {
                            _builder.append("\t");
                            _builder.append("for(int i = 0; i < ");
                            long _padding_3 = m.getPadding();
                            _builder.append((Object)_padding_3, "\t");
                            _builder.append(" - 2; ++i) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("buf.put((byte)");
                            long _using_3 = m.getUsing();
                            _builder.append((Object)_using_3, "\t\t");
                            _builder.append(");\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("}");
                            _builder.newLine();
                        }
                    } else {
                        boolean _equals_4 = m.getTypename().equals("int32_t");
                        if (_equals_4) {
                            _builder.append("\t");
                            _builder.append("buf.putInt((int)value);");
                            _builder.newLine();
                            boolean _isPadded_4 = this.isPadded(m);
                            if (_isPadded_4) {
                                _builder.append("\t");
                                _builder.append("for(int i = 0; i < ");
                                long _padding_4 = m.getPadding();
                                _builder.append((Object)_padding_4, "\t");
                                _builder.append(" - 4; ++i) {");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("buf.put((byte)");
                                long _using_4 = m.getUsing();
                                _builder.append((Object)_using_4, "\t\t");
                                _builder.append(");\t");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t");
                                _builder.append("}");
                                _builder.newLine();
                            }
                        } else {
                            boolean _equals_5 = m.getTypename().equals("uint32_t");
                            if (_equals_5) {
                                _builder.append("\t");
                                _builder.append("buf.putInt((int)value);");
                                _builder.newLine();
                                boolean _isPadded_5 = this.isPadded(m);
                                if (_isPadded_5) {
                                    _builder.append("\t");
                                    _builder.append("for(int i = 0; i < ");
                                    long _padding_5 = m.getPadding();
                                    _builder.append((Object)_padding_5, "\t");
                                    _builder.append(" - 4; ++i) {");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    _builder.append("buf.put((byte)");
                                    long _using_5 = m.getUsing();
                                    _builder.append((Object)_using_5, "\t\t");
                                    _builder.append(");\t");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t");
                                    _builder.append("}");
                                    _builder.newLine();
                                }
                            } else {
                                boolean _equals_6 = m.getTypename().equals("int64_t");
                                if (_equals_6) {
                                    _builder.append("\t");
                                    _builder.append("buf.putLong(value);");
                                    _builder.newLine();
                                    boolean _isPadded_6 = this.isPadded(m);
                                    if (_isPadded_6) {
                                        _builder.append("\t");
                                        _builder.append("for(int i = 0; i < ");
                                        long _padding_6 = m.getPadding();
                                        _builder.append((Object)_padding_6, "\t");
                                        _builder.append(" - 8; ++i) {");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("\t");
                                        _builder.append("\t");
                                        _builder.append("buf.put((byte)");
                                        long _using_6 = m.getUsing();
                                        _builder.append((Object)_using_6, "\t\t");
                                        _builder.append(");\t");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("\t");
                                        _builder.append("}");
                                        _builder.newLine();
                                    }
                                } else {
                                    boolean _equals_7 = m.getTypename().equals("uint64_t");
                                    if (_equals_7) {
                                        _builder.append("\t");
                                        _builder.append("buf.putLong(value);");
                                        _builder.newLine();
                                        boolean _isPadded_7 = this.isPadded(m);
                                        if (_isPadded_7) {
                                            _builder.append("\t");
                                            _builder.append("for(int i = 0; i < ");
                                            long _padding_7 = m.getPadding();
                                            _builder.append((Object)_padding_7, "\t");
                                            _builder.append(" - 8; ++i) {");
                                            _builder.newLineIfNotEmpty();
                                            _builder.append("\t");
                                            _builder.append("\t");
                                            _builder.append("buf.put((byte)");
                                            long _using_7 = m.getUsing();
                                            _builder.append((Object)_using_7, "\t\t");
                                            _builder.append(");\t");
                                            _builder.newLineIfNotEmpty();
                                            _builder.append("\t");
                                            _builder.append("}");
                                            _builder.newLine();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence writerMethodForFloatMember(FloatMember m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private void ");
        String _writerMethodName = this.writerMethodName(m);
        _builder.append(_writerMethodName);
        String _arrayPostfix = this.arrayPostfix(m);
        _builder.append(_arrayPostfix);
        _builder.append("(java.nio.ByteBuffer buf");
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            _builder.append(", ");
            String _native2JavaType = this.native2JavaType(this.nativeTypeName(m));
            _builder.append(_native2JavaType);
            _builder.append(" value");
        }
        _builder.append(") throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        boolean _equals = m.getTypename().equals("float");
        if (_equals) {
            _builder.append("\t");
            _builder.append("buf.putFloat((float)");
            boolean _isArray_1 = this.isArray(m);
            if (_isArray_1) {
                _builder.append("value");
            } else {
                String _terName = this.getterName(m);
                _builder.append(_terName, "\t");
                _builder.append("()");
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            boolean _isPadded = this.isPadded(m);
            if (_isPadded) {
                _builder.append("\t");
                _builder.append("for(int i = 0; i < ");
                long _padding = m.getPadding();
                _builder.append((Object)_padding, "\t");
                _builder.append(" - 4; ++i) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("buf.put((byte)");
                long _using = m.getUsing();
                _builder.append((Object)_using, "\t\t");
                _builder.append(");\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
        } else {
            boolean _equals_1 = m.getTypename().equals("double");
            if (_equals_1) {
                _builder.append("\t");
                _builder.append("buf.putDouble(");
                boolean _isArray_2 = this.isArray(m);
                if (_isArray_2) {
                    _builder.append("value");
                } else {
                    String _terName_1 = this.getterName(m);
                    _builder.append(_terName_1, "\t");
                    _builder.append("()");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                boolean _isPadded_1 = this.isPadded(m);
                if (_isPadded_1) {
                    _builder.append("\t");
                    _builder.append("for(int i = 0; i < ");
                    long _padding_1 = m.getPadding();
                    _builder.append((Object)_padding_1, "\t");
                    _builder.append(" - 8; ++i) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("buf.put((byte)");
                    long _using_1 = m.getUsing();
                    _builder.append((Object)_using_1, "\t\t");
                    _builder.append(");\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence writerMethodForString(StringMember m) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private void ");
        String _writerMethodName = this.writerMethodName(m);
        _builder.append(_writerMethodName);
        _builder.append("(java.nio.ByteBuffer buf) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        boolean _isPadded = this.isPadded(m);
        if (_isPadded) {
            _builder.append("\t\t");
            _builder.append("int memberBegin = buf.position();");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("byte[] encoded = (");
        String _terName = this.getterName(m);
        _builder.append(_terName, "\t\t");
        _builder.append("() != null) ? ");
        String _terName_1 = this.getterName(m);
        _builder.append(_terName_1, "\t\t");
        _builder.append("().getBytes(\"");
        String _encodingOf = this.encodingOf(m);
        _builder.append(_encodingOf, "\t\t");
        _builder.append("\") : new byte[]{};");
        _builder.newLineIfNotEmpty();
        int _dimensionOf = this.dimensionOf(m);
        boolean bl = _equals = _dimensionOf == 0;
        if (_equals) {
            boolean _tripleEquals;
            _builder.append("\t\t");
            _builder.append("buf.put(encoded);");
            _builder.newLine();
            IntegerMember _findMemberDefiningSizeOf = this.findMemberDefiningSizeOf(m);
            boolean bl2 = _tripleEquals = _findMemberDefiningSizeOf == null;
            if (_tripleEquals) {
                _builder.append("\t\t");
                _builder.append("buf.put(\"\\0\".getBytes(\"");
                String _encodingOf_1 = this.encodingOf(m);
                _builder.append(_encodingOf_1, "\t\t");
                _builder.append("\"));");
                _builder.newLineIfNotEmpty();
            } else {
                boolean _tripleNotEquals;
                String _nullTerminated = m.getNullTerminated();
                boolean bl3 = _tripleNotEquals = _nullTerminated != null;
                if (_tripleNotEquals) {
                    _builder.append("\t\t");
                    _builder.append("buf.put(\"\\0\".getBytes(\"");
                    String _encodingOf_2 = this.encodingOf(m);
                    _builder.append(_encodingOf_2, "\t\t");
                    _builder.append("\"));");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.newLine();
        } else {
            _builder.append("\t\t");
            _builder.append("int len = Math.min(encoded.length, ");
            int _dimensionOf_1 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_1, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("int bytesToFill = ");
            int _dimensionOf_2 = this.dimensionOf(m);
            _builder.append((Object)_dimensionOf_2, "\t\t");
            _builder.append(" - len;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("buf.put(encoded, 0, len);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if(bytesToFill > 0) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("for(int i = 0; i < bytesToFill; ++i) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("buf.put((byte)");
            long _filler = m.getFiller();
            _builder.append((Object)_filler, "\t\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        boolean _isPadded_1 = this.isPadded(m);
        if (_isPadded_1) {
            _builder.append("\t\t");
            _builder.append("int bytesOverlap = ((buf.position() - memberBegin) % ");
            long _padding = m.getPadding();
            _builder.append((Object)_padding, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("if(bytesOverlap > 0) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("for(int i = 0; i < ");
            long _padding_1 = m.getPadding();
            _builder.append((Object)_padding_1, "\t\t\t");
            _builder.append(" - bytesOverlap; ++i) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("buf.put((byte)");
            long _using = m.getUsing();
            _builder.append((Object)_using, "\t\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("} catch(java.io.UnsupportedEncodingException e) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("throw new java.io.IOException(e);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public String encodingOf(StringMember m) {
        boolean _tripleNotEquals;
        String _encoding = m.getEncoding();
        boolean bl = _tripleNotEquals = _encoding != null;
        if (_tripleNotEquals) {
            return m.getEncoding();
        }
        return "UTF-8";
    }

    public CharSequence packageDeclaration(StructsFile structsFile) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = structsFile.getName().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("package ");
            String _name = structsFile.getName();
            _builder.append(_name);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence fields(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            if (m instanceof BitfieldMember) {
                CharSequence _field = this.field((BitfieldMember)m);
                _builder.append((Object)_field);
                _builder.newLineIfNotEmpty();
                continue;
            }
            CharSequence _field_1 = this.field(m);
            _builder.append((Object)_field_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence getters(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            if (m instanceof BitfieldMember) {
                CharSequence _ter = this.getter((BitfieldMember)m);
                _builder.append((Object)_ter);
                _builder.newLineIfNotEmpty();
                continue;
            }
            CharSequence _ter_1 = this.getter(m);
            _builder.append((Object)_ter_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence setters(StructDeclaration struct) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<Member> _nonTransientMembers = this.nonTransientMembers(struct);
        for (Member m : _nonTransientMembers) {
            boolean _not;
            boolean _isConst = this.isConst(m);
            boolean bl = _not = !_isConst;
            if (!_not) continue;
            if (m instanceof BitfieldMember) {
                CharSequence _setter = this.setter((BitfieldMember)m);
                _builder.append((Object)_setter);
                _builder.newLineIfNotEmpty();
                continue;
            }
            CharSequence _setter_1 = this.setter(m);
            _builder.append((Object)_setter_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public boolean isConst(Member m) {
        if (m instanceof ComplexTypeMember) {
            return false;
        }
        if (m instanceof IntegerMember) {
            String _constant = ((IntegerMember)m).getConstant();
            return _constant != null;
        }
        if (m instanceof FloatMember) {
            String _constant_1 = ((FloatMember)m).getConstant();
            return _constant_1 != null;
        }
        if (m instanceof StringMember) {
            String _constant_2 = ((StringMember)m).getConstant();
            return _constant_2 != null;
        }
        return false;
    }

    public CharSequence field(Member m) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _printComments = this.printComments(m);
        _builder.append((Object)_printComments);
        _builder.newLineIfNotEmpty();
        _builder.append("private ");
        String _attributeJavaType = this.attributeJavaType(m);
        _builder.append(_attributeJavaType);
        _builder.append(" ");
        String _attributeName = this.attributeName(m);
        _builder.append(_attributeName);
        _builder.append(" = ");
        String _defaultConstruct = this.defaultConstruct(m);
        _builder.append(_defaultConstruct);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence field(BitfieldMember m) {
        StringConcatenation _builder = new StringConcatenation();
        EList<BitfieldEntry> _entries = m.getEntries();
        for (BitfieldEntry entry : _entries) {
            CharSequence _printComments = this.printComments(entry);
            _builder.append((Object)_printComments);
            _builder.newLineIfNotEmpty();
            _builder.append("private ");
            String _attributeJavaType = this.attributeJavaType(entry);
            _builder.append(_attributeJavaType);
            _builder.append(" ");
            String _attributeName = this.attributeName(entry);
            _builder.append(_attributeName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence getter(Member m) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _printComments = this.printComments(m);
        _builder.append((Object)_printComments);
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _attributeJavaType = this.attributeJavaType(m);
        _builder.append(_attributeJavaType);
        _builder.append(" ");
        String _terName = this.getterName(m);
        _builder.append(_terName);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return this.");
        String _attributeName = this.attributeName(m);
        _builder.append(_attributeName, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getter(BitfieldMember m) {
        StringConcatenation _builder = new StringConcatenation();
        EList<BitfieldEntry> _entries = m.getEntries();
        for (BitfieldEntry entry : _entries) {
            CharSequence _printComments = this.printComments(entry);
            _builder.append((Object)_printComments);
            _builder.newLineIfNotEmpty();
            _builder.append("public ");
            String _attributeJavaType = this.attributeJavaType(entry);
            _builder.append(_attributeJavaType);
            _builder.append(" ");
            String _terName = this.getterName(entry);
            _builder.append(_terName);
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return this.");
            String _attributeName = this.attributeName(entry);
            _builder.append(_attributeName, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("private ");
        String _attributeJavaType_1 = this.attributeJavaType(m);
        _builder.append(_attributeJavaType_1);
        _builder.append(" ");
        String _terName_1 = this.getterName(m);
        _builder.append(_terName_1);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            _builder.append("\t");
            _builder.append("// TODO: array");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("throw new UnsupportedOperationException(\"Bitfields on top of arrays are not yet supported.\");");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("long value = 0;");
            _builder.newLine();
            EList<BitfieldEntry> _entries_1 = m.getEntries();
            for (BitfieldEntry entry_1 : _entries_1) {
                boolean _isEnumType = this.isEnumType(entry_1);
                if (_isEnumType) {
                    _builder.append("\t");
                    _builder.append("value |= this.");
                    String _attributeName_1 = this.attributeName(entry_1);
                    _builder.append(_attributeName_1, "\t");
                    _builder.append(".getValue() << ");
                    int _computeBitsToShift = this.computeBitsToShift(entry_1);
                    _builder.append((Object)_computeBitsToShift, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                boolean _isBooleanType = this.isBooleanType(entry_1);
                if (_isBooleanType) {
                    _builder.append("\t");
                    _builder.append("value |= (this.");
                    String _attributeName_2 = this.attributeName(entry_1);
                    _builder.append(_attributeName_2, "\t");
                    _builder.append(" ? 1 : 0) << ");
                    int _computeBitsToShift_1 = this.computeBitsToShift(entry_1);
                    _builder.append((Object)_computeBitsToShift_1, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t");
                _builder.append("value |= this.");
                String _attributeName_3 = this.attributeName(entry_1);
                _builder.append(_attributeName_3, "\t");
                _builder.append(" << ");
                int _computeBitsToShift_2 = this.computeBitsToShift(entry_1);
                _builder.append((Object)_computeBitsToShift_2, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("return (");
            String _attributeJavaType_2 = this.attributeJavaType(m);
            _builder.append(_attributeJavaType_2, "\t");
            _builder.append(") value;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setter(Member m) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _printComments = this.printComments(m);
        _builder.append((Object)_printComments);
        _builder.newLineIfNotEmpty();
        _builder.append("public void ");
        String _setterName = this.setterName(m);
        _builder.append(_setterName);
        _builder.append("(");
        String _attributeJavaType = this.attributeJavaType(m);
        _builder.append(_attributeJavaType);
        _builder.append(" ");
        String _attributeName = this.attributeName(m);
        _builder.append(_attributeName);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("this.");
        String _attributeName_1 = this.attributeName(m);
        _builder.append(_attributeName_1, "\t");
        _builder.append(" = ");
        String _attributeName_2 = this.attributeName(m);
        _builder.append(_attributeName_2, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setter(BitfieldMember m) {
        StringConcatenation _builder = new StringConcatenation();
        EList<BitfieldEntry> _entries = m.getEntries();
        for (BitfieldEntry entry : _entries) {
            CharSequence _printComments = this.printComments(entry);
            _builder.append((Object)_printComments);
            _builder.newLineIfNotEmpty();
            _builder.append("public void ");
            String _setterName = this.setterName(entry);
            _builder.append(_setterName);
            _builder.append("(");
            String _attributeJavaType = this.attributeJavaType(entry);
            _builder.append(_attributeJavaType);
            _builder.append(" ");
            String _attributeName = this.attributeName(entry);
            _builder.append(_attributeName);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("this.");
            String _attributeName_1 = this.attributeName(entry);
            _builder.append(_attributeName_1, "\t");
            _builder.append(" = ");
            String _attributeName_2 = this.attributeName(entry);
            _builder.append(_attributeName_2, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public String defaultConstructArrayItem(Member m) {
        boolean _not;
        String _xblockexpression = null;
        boolean _isArray = this.isArray(m);
        boolean bl = _not = !_isArray;
        if (_not) {
            throw new RuntimeException("compiler-error: non-array member passed to defaultConstructArrayItem()");
        }
        String _switchResult = null;
        boolean _matched = false;
        if (m instanceof ComplexTypeMember) {
            _matched = true;
            String _xblockexpression_1 = null;
            ComplexTypeDeclaration _type = ((ComplexTypeMember)m).getType();
            if (_type instanceof EnumDeclaration) {
                boolean _tripleEquals;
                Item _defaultValue = ((ComplexTypeMember)m).getDefaultValue();
                boolean bl2 = _tripleEquals = _defaultValue == null;
                if (_tripleEquals) {
                    return "null";
                }
                String _attributeJavaType = this.attributeJavaType(m);
                String _plus = _attributeJavaType + ".";
                String _name = ((ComplexTypeMember)m).getDefaultValue().getName();
                return _plus + _name;
            }
            String _javaType = this.javaType(((ComplexTypeMember)m).getType());
            String _plus_1 = "new " + _javaType;
            _switchResult = _xblockexpression_1 = _plus_1 + "()";
        }
        if (!_matched && m instanceof IntegerMember) {
            _matched = true;
            long _defaultValue = ((IntegerMember)m).getDefaultValue();
            _switchResult = String.valueOf((Object)_defaultValue);
        }
        if (!_matched && m instanceof FloatMember) {
            _matched = true;
            float _defaultValue = ((FloatMember)m).getDefaultValue();
            _switchResult = String.valueOf(Float.valueOf(_defaultValue)) + "f";
        }
        if (!_matched) {
            throw new RuntimeException("Unsupported member type: " + String.valueOf(m));
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public String defaultConstruct(Member m) {
        ComplexTypeDeclaration _type;
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            boolean _doesAttributeJavaTypeMapToByteBuffer;
            if (m instanceof IntegerMember && (_doesAttributeJavaTypeMapToByteBuffer = this.doesAttributeJavaTypeMapToByteBuffer(m))) {
                boolean _tripleEquals;
                IntInitializerList _defaultValues = ((IntegerMember)m).getDefaultValues();
                boolean bl = _tripleEquals = _defaultValues == null;
                if (_tripleEquals) {
                    return "java.nio.ByteBuffer.wrap(new byte[]{})";
                }
                String initList = IterableExtensions.join(((IntegerMember)m).getDefaultValues().getItems(), (CharSequence)", ");
                return "java.nio.ByteBuffer.wrap(new byte[]{" + initList + "})";
            }
            if (m instanceof StringMember) {
                String _defaultValue = ((StringMember)m).getDefaultValue();
                String _plus = "\"" + _defaultValue;
                return _plus + "\"";
            }
            String nativeType = this.nativeTypeName(m);
            String javaType = this.native2JavaType(nativeType);
            if (m instanceof IntegerMember) {
                boolean _tripleNotEquals;
                IntInitializerList _defaultValues_1 = ((IntegerMember)m).getDefaultValues();
                boolean bl = _tripleNotEquals = _defaultValues_1 != null;
                if (_tripleNotEquals) {
                    String _box = this.box(javaType);
                    String _plus_1 = "new java.util.ArrayList<" + _box;
                    String _plus_2 = _plus_1 + ">(java.util.Arrays.<Long>asList(";
                    Function<Long, String> _function = v -> String.valueOf(v) + "L";
                    String _collect = ((IntegerMember)m).getDefaultValues().getItems().stream().map(_function).collect(Collectors.joining(", "));
                    String _plus_3 = _plus_2 + _collect;
                    return _plus_3 + "))";
                }
            } else if (m instanceof FloatMember) {
                boolean _tripleNotEquals_1;
                FloatInitializerList _defaultValues_2 = ((FloatMember)m).getDefaultValues();
                boolean bl = _tripleNotEquals_1 = _defaultValues_2 != null;
                if (_tripleNotEquals_1) {
                    String _box_1 = this.box(javaType);
                    String _plus_4 = "new java.util.ArrayList<" + _box_1;
                    String _plus_5 = _plus_4 + ">(java.util.Arrays.<Double>asList(";
                    String _join = IterableExtensions.join(((FloatMember)m).getDefaultValues().getItems(), (CharSequence)", ");
                    String _plus_6 = _plus_5 + _join;
                    return _plus_6 + "))";
                }
            }
            String _box_2 = this.box(javaType);
            String _plus_7 = "new java.util.ArrayList<" + _box_2;
            return _plus_7 + ">()";
        }
        if (m instanceof IntegerMember) {
            long _defaultValue_1 = ((IntegerMember)m).getDefaultValue();
            return String.valueOf((Object)_defaultValue_1);
        }
        if (m instanceof FloatMember) {
            float _defaultValue_2 = ((FloatMember)m).getDefaultValue();
            return String.valueOf(Float.valueOf(_defaultValue_2)) + "f";
        }
        boolean _isBooleanType = this.isBooleanType(m);
        if (_isBooleanType) {
            return "false";
        }
        if (m instanceof ComplexTypeMember && (_type = ((ComplexTypeMember)m).getType()) instanceof EnumDeclaration) {
            boolean _tripleEquals_1;
            Item _defaultValue_3 = ((ComplexTypeMember)m).getDefaultValue();
            boolean bl = _tripleEquals_1 = _defaultValue_3 == null;
            if (_tripleEquals_1) {
                return "null";
            }
            String _attributeJavaType = this.attributeJavaType(m);
            String _plus_8 = _attributeJavaType + ".";
            String _name = ((ComplexTypeMember)m).getDefaultValue().getName();
            return _plus_8 + _name;
        }
        String _attributeJavaType_1 = this.attributeJavaType(m);
        String _plus_9 = "new " + _attributeJavaType_1;
        return _plus_9 + "()";
    }

    public String attributeJavaType(Member m) {
        String nativeType = this.nativeTypeName(m);
        String javaType = this.native2JavaType(nativeType);
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            if (m instanceof IntegerMember && (((IntegerMember)m).getTypename().equals("uint8_t") || ((IntegerMember)m).getTypename().equals("int8_t"))) {
                return "java.nio.ByteBuffer";
            }
            if (m instanceof StringMember) {
                return javaType;
            }
            String _box = this.box(javaType);
            String _plus = "java.util.ArrayList<" + _box;
            return _plus + ">";
        }
        return javaType;
    }

    public boolean doesAttributeJavaTypeMapToByteBuffer(Member m) {
        boolean _not;
        boolean _isArray = this.isArray(m);
        boolean bl = _not = !_isArray;
        if (_not) {
            return false;
        }
        return m instanceof IntegerMember && (((IntegerMember)m).getTypename().equals("uint8_t") || ((IntegerMember)m).getTypename().equals("int8_t"));
    }

    public String attributeJavaType(BitfieldEntry m) {
        return this.native2JavaType(this.nativeTypeName(m));
    }

    public String box(String type) {
        String _switchResult;
        block27: {
            block25: {
                _switchResult = null;
                if (type == null) break block25;
                switch (type) {
                    case "byte": {
                        _switchResult = "Byte";
                        break;
                    }
                    case "short": {
                        _switchResult = "Short";
                        break;
                    }
                    case "int": {
                        _switchResult = "Integer";
                        break;
                    }
                    case "long": {
                        _switchResult = "Long";
                        break;
                    }
                    case "float": {
                        _switchResult = "Float";
                        break;
                    }
                    case "double": {
                        _switchResult = "Double";
                        break;
                    }
                    case "boolean": {
                        _switchResult = "Boolean";
                        break;
                    }
                    default: {
                        _switchResult = type;
                        break;
                    }
                }
                break block27;
            }
            _switchResult = type;
        }
        return _switchResult;
    }

    public String unbox(String type) {
        String _switchResult;
        block21: {
            block19: {
                _switchResult = null;
                if (type == null) break block19;
                switch (type) {
                    case "Short": {
                        _switchResult = "short";
                        break;
                    }
                    case "Int": {
                        _switchResult = "int";
                        break;
                    }
                    case "Long": {
                        _switchResult = "long";
                        break;
                    }
                    case "Float": {
                        _switchResult = "float";
                        break;
                    }
                    case "Double": {
                        _switchResult = "double";
                        break;
                    }
                    default: {
                        _switchResult = type;
                        break;
                    }
                }
                break block21;
            }
            _switchResult = type;
        }
        return _switchResult;
    }

    public String nativeTypeName(Member m) {
        String _switchResult = null;
        boolean _matched = false;
        if (m instanceof ComplexTypeMember) {
            _matched = true;
            _switchResult = this.javaType(((ComplexTypeMember)m).getType());
        }
        if (!_matched && m instanceof IntegerMember) {
            _matched = true;
            _switchResult = ((IntegerMember)m).getTypename();
        }
        if (!_matched && m instanceof FloatMember) {
            _matched = true;
            _switchResult = ((FloatMember)m).getTypename();
        }
        if (!_matched && m instanceof StringMember) {
            _matched = true;
            _switchResult = ((StringMember)m).getTypename();
        }
        if (!_matched && m instanceof BitfieldMember) {
            _matched = true;
            _switchResult = ((BitfieldMember)m).getTypename();
        }
        if (!_matched) {
            throw new RuntimeException("Unsupported member type: " + String.valueOf(m));
        }
        return _switchResult;
    }

    public String nativeTypeName(BitfieldEntry m) {
        boolean _tripleNotEquals;
        EnumDeclaration _type = m.getType();
        boolean bl = _tripleNotEquals = _type != null;
        if (_tripleNotEquals) {
            return this.javaType(m.getType());
        }
        return m.getTypename();
    }

    public String native2JavaType(String type) {
        String _switchResult;
        block42: {
            block40: {
                _switchResult = null;
                if (type == null) break block40;
                switch (type) {
                    case "uint8_t": {
                        _switchResult = "long";
                        break;
                    }
                    case "int8_t": {
                        _switchResult = "long";
                        break;
                    }
                    case "uint16_t": {
                        _switchResult = "long";
                        break;
                    }
                    case "int16_t": {
                        _switchResult = "long";
                        break;
                    }
                    case "int32_t": {
                        _switchResult = "long";
                        break;
                    }
                    case "uint32_t": {
                        _switchResult = "long";
                        break;
                    }
                    case "int64_t": {
                        _switchResult = "long";
                        break;
                    }
                    case "uint64_t": {
                        _switchResult = "long";
                        break;
                    }
                    case "char": {
                        _switchResult = "String";
                        break;
                    }
                    case "bool": {
                        _switchResult = "boolean";
                        break;
                    }
                    case "float": {
                        _switchResult = "double";
                        break;
                    }
                    case "double": {
                        _switchResult = "double";
                        break;
                    }
                    default: {
                        _switchResult = type;
                        break;
                    }
                }
                break block42;
            }
            _switchResult = type;
        }
        return _switchResult;
    }

    public String javaType(ComplexTypeDeclaration type) {
        EObject _eContainer = type.eContainer();
        StructsFile pkg = (StructsFile)_eContainer;
        if (pkg != null && !pkg.getName().isEmpty()) {
            String _name = pkg.getName();
            String _plus = _name + ".";
            String _name_1 = type.getName();
            return _plus + _name_1;
        }
        return type.getName();
    }

    public boolean isFixedSize(StructDeclaration struct) {
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            boolean _isSizeofThis;
            boolean _not;
            boolean _isFixedSize = this.isFixedSize(m);
            boolean bl = _not = !_isFixedSize;
            if (_not) {
                return false;
            }
            if (!(m instanceof IntegerMember) || !(_isSizeofThis = ((IntegerMember)m).isSizeofThis())) continue;
            return false;
        }
        return true;
    }

    public boolean isFixedSize(ComplexTypeDeclaration typeDecl) {
        if (typeDecl instanceof StructDeclaration) {
            return this.isFixedSize((StructDeclaration)typeDecl);
        }
        return true;
    }

    public boolean isFixedSize(Member m) {
        boolean _isArray = this.isArray(m);
        if (_isArray) {
            boolean _equals;
            long _dimension = m.getArray().getDimension();
            boolean bl = _equals = _dimension == 0L;
            if (_equals) {
                return false;
            }
        }
        if (m instanceof ComplexTypeMember) {
            return this.isFixedSize(((ComplexTypeMember)m).getType());
        }
        return true;
    }

    public long computeFixedSizeOf(StructDeclaration struct) {
        long size = 0L;
        EList<Member> _members = struct.getMembers();
        for (Member m : _members) {
            boolean _isArray = this.isArray(m);
            if (_isArray) {
                long _size = size;
                long _computeFixedSizeOf = this.computeFixedSizeOf(m);
                int _dimensionOf = this.dimensionOf(m);
                long _multiply = _computeFixedSizeOf * (long)_dimensionOf;
                size = _size + _multiply;
                continue;
            }
            long _size_1 = size;
            long _computeFixedSizeOf_1 = this.computeFixedSizeOf(m);
            size = _size_1 + _computeFixedSizeOf_1;
        }
        return size;
    }

    public long computeFixedSizeOf(Member m) {
        String _typename;
        boolean _equals;
        boolean _matched = false;
        if (m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "uint8_t"))) {
            _matched = true;
            return 1L;
        }
        if (!_matched && m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "int8_t"))) {
            _matched = true;
            return 1L;
        }
        if (!_matched && m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "uint16_t"))) {
            _matched = true;
            return 2L;
        }
        if (!_matched && m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "int16_t"))) {
            _matched = true;
            return 2L;
        }
        if (!_matched && m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "uint32_t"))) {
            _matched = true;
            return 4L;
        }
        if (!_matched && m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "int32_t"))) {
            _matched = true;
            return 4L;
        }
        if (!_matched && m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "uint64_t"))) {
            _matched = true;
            return 8L;
        }
        if (!_matched && m instanceof IntegerMember && (_equals = Objects.equals(_typename = ((IntegerMember)m).getTypename(), "int64_t"))) {
            _matched = true;
            return 8L;
        }
        if (!_matched && m instanceof BitfieldMember && (_equals = Objects.equals(_typename = ((BitfieldMember)m).getTypename(), "uint8_t"))) {
            _matched = true;
            return 1L;
        }
        if (!_matched && m instanceof BitfieldMember && (_equals = Objects.equals(_typename = ((BitfieldMember)m).getTypename(), "int8_t"))) {
            _matched = true;
            return 1L;
        }
        if (!_matched && m instanceof BitfieldMember && (_equals = Objects.equals(_typename = ((BitfieldMember)m).getTypename(), "uint16_t"))) {
            _matched = true;
            return 2L;
        }
        if (!_matched && m instanceof BitfieldMember && (_equals = Objects.equals(_typename = ((BitfieldMember)m).getTypename(), "int16_t"))) {
            _matched = true;
            return 2L;
        }
        if (!_matched && m instanceof BitfieldMember && (_equals = Objects.equals(_typename = ((BitfieldMember)m).getTypename(), "uint32_t"))) {
            _matched = true;
            return 4L;
        }
        if (!_matched && m instanceof BitfieldMember && (_equals = Objects.equals(_typename = ((BitfieldMember)m).getTypename(), "int32_t"))) {
            _matched = true;
            return 4L;
        }
        if (!_matched && m instanceof BitfieldMember && (_equals = Objects.equals(_typename = ((BitfieldMember)m).getTypename(), "uint64_t"))) {
            _matched = true;
            return 8L;
        }
        if (!_matched && m instanceof BitfieldMember && (_equals = Objects.equals(_typename = ((BitfieldMember)m).getTypename(), "int64_t"))) {
            _matched = true;
            return 8L;
        }
        if (!_matched && m instanceof FloatMember && (_equals = Objects.equals(_typename = ((FloatMember)m).getTypename(), "float"))) {
            _matched = true;
            return 4L;
        }
        if (!_matched && m instanceof FloatMember && (_equals = Objects.equals(_typename = ((FloatMember)m).getTypename(), "double"))) {
            _matched = true;
            return 8L;
        }
        if (!_matched && m instanceof StringMember) {
            _matched = true;
            return 1L;
        }
        if (!_matched && m instanceof ComplexTypeMember) {
            _matched = true;
            return this.computeFixedSizeOf(((ComplexTypeMember)m).getType());
        }
        throw new RuntimeException("Unexpected member type: " + String.valueOf(m));
    }

    public long computeFixedSizeOf(ComplexTypeDeclaration typeDecl) {
        if (typeDecl instanceof StructDeclaration) {
            return this.computeFixedSizeOf((StructDeclaration)typeDecl);
        }
        return this.computeFixedSizeOf((EnumDeclaration)typeDecl);
    }

    public long computeFixedSizeOf(EnumDeclaration enumDecl) {
        block22: {
            String _typename = enumDecl.getTypename();
            if (_typename == null) break block22;
            switch (_typename) {
                case "int8_t": {
                    return 1L;
                }
                case "uint8_t": {
                    return 1L;
                }
                case "int16_t": {
                    return 2L;
                }
                case "uint16_t": {
                    return 2L;
                }
                case "int32_t": {
                    return 4L;
                }
                case "uint32_t": {
                    return 4L;
                }
            }
            return 0L;
        }
        return 0L;
    }
}

