/*
 * Decompiled with CFR 0.152.
 */
package org.structs4java.generator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.structs4java.structs4JavaDsl.EnumDeclaration;
import org.structs4java.structs4JavaDsl.Item;
import org.structs4java.structs4JavaDsl.StructsFile;

public class EnumGenerator {
    public CharSequence compile(StructsFile structsFile, EnumDeclaration enumDecl) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageDeclaration = this.packageDeclaration(structsFile);
        _builder.append((Object)_packageDeclaration);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _printComments = this.printComments(enumDecl);
        _builder.append((Object)_printComments);
        _builder.newLineIfNotEmpty();
        _builder.append("public enum ");
        String _name = enumDecl.getName();
        _builder.append(_name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _items = this.items(enumDecl);
        _builder.append((Object)_items, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _reader = this.reader(enumDecl);
        _builder.append((Object)_reader, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _writer = this.writer(enumDecl);
        _builder.append((Object)_writer, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public long getValue() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return value;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private ");
        String _name_1 = enumDecl.getName();
        _builder.append(_name_1, "\t");
        _builder.append("(long value) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("this.value = value;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private long value;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence printComments(EnumDeclaration typeDecl) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        EList<String> _comments = typeDecl.getComments();
        for (String comment : _comments) {
            _builder.append("* ");
            String _trim = comment.substring(2).trim();
            _builder.append(_trim);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("*/");
        _builder.newLine();
        return _builder;
    }

    public CharSequence printComments(Item item) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        EList<String> _comments = item.getComments();
        for (String comment : _comments) {
            _builder.append("* ");
            String _trim = comment.substring(2).trim();
            _builder.append(_trim);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("*/");
        _builder.newLine();
        return _builder;
    }

    public CharSequence items(EnumDeclaration enumDecl) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Item> _items = enumDecl.getItems();
        boolean _hasElements = false;
        for (Item i : _items) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            CharSequence _printComments = this.printComments(i);
            _builder.append((Object)_printComments);
            _builder.newLineIfNotEmpty();
            String _name = i.getName();
            _builder.append(_name);
            _builder.append("(");
            long _value = i.getValue();
            _builder.append((Object)_value);
            _builder.append("L)");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append(";");
        }
        return _builder;
    }

    public CharSequence reader(EnumDeclaration enumDecl) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public static ");
        String _name = enumDecl.getName();
        _builder.append(_name);
        _builder.append(" read(java.nio.ByteBuffer buf, boolean partialRead) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return read(buf);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public static ");
        String _name_1 = enumDecl.getName();
        _builder.append(_name_1);
        _builder.append(" read(java.nio.ByteBuffer buf) throws java.io.IOException {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _read = this.read(enumDecl);
        _builder.append((Object)_read, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return fromValue(value);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch(IllegalArgumentException e) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("throw new java.io.IOException(e);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public static ");
        String _name_2 = enumDecl.getName();
        _builder.append(_name_2);
        _builder.append(" fromValue(long value) throws IllegalArgumentException {");
        _builder.newLineIfNotEmpty();
        EList<Item> _items = enumDecl.getItems();
        for (Item f : _items) {
            _builder.append("\t");
            _builder.append("if(value == ");
            long _value = f.getValue();
            _builder.append((Object)_value, "\t");
            _builder.append("L) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            String _name_3 = f.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("throw new IllegalArgumentException(String.format(\"Unknown enum value: 0x%X\", value));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence read(EnumDeclaration enumDecl) {
        StringConcatenation _switchResult;
        block28: {
            _switchResult = null;
            String _typename = enumDecl.getTypename();
            if (_typename == null) break block28;
            switch (_typename) {
                case "int8_t": {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("long value = buf.get();");
                    _switchResult = _builder;
                    break;
                }
                case "uint8_t": {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("long value = buf.get() & 0xFFL;");
                    _switchResult = _builder_1;
                    break;
                }
                case "int16_t": {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("long value = buf.getShort();");
                    _switchResult = _builder_2;
                    break;
                }
                case "uint16_t": {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("long value = buf.getShort() & 0xFFFFL;");
                    _switchResult = _builder_3;
                    break;
                }
                case "int32_t": {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("long value = buf.getInt();");
                    _switchResult = _builder_4;
                    break;
                }
                case "uint32_t": {
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append("long value = buf.getInt() & 0xFFFFFFFFL;");
                    _switchResult = _builder_5;
                    break;
                }
                case "int64_t": {
                    StringConcatenation _builder_6 = new StringConcatenation();
                    _builder_6.append("long value = buf.getLong();");
                    _switchResult = _builder_6;
                    break;
                }
                case "uint64_t": {
                    StringConcatenation _builder_7 = new StringConcatenation();
                    _builder_7.append("long value = buf.getLong();");
                    _switchResult = _builder_7;
                }
            }
        }
        return _switchResult;
    }

    public CharSequence writer(EnumDeclaration enumDecl) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public void write(java.nio.ByteBuffer buf) throws java.io.IOException {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _write = this.write(enumDecl);
        _builder.append((Object)_write, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence write(EnumDeclaration enumDecl) {
        StringConcatenation _switchResult;
        block28: {
            _switchResult = null;
            String _typename = enumDecl.getTypename();
            if (_typename == null) break block28;
            switch (_typename) {
                case "int8_t": {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("buf.put((byte)(this.value));");
                    _switchResult = _builder;
                    break;
                }
                case "uint8_t": {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("buf.put((byte)(this.value & 0xFFL));");
                    _switchResult = _builder_1;
                    break;
                }
                case "int16_t": {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("buf.putShort((short)(this.value));");
                    _switchResult = _builder_2;
                    break;
                }
                case "uint16_t": {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("buf.putShort((short)(this.value & 0xFFFFL));");
                    _switchResult = _builder_3;
                    break;
                }
                case "int32_t": {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("buf.putInt((int)(this.value));");
                    _switchResult = _builder_4;
                    break;
                }
                case "uint32_t": {
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append("buf.putInt((int)(this.value & 0xFFFFFFFFL));");
                    _switchResult = _builder_5;
                    break;
                }
                case "int64_t": {
                    StringConcatenation _builder_6 = new StringConcatenation();
                    _builder_6.append("buf.putLong(this.value);");
                    _switchResult = _builder_6;
                    break;
                }
                case "uint64_t": {
                    StringConcatenation _builder_7 = new StringConcatenation();
                    _builder_7.append("buf.putLong(this.value);");
                    _switchResult = _builder_7;
                }
            }
        }
        return _switchResult;
    }

    public CharSequence packageDeclaration(StructsFile structsFile) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = structsFile.getName().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("package ");
            String _name = structsFile.getName();
            _builder.append(_name);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }
}

