/*
 * Decompiled with CFR 0.152.
 */
package org.structs4java.formatting2;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.structs4java.structs4JavaDsl.EnumDeclaration;
import org.structs4java.structs4JavaDsl.Import;
import org.structs4java.structs4JavaDsl.Item;
import org.structs4java.structs4JavaDsl.Member;
import org.structs4java.structs4JavaDsl.StructDeclaration;
import org.structs4java.structs4JavaDsl.Structs4JavaDslPackage;
import org.structs4java.structs4JavaDsl.StructsFile;

public class Structs4JavaDslFormatter
extends AbstractFormatter2 {
    protected void _format(StructsFile structsFile, @Extension IFormattableDocument document) {
        EList<Import> _imports = structsFile.getImports();
        for (Import imports : _imports) {
            document.format((Object)imports);
        }
        EList<StructDeclaration> _structs = structsFile.getStructs();
        for (StructDeclaration structs : _structs) {
            document.format((Object)structs);
        }
        EList<EnumDeclaration> _enums = structsFile.getEnums();
        for (EnumDeclaration enums : _enums) {
            document.format((Object)enums);
        }
        Procedures.Procedure1 _function = it -> it.setNewLines(2);
        document.append(this.textRegionExtensions.regionFor((EObject)structsFile).keyword(";"), _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)structsFile).keyword(";"), _function_1);
    }

    protected void _format(StructDeclaration structDeclaration, @Extension IFormattableDocument document) {
        ISemanticRegion open = this.textRegionExtensions.regionFor((EObject)structDeclaration).keyword("{");
        ISemanticRegion close = this.textRegionExtensions.regionFor((EObject)structDeclaration).keyword("}");
        Procedures.Procedure1 _function = it -> it.newLine();
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append(document.prepend(open, _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.setNewLines(2);
        document.append(close, _function_2);
        Procedures.Procedure1 _function_3 = it -> it.indent();
        document.interior(open, close, _function_3);
        EList<Member> _members = structDeclaration.getMembers();
        for (Member members : _members) {
            document.format((Object)members);
        }
    }

    protected void _format(Import imp, @Extension IFormattableDocument document) {
        EObject _eContainer = imp.eContainer();
        Import _lastOrNull = (Import)IterableExtensions.lastOrNull(((StructsFile)_eContainer).getImports());
        boolean _equals = Objects.equals(_lastOrNull, imp);
        if (_equals) {
            Procedures.Procedure1 _function = it -> it.noSpace();
            Procedures.Procedure1 _function_1 = it -> it.setNewLines(2);
            document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)imp).keyword(";"), _function), _function_1);
        } else {
            Procedures.Procedure1 _function_2 = it -> it.noSpace();
            Procedures.Procedure1 _function_3 = it -> it.newLine();
            document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)imp).keyword(";"), _function_2), _function_3);
        }
    }

    protected void _format(Member member, @Extension IFormattableDocument document) {
        EObject _nextSibling = EcoreUtil2.getNextSibling((EObject)member);
        Member nextMember = (Member)_nextSibling;
        if (nextMember != null && nextMember.getComments().size() > 0) {
            Procedures.Procedure1 _function = it -> it.noSpace();
            Procedures.Procedure1 _function_1 = it -> it.setNewLines(2);
            document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)member).keyword(";"), _function), _function_1);
        } else {
            Procedures.Procedure1 _function_2 = it -> it.noSpace();
            Procedures.Procedure1 _function_3 = it -> it.newLine();
            document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)member).keyword(";"), _function_2), _function_3);
        }
        List comments = this.textRegionExtensions.regionFor((EObject)member).features(new EStructuralFeature[]{Structs4JavaDslPackage.Literals.MEMBER__COMMENTS});
        Consumer<ISemanticRegion> _function_4 = it -> {
            Procedures.Procedure1 _function_5 = it_1 -> it_1.newLine();
            document.append(it, _function_5);
        };
        comments.forEach(_function_4);
    }

    protected void _format(EnumDeclaration _enum, @Extension IFormattableDocument document) {
        ISemanticRegion open = this.textRegionExtensions.regionFor((EObject)_enum).keyword("{");
        ISemanticRegion close = this.textRegionExtensions.regionFor((EObject)_enum).keyword("}");
        Procedures.Procedure1 _function = it -> it.newLine();
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append(document.prepend(open, _function), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.newLine();
        Procedures.Procedure1 _function_3 = it -> it.setNewLines(2);
        document.append(document.prepend(close, _function_2), _function_3);
        Procedures.Procedure1 _function_4 = it -> it.indent();
        document.interior(open, close, _function_4);
        Procedures.Procedure1 _function_5 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)_enum).keyword(":"), _function_5);
        EList<Item> _items = _enum.getItems();
        for (Item itm : _items) {
            document.format((Object)itm);
        }
    }

    protected void _format(Item item, @Extension IFormattableDocument document) {
        EObject _nextSibling;
        Item nextItem;
        ISemanticRegion region = this.textRegionExtensions.regionFor((EObject)item).keyword(",");
        if (region != null) {
            Procedures.Procedure1 _function = it -> it.noSpace();
            document.prepend(region, _function);
        }
        if (region == null) {
            region = this.textRegionExtensions.regionFor((EObject)item).feature((EStructuralFeature)Structs4JavaDslPackage.Literals.ITEM__VALUE);
        }
        if ((nextItem = (Item)(_nextSibling = EcoreUtil2.getNextSibling((EObject)item))) != null && nextItem.getComments().size() > 0) {
            Procedures.Procedure1 _function_1 = it -> it.noSpace();
            Procedures.Procedure1 _function_2 = it -> it.setNewLines(2);
            document.append(document.prepend(region, _function_1), _function_2);
        } else {
            Procedures.Procedure1 _function_3 = it -> it.newLine();
            document.append(region, _function_3);
        }
        Procedures.Procedure1 _function_4 = it -> it.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)item).keyword("="), _function_4);
        List comments = this.textRegionExtensions.regionFor((EObject)item).features(new EStructuralFeature[]{Structs4JavaDslPackage.Literals.ITEM__COMMENTS});
        Consumer<ISemanticRegion> _function_5 = it -> {
            Procedures.Procedure1 _function_6 = it_1 -> it_1.newLine();
            document.append(it, _function_6);
        };
        comments.forEach(_function_5);
    }

    @XbaseGenerated
    public void format(Object _enum, IFormattableDocument document) {
        if (_enum instanceof XtextResource) {
            this._format((XtextResource)_enum, document);
            return;
        }
        if (_enum instanceof EnumDeclaration) {
            this._format((EnumDeclaration)_enum, document);
            return;
        }
        if (_enum instanceof StructDeclaration) {
            this._format((StructDeclaration)_enum, document);
            return;
        }
        if (_enum instanceof Import) {
            this._format((Import)_enum, document);
            return;
        }
        if (_enum instanceof Item) {
            this._format((Item)_enum, document);
            return;
        }
        if (_enum instanceof Member) {
            this._format((Member)_enum, document);
            return;
        }
        if (_enum instanceof StructsFile) {
            this._format((StructsFile)_enum, document);
            return;
        }
        if (_enum instanceof EObject) {
            this._format((EObject)_enum, document);
            return;
        }
        if (_enum == null) {
            this._format(null, document);
            return;
        }
        if (_enum != null) {
            this._format(_enum, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(_enum, document).toString());
    }
}

