/*
 * Decompiled with CFR 0.152.
 */
package com.github.manikmagar.maven.versioner.core.version;

import java.util.Objects;

public class Version {
    private final int major;
    private final int minor;
    private final int patch;
    private int commit;
    private final String branch;
    private final String hash;

    public Version(String branch, String hash) {
        this(branch, hash, 0, 0, 0);
        this.commit = 0;
    }

    public Version(String branch, String hash, int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.branch = branch;
        this.hash = hash;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getCommit() {
        return this.commit;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.getMajor() == version.getMajor() && this.getMinor() == version.getMinor() && this.getPatch() == version.getPatch();
    }

    public int hashCode() {
        return Objects.hash(this.getMajor(), this.getMinor(), this.getPatch());
    }
}

