/*
 * Decompiled with CFR 0.152.
 */
package com.github.manikmagar.maven.versioner.core.git;

import com.github.manikmagar.maven.versioner.core.git.JGit;
import com.github.manikmagar.maven.versioner.core.params.VersionConfig;
import com.github.manikmagar.maven.versioner.core.version.SemVerStrategy;
import com.github.manikmagar.maven.versioner.core.version.VersionComponentType;
import com.github.manikmagar.maven.versioner.core.version.VersionStrategy;
import com.github.manikmagar.maven.versioner.core.version.Versioner;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;

public class JGitVersioner
implements Versioner {
    VersionConfig versionConfig;

    public JGitVersioner(VersionConfig versionConfig) {
        this.versionConfig = versionConfig;
    }

    @Override
    public VersionStrategy version() {
        return JGit.executeOperation(git -> {
            String branch = git.getRepository().getBranch();
            Ref head = git.getRepository().findRef("HEAD");
            String hash = "";
            if (head != null && head.getObjectId() != null) {
                hash = head.getObjectId().getName();
            }
            SemVerStrategy versionStrategy = new SemVerStrategy(this.versionConfig.getInitial().getMajor(), this.versionConfig.getInitial().getMinor(), this.versionConfig.getInitial().getPatch(), branch, hash);
            Iterable commits = git.log().call();
            List revCommits = StreamSupport.stream(commits.spliterator(), false).collect(Collectors.toList());
            Collections.reverse(revCommits);
            for (RevCommit commit : revCommits) {
                if (commit.getFullMessage().contains(this.versionConfig.getKeywords().getMajorKey())) {
                    versionStrategy.increment(VersionComponentType.MAJOR, hash);
                    continue;
                }
                if (commit.getFullMessage().contains(this.versionConfig.getKeywords().getMinorKey())) {
                    versionStrategy.increment(VersionComponentType.MINOR, hash);
                    continue;
                }
                if (commit.getFullMessage().contains(this.versionConfig.getKeywords().getPatchKey())) {
                    versionStrategy.increment(VersionComponentType.PATCH, hash);
                    continue;
                }
                versionStrategy.increment(VersionComponentType.COMMIT, hash);
            }
            return versionStrategy;
        });
    }
}

