/*
 * Decompiled with CFR 0.152.
 */
package javapersianutils.core.validators;

import java.util.regex.Pattern;
import javapersianutils.core.validators.StringUtil;

public class RegexUtils {
    private static final Pattern _matchAllTags = Pattern.compile("<(.|\n)*?>", 2);
    private static final Pattern _matchArabicHebrew = Pattern.compile("[\u0622-\u0669,\u0600-\u06ff,\u0590-\u05ff,\u00ab,\u00bb]", 2);
    private static final Pattern _matchOnlyPersianNumbersRange = Pattern.compile("^[\u06f0-\u06f9]+$", 2);
    private static final Pattern _matchOnlyPersianLetters = Pattern.compile("^[\\s,\u06a9\u06af\u06c0\u06cc\u060c,\u062a\u062b\u062c\u062d\u062e\u062f,\u063a\u064a\u064b\u064c\u064d\u064e,\u064f\u067e\u0670\u0686\u0698\u200c,\u0621-\u0629\u0630-\u0639\u0641-\u0654]+$", 2);

    private RegexUtils() {
    }

    public static boolean containsFarsi(String text) {
        return !StringUtil.isNullOrEmpty(text) && _matchArabicHebrew.matcher(RegexUtils.stripHtmlTags(text).replace(",", "")).find();
    }

    public static boolean containsOnlyFarsiLetters(String text) {
        return !StringUtil.isNullOrEmpty(text) && _matchOnlyPersianLetters.matcher(RegexUtils.stripHtmlTags(text).replace(",", "")).matches();
    }

    public static String stripHtmlTags(String text) {
        return StringUtil.isNullOrEmpty(text) ? "" : _matchAllTags.matcher(text).replaceAll(" ").replace("&nbsp;", " ");
    }

    public static String wrapInDirectionalDiv(String body) {
        return RegexUtils.wrapInDirectionalDiv(body, "tahoma", "9pt");
    }

    public static String wrapInDirectionalDiv(String body, String fontFamily, String fontSize) {
        if (StringUtil.isNullOrWhiteSpace(body)) {
            return "";
        }
        if (RegexUtils.containsFarsi(body)) {
            return "<div style='text-align: right; font-family:{fontFamily}; font-size:{fontSize};' dir='rtl'>{body}</div>";
        }
        return "<div style='text-align: left; font-family:{fontFamily}; font-size:{fontSize};' dir='ltr'>{body}</div>";
    }

    public static boolean containsOnlyPersianNumbers(String text) {
        return !StringUtil.isNullOrEmpty(text) && _matchOnlyPersianNumbersRange.matcher(RegexUtils.stripHtmlTags(text)).matches();
    }
}

