/*
 * Decompiled with CFR 0.152.
 */
package javapersianutils.core.validators;

import javapersianutils.core.validators.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class NationalCodeUtils {
    private NationalCodeUtils() {
    }

    public static boolean isNumber(String data) {
        return !StringUtil.isNullOrWhiteSpace(data) && StringUtils.isNumeric((CharSequence)data);
    }

    public static boolean isValidIranianNationalCode(String nationalCode) {
        if (StringUtil.isNullOrWhiteSpace(nationalCode)) {
            return false;
        }
        nationalCode = StringUtils.leftPad((String)nationalCode, (int)10, (char)'0');
        int nationalCodeLength = 10;
        if (nationalCode.length() != 10) {
            return false;
        }
        if (!NationalCodeUtils.isNumber(nationalCode)) {
            return false;
        }
        int j = 10;
        int sum = 0;
        for (int i = 0; i < nationalCode.length() - 1; ++i) {
            sum += Character.getNumericValue(nationalCode.charAt(i)) * j--;
        }
        int remainder = sum % 11;
        int controlNumber = Character.getNumericValue(nationalCode.charAt(9));
        return remainder < 2 && controlNumber == remainder || remainder >= 2 && controlNumber == 11 - remainder;
    }
}

