/*
 * Decompiled with CFR 0.152.
 */
package javapersianutils.core.validators;

import java.util.regex.Pattern;
import javapersianutils.core.validators.StringUtil;

public class IranShetabUtils {
    private static final Pattern _matchIranShetab = Pattern.compile("[0-9]{16}", 2);

    private IranShetabUtils() {
    }

    public static boolean isValidIranShetabNumber(String creditCardNumber) {
        if (StringUtil.isNullOrEmpty(creditCardNumber)) {
            return false;
        }
        if ((creditCardNumber = creditCardNumber.replace("-", "").replace(" ", "")).length() != 16) {
            return false;
        }
        if (!_matchIranShetab.matcher(creditCardNumber).matches()) {
            return false;
        }
        int sumOfDigits = 0;
        int result = 0;
        for (int i = 1; i <= creditCardNumber.length(); ++i) {
            int number = Integer.parseInt(creditCardNumber.charAt(i - 1) + "");
            result = number * (i % 2 == 0 ? 1 : 2);
            sumOfDigits += result > 9 ? result - 9 : result;
        }
        return sumOfDigits % 10 == 0;
    }
}

