/*
 * Decompiled with CFR 0.152.
 */
package javapersianutils.core.validators;

import java.util.regex.Pattern;
import javapersianutils.core.validators.StringUtil;

public class IranShebaUtils {
    private static final Pattern _matchIranSheba = Pattern.compile("IR[0-9]{24}", 2);

    private IranShebaUtils() {
    }

    public static boolean isValidIranShebaNumber(String iban) {
        if (StringUtil.isNullOrEmpty(iban)) {
            return false;
        }
        if (iban.length() < 4 || iban.charAt(0) == ' ' || iban.charAt(1) == ' ' || iban.charAt(2) == ' ' || iban.charAt(3) == ' ') {
            return false;
        }
        if (iban.length() != 26) {
            return false;
        }
        if (!_matchIranSheba.matcher(iban).matches()) {
            return false;
        }
        int checksum = 0;
        int ibanLength = iban.length();
        for (int charIndex = 0; charIndex < ibanLength; ++charIndex) {
            int value;
            if (iban.charAt(charIndex) == ' ') continue;
            char c = iban.charAt((charIndex + 4) % ibanLength);
            if (c >= '0' && c <= '9') {
                value = c - 48;
            } else if (c >= 'A' && c <= 'Z') {
                value = c - 65;
                checksum = (checksum * 10 + (value / 10 + 1)) % 97;
                value %= 10;
            } else if (c >= 'a' && c <= 'z') {
                value = c - 97;
                checksum = (checksum * 10 + (value / 10 + 1)) % 97;
                value %= 10;
            } else {
                return false;
            }
            checksum = (checksum * 10 + value) % 97;
        }
        return checksum == 1;
    }
}

