/*
 * Decompiled with CFR 0.152.
 */
package javapersianutils.core.validators;

import java.util.regex.Pattern;
import javapersianutils.core.validators.StringUtil;

public class IranCodesUtils {
    private static final Pattern _matchIranianMobileNumber1 = Pattern.compile("^(((98)|(\\+98)|(0098)|0)(9){1}[0-9]{9})+$", 2);
    private static final Pattern _matchIranianMobileNumber2 = Pattern.compile("^(9){1}[0-9]{9}$", 2);
    private static final Pattern _matchIranianPhoneNumber = Pattern.compile("^[2-9][0-9]{7}$", 2);
    private static final Pattern _matchIranianPostalCode = Pattern.compile("^(\\d{5}-?\\d{5})$", 2);

    private IranCodesUtils() {
    }

    public static boolean isValidIranianMobileNumber(String mobileNumber) {
        return !StringUtil.isNullOrWhiteSpace(mobileNumber) && (_matchIranianMobileNumber1.matcher(mobileNumber).matches() || _matchIranianMobileNumber2.matcher(mobileNumber).matches());
    }

    public static boolean isValidIranianPhoneNumber(String phoneNumber) {
        return !StringUtil.isNullOrWhiteSpace(phoneNumber) && _matchIranianPhoneNumber.matcher(phoneNumber).matches();
    }

    public static boolean isValidIranianPostalCode(String postalCode) {
        return !StringUtil.isNullOrWhiteSpace(postalCode) && _matchIranianPostalCode.matcher(postalCode).matches();
    }
}

