/*
 * Decompiled with CFR 0.152.
 */
package javapersianutils.core.normalizer;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javapersianutils.core.validators.StringUtil;
import org.apache.commons.lang3.StringEscapeUtils;

public class AggressiveEditing {
    private static final Pattern _matchCleanupExtraMarks1 = Pattern.compile("(!){2,}", 2);
    private static final Pattern _matchCleanupExtraMarks2 = Pattern.compile("(\u061f){2,}", 2);
    private static final Pattern _matchCleanupSpacingAndLineBreaks1 = Pattern.compile("[ ]+", 2);
    private static final Pattern _matchCleanupSpacingAndLineBreaks2 = Pattern.compile("([\n]+)[   \u200c]*", 2);
    private static final Pattern _matchRemoveAllKashida = Pattern.compile("\u0640+", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing1 = Pattern.compile("[   \u200c]*(\\()\\s*([^)]+?)\\s*?(\\))[   \u200c]*", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing10 = Pattern.compile("(\\{)\\s*([^)]+?)\\s*?(\\})", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing11 = Pattern.compile("(\u201c)\\s*([^)]+?)\\s*?(\u201d)", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing12 = Pattern.compile("(\u00ab)\\s*([^)]+?)\\s*?(\u00bb)", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing2 = Pattern.compile("[   \u200c]*(\\[)\\s*([^)]+?)\\s*?(\\])[   \u200c]*", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing3 = Pattern.compile("[   \u200c]*(\\{)\\s*([^)]+?)\\s*?(\\})[   \u200c]*", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing4 = Pattern.compile("[   \u200c]*(\u201c)\\s*([^)]+?)\\s*?(\u201d)[   \u200c]*", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing5 = Pattern.compile("[   \u200c]*(\u00ab)\\s*([^)]+?)\\s*?(\u00bb)[   \u200c]*", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing6 = Pattern.compile("[ ?  ]*([:;,??.?!]{1})[ ?  ]*", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing7 = Pattern.compile("([0-9]+):\\s+([0-9]+)", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing8 = Pattern.compile("(\\()\\s*([^)]+?)\\s*?(\\))", 2);
    private static final Pattern _matchRemoveOutsideInsideSpacing9 = Pattern.compile("(\\[)\\s*([^)]+?)\\s*?(\\])", 2);
    private static final Pattern _matchHexadecimalSymbols = Pattern.compile("[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]", 2);

    private AggressiveEditing() {
    }

    public static String normalizeAllKashida(String text) {
        return _matchRemoveAllKashida.matcher(text).replaceAll("");
    }

    public static String normalizeExtraMarks(String text) {
        String phase1 = _matchCleanupExtraMarks1.matcher(text).replaceAll("$1");
        String phase2 = _matchCleanupExtraMarks2.matcher(phase1).replaceAll("$1");
        return phase2;
    }

    public static String normalizeOutsideInsideSpacing(String text) {
        String replacement = " $1$2$3 ";
        String phase1 = _matchRemoveOutsideInsideSpacing1.matcher(text).replaceAll(" $1$2$3 ");
        String phase2 = _matchRemoveOutsideInsideSpacing2.matcher(phase1).replaceAll(" $1$2$3 ");
        String phase3 = _matchRemoveOutsideInsideSpacing3.matcher(phase2).replaceAll(" $1$2$3 ");
        String phase4 = _matchRemoveOutsideInsideSpacing4.matcher(phase3).replaceAll(" $1$2$3 ");
        String phase5 = _matchRemoveOutsideInsideSpacing5.matcher(phase4).replaceAll(" $1$2$3 ");
        String phase6 = _matchRemoveOutsideInsideSpacing6.matcher(phase5).replaceAll("$1 ");
        String phase7 = _matchRemoveOutsideInsideSpacing7.matcher(phase6).replaceAll("$1:$2");
        String replacement2 = "$1$2$3";
        String phase8 = _matchRemoveOutsideInsideSpacing8.matcher(phase7).replaceAll("$1$2$3");
        String phase9 = _matchRemoveOutsideInsideSpacing9.matcher(phase8).replaceAll("$1$2$3");
        String phase10 = _matchRemoveOutsideInsideSpacing10.matcher(phase9).replaceAll("$1$2$3");
        String phase11 = _matchRemoveOutsideInsideSpacing11.matcher(phase10).replaceAll("$1$2$3");
        String phase12 = _matchRemoveOutsideInsideSpacing12.matcher(phase11).replaceAll("$1$2$3");
        return phase12.trim();
    }

    public static String normalizeSpacingAndLineBreaks(String text) {
        String phase1 = _matchCleanupSpacingAndLineBreaks1.matcher(text).replaceAll(" ");
        String phase2 = _matchCleanupSpacingAndLineBreaks2.matcher(phase1).replaceAll("$1");
        return phase2.trim();
    }

    public static String normalizeUnderLines(String text) {
        if (StringUtil.isNullOrWhiteSpace(text)) {
            return "";
        }
        int chr1600 = 1600;
        int chr8204 = 8204;
        return text.replaceAll("\u0640", "").replaceAll("\u200c", "");
    }

    public static String removeHexadecimalSymbols(String text) {
        return StringUtil.isNullOrWhiteSpace(text) ? "" : _matchHexadecimalSymbols.matcher(text).replaceAll("");
    }

    public static String convertArabic1256ToUtf8(String text) throws UnsupportedEncodingException {
        String string = StringEscapeUtils.unescapeHtml4((String)text);
        byte[] b = string.getBytes(StandardCharsets.ISO_8859_1);
        return new String(b, "Windows-1256");
    }
}

