package com.luues.openoffice.utils;

import com.luues.openoffice.config.ConfigConstants;
import com.luues.openoffice.service.cache.CacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @auther: chenjh
 * @since: 2019/6/11 7:45
 */
@Component
@ConditionalOnExpression("'${cache.clean:false}'.equals('true')")
public class ShedulerClean {

    private static final Logger LOGGER = LoggerFactory.getLogger(ShedulerClean.class);

    @Autowired
    private CacheService cacheService;
    @Autowired
    private ConfigConstants configConstants;

    @Scheduled(cron = "0 0 3 * * ?")   //每晚3点执行一次
    public void clean() {
        LOGGER.info("Cache clean start");
        cacheService.cleanCache();
        DeleteFileUtil.deleteDirectory(configConstants.getFileDir());
        LOGGER.info("Cache clean end");
    }
}
