package com.luues.openoffice.service.impl;

import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.model.ReturnResponse;
import com.luues.openoffice.service.FilePreview;
import com.luues.openoffice.utils.FileUtils;
import com.luues.openoffice.utils.SimTextUtil;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created Mr-Wu
 * Content :处理文本文件
 */
@Service
public class SimTextFilePreviewImpl implements FilePreview {

    @Autowired
    SimTextUtil simTextUtil;
    @Autowired
    FileUtils fileUtils;

    @Override
    public JSONObject filePreviewHandle(FileAttribute fileAttribute) {
        JSONObject jsonObject = new JSONObject();
        String decodedUrl = fileAttribute.getDecodedUrl();
        String fileName = fileAttribute.getName();
        ReturnResponse<String> response = simTextUtil.readSimText(decodedUrl, fileName);
        if (0 != response.getCode()) {
            jsonObject.put("msg", response.getMsg());
            jsonObject.put("fileType", fileAttribute.getSuffix());
            jsonObject.put("path", "fileNotSupported");
            return jsonObject;
        }
        jsonObject.put("ordinaryUrl", response.getMsg());
        jsonObject.put("path", "txt");
        return jsonObject;
    }

}
