package com.luues.openoffice.service.impl;

import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.service.FilePreview;
import com.luues.openoffice.utils.FileUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.List;

/**
 * Created Mr-Wu
 * Content :图片文件处理
 */
@Service
public class PictureFilePreviewImpl implements FilePreview {

    @Autowired
    FileUtils fileUtils;

    @Override
    public JSONObject filePreviewHandle(FileAttribute fileAttribute) {
        String fileKey = (String) RequestContextHolder.currentRequestAttributes().getAttribute("fileKey", 0);
        String url = fileAttribute.getUrl();
        List imgUrls = Lists.newArrayList(url);
        try {
            imgUrls.clear();
            imgUrls.addAll(fileUtils.getRedisImgUrls(fileKey));
        } catch (Exception e) {
            imgUrls = Lists.newArrayList(url);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("imgurls", imgUrls);
        jsonObject.put("currentUrl", url);
        jsonObject.put("path", "picture");
        return jsonObject;
    }
}
