package com.luues.openoffice.service.impl;

import com.luues.openoffice.config.ConfigConstants;
import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.model.ReturnResponse;
import com.luues.openoffice.service.FilePreview;
import com.luues.openoffice.utils.DownloadUtils;
import com.luues.openoffice.utils.FileUtils;
import com.luues.openoffice.utils.PdfUtils;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.io.File;
import java.util.List;

/**
 * Created Mr-Wu
 * Content :处理pdf文件
 */
@Service
public class PdfFilePreviewImpl implements FilePreview {

    @Autowired
    FileUtils fileUtils;
    @Autowired
    PdfUtils pdfUtils;
    @Autowired
    DownloadUtils downloadUtils;
    @Autowired
    private ConfigConstants configConstants;

    @Override
    public JSONObject filePreviewHandle(FileAttribute fileAttribute) {
        JSONObject jsonObject = new JSONObject();
        String suffix = fileAttribute.getSuffix();
        String fileName = fileAttribute.getName();
        //String officePreviewType = model.asMap().get("officePreviewType") == null ? ConfigConstants.getOfficePreviewType() : model.asMap().get("officePreviewType").toString();
        //String originUrl = model.asMap().get("originUrl").toString();
        String officePreviewType = configConstants.getOfficePreviewType();
        String originUrl = fileAttribute.getUrl();
        jsonObject.put("pdfUrl", originUrl);
        String pdfName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + "pdf";
        String outFilePath = configConstants.getFileDir() + pdfName;
        if (OfficeFilePreviewImpl.OFFICE_PREVIEW_TYPE_IMAGE.equals(officePreviewType)
                || OfficeFilePreviewImpl.OFFICE_PREVIEW_TYPE_ALLIMAGES.equals(officePreviewType)) {
            //当文件不存在时，就去下载
            if (!new File(outFilePath).exists()) {
                ReturnResponse<String> response = downloadUtils.downLoad(fileAttribute, fileName);
                if (0 != response.getCode()) {
                    jsonObject.put("fileType", suffix);
                    jsonObject.put("msg", response.getMsg());
                    jsonObject.put("path", "fileNotSupported");
                    return jsonObject;
                }
                outFilePath = response.getContent();
            }
            List<String> imageUrls = pdfUtils.pdf2jpg(outFilePath, pdfName, originUrl);
            if (imageUrls == null || imageUrls.size() < 1) {
                jsonObject.put("msg", "pdf转图片异常，请联系管理员");
                jsonObject.put("fileType", fileAttribute.getSuffix());
                jsonObject.put("path", "fileNotSupported");
                return jsonObject;
            }
            jsonObject.put("imgurls", imageUrls);
            jsonObject.put("currentUrl", imageUrls.get(0));
            if (OfficeFilePreviewImpl.OFFICE_PREVIEW_TYPE_IMAGE.equals(officePreviewType)) {
                jsonObject.put("path", "officePicture");
            } else {
                jsonObject.put("path", "picture");
            }
            return jsonObject;
        }
        jsonObject.put("path", "pdf");
        return jsonObject;
    }
}
