package com.luues.openoffice.service.impl;

import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.service.FilePreview;
import com.luues.openoffice.utils.FileUtils;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created Mr-Wu
 * Content :其他文件
 */
@Service
public class OtherFilePreviewImpl implements FilePreview {
    @Autowired
    FileUtils fileUtils;

    @Override
    public JSONObject filePreviewHandle(FileAttribute fileAttribute) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fileType", fileAttribute.getSuffix());
        jsonObject.put("msg", "系统还不支持该格式文件的在线预览，如有需要请按下方显示的邮箱地址联系系统维护人员");
        jsonObject.put("path", "fileNotSupported");
        return jsonObject;
    }
}
