package com.luues.openoffice.service.impl;

import com.luues.openoffice.config.ConfigConstants;
import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.model.ReturnResponse;
import com.luues.openoffice.service.FilePreview;
import com.luues.openoffice.utils.DownloadUtils;
import com.luues.openoffice.utils.FileUtils;
import com.luues.openoffice.utils.OfficeToPdf;
import com.luues.openoffice.utils.PdfUtils;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.io.File;
import java.util.List;

/**
 * Created Mr-Wu
 */
@Service
public class OfficeFilePreviewImpl implements FilePreview {

    @Autowired
    FileUtils fileUtils;
    @Autowired
    PdfUtils pdfUtils;
    @Autowired
    DownloadUtils downloadUtils;
    @Autowired
    private OfficeToPdf officeToPdf;
    @Autowired
    private ConfigConstants configConstants;

    public static final String OFFICE_PREVIEW_TYPE_PDF = "pdf";
    public static final String OFFICE_PREVIEW_TYPE_IMAGE = "image";
    public static final String OFFICE_PREVIEW_TYPE_ALLIMAGES = "allImages";

    @Override
    public JSONObject filePreviewHandle(FileAttribute fileAttribute) {
        // 预览Type，参数传了就取参数的，没传取系统默认
        //String officePreviewType = model.asMap().get("officePreviewType") == null ? ConfigConstants.getOfficePreviewType() : model.asMap().get("officePreviewType").toString();
        //String originUrl = (String) model.asMap().get("originUrl");
        JSONObject jsonObject = new JSONObject();
        String officePreviewType = configConstants.getOfficePreviewType();
        String originUrl = fileAttribute.getUrl();
        String suffix = fileAttribute.getSuffix();
        String fileName = fileAttribute.getName();
        boolean isHtml = suffix.equalsIgnoreCase("xls") || suffix.equalsIgnoreCase("xlsx");
        boolean localFile = fileAttribute.isLocalFile();
        String pdfName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + (isHtml ? "html" : "pdf");
        String outFilePath = configConstants.getFileDir() + pdfName;
        // 判断之前是否已转换过，如果转换过，直接返回，否则执行转换
        if (!fileUtils.listConvertedFiles().containsKey(pdfName)) {
            String filePath = configConstants.getFileDir() + fileName;
            if (!new File(filePath).exists()) {
                if(localFile){
                    filePath = fileAttribute.getUrl();
                }else{
                    ReturnResponse<String> response = downloadUtils.downLoad(fileAttribute, null);
                    if (0 != response.getCode()) {
                        jsonObject.put("fileType", suffix);
                        jsonObject.put("msg", response.getMsg());
                        jsonObject.put("path", "fileNotSupported");
                        return jsonObject;
                    }
                    filePath = response.getContent();
                }
            }
            if (StringUtils.hasText(outFilePath)) {
                officeToPdf.openOfficeToPDF(filePath, outFilePath);
                File f = new File(filePath);
                if (f.exists()) {
                    f.delete();
                }
                if (isHtml) {
                    // 对转换后的文件进行操作(改变编码方式)
                    fileUtils.doActionConvertedFile(outFilePath);
                }
                // 加入缓存
                fileUtils.addConvertedFile(pdfName, fileUtils.getRelativePath(outFilePath));
            }
        }
        if (!isHtml && originUrl != null && (OFFICE_PREVIEW_TYPE_IMAGE.equals(officePreviewType) || OFFICE_PREVIEW_TYPE_ALLIMAGES.equals(officePreviewType))) {
            List<String> imageUrls = pdfUtils.pdf2jpg(outFilePath, pdfName, originUrl);
            if (imageUrls == null || imageUrls.size() < 1) {
                jsonObject.put("msg", "office转图片异常，请联系管理员");
                jsonObject.put("fileType", fileAttribute.getSuffix());
                jsonObject.put("path", "fileNotSupported");
                return jsonObject;
            }
            jsonObject.put("imgurls", imageUrls);
            jsonObject.put("currentUrl", imageUrls.get(0));
            if (OFFICE_PREVIEW_TYPE_IMAGE.equals(officePreviewType)) {
                jsonObject.put("path", "officePicture");
            } else {
                jsonObject.put("path", "picture");
            }
            return jsonObject;
        }
        jsonObject.put("pdfUrl", pdfName);
        if (isHtml) {
            jsonObject.put("path", "html");
        } else {
            jsonObject.put("path", "pdf");
        }
        return jsonObject;
    }
}
