package com.luues.openoffice.service.impl;

import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.service.FilePreview;
import com.luues.openoffice.utils.FileUtils;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : Mr-Wu
 **/
@Service
public class MediaFilePreviewImpl implements FilePreview {

    @Autowired
    FileUtils fileUtils;

    @Override
    public JSONObject filePreviewHandle(FileAttribute fileAttribute) {
        JSONObject jsonObject = new JSONObject();
        String url = fileAttribute.getUrl();
        jsonObject.put("mediaUrl", url);
        String suffix = fileAttribute.getSuffix();
        if ("flv".equalsIgnoreCase(suffix)) {
            jsonObject.put("path", "flv");
        } else {
            jsonObject.put("path", "media");
        }
        return jsonObject;
    }


}
