package com.luues.openoffice.service.impl;

import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.model.ReturnResponse;
import com.luues.openoffice.service.FilePreview;
import com.luues.openoffice.utils.DownloadUtils;
import com.luues.openoffice.utils.FileUtils;
import com.luues.openoffice.utils.ZipReader;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * Created Mr-Wu
 * Content :处理压缩包文件
 */
@Service
public class CompressFilePreviewImpl implements FilePreview {

    @Autowired
    FileUtils fileUtils;

    @Autowired
    DownloadUtils downloadUtils;

    @Autowired
    ZipReader zipReader;

    @Override
    public JSONObject filePreviewHandle(FileAttribute fileAttribute) {
        JSONObject jsonObject = new JSONObject();
        String fileName = fileAttribute.getName();
        String suffix = fileAttribute.getSuffix();
        String fileTree = null;
        // 判断文件名是否存在(redis缓存读取)
        if (!StringUtils.hasText(fileUtils.getConvertedFile(fileName))) {
            ReturnResponse<String> response = downloadUtils.downLoad(fileAttribute, fileName);
            if (0 != response.getCode()) {
                jsonObject.put("fileType", suffix);
                jsonObject.put("msg", response.getMsg());
                jsonObject.put("path", "fileNotSupported");
                return jsonObject;
            }
            String filePath = response.getContent();
            if ("zip".equalsIgnoreCase(suffix) || "jar".equalsIgnoreCase(suffix) || "gzip".equalsIgnoreCase(suffix)) {
                fileTree = zipReader.readZipFile(filePath, fileName);
            } else if ("rar".equalsIgnoreCase(suffix)) {
                fileTree = zipReader.unRar(filePath, fileName);
            } else if ("7z".equalsIgnoreCase(suffix)) {
                fileTree = zipReader.read7zFile(filePath, fileName);
            }
            if (fileTree != null && !"null".equals(fileTree)) {
                fileUtils.addConvertedFile(fileName, fileTree);
            }
        } else {
            fileTree = fileUtils.getConvertedFile(fileName);
        }
        if (fileTree != null && !"null".equals(fileTree)) {
            jsonObject.put("fileTree", fileTree);
            jsonObject.put("path", "compress");
            return jsonObject;
        } else {
            jsonObject.put("fileType", suffix);
            jsonObject.put("msg", "压缩文件类型不受支持，尝试在压缩的时候选择RAR4格式");
            jsonObject.put("path", "fileNotSupported");
            return jsonObject;
        }
    }
}
