package com.luues.openoffice.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.io.File;

@Component
@Data
public class ConfigConstants {

    private String[] simText = {};
    private String[] media = {};
    private String convertedFileCharset;
    private String officePreviewType;
    private String ftpUsername;
    private String ftpPassword;
    private String ftpControlEncoding;
    private String fileDir;
    private String homePath;
    @Autowired
    private ApplicationData applicationData;

    @PostConstruct
    public void init() {
        fileDir = applicationData.getFileDir();
        simText = applicationData.getSimText().split(",");
        media = applicationData.getMedia().split(",");
        convertedFileCharset = applicationData.getConvertedFileCharset();
        officePreviewType = applicationData.getOfficePreviewType();
        ftpUsername = applicationData.getFtpUsername();
        ftpPassword = applicationData.getFtpPassword();
        ftpControlEncoding = applicationData.getFtpControlEncoding();
    }
    public String getFileDir() {
        if(null == fileDir || "null".equals(fileDir)){
            fileDir = ConfigConstants.class.getClassLoader().getResource("").getPath() + "fileDir/";
        }
        return fileDir;
    }

    public String getHomePath() {
        if(null == homePath || "null".equals(homePath)){
            homePath = ConfigConstants.class.getClassLoader().getResource("").getPath();
        }
        return homePath;
    }

}
