package com.luues.openoffice.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
@Data
public class ApplicationData {

    @Value(value = "${file.dir:null}")
    private String fileDir; //文件资源路径（默认为打包根路径下的file目录下）
    @Value(value = "${office.home:null}")
    private String officeHome; //openOffice安装目录
    @Value(value = "${cache.clean:false}")
    private boolean cacheClean; //缓存自动清理(每晚3点自动清理) true 为开启，注释掉或其他值都为关闭
    @Value(value = "${openoffice.simText:txt,html,xml,properties,md,java,py,c,cpp,sql}")
    private String simText; //文本类型，默认如下，可自定义添加
    @Value(value = "${openoffice.media:mp3,wav,mp4,flv}")
    private String media; //多媒体类型，默认如下，可自定义添加
    @Value(value = "${converted.file.charset:UTF-8}")
    private String convertedFileCharset; //文件转换编码，默认根据操作系统获取
    @Value(value = "${office.preview.type:pdf}")
    private String officePreviewType; //office类型文档(word ppt)样式，默认为图片(image)，可配置为pdf（预览时也有按钮切换）
    @Value(value = "${ftp.username:null}")
    private String ftpUsername; //预览源为FTP时 FTP用户名，可在ftp url后面加参数ftp.username=ftpuser指定，不指定默认用配置的
    @Value(value = "${ftp.password:null}")
    private String ftpPassword; //预览源为FTP时 FTP密码，可在ftp url后面加参数ftp.password=123456指定，不指定默认用配置的
    @Value(value = "${ftp.control.encoding:UTF-8}")
    private String ftpControlEncoding; //预览源为FTP时, FTP连接默认ControlEncoding(根据FTP服务器操作系统选择，Linux一般为UTF-8，Windows一般为GBK)，可在ftp url后面加参数ftp.control.encoding=UTF-8指定，不指定默认用配置的

}
