/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.service.imple;

import com.luues.jdbc.plus.core.conditions.AbstractWrapper;
import com.luues.jdbc.plus.core.conditions.Wrapper;
import com.luues.jdbc.plus.core.conditions.query.QueryWrapper;
import com.luues.jdbc.plus.core.metadata.IPage;
import com.luues.jdbc.plus.core.metadata.TableInfoHelper;
import com.luues.jdbc.plus.core.toolkit.ReflectionKit;
import com.luues.jdbc.plus.core.toolkit.Wrappers;
import com.luues.jdbc.plus.extension.conditions.query.LambdaQueryChainWrapper;
import com.luues.jdbc.plus.extension.conditions.query.QueryChainWrapper;
import com.luues.jdbc.plus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.luues.jdbc.plus.extension.conditions.update.UpdateChainWrapper;
import com.luues.jdbc.plus.extension.plugins.pagination.Page;
import com.luues.jdbc.plus.service.BaseDao;
import com.luues.jdbc.plus.service.core.BaseMapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDaoImpl<T>
implements BaseDao<T> {
    @Autowired
    private BaseMapper<T> baseMapper;
    protected Class<T> entityClass = this.currentModelClass();

    @Override
    public boolean save(T entity) {
        return null != this.baseMapper.save(entity);
    }

    @Override
    public boolean saveBatch(Collection<T> entityList) {
        return this.saveBatch(entityList, entityList.size());
    }

    @Override
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        return this.baseMapper.saveBatch(entityList, batchSize);
    }

    @Override
    public boolean removeById(Serializable id) {
        return this.baseMapper.delete(this.entityClass, id);
    }

    @Override
    public boolean removeByMap(Map<String, Object> columnMap) {
        return this.baseMapper.delete(this.entityClass, columnMap);
    }

    @Override
    public boolean remove(Wrapper<T> wrapper) {
        AbstractWrapper abstractWrapper = (AbstractWrapper)wrapper;
        abstractWrapper.setEntityClass(this.entityClass);
        return this.baseMapper.delete(abstractWrapper);
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        return this.baseMapper.delete(this.entityClass, idList);
    }

    @Override
    public boolean updateById(T entity) {
        return this.baseMapper.update(entity);
    }

    @Override
    public boolean update(Wrapper<T> wrapper) {
        AbstractWrapper abstractWrapper = (AbstractWrapper)wrapper;
        abstractWrapper.setEntityClass(this.entityClass);
        return this.baseMapper.update(abstractWrapper);
    }

    @Override
    public boolean update(T entity, Wrapper<T> wrapper) {
        AbstractWrapper abstractWrapper = (AbstractWrapper)wrapper;
        abstractWrapper.setEntityClass(this.entityClass);
        return this.baseMapper.update(entity, abstractWrapper);
    }

    @Override
    public boolean updateBatchById(Collection<T> entityList) {
        return this.baseMapper.update(entityList);
    }

    @Override
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        return this.baseMapper.update(entityList, batchSize);
    }

    @Override
    public boolean saveOrUpdate(T entity) {
        return this.baseMapper.saveOrUpdate(entity);
    }

    @Override
    public T getById(Serializable id) {
        return this.baseMapper.getById(this.entityClass, id);
    }

    @Override
    public List<T> listByIds(Collection<? extends Serializable> idList) {
        return this.baseMapper.listByIds(this.entityClass, idList);
    }

    @Override
    public List<T> listByMap(Map<String, Object> columnMap) {
        return this.baseMapper.listByMap(this.entityClass, columnMap);
    }

    @Override
    public T getOne(Wrapper<T> queryWrapper) {
        return this.baseMapper.selectOne(queryWrapper);
    }

    @Override
    public T getOne(Wrapper<T> wrapper, boolean throwEx) {
        return this.baseMapper.selectOne(throwEx, wrapper);
    }

    @Override
    public Map<String, Object> getMap(Wrapper<T> wrapper) {
        return this.baseMapper.getMap(wrapper);
    }

    @Override
    public int count() {
        return this.baseMapper.count(this.entityClass);
    }

    @Override
    public int count(Wrapper<T> wrapper) {
        AbstractWrapper abstractWrapper = (AbstractWrapper)wrapper;
        abstractWrapper.setEntityClass(this.entityClass);
        return this.baseMapper.count(abstractWrapper);
    }

    @Override
    public List<T> list(Wrapper<T> wrapper) {
        AbstractWrapper abstractWrapper = (AbstractWrapper)wrapper;
        abstractWrapper.setEntityClass(this.entityClass);
        return this.baseMapper.list(abstractWrapper);
    }

    @Override
    public List<T> list() {
        return this.baseMapper.list(this.entityClass);
    }

    @Override
    public IPage<T> page(Page<T> page, Wrapper<T> wrapper) {
        AbstractWrapper abstractWrapper = (AbstractWrapper)wrapper;
        abstractWrapper.setEntityClass(this.entityClass);
        return this.baseMapper.page(page, abstractWrapper);
    }

    @Override
    public IPage<T> page(Page<T> page, T entity) {
        return this.baseMapper.page(page, entity, this.entityClass);
    }

    @Override
    public IPage<T> page(Page<T> page) {
        QueryWrapper<T> abstractWrapper = Wrappers.emptyWrapper();
        abstractWrapper.setEntityClass(this.entityClass);
        return this.baseMapper.page(page, abstractWrapper);
    }

    @Override
    public List<Map<String, Object>> listMaps(Wrapper<T> queryWrapper) {
        return this.baseMapper.listMaps(queryWrapper);
    }

    @Override
    public List<Map<String, Object>> listMaps() {
        return this.baseMapper.listMaps(this.entityClass);
    }

    @Override
    public QueryChainWrapper<T> query() {
        return this.baseMapper.query();
    }

    @Override
    public LambdaQueryChainWrapper<T> lambdaQuery() {
        return this.baseMapper.lambdaQuery(this.entityClass);
    }

    @Override
    public UpdateChainWrapper<T> update() {
        return this.baseMapper.update();
    }

    @Override
    public LambdaUpdateChainWrapper<T> lambdaUpdate() {
        return this.baseMapper.lambdaUpdate();
    }

    @Override
    public T getOneBySql(String sql, boolean throwEx, Object ... params) {
        return this.baseMapper.getOneBySql(sql, this.entityClass, params);
    }

    @Override
    public List<T> getBySql(String sql, boolean throwEx, Object ... params) {
        return this.baseMapper.getBySql(sql, this.entityClass, params);
    }

    @Override
    public boolean update(String sql, boolean throwEx) {
        return this.baseMapper.update(sql);
    }

    protected Class<T> currentModelClass() {
        Class<?> tClass = ReflectionKit.getSuperClassGenericType(this.getClass(), 0);
        TableInfoHelper.initTableInfo(tClass);
        return tClass;
    }
}

