/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.service.core.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.luues.jdbc.plus.core.conditions.Wrapper;
import com.luues.jdbc.plus.core.conditions.query.QueryWrapper;
import com.luues.jdbc.plus.core.jdbc.SqlHelp;
import com.luues.jdbc.plus.core.jdbc.SqlInfo;
import com.luues.jdbc.plus.core.metadata.IPage;
import com.luues.jdbc.plus.core.metadata.TableFieldInfo;
import com.luues.jdbc.plus.core.metadata.TableInfo;
import com.luues.jdbc.plus.core.metadata.TableInfoHelper;
import com.luues.jdbc.plus.core.toolkit.ExceptionUtils;
import com.luues.jdbc.plus.core.toolkit.Wrappers;
import com.luues.jdbc.plus.extension.conditions.query.LambdaQueryChainWrapper;
import com.luues.jdbc.plus.extension.conditions.query.QueryChainWrapper;
import com.luues.jdbc.plus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.luues.jdbc.plus.extension.conditions.update.UpdateChainWrapper;
import com.luues.jdbc.plus.extension.plugins.pagination.Page;
import com.luues.jdbc.plus.extension.toolkit.ChainWrappers;
import com.luues.jdbc.plus.service.core.BaseMapper;
import com.luues.util.TypeConvert;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class Mapper<T>
implements BaseMapper<T> {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public List<T> selectList(boolean flag, Wrapper<T> wrapper) {
        SqlInfo sqlInfo = SqlHelp.getSelectListSqlInfo(wrapper);
        return this.jdbcTemplate.query(sqlInfo.getSql(), (RowMapper)new BeanPropertyRowMapper(wrapper.getEntityClass()), sqlInfo.getParams().toArray());
    }

    @Override
    public IPage<T> page(boolean flag, Page<T> page, Wrapper<T> wrapper) {
        int count = this.count(true, wrapper);
        SqlInfo sqlInfo = SqlHelp.getSelectPageSqlInfo(page, wrapper);
        List tList = this.jdbcTemplate.query(sqlInfo.getSql(), (RowMapper)new BeanPropertyRowMapper(wrapper.getEntityClass()), sqlInfo.getParams().toArray());
        Page iPage = new Page();
        BeanUtils.copyProperties(page, iPage);
        iPage.setRecords(tList);
        iPage.setTotal(count);
        return iPage;
    }

    @Override
    public IPage<T> page(boolean flag, Page<T> page, T entity, Class<T> tClass) {
        JSONObject jsonObject;
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
        QueryWrapper<T> queryWrapper = Wrappers.query();
        List<TableFieldInfo> fieldInfoList = tableInfo.getFieldList();
        try {
            jsonObject = JSON.parseObject((String)JSON.toJSONStringWithDateFormat(entity, (String)"yyyy-MM-dd HH:mm:ss.SSS", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        }
        catch (Exception e) {
            try {
                jsonObject = JSON.parseObject((String)JSON.toJSONStringWithDateFormat(entity, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
            }
            catch (Exception e1) {
                try {
                    jsonObject = JSON.parseObject((String)JSON.toJSONStringWithDateFormat(entity, (String)"yyyy-MM-dd HH:mm", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                }
                catch (Exception e2) {
                    try {
                        jsonObject = JSON.parseObject((String)JSON.toJSONStringWithDateFormat(entity, (String)"yyyy-MM-dd HH", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                    }
                    catch (Exception e3) {
                        try {
                            jsonObject = JSON.parseObject((String)JSON.toJSONStringWithDateFormat(entity, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                        }
                        catch (Exception e4) {
                            throw ExceptionUtils.mpe("CLASS Transformation JSON FAIL !", new Object[0]);
                        }
                    }
                }
            }
        }
        for (TableFieldInfo tableFieldInfo : fieldInfoList) {
            if (TypeConvert.isNull((Object[])new Object[]{jsonObject.get((Object)tableFieldInfo.getColumn())})) continue;
            queryWrapper.eq(tableFieldInfo.getProperty(), jsonObject.get((Object)tableFieldInfo.getColumn()));
        }
        queryWrapper.setEntityClass(tClass);
        int count = this.count(true, queryWrapper);
        SqlInfo sqlInfo = SqlHelp.getSelectPageSqlInfo(page, queryWrapper);
        List tList = this.jdbcTemplate.query(sqlInfo.getSql(), (RowMapper)new BeanPropertyRowMapper(queryWrapper.getEntityClass()), sqlInfo.getParams().toArray());
        Page iPage = new Page();
        BeanUtils.copyProperties(page, iPage);
        iPage.setRecords(tList);
        iPage.setTotal(count);
        return iPage;
    }

    @Override
    public Integer selectCount(boolean flag, Wrapper<T> wrapper) {
        SqlInfo sqlInfo = SqlHelp.getSelectOneSqlInfo(wrapper);
        return (Integer)this.jdbcTemplate.queryForObject(sqlInfo.getSql(), Integer.class, sqlInfo.getParams().toArray());
    }

    @Override
    public T getOneBySql(String sql, Class<T> tClass, boolean throwEx, Object ... params) {
        SqlInfo sqlInfo = SqlHelp.getCusSql(sql, params);
        List list = this.jdbcTemplate.query(sqlInfo.getSql(), (RowMapper)new BeanPropertyRowMapper(tClass), sqlInfo.getParams().toArray());
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw ExceptionUtils.mpe("Expected one result (or null) to be returned by selectOne(), but found: " + list.size() + "", new Object[0]);
        }
        return (T)list.get(0);
    }

    @Override
    public List<T> getBySql(String sql, Class<T> tClass, boolean throwEx, Object ... params) {
        SqlInfo sqlInfo = SqlHelp.getCusSql(sql, params);
        return this.jdbcTemplate.query(sqlInfo.getSql(), (RowMapper)new BeanPropertyRowMapper(tClass), sqlInfo.getParams().toArray());
    }

    @Override
    public boolean update(String sql, boolean throwEx) {
        SqlInfo sqlInfo = SqlHelp.getCusSql(sql, new Object[0]);
        return this.jdbcTemplate.update(sqlInfo.getSql()) > 0;
    }

    @Override
    public T selectOne(boolean flag, Wrapper<T> wrapper) {
        SqlInfo sqlInfo = SqlHelp.getSelectOneSqlInfo(wrapper);
        List list = this.jdbcTemplate.query(sqlInfo.getSql(), (RowMapper)new BeanPropertyRowMapper(wrapper.getEntityClass()), sqlInfo.getParams().toArray());
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw ExceptionUtils.mpe("Expected one result (or null) to be returned by selectOne(), but found: " + list.size() + "", new Object[0]);
        }
        return (T)list.get(0);
    }

    @Override
    public <T> T save(boolean flag, T entity) {
        final SqlInfo sqlInfo = SqlHelp.getInsertSqlInfo(entity);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement preparedStatement = connection.prepareStatement(sqlInfo.getSql(), 1);
                AtomicInteger k = new AtomicInteger(1);
                sqlInfo.getParams().forEach(params -> {
                    try {
                        preparedStatement.setObject(k.getAndIncrement(), params);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                });
                return preparedStatement;
            }
        }, (KeyHolder)keyHolder);
        Number id = keyHolder.getKey();
        if (null == id || id.longValue() <= 0L) {
            id = (Number)sqlInfo.getKeyValue();
        }
        if (null == id) {
            return entity;
        }
        TableInfo tableInfo = sqlInfo.getTableInfo();
        Method method = tableInfo.getFieldSetMethod().get(tableInfo.getKeyProperty());
        switch (tableInfo.getFieldType().get(tableInfo.getKeyProperty()).getSimpleName().toUpperCase()) {
            case "LONG": {
                method.invoke(entity, id.longValue());
                break;
            }
            case "STRING": {
                method.invoke(entity, id.toString());
                break;
            }
            case "INT": {
                method.invoke(entity, id.intValue());
                break;
            }
            case "INTEGER": {
                method.invoke(entity, Integer.valueOf(id.toString()));
                break;
            }
            case "BIGINTEGER": {
                method.invoke(entity, new BigInteger(id.toString()));
                break;
            }
            case "NUMBER": {
                method.invoke(entity, id);
                break;
            }
            default: {
                method.invoke(entity, String.valueOf(id));
            }
        }
        return entity;
    }

    @Override
    public <T> T update(boolean flag, T entity) {
        SqlInfo sqlInfo = SqlHelp.getUpdateSqlInfo(entity);
        return (T)(this.jdbcTemplate.update(sqlInfo.getSql(), sqlInfo.getParams().toArray()) > 0 ? entity : null);
    }

    @Override
    public List<T> update(boolean flag, Collection<T> entityList) {
        return this.update(flag, entityList, entityList.size());
    }

    @Override
    public List<T> update(boolean flag, Collection<T> entityList, int batchSize) {
        List<SqlInfo> sqlInfoList = SqlHelp.getBatchUpdateSqlInfo(entityList);
        sqlInfoList.stream().forEach(sqlInfo -> {
            List<Collection<Object>> paramsList = sqlInfo.getParamsList();
            List params = IntStream.range(0, paramsList.size()).mapToObj(i -> ((Collection)paramsList.get(i)).stream().collect(Collectors.toList()).toArray()).collect(Collectors.toList());
            this.jdbcTemplate.batchUpdate(sqlInfo.getSql(), params);
        });
        return entityList.stream().collect(Collectors.toList());
    }

    @Override
    public boolean update(boolean flag, Wrapper<T> wrapper) {
        SqlInfo sqlInfo = SqlHelp.getUpdateSqlInfo(wrapper);
        return this.jdbcTemplate.update(sqlInfo.getSql(), sqlInfo.getParams().toArray()) > 0;
    }

    @Override
    public boolean update(boolean flag, T entity, Wrapper<T> wrapper) {
        SqlInfo sqlInfo = SqlHelp.getUpdateSqlInfo(entity, wrapper);
        return this.jdbcTemplate.update(sqlInfo.getSql(), sqlInfo.getParams().toArray()) > 0;
    }

    @Override
    public int delete(boolean flag, T entity) {
        SqlInfo sqlInfo = SqlHelp.getDeleteSqlInfo(entity);
        return this.jdbcTemplate.update(sqlInfo.getSql(), sqlInfo.getParams().toArray());
    }

    @Override
    public int delete(boolean flag, Class<T> tClass, Serializable id) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(tClass);
        QueryWrapper queryWrapper = (QueryWrapper)Wrappers.query().eq(tableInfo.getKeyColumn(), id);
        if (null == queryWrapper.getEntityClass()) {
            queryWrapper.setEntityClass(tClass);
        }
        return this.delete(flag, queryWrapper);
    }

    @Override
    public int delete(boolean flag, Class<T> tClass, Map<String, Object> columnMap) {
        QueryWrapper<T> queryWrapper = Wrappers.query();
        for (String key : columnMap.keySet()) {
            queryWrapper.eq(key, columnMap.get(key));
        }
        return this.delete(true, (Wrapper<T>)queryWrapper.setEntityClass(tClass));
    }

    @Override
    public int delete(boolean flag, Wrapper<T> wrapper) {
        SqlInfo sqlInfo = SqlHelp.getDeleteSqlInfo(wrapper);
        return this.jdbcTemplate.update(sqlInfo.getSql(), sqlInfo.getParams().toArray());
    }

    @Override
    public int delete(boolean flag, Class<T> tClass, Collection<? extends Serializable> idList) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(tClass);
        Object wrapper = ((QueryWrapper)Wrappers.query().in(tableInfo.getKeyColumn(), idList.stream().collect(Collectors.toList()).toArray())).setEntityClass(tClass);
        return this.delete(flag, (Wrapper<T>)wrapper);
    }

    @Override
    public boolean saveBatch(boolean flag, Collection<T> entitys) {
        return this.saveBatch(true, entitys, entitys.size());
    }

    @Override
    public boolean saveBatch(boolean flag, Collection<T> entitys, int batchSize) {
        List<SqlInfo> sqlInfoList = SqlHelp.getBatchSaveSqlInfo(entitys);
        sqlInfoList.stream().forEach(sqlInfo -> {
            List<Collection<Object>> paramsList = sqlInfo.getParamsList();
            List params = IntStream.range(0, paramsList.size()).mapToObj(i -> ((Collection)paramsList.get(i)).stream().collect(Collectors.toList()).toArray()).collect(Collectors.toList());
            this.jdbcTemplate.batchUpdate(sqlInfo.getSql(), params);
        });
        return true;
    }

    @Override
    public <T> T saveOrUpdate(boolean flag, T entity) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
        try {
            Method method = entity.getClass().getMethod("get" + TypeConvert.upperCase((String)tableInfo.getKeyColumn()), new Class[0]);
            Object keyValue = method.invoke(entity, new Object[0]);
            if (null == keyValue) {
                return this.save(flag, entity);
            }
            Object queryWrapper = ((QueryWrapper)Wrappers.query().eq(tableInfo.getKeyColumn(), keyValue)).setEntityClass(entity.getClass());
            T entity_ = this.selectOne(flag, (Wrapper<T>)queryWrapper);
            if (null == entity_) {
                return this.save(flag, entity);
            }
            return this.update(flag, entity);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionUtils.mpe("Failed to get primary key get method", new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtils.mpe("Primary key get method failed to get value", new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw ExceptionUtils.mpe("Primary key get method failed to get value", new Object[0]);
        }
    }

    @Override
    public <T> T getById(boolean flag, Class<T> tClass, Serializable id) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(tClass);
        Object wrapper = ((QueryWrapper)Wrappers.query().eq(tableInfo.getKeyColumn(), id)).setEntityClass(tClass);
        return this.selectOne(flag, (Wrapper<T>)wrapper);
    }

    @Override
    public List<T> listByIds(boolean flag, Class<T> tClass, Collection<? extends Serializable> idList) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(tClass);
        Object wrapper = ((QueryWrapper)Wrappers.query().in(tableInfo.getKeyColumn(), idList.stream().collect(Collectors.toList()).toArray())).setEntityClass(tClass);
        return this.selectList(flag, (Wrapper<T>)wrapper);
    }

    @Override
    public List<T> listByMap(boolean flag, Class<T> tClass, Map<String, Object> columnMap) {
        QueryWrapper<T> queryWrapper = Wrappers.query();
        for (String key : columnMap.keySet()) {
            queryWrapper.eq(key, columnMap.get(key));
        }
        return this.selectList(flag, (Wrapper<T>)queryWrapper.setEntityClass(tClass));
    }

    @Override
    public Map<String, Object> getMap(boolean flag, Wrapper<T> wrapper) {
        SqlInfo sqlInfo = SqlHelp.getSelectOneSqlInfo(wrapper);
        List list = this.jdbcTemplate.queryForList(sqlInfo.getSql(), sqlInfo.getParams().toArray());
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw ExceptionUtils.mpe("Expected one result (or null) to be returned by selectOne(), but found: " + list.size() + "", new Object[0]);
        }
        return (Map)list.get(0);
    }

    @Override
    public int count(boolean flag, Class<T> tClass) {
        QueryWrapper<T> queryWrapper = Wrappers.query();
        return this.count(flag, (Wrapper<T>)queryWrapper.setEntityClass(tClass));
    }

    @Override
    public int count(boolean flag, Wrapper<T> wrapper) {
        SqlInfo sqlInfo = SqlHelp.getSelectCountSqlInfo(wrapper);
        return (Integer)this.jdbcTemplate.queryForObject(sqlInfo.getSql(), Integer.class, sqlInfo.getParams().toArray());
    }

    @Override
    public List<T> list(boolean flag, Wrapper<T> wrapper) {
        return this.selectList(flag, wrapper);
    }

    @Override
    public List<T> list(boolean flag, Class<T> tClass) {
        QueryWrapper<T> queryWrapper = Wrappers.query();
        return this.list(flag, (Wrapper<T>)queryWrapper.setEntityClass(tClass));
    }

    @Override
    public List<Map<String, Object>> listMaps(boolean flag, Wrapper<T> queryWrapper) {
        SqlInfo sqlInfo = SqlHelp.getSelectOneSqlInfo(queryWrapper);
        return this.jdbcTemplate.queryForList(sqlInfo.getSql(), sqlInfo.getParams().toArray());
    }

    @Override
    public List<Map<String, Object>> listMaps(boolean flag, Class<T> tClass) {
        QueryWrapper<T> queryWrapper = Wrappers.query();
        return this.listMaps(flag, (Wrapper<T>)queryWrapper.setEntityClass(tClass));
    }

    @Override
    public QueryChainWrapper<T> query(boolean flag) {
        return ChainWrappers.queryChain(this);
    }

    @Override
    public LambdaQueryChainWrapper<T> lambdaQuery(boolean flag, Class<T> tClass) {
        return ChainWrappers.lambdaQueryChain(this);
    }

    @Override
    public UpdateChainWrapper<T> update(boolean flag) {
        return ChainWrappers.updateChain(this);
    }

    @Override
    public LambdaUpdateChainWrapper<T> lambdaUpdate(boolean flag) {
        return ChainWrappers.lambdaUpdateChain(this);
    }
}

