/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.service.core;

import com.luues.jdbc.plus.core.conditions.Wrapper;
import com.luues.jdbc.plus.core.metadata.IPage;
import com.luues.jdbc.plus.extension.conditions.query.LambdaQueryChainWrapper;
import com.luues.jdbc.plus.extension.conditions.query.QueryChainWrapper;
import com.luues.jdbc.plus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.luues.jdbc.plus.extension.conditions.update.UpdateChainWrapper;
import com.luues.jdbc.plus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface BaseMapper<T>
extends Serializable {
    default public <T> T save(T entity) {
        return this.save(true, entity);
    }

    public <T> T save(boolean var1, T var2);

    default public boolean saveBatch(Collection<T> entitys) {
        return this.saveBatch(true, entitys);
    }

    public boolean saveBatch(boolean var1, Collection<T> var2);

    default public boolean saveBatch(Collection<T> entitys, int batchSize) {
        return false != this.saveBatch(true, entitys, batchSize);
    }

    public boolean saveBatch(boolean var1, Collection<T> var2, int var3);

    default public boolean update(T entity) {
        return null != this.update(true, entity);
    }

    public <T> T update(boolean var1, T var2);

    default public boolean update(Wrapper<T> wrapper) {
        return this.update((T)true, wrapper);
    }

    public boolean update(boolean var1, Wrapper<T> var2);

    default public boolean update(T entity, Wrapper<T> wrapper) {
        return this.update(true, entity, wrapper);
    }

    public boolean update(boolean var1, T var2, Wrapper<T> var3);

    default public boolean update(Collection<T> entityList) {
        return null != this.update(true, entityList);
    }

    public List<T> update(boolean var1, Collection<T> var2);

    default public boolean update(Collection<T> entityList, int batchSize) {
        return null != this.update(true, entityList, batchSize);
    }

    public List<T> update(boolean var1, Collection<T> var2, int var3);

    default public boolean saveOrUpdate(T entity) {
        return null != this.saveOrUpdate(true, entity);
    }

    public <T> T saveOrUpdate(boolean var1, T var2);

    default public <T> T getById(Class<T> tClass, Serializable id) {
        return this.getById(true, tClass, id);
    }

    public <T> T getById(boolean var1, Class<T> var2, Serializable var3);

    default public List<T> listByIds(Class<T> tClass, Collection<? extends Serializable> idList) {
        return this.listByIds(true, tClass, idList);
    }

    public List<T> listByIds(boolean var1, Class<T> var2, Collection<? extends Serializable> var3);

    default public List<T> listByMap(Class<T> tClass, Map<String, Object> columnMap) {
        return this.listByMap(true, tClass, columnMap);
    }

    public List<T> listByMap(boolean var1, Class<T> var2, Map<String, Object> var3);

    default public Map<String, Object> getMap(Wrapper<T> wrapper) {
        return this.getMap(true, wrapper);
    }

    public Map<String, Object> getMap(boolean var1, Wrapper<T> var2);

    default public int count(Class<T> tClass) {
        return this.count(true, tClass);
    }

    public int count(boolean var1, Class<T> var2);

    default public int count(Wrapper<T> wrapper) {
        return this.count(true, wrapper);
    }

    public int count(boolean var1, Wrapper<T> var2);

    default public List<T> list(Wrapper<T> wrapper) {
        return this.list(true, wrapper);
    }

    public List<T> list(boolean var1, Wrapper<T> var2);

    default public List<T> list(Class<T> tClass) {
        return this.list(true, tClass);
    }

    public List<T> list(boolean var1, Class<T> var2);

    default public IPage<T> page(Page<T> page, Wrapper<T> wrapper) {
        return this.page(true, page, wrapper);
    }

    public IPage<T> page(boolean var1, Page<T> var2, Wrapper<T> var3);

    default public IPage<T> page(Page<T> page, T entity, Class<T> tClass) {
        return this.page(true, page, entity, tClass);
    }

    public IPage<T> page(boolean var1, Page<T> var2, T var3, Class<T> var4);

    default public List<Map<String, Object>> listMaps(Wrapper<T> queryWrapper) {
        return this.listMaps(true, queryWrapper);
    }

    public List<Map<String, Object>> listMaps(boolean var1, Wrapper<T> var2);

    default public List<Map<String, Object>> listMaps(Class<T> tClass) {
        return this.listMaps(true, tClass);
    }

    public List<Map<String, Object>> listMaps(boolean var1, Class<T> var2);

    default public QueryChainWrapper<T> query() {
        return this.query(true);
    }

    public QueryChainWrapper<T> query(boolean var1);

    default public LambdaQueryChainWrapper<T> lambdaQuery(Class<T> tClass) {
        return this.lambdaQuery(true, tClass);
    }

    public LambdaQueryChainWrapper<T> lambdaQuery(boolean var1, Class<T> var2);

    default public UpdateChainWrapper<T> update() {
        return this.update(true);
    }

    public UpdateChainWrapper<T> update(boolean var1);

    default public LambdaUpdateChainWrapper<T> lambdaUpdate() {
        return this.lambdaUpdate(true);
    }

    public LambdaUpdateChainWrapper<T> lambdaUpdate(boolean var1);

    default public boolean delete(T entity) {
        return 0 != this.delete(true, entity);
    }

    public int delete(boolean var1, T var2);

    default public boolean delete(Class<T> tClass, Serializable id) {
        return 0 != this.delete(true, tClass, id);
    }

    public int delete(boolean var1, Class<T> var2, Serializable var3);

    default public boolean delete(Class<T> tClass, Map<String, Object> columnMap) {
        return 0 != this.delete(true, tClass, columnMap);
    }

    public int delete(boolean var1, Class<T> var2, Map<String, Object> var3);

    default public boolean delete(Wrapper<T> wrapper) {
        return 0 != this.delete(true, wrapper);
    }

    public int delete(boolean var1, Wrapper<T> var2);

    default public boolean delete(Class<T> tClass, Collection<? extends Serializable> idList) {
        return 0 != this.delete(true, tClass, idList);
    }

    public int delete(boolean var1, Class<T> var2, Collection<? extends Serializable> var3);

    default public List<T> selectList(Wrapper<T> wrapper) {
        return this.selectList(true, wrapper);
    }

    public List<T> selectList(boolean var1, Wrapper<T> var2);

    default public T selectOne(Wrapper<T> wrapper) {
        return this.selectOne(true, wrapper);
    }

    public T selectOne(boolean var1, Wrapper<T> var2);

    default public Integer selectCount(Wrapper<T> wrapper) {
        return this.selectCount(true, wrapper);
    }

    public Integer selectCount(boolean var1, Wrapper<T> var2);

    default public T getOneBySql(String sql, Class<T> tClass, Object ... params) {
        return this.getOneBySql(sql, tClass, true, params);
    }

    public T getOneBySql(String var1, Class<T> var2, boolean var3, Object ... var4);

    default public List<T> getBySql(String sql, Class<T> tClass, Object ... params) {
        return this.getBySql(sql, tClass, true, params);
    }

    public List<T> getBySql(String var1, Class<T> var2, boolean var3, Object ... var4);

    default public boolean update(String sql) {
        return this.update(sql, true);
    }

    public boolean update(String var1, boolean var2);
}

