/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.service;

import com.luues.jdbc.plus.core.conditions.Wrapper;
import com.luues.jdbc.plus.core.metadata.IPage;
import com.luues.jdbc.plus.extension.conditions.query.LambdaQueryChainWrapper;
import com.luues.jdbc.plus.extension.conditions.query.QueryChainWrapper;
import com.luues.jdbc.plus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.luues.jdbc.plus.extension.conditions.update.UpdateChainWrapper;
import com.luues.jdbc.plus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

public interface BaseDao<T> {
    public static final int DEFAULT_BATCH_SIZE = 1000;

    public boolean save(T var1);

    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> var1);

    public boolean saveBatch(Collection<T> var1, int var2);

    public boolean removeById(Serializable var1);

    public boolean removeByMap(Map<String, Object> var1);

    public boolean remove(Wrapper<T> var1);

    public boolean removeByIds(Collection<? extends Serializable> var1);

    public boolean updateById(T var1);

    public boolean update(Wrapper<T> var1);

    public boolean update(T var1, Wrapper<T> var2);

    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> var1);

    public boolean updateBatchById(Collection<T> var1, int var2);

    public boolean saveOrUpdate(T var1);

    public T getById(Serializable var1);

    public List<T> listByIds(Collection<? extends Serializable> var1);

    public List<T> listByMap(Map<String, Object> var1);

    public T getOne(Wrapper<T> var1);

    public T getOne(Wrapper<T> var1, boolean var2);

    public Map<String, Object> getMap(Wrapper<T> var1);

    public int count();

    public int count(Wrapper<T> var1);

    public List<T> list(Wrapper<T> var1);

    public List<T> list();

    public IPage<T> page(Page<T> var1, Wrapper<T> var2);

    public IPage<T> page(Page<T> var1, T var2);

    public IPage<T> page(Page<T> var1);

    public List<Map<String, Object>> listMaps(Wrapper<T> var1);

    public List<Map<String, Object>> listMaps();

    public QueryChainWrapper<T> query();

    public LambdaQueryChainWrapper<T> lambdaQuery();

    public UpdateChainWrapper<T> update();

    public LambdaUpdateChainWrapper<T> lambdaUpdate();

    default public T getOneBySql(String sql, Object ... params) {
        return this.getOneBySql(sql, true, params);
    }

    public T getOneBySql(String var1, boolean var2, Object ... var3);

    default public List<T> getBySql(String sql, Object ... params) {
        return this.getBySql(sql, true, params);
    }

    public List<T> getBySql(String var1, boolean var2, Object ... var3);

    default public boolean update(String sql) {
        return this.update(sql, true);
    }

    public boolean update(String var1, boolean var2);
}

