/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure;

import com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure.hikari.HikariCpConfig;
import com.luues.jdbc.plus.dynamic.datasource.toolkit.CryptoUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.datasource")
public class SingleDynamicDataSourceProperties {
    private static final Logger log = LoggerFactory.getLogger(SingleDynamicDataSourceProperties.class);
    public static final String PREFIX = "spring.datasource";
    private static final Pattern ENC_PATTERN = Pattern.compile("^ENC\\((.*)\\)$");
    private String poolName;
    private Class<? extends DataSource> type;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private Boolean fieldUnderline;
    private String jndiName;
    private String schema;
    private String data;
    private boolean continueOnError = true;
    private String separator = ";";
    @NestedConfigurationProperty
    private DruidConfig druid = new DruidConfig();
    @NestedConfigurationProperty
    private HikariCpConfig hikari = new HikariCpConfig();
    private String publicKey;

    public String getUrl() {
        return this.decrypt(this.url);
    }

    public String getUsername() {
        return this.decrypt(this.username);
    }

    public String getPassword() {
        return this.decrypt(this.password);
    }

    private String decrypt(String cipherText) {
        Matcher matcher;
        if (StringUtils.hasText((String)cipherText) && (matcher = ENC_PATTERN.matcher(cipherText)).find()) {
            try {
                return CryptoUtils.decrypt(this.publicKey, matcher.group(1));
            }
            catch (Exception e) {
                log.error("DynamicDataSourceProperties.decrypt error ", (Throwable)e);
            }
        }
        return cipherText;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public Class<? extends DataSource> getType() {
        return this.type;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public Boolean getFieldUnderline() {
        return this.fieldUnderline;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getData() {
        return this.data;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public String getSeparator() {
        return this.separator;
    }

    public DruidConfig getDruid() {
        return this.druid;
    }

    public HikariCpConfig getHikari() {
        return this.hikari;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setType(Class<? extends DataSource> type) {
        this.type = type;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setFieldUnderline(Boolean fieldUnderline) {
        this.fieldUnderline = fieldUnderline;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setDruid(DruidConfig druid) {
        this.druid = druid;
    }

    public void setHikari(HikariCpConfig hikari) {
        this.hikari = hikari;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }
}

