/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure;

import com.luues.jdbc.plus.core.metadata.TableInfoHelper;
import com.luues.jdbc.plus.dynamic.datasource.DynamicDataSourceConfigure;
import com.luues.jdbc.plus.dynamic.datasource.DynamicRoutingDataSource;
import com.luues.jdbc.plus.dynamic.datasource.aop.DynamicDataSourceAdvisor;
import com.luues.jdbc.plus.dynamic.datasource.aop.DynamicDataSourceAnnotationAdvisor;
import com.luues.jdbc.plus.dynamic.datasource.aop.DynamicDataSourceAnnotationInterceptor;
import com.luues.jdbc.plus.dynamic.datasource.processor.DsHeaderProcessor;
import com.luues.jdbc.plus.dynamic.datasource.processor.DsProcessor;
import com.luues.jdbc.plus.dynamic.datasource.processor.DsSessionProcessor;
import com.luues.jdbc.plus.dynamic.datasource.processor.DsSpelExpressionProcessor;
import com.luues.jdbc.plus.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.luues.jdbc.plus.dynamic.datasource.provider.YmlDynamicDataSourceProvider;
import com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceCreatorAutoConfiguration;
import com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure.SingleDynamicDataSourceProperties;
import com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure.druid.DruidDynamicDataSourceConfiguration;
import com.luues.jdbc.plus.dynamic.datasource.strategy.DynamicDataSourceStrategy;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={DynamicDataSourceProperties.class, SingleDynamicDataSourceProperties.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Import(value={DruidDynamicDataSourceConfiguration.class, DynamicDataSourceCreatorAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.datasource.dynamic", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class DynamicDataSourceAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceAutoConfiguration.class);
    private final DynamicDataSourceProperties dynamicDataSourceProperties;
    private final SingleDynamicDataSourceProperties singleDynamicDataSourceProperties;

    @Bean
    @ConditionalOnMissingBean
    public DynamicDataSourceProvider dynamicDataSourceProvider() {
        TableInfoHelper.setDynamicDataSourceProperties(this.dynamicDataSourceProperties);
        TableInfoHelper.setSingleDynamicDataSourceProperties(this.singleDynamicDataSourceProperties);
        Map<String, DataSourceProperty> datasourceMap = this.dynamicDataSourceProperties.getDatasource();
        if (Strings.isNotBlank((String)this.singleDynamicDataSourceProperties.getUrl()) && Strings.isNotBlank((String)this.singleDynamicDataSourceProperties.getUsername()) && Strings.isNotBlank((String)this.singleDynamicDataSourceProperties.getPassword())) {
            datasourceMap = new LinkedHashMap<String, DataSourceProperty>();
            DataSourceProperty dataSourceProperty = new DataSourceProperty();
            BeanUtils.copyProperties((Object)this.singleDynamicDataSourceProperties, (Object)dataSourceProperty);
            datasourceMap.put(this.dynamicDataSourceProperties.getPrimary(), dataSourceProperty);
        }
        return new YmlDynamicDataSourceProvider(datasourceMap);
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicDataSourceStrategy dynamicDataSourceStrategy() throws IllegalAccessException, InstantiationException {
        return this.dynamicDataSourceProperties.getStrategy().newInstance();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSource dataSource(DynamicDataSourceProvider dynamicDataSourceProvider, DynamicDataSourceStrategy dynamicDataSourceStrategy) {
        DynamicRoutingDataSource dataSource = new DynamicRoutingDataSource();
        dataSource.setPrimary(this.dynamicDataSourceProperties.getPrimary());
        dataSource.setStrict(this.dynamicDataSourceProperties.getStrict());
        dataSource.setStrategy(dynamicDataSourceStrategy);
        dataSource.setProvider(dynamicDataSourceProvider);
        dataSource.setP6spy(this.dynamicDataSourceProperties.getP6spy());
        dataSource.setSeata(this.dynamicDataSourceProperties.getSeata());
        return dataSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicDataSourceAnnotationAdvisor dynamicDatasourceAnnotationAdvisor(DsProcessor dsProcessor) {
        DynamicDataSourceAnnotationInterceptor interceptor = new DynamicDataSourceAnnotationInterceptor();
        interceptor.setDsProcessor(dsProcessor);
        DynamicDataSourceAnnotationAdvisor advisor = new DynamicDataSourceAnnotationAdvisor(interceptor);
        advisor.setOrder(this.dynamicDataSourceProperties.getOrder());
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean
    public DsProcessor dsProcessor() {
        DsHeaderProcessor headerProcessor = new DsHeaderProcessor();
        DsSessionProcessor sessionProcessor = new DsSessionProcessor();
        DsSpelExpressionProcessor spelExpressionProcessor = new DsSpelExpressionProcessor();
        headerProcessor.setNextProcessor(sessionProcessor);
        sessionProcessor.setNextProcessor(spelExpressionProcessor);
        return headerProcessor;
    }

    @Bean
    @ConditionalOnBean(value={DynamicDataSourceConfigure.class})
    public DynamicDataSourceAdvisor dynamicAdvisor(DynamicDataSourceConfigure dynamicDataSourceConfigure, DsProcessor dsProcessor) {
        DynamicDataSourceAdvisor advisor = new DynamicDataSourceAdvisor(dynamicDataSourceConfigure.getMatchers());
        advisor.setDsProcessor(dsProcessor);
        advisor.setOrder(Integer.MIN_VALUE);
        return advisor;
    }

    public DynamicDataSourceAutoConfiguration(DynamicDataSourceProperties dynamicDataSourceProperties, SingleDynamicDataSourceProperties singleDynamicDataSourceProperties) {
        this.dynamicDataSourceProperties = dynamicDataSourceProperties;
        this.singleDynamicDataSourceProperties = singleDynamicDataSourceProperties;
    }
}

