/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.dynamic.datasource.creator;

import com.luues.jdbc.plus.dynamic.datasource.creator.BasicDataSourceCreator;
import com.luues.jdbc.plus.dynamic.datasource.creator.DruidDataSourceCreator;
import com.luues.jdbc.plus.dynamic.datasource.creator.HikariDataSourceCreator;
import com.luues.jdbc.plus.dynamic.datasource.creator.JndiDataSourceCreator;
import com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.luues.jdbc.plus.dynamic.datasource.support.ScriptRunner;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DataSourceCreator {
    private static final Logger log = LoggerFactory.getLogger(DataSourceCreator.class);
    private static Boolean druidExists = false;
    private static Boolean hikariExists = false;
    private BasicDataSourceCreator basicDataSourceCreator;
    private JndiDataSourceCreator jndiDataSourceCreator;
    private HikariDataSourceCreator hikariDataSourceCreator;
    private DruidDataSourceCreator druidDataSourceCreator;
    private String globalPublicKey = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAMCPLTci4ygq/RI7DlwPsORT1z/8i1AlZw9wad+TsmENAgQEV8l9HPwCzNmL3P5GqTz0TfJkZJVNwC/rgZrHF+cCAwEAAQ==";

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type;
        String jndiName = dataSourceProperty.getJndiName();
        DataSource dataSource = jndiName != null && !jndiName.isEmpty() ? this.createJNDIDataSource(jndiName) : ((type = dataSourceProperty.getType()) == null ? (druidExists.booleanValue() ? this.createDruidDataSource(dataSourceProperty) : (hikariExists.booleanValue() ? this.createHikariDataSource(dataSourceProperty) : this.createBasicDataSource(dataSourceProperty))) : ("com.alibaba.druid.pool.DruidDataSource".equals(type.getName()) ? this.createDruidDataSource(dataSourceProperty) : ("com.zaxxer.hikari.HikariDataSource".equals(type.getName()) ? this.createHikariDataSource(dataSourceProperty) : this.createBasicDataSource(dataSourceProperty))));
        this.runScrip(dataSourceProperty, dataSource);
        return dataSource;
    }

    private void runScrip(DataSourceProperty dataSourceProperty, DataSource dataSource) {
        String schema = dataSourceProperty.getSchema();
        String data = dataSourceProperty.getData();
        if (StringUtils.hasText((String)schema) || StringUtils.hasText((String)data)) {
            ScriptRunner scriptRunner = new ScriptRunner(dataSourceProperty.isContinueOnError(), dataSourceProperty.getSeparator());
            if (StringUtils.hasText((String)schema)) {
                scriptRunner.runScript(dataSource, schema);
            }
            if (StringUtils.hasText((String)data)) {
                scriptRunner.runScript(dataSource, data);
            }
        }
    }

    public DataSource createBasicDataSource(DataSourceProperty dataSourceProperty) {
        if (StringUtils.isEmpty((Object)dataSourceProperty.getPublicKey())) {
            dataSourceProperty.setPublicKey(this.globalPublicKey);
        }
        return this.basicDataSourceCreator.createDataSource(dataSourceProperty);
    }

    public DataSource createJNDIDataSource(String jndiName) {
        return this.jndiDataSourceCreator.createDataSource(jndiName);
    }

    public DataSource createDruidDataSource(DataSourceProperty dataSourceProperty) {
        if (StringUtils.isEmpty((Object)dataSourceProperty.getPublicKey())) {
            dataSourceProperty.setPublicKey(this.globalPublicKey);
        }
        return this.druidDataSourceCreator.createDataSource(dataSourceProperty);
    }

    public DataSource createHikariDataSource(DataSourceProperty dataSourceProperty) {
        if (StringUtils.isEmpty((Object)dataSourceProperty.getPublicKey())) {
            dataSourceProperty.setPublicKey(this.globalPublicKey);
        }
        return this.hikariDataSourceCreator.createDataSource(dataSourceProperty);
    }

    public void setBasicDataSourceCreator(BasicDataSourceCreator basicDataSourceCreator) {
        this.basicDataSourceCreator = basicDataSourceCreator;
    }

    public void setJndiDataSourceCreator(JndiDataSourceCreator jndiDataSourceCreator) {
        this.jndiDataSourceCreator = jndiDataSourceCreator;
    }

    public void setHikariDataSourceCreator(HikariDataSourceCreator hikariDataSourceCreator) {
        this.hikariDataSourceCreator = hikariDataSourceCreator;
    }

    public void setDruidDataSourceCreator(DruidDataSourceCreator druidDataSourceCreator) {
        this.druidDataSourceCreator = druidDataSourceCreator;
    }

    public void setGlobalPublicKey(String globalPublicKey) {
        this.globalPublicKey = globalPublicKey;
    }

    static {
        try {
            Class.forName("com.alibaba.druid.pool.DruidDataSource");
            druidExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("com.zaxxer.hikari.HikariDataSource");
            hikariExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

