/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.core.toolkit;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TableNameParser {
    private static final int NO_INDEX = -1;
    private static final String SPACE = " ";
    private static final String REGEX_SPACE = "\\s+";
    private static final String TOKEN_ORACLE_HINT_START = "/*+";
    private static final String TOKEN_ORACLE_HINT_END = "*/";
    private static final String TOKEN_SINGLE_LINE_COMMENT = "--";
    private static String TOKEN_NEWLINE = "\\r\\n|\\r|\\n|\\n\\r";
    private static final String TOKEN_SEMI_COLON = ";";
    private static final String TOKEN_PARAN_START = "(";
    private static final String TOKEN_COMMA = ",";
    private static final String TOKEN_SET = "set";
    private static final String TOKEN_OF = "of";
    private static final String TOKEN_DUAL = "dual";
    private static final String TOKEN_DELETE = "delete";
    private static final String TOKEN_CREATE = "create";
    private static final String TOKEN_INDEX = "index";
    private static final String TOKEN_ASTERICK = "*";
    private static final String KEYWORD_JOIN = "join";
    private static final String KEYWORD_INTO = "into";
    private static final String KEYWORD_TABLE = "table";
    private static final String KEYWORD_FROM = "from";
    private static final String KEYWORD_USING = "using";
    private static final String KEYWORD_UPDATE = "update";
    private static final List<String> concerned = Arrays.asList("table", "into", "join", "using", "update");
    private static final List<String> ignored = Arrays.asList("(", "set", "of", "dual");
    private Map<String, String> tables = new HashMap<String, String>();

    public TableNameParser(String sql) {
        String noComments = this.removeComments(sql);
        String normalized = this.normalized(noComments);
        String cleansed = this.clean(normalized);
        String[] tokens = cleansed.split(REGEX_SPACE);
        int index = 0;
        String firstToken = tokens[index];
        if (this.isOracleSpecialDelete(firstToken, tokens, index)) {
            this.handleSpecialOracleSpecialDelete(firstToken, tokens, index);
        } else if (this.isCreateIndex(firstToken, tokens, index)) {
            this.handleCreateIndex(firstToken, tokens, index);
        } else {
            while (this.moreTokens(tokens, index)) {
                String currentToken;
                if (this.isFromToken(currentToken = tokens[index++])) {
                    this.processFromToken(tokens, index);
                    continue;
                }
                if (!this.shouldProcess(currentToken) || !this.moreTokens(tokens, index)) continue;
                String nextToken = tokens[index++];
                this.considerInclusion(nextToken);
            }
        }
    }

    private String removeComments(String sql) {
        StringBuilder sb = new StringBuilder(sql);
        int nextCommentPosition = sb.indexOf(TOKEN_SINGLE_LINE_COMMENT);
        while (nextCommentPosition > -1) {
            int end = this.indexOfRegex(TOKEN_NEWLINE, sb.substring(nextCommentPosition));
            if (end == -1) {
                return sb.substring(0, nextCommentPosition);
            }
            sb.replace(nextCommentPosition, end + nextCommentPosition, "");
            nextCommentPosition = sb.indexOf(TOKEN_SINGLE_LINE_COMMENT);
        }
        return sb.toString();
    }

    private int indexOfRegex(String regex, String string) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        return matcher.find() ? matcher.start() : -1;
    }

    private String normalized(String sql) {
        String normalized = sql.trim().replaceAll(TOKEN_NEWLINE, SPACE).replaceAll(TOKEN_COMMA, " , ").replaceAll("\\(", " ( ").replaceAll("\\)", " ) ");
        if (normalized.endsWith(TOKEN_SEMI_COLON)) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        return normalized;
    }

    private String clean(String normalized) {
        int end;
        int start = normalized.indexOf(TOKEN_ORACLE_HINT_START);
        if (start != -1 && (end = normalized.indexOf(TOKEN_ORACLE_HINT_END)) != -1) {
            String firstHalf = normalized.substring(0, start);
            String secondHalf = normalized.substring(end + 2, normalized.length());
            return firstHalf.trim() + SPACE + secondHalf.trim();
        }
        return normalized;
    }

    private boolean isOracleSpecialDelete(String currentToken, String[] tokens, int index) {
        String nextToken;
        ++index;
        return TOKEN_DELETE.equals(currentToken) && this.moreTokens(tokens, index) && !KEYWORD_FROM.equals(nextToken = tokens[index++]) && !TOKEN_ASTERICK.equals(nextToken);
    }

    private void handleSpecialOracleSpecialDelete(String currentToken, String[] tokens, int index) {
        String tableName = tokens[index + 1];
        this.considerInclusion(tableName);
    }

    private boolean isCreateIndex(String currentToken, String[] tokens, int index) {
        String nextToken;
        ++index;
        return TOKEN_CREATE.equals(currentToken.toLowerCase()) && this.hasIthToken(tokens, index, 3) && TOKEN_INDEX.equals((nextToken = tokens[index++]).toLowerCase());
    }

    private void handleCreateIndex(String currentToken, String[] tokens, int index) {
        String tableName = tokens[index + 4];
        this.considerInclusion(tableName);
    }

    private boolean hasIthToken(String[] tokens, int currentIndex, int tokenNumber) {
        return this.moreTokens(tokens, currentIndex) && tokens.length > currentIndex + tokenNumber;
    }

    private boolean shouldProcess(String currentToken) {
        return concerned.contains(currentToken.toLowerCase());
    }

    private boolean isFromToken(String currentToken) {
        return KEYWORD_FROM.equals(currentToken.toLowerCase());
    }

    private void processFromToken(String[] tokens, int index) {
        String currentToken = tokens[index++];
        this.considerInclusion(currentToken);
        String nextToken = null;
        if (this.moreTokens(tokens, index)) {
            nextToken = tokens[index++];
        }
        if (this.shouldProcessMultipleTables(nextToken)) {
            this.processNonAliasedMultiTables(tokens, index, nextToken);
        } else {
            this.processAliasedMultiTables(tokens, index, currentToken);
        }
    }

    private void processNonAliasedMultiTables(String[] tokens, int index, String nextToken) {
        while (nextToken.equals(TOKEN_COMMA)) {
            String currentToken = tokens[index++];
            this.considerInclusion(currentToken);
            if (!this.moreTokens(tokens, index)) break;
            nextToken = tokens[index++];
        }
    }

    private void processAliasedMultiTables(String[] tokens, int index, String currentToken) {
        String nextNextToken = null;
        if (this.moreTokens(tokens, index)) {
            nextNextToken = tokens[index++];
        }
        if (this.shouldProcessMultipleTables(nextNextToken)) {
            while (this.moreTokens(tokens, index) && nextNextToken.equals(TOKEN_COMMA)) {
                if (this.moreTokens(tokens, index)) {
                    currentToken = tokens[index++];
                }
                if (this.moreTokens(tokens, index)) {
                    ++index;
                }
                if (this.moreTokens(tokens, index)) {
                    nextNextToken = tokens[index++];
                }
                this.considerInclusion(currentToken);
            }
        }
    }

    private boolean shouldProcessMultipleTables(String nextToken) {
        return nextToken != null && nextToken.equals(TOKEN_COMMA);
    }

    private boolean moreTokens(String[] tokens, int index) {
        return index < tokens.length;
    }

    private void considerInclusion(String token) {
        if (!ignored.contains(token.toLowerCase()) && !this.tables.containsKey(token.toLowerCase())) {
            this.tables.put(token.toLowerCase(), token);
        }
    }

    public Collection<String> tables() {
        return new HashSet<String>(this.tables.values());
    }
}

