/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.core.toolkit;

import com.luues.jdbc.plus.core.metadata.TableInfo;
import com.luues.jdbc.plus.core.metadata.TableInfoHelper;
import com.luues.jdbc.plus.core.toolkit.StringUtils;
import com.luues.jdbc.plus.core.toolkit.support.ColumnCache;
import com.luues.jdbc.plus.core.toolkit.support.SFunction;
import com.luues.jdbc.plus.core.toolkit.support.SerializedLambda;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class LambdaUtils {
    private static final Map<Class<?>, TableInfo> TABLE_INFO_CACHE = new ConcurrentHashMap();
    private static final Map<String, Map<String, ColumnCache>> COLUMN_CACHE_MAP = new ConcurrentHashMap<String, Map<String, ColumnCache>>();
    private static final Map<Class<?>, WeakReference<SerializedLambda>> FUNC_CACHE = new ConcurrentHashMap();

    public static <T> SerializedLambda resolve(SFunction<T, ?> func) {
        Class<?> clazz = func.getClass();
        return Optional.ofNullable(FUNC_CACHE.get(clazz)).map(Reference::get).orElseGet(() -> {
            SerializedLambda lambda = SerializedLambda.resolve(func);
            FUNC_CACHE.put(clazz, new WeakReference<SerializedLambda>(lambda));
            return lambda;
        });
    }

    public static String formatKey(String key) {
        return key.toUpperCase(Locale.ENGLISH);
    }

    public static void installCache(TableInfo tableInfo) {
        COLUMN_CACHE_MAP.put(tableInfo.getEntityType().getName(), LambdaUtils.createColumnCacheMap(tableInfo));
    }

    private static Map<String, ColumnCache> createColumnCacheMap(TableInfo info) {
        HashMap<String, ColumnCache> map = new HashMap<String, ColumnCache>();
        String kp = info.getKeyProperty();
        if (StringUtils.isNotBlank(kp)) {
            map.put(LambdaUtils.formatKey(kp), new ColumnCache(info.getKeyColumn(), info.getKeySqlSelect()));
        }
        info.getFieldList().forEach(i -> map.put(LambdaUtils.formatKey(i.getProperty()), new ColumnCache(i.getColumn(), i.getSqlSelect())));
        return map;
    }

    public static Map<String, ColumnCache> getColumnMap(Class<?> clazz) {
        return COLUMN_CACHE_MAP.computeIfAbsent(clazz.getName(), key -> {
            TableInfo info = TableInfoHelper.getTableInfo(clazz);
            return info == null ? null : LambdaUtils.createColumnCacheMap(info);
        });
    }
}

